/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.JLibraryModel;
import oracle.jdevimpl.library.LeafNode;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;
import oracle.jdevimpl.library.LibraryListNode;
import oracle.jdevimpl.library.LibraryNode;
import oracle.jdevimpl.library.ListNode;
import oracle.jdevimpl.library.TreePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrariesPanel
extends TreePanel {
    private LibraryEditPanel _detailPanel;
    private Library _currentLib;
    protected final LocalChangeListener listener;
    private List<JLibrary> _existingLibs;

    private void $init$() {
        this.listener = new LocalChangeListener();
    }

    public LibrariesPanel() {
        this.$init$();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, this.getHelpId());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getDetailPanel().setLibrary(null);
        this.setDetailPanel(this.getDetailPanel(), this.getDetailTitle());
    }

    protected LibraryEditPanel getDetailPanel() {
        if (this._detailPanel == null) {
            this._detailPanel = new LibraryEditPanel();
        }
        return this._detailPanel;
    }

    protected String getDetailTitle() {
        return LibraryArb.getString(61);
    }

    @Override
    public String getHelpId() {
        if (this.getParent() != null && this.getParent() instanceof JTabbedPane) {
            return "f1_idedmanagelibrarieslibraries_html";
        }
        return "f1_idedaddlibrary_html";
    }

    public void makeDoubleClickCloseDialog() {
        LibrariesPanel panel = this;
        1 l = new 1(this, panel);
        this.addMouseListenerToTree(l);
    }

    public void setExistingLibraries(List<JLibrary> existingLibraries) {
        this._existingLibs = existingLibraries;
    }

    @Override
    protected DefaultTreeModel createTreeModel(ListWrapper[] lists) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        int i = lists.length - 1;
        while (i >= 0) {
            ListWrapper list = lists[i];
            LibraryListNode listNode = this.buildListNode(list);
            root.add(listNode);
            --i;
        }
        return new DefaultTreeModel(root);
    }

    @Override
    public boolean commitChanges() {
        ListNode listNode;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.findNode(null, this._currentLib);
        Object[] nodes = node != null ? node.getPath() : null;
        TreePath path = nodes != null && nodes.length > 1 ? new TreePath(nodes) : null;
        ListNode listNode2 = listNode = path != null ? (ListNode)path.getPathComponent(1) : null;
        if (listNode != null) {
            try {
                this._currentLib = this.commitChanges(listNode.getList(), this._currentLib, this.getDetailPanel());
                node.setUserObject(this._currentLib);
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    protected Library commitChanges(MutableLibraryList list, Library lib, LibraryEditPanel panel) throws Exception {
        if (lib == null) {
            return lib;
        }
        JLibraryModel model = new JLibraryModel((JLibrary)lib, list, (Component)panel);
        model.setName(panel.getLibraryName());
        model.setClassPath(panel.getClassPath());
        model.setSourcePath(panel.getSourcePath());
        model.setDocPath(panel.getDocPath());
        model.setDeployedByDefault(panel.isDeployByDefault());
        return model.commit();
    }

    @Override
    protected Library createNewElement(ListWrapper[] wrapper) {
        ListWrapper list = wrapper[0];
        HashStructure hash = HashStructure.newInstance();
        Library lib = new JLibraryAdapter(hash);
        LibraryEditPanel newPanel = new LibraryEditPanel();
        newPanel.setLibrary(lib);
        newPanel.setLibraryLists(this.getLibraryLists());
        newPanel.setListsVisible(true);
        newPanel.setLibraryList(list);
        this.listener.initialize(newPanel, lib);
        if (OnePageWizardDialogFactory.runDialog((Component)this, (Component)newPanel, (Component)newPanel.addBtn, (String)this.getDetailTitle(), (int)7, (VetoableChangeListener)this.listener)) {
            lib = this.listener.getLibrary();
            wrapper[0] = (ListWrapper)newPanel.getLibraryList();
        } else {
            lib = null;
        }
        return lib;
    }

    @Override
    protected ListNode addLibraryList(ListWrapper list) {
        LibraryListNode listNode = this.buildListNode(list);
        DefaultTreeModel model = this.getTreeModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        model.insertNodeInto(listNode, root, root.getChildCount());
        return listNode;
    }

    @Override
    protected void nodeDeleted(LeafNode node) {
        if (node instanceof LibraryNode && ((LibraryNode)node).getLibrary() == this._currentLib) {
            this._currentLib = null;
            this.getDetailPanel().setLibrary(null);
        }
    }

    @Override
    protected boolean updateSelection(Library elem) {
        Library lib = elem;
        if (this._currentLib != lib) {
            if (this._currentLib != null && this.isSplit()) {
                try {
                    this.commitChanges();
                }
                catch (Exception e) {
                    boolean bl = false;
                    return bl;
                }
            }
            this._currentLib = lib;
            this.getDetailPanel().setLibrary(lib);
        }
        return true;
    }

    protected LibraryListNode buildListNode(ListWrapper list) {
        ArrayList libs;
        ArrayList arrayList = libs = list != null ? list.getLibraryList() : null;
        if (this._existingLibs != null && libs != null && libs.size() > 0) {
            ArrayList filteredLibs = new ArrayList(libs.size());
            filteredLibs.addAll(libs);
            filteredLibs.removeAll(this._existingLibs);
            libs = filteredLibs.size() > 0 ? filteredLibs : null;
        }
        Iterator i = libs != null ? libs.iterator() : null;
        return new LibrariesPanelLibraryListNode(list, i);
    }

    @Override
    protected LibraryListNode createLibraryListNode(ListWrapper list, Iterator i) {
        return new LibrariesPanelLibraryListNode(list, i);
    }

    final class 1
    extends MouseAdapter {
        private final /* synthetic */ JPanel v$panel;
        final /* synthetic */ LibrariesPanel this$0;

        public void mouseClicked(MouseEvent e) {
            Dialog dlg;
            Library[] selLibs;
            if (e.getClickCount() == 2 && (selLibs = this.this$0.getSelection()) != null && (dlg = IdeUtil.findDialog((Component)this.v$panel)) instanceof JEWTDialog) {
                JEWTDialog jdlg = (JEWTDialog)dlg;
                jdlg.closeDialog(false);
            }
        }

        public 1(LibrariesPanel librariesPanel, JPanel jPanel) {
            this.v$panel = jPanel;
            this.this$0 = librariesPanel;
        }
    }

    final class LocalChangeListener
    implements VetoableChangeListener {
        private boolean vetoThrown;
        private LibraryEditPanel _newPanel;
        private Library _lib;

        public void initialize(LibraryEditPanel panel, Library lib) {
            this._newPanel = panel;
            this._lib = lib;
        }

        public Library getLibrary() {
            return this._lib;
        }

        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (this.vetoThrown) {
                this.vetoThrown = false;
                return;
            }
            try {
                this._lib = LibrariesPanel.this.commitChanges((MutableLibraryList)this._newPanel.getLibraryList(), this._lib, this._newPanel);
            }
            catch (Exception x) {
                this.vetoThrown = true;
                throw new PropertyVetoException(null, e);
            }
        }

        LocalChangeListener() {
        }
    }

    protected class LibrariesPanelLibraryListNode
    extends LibraryListNode {
        LibrariesPanelLibraryListNode(ListWrapper list, Iterator i) {
            super(list, i);
        }

        void selectNode(DefaultMutableTreeNode node) {
            LibrariesPanel.this.selectNode(node);
        }
    }
}

