/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.templates.CodeTemplateUtil;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.javatools.editor.BasicEditorPane;

public class CodeTemplatesMenu
implements ContextMenuListener,
Controller {
    static final String ACCELERATOR_FILE = "oracle/dbtools/raptor/oviewer/accelerators.xml";
    public static int CODE_TEMPLATE = Ide.findOrCreateCmdID((String)"code_template");
    private IdeAction codeTemplate;
    private static CodeTemplatesMenu _instance;

    private CodeTemplatesMenu() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCELERATOR_FILE);
        this.createAction();
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (this.canShow(context) && context.getEvent().getSource() instanceof JTextComponent) {
            if (this.codeTemplate == null) {
                this.createAction();
            }
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.codeTemplate));
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == CODE_TEMPLATE) {
            if (this.canShow(context)) {
                String string = DBConfig.getInstance().getString("TEMPLATES");
                CodeTemplateUtil.insertTemplate((String)string, (BasicEditorPane)((FindableEditor)context.getView()).getFocusedEditorPane());
            }
            return true;
        }
        return false;
    }

    private boolean canShow(Context context) {
        return context.getView() instanceof Editor;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public static ContextMenuListener getInstance() {
        if (_instance == null) {
            _instance = new CodeTemplatesMenu();
        }
        return _instance;
    }

    private void createAction() {
        if (this.codeTemplate == null) {
            this.codeTemplate = IdeAction.get((int)CODE_TEMPLATE, null, (String)Translate.translate((String)"Code Template"), null, null, null, null, (boolean)true);
            this.codeTemplate.addController((Controller)this);
        }
    }
}

