/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseContainer;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.OBResourcesArb;
import oracle.dbtools.raptor.oviewer.base.HTMLTabFormatter;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionExportDataProvider
extends AbstractMenuAction {
    private static final String NODE_TYPES_HTML = "/nodeTypes.html";
    private DBObject _selectedObject;
    private DelayedProgressRunnable pBar;
    private DRunnable _runnable;
    private File _outputDir;
    private ObjectFactory _factory;

    private void setProgressbarMsg(String string) {
        ((JLabel)this.pBar.getDetailComponent()).setText(string);
    }

    public void launch() {
        URL uRL;
        this._selectedObject = this.getDBObject();
        if (this._selectedObject.getConnection() == null) {
            return;
        }
        this._runnable = new DRunnable();
        JLabel jLabel = new JLabel("Starting...");
        this.pBar = new DelayedProgressRunnable(OBResourcesArb.getString(8), "", 1, (IDelayedProgressRunnable)this._runnable, (Component)jLabel);
        this.pBar.setDetailVisible(true);
        this.pBar.setCancellable(true);
        this.pBar.setCloseOnFinish(true);
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setSelectionScope(1);
        uRLChooser.setSelectionMode(0);
        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), OBResourcesArb.getString(11));
        if (n == 0 && (uRL = uRLChooser.getSelectedURL()) != null && uRL.toString().length() > 0) {
            this._outputDir = new File(uRL.getPath());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConnectionExportDataProvider.this.pBar.start();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNodeTypes(File file) throws IOException {
        String string = this._selectedObject.getConnectionName();
        Connection connection = this._selectedObject.getConnection();
        this.setProgressbarMsg(OBResourcesArb.getString(9));
        try {
            this._factory = ObjectFactory.getFactory((String)string, (Connection)connection);
        }
        catch (DBException dBException) {
            this.setProgressbarMsg(dBException.getMessage());
            return;
        }
        if (this._runnable.isCancelled()) {
            return;
        }
        if (this._factory != null) {
            Writer writer = null;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                File file2 = new File(file.getAbsolutePath() + NODE_TYPES_HTML);
                file2.createNewFile();
                writer = new BufferedWriter(new FileWriter(file2));
                writer.write("<html>" + ConnectionExportDataProvider.getLineTerminator());
                ConnectionExportDataProvider.writeStyleSheetTag((BufferedWriter)writer, "./");
                writer.write("<body id=\"top_left\">" + ConnectionExportDataProvider.getLineTerminator());
                writer.write("<h2>" + this._factory.getSchema() + "</h2>" + ConnectionExportDataProvider.getLineTerminator());
                DBSchemaInstance dBSchemaInstance = this._factory.createSchemaInstance(this._selectedObject.getSchemaName());
                Set<DBFolderInstance> set = this.getSortedFolderList(dBSchemaInstance);
                boolean bl = false;
                for (DBFolderInstance dBFolderInstance : set) {
                    String string2 = this.getFolderTypeName(dBFolderInstance);
                    String string3 = "";
                    File file3 = new File(file.getAbsolutePath() + "/" + dBFolderInstance.getType().toLowerCase());
                    file3.mkdir();
                    if (this.createNodeValues(dBFolderInstance, file3)) {
                        if (bl) {
                            string3 = "<a href=\"javascript:$n('" + dBFolderInstance.getType().toLowerCase() + "')\" id=\"" + dBFolderInstance.getType().toLowerCase() + "\" class=\"current\">" + string2 + "</a>";
                            bl = true;
                        } else {
                            string3 = "<a href=\"javascript:$n('" + dBFolderInstance.getType().toLowerCase() + "')\" id=\"" + dBFolderInstance.getType().toLowerCase() + "\">" + string2 + "</a>";
                        }
                        stringBuilder.append(string3 + ConnectionExportDataProvider.getLineTerminator());
                    }
                    if (!this._runnable.isCancelled()) continue;
                    return;
                }
            }
            finally {
                this.setProgressbarMsg(OBResourcesArb.getString(10));
                writer.write(stringBuilder.toString() + ConnectionExportDataProvider.getLineTerminator() + "</body> </html>");
                ((BufferedWriter)writer).close();
            }
        }
    }

    private Set<DBFolderInstance> getSortedFolderList(DBSchemaInstance dBSchemaInstance) {
        TreeSet<DBFolderInstance> treeSet = new TreeSet<DBFolderInstance>(new Comparator<DBFolderInstance>(){

            @Override
            public int compare(DBFolderInstance dBFolderInstance, DBFolderInstance dBFolderInstance2) {
                if (dBFolderInstance == dBFolderInstance2) {
                    return 0;
                }
                DatabaseFolder databaseFolder = (DatabaseFolder)dBFolderInstance.getDescriptor();
                DatabaseFolder databaseFolder2 = (DatabaseFolder)dBFolderInstance2.getDescriptor();
                double d = databaseFolder.getWeight() - databaseFolder2.getWeight();
                if (d == 0.0) {
                    return dBFolderInstance.getType().compareTo(dBFolderInstance2.getType());
                }
                return (int)d;
            }
        });
        if (dBSchemaInstance.getProperty("SCHEMA") == null) {
            dBSchemaInstance.setProperty("SCHEMA", (Object)this._factory.getSchema());
        }
        for (DBFolderInstance dBFolderInstance : dBSchemaInstance.listTypeFolders()) {
            String string = dBFolderInstance.getDescriptor().getType().toUpperCase();
            if (string.equals("RECYCLEBIN") || string.equals("PUBLIC_SYNONYM")) continue;
            treeSet.add(dBFolderInstance);
        }
        return treeSet;
    }

    static void writeStyleSheetTag(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write("<head>" + ConnectionExportDataProvider.getLineTerminator());
        bufferedWriter.write("<script src=\"" + string + "dbdoc.js\" type=\"text/javascript\"></script>" + ConnectionExportDataProvider.getLineTerminator());
        bufferedWriter.write("<link href=\"" + string + "dbdoc.css\" type=\"text/css\" rel=\"stylesheet\">" + ConnectionExportDataProvider.getLineTerminator());
        bufferedWriter.write("</head>" + ConnectionExportDataProvider.getLineTerminator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createNodeValues(DBFolderInstance dBFolderInstance, File file) throws IOException {
        Writer writer = null;
        boolean bl = false;
        try {
            File file2 = new File(file.getAbsolutePath() + "/index.html");
            file2.createNewFile();
            writer = new BufferedWriter(new FileWriter(file2));
            writer.write("<html>" + ConnectionExportDataProvider.getLineTerminator());
            ConnectionExportDataProvider.writeStyleSheetTag((BufferedWriter)writer, "../");
            writer.write("<body id=\"bottom_left\">" + ConnectionExportDataProvider.getLineTerminator());
            String string = this.getFolderTypeName(dBFolderInstance);
            writer.write("<h2>" + string + "" + ConnectionExportDataProvider.getLineTerminator());
            writer.write("<div id=\"search\"><input type=\"text\" onkeyup=\"$d_Find('narrow',this.value,'a')\"/></div></h2><div id=\"narrow\">");
            try {
                List list = dBFolderInstance.listChildren();
                Collections.sort(list, new Comparator<DBChildInstance>(){

                    @Override
                    public int compare(DBChildInstance dBChildInstance, DBChildInstance dBChildInstance2) {
                        Comparable comparable = (Comparable)dBChildInstance.getProperty("NAME");
                        Comparable comparable2 = (Comparable)dBChildInstance2.getProperty("NAME");
                        return comparable.compareTo(comparable2);
                    }
                });
                Iterator iterator = list.iterator();
                do {
                    if (!iterator.hasNext()) return bl;
                    DBChildInstance dBChildInstance = (DBChildInstance)iterator.next();
                    bl = true;
                    String string2 = (String)dBChildInstance.getProperty("NAME");
                    String string3 = URLEncoder.encode(string2, "UTF-8");
                    String string4 = "<a href =\"" + string3 + ".html\" target=\"ObjectDetailsFrame\">" + string2 + "</a>";
                    writer.write(string4 + ConnectionExportDataProvider.getLineTerminator());
                    this.createNodeDetails(dBFolderInstance, dBChildInstance, file);
                } while (!this._runnable.isCancelled());
                boolean bl2 = bl;
                return bl2;
            }
            catch (SQLException sQLException) {
                this.setProgressbarMsg(sQLException.getMessage());
                return bl;
            }
            catch (AbortException abortException) {
                this.setProgressbarMsg(abortException.getMessage());
                return bl;
            }
        }
        finally {
            writer.write(ConnectionExportDataProvider.getLineTerminator() + "</body> </html>");
            ((BufferedWriter)writer).close();
        }
    }

    private String getFolderTypeName(DBFolderInstance dBFolderInstance) {
        String string = dBFolderInstance.getType().toLowerCase();
        if (dBFolderInstance.getDescriptor() instanceof DatabaseContainer) {
            string = ((DatabaseContainer)dBFolderInstance.getDescriptor()).getLabel();
        }
        return string;
    }

    private void createNodeDetails(DBFolderInstance dBFolderInstance, DBChildInstance dBChildInstance, File file) throws IOException {
        String string = this._selectedObject.getConnectionName();
        Connection connection = this._selectedObject.getConnection();
        ObjectFactory objectFactory = null;
        try {
            objectFactory = ObjectFactory.getFactory((String)string, (Connection)connection);
        }
        catch (DBException dBException) {
            this.setProgressbarMsg(dBException.getMessage());
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            return;
        }
        if (objectFactory != null) {
            ViewerAddin viewerAddin = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
            String string2 = (String)dBChildInstance.getProperty("NAME");
            URL uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)this._factory.getSchema(), (String)dBFolderInstance.getType()), (String)string2);
            DBObject dBObject = new DBObject(uRL);
            List<DisplayModel> list = viewerAddin.getModels(dBObject);
            this.setProgressbarMsg("Processing " + dBFolderInstance.getType() + " " + string2);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator iterator = dBChildInstance.getPropertyKeys().iterator();
            String string3 = null;
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                hashMap.put(string3, dBChildInstance.getProperty(string3));
            }
            HTMLTabFormatter hTMLTabFormatter = new HTMLTabFormatter(dBObject, list, hashMap, file);
            hTMLTabFormatter.start();
            if (this._runnable.isCancelled()) {
                return;
            }
        }
    }

    private static String getLineTerminator() {
        return System.getProperty("line.separator");
    }

    private boolean copyFileFromJar(URL uRL, File file) throws IOException {
        int n;
        file.createNewFile();
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while ((n = inputStream.read()) != -1) {
            fileOutputStream.write(n);
        }
        fileOutputStream.close();
        inputStream.close();
        return true;
    }

    private boolean copyResourceFile(File file, URL uRL, String string) {
        try {
            return this.copyFileFromJar(uRL, new File(file.getAbsolutePath() + "/" + string));
        }
        catch (IOException iOException) {
            this.setProgressbarMsg(iOException.getMessage());
            return false;
        }
    }

    public void setArgs(String string) {
    }

    class DRunnable
    implements IDelayedProgressRunnable {
        private boolean _isCanceled;

        DRunnable() {
        }

        public synchronized boolean isCancelled() {
            return this._isCanceled;
        }

        public void preWork() {
        }

        public void finish(Object object) {
            try {
                if (!this.isCancelled() && object instanceof File && System.getProperty("os.name").startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler file://" + ((File)object).getPath() + "/index.html");
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }

        public Object doWork() {
            if (ConnectionExportDataProvider.this._outputDir != null) {
                ConnectionExportDataProvider.this._outputDir.mkdirs();
                boolean bl = false;
                List list = FileUtils.getFilesInPackage((String)"oracle.dbtools.raptor.oviewer.base.htmlExportResources", (String)"");
                for (URL uRL : list) {
                    if (ConnectionExportDataProvider.this.copyResourceFile(ConnectionExportDataProvider.this._outputDir, uRL, uRL.getFile().substring(uRL.getFile().lastIndexOf("/") + 1))) continue;
                    bl = true;
                }
                if (bl) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ((JLabel)ConnectionExportDataProvider.this.pBar.getDetailComponent()).getText());
                    return null;
                }
                try {
                    ConnectionExportDataProvider.this.createNodeTypes(ConnectionExportDataProvider.this._outputDir);
                }
                catch (IOException iOException) {
                    ConnectionExportDataProvider.this.setProgressbarMsg(iOException.getMessage());
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
            if (ConnectionExportDataProvider.this._outputDir == null) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Directory does not exist", (String)"DB Doc Failure", (String)"f1_dbdoc_html");
            }
            return ConnectionExportDataProvider.this._outputDir;
        }

        public void cancel() {
            this._isCanceled = true;
        }
    }
}

