/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.oviewer.base.ConnectionExportDataProvider;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataTypesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTabFormatter {
    private static final int RESULTSET_FETCH_SIZE = 200;
    public static final String FORMAT_TYPE = "HTML DDL";
    private List<DisplayModel> _models;
    private DBObject _selectedObject;
    private HashMap<String, Object> _binds;
    private File _baseDir;

    public HTMLTabFormatter(DBObject dBObject, List<DisplayModel> list, HashMap<String, Object> hashMap, File file) {
        this._baseDir = file;
        this._models = list;
        this._selectedObject = dBObject;
        this._binds = hashMap;
    }

    public void start() throws IOException {
        for (int i = 0; i < this._models.size(); ++i) {
            DisplayModel displayModel = this._models.get(i);
            if (displayModel.getQuery() == null) continue;
            BufferedWriter bufferedWriter = i == 0 ? this.initFile(this._baseDir.getAbsolutePath() + File.separator + this._selectedObject.getObjectName() + ".html") : this.initFile(this._baseDir.getAbsolutePath() + File.separator + this._selectedObject.getObjectName() + "_" + displayModel.getName() + ".html");
            bufferedWriter.write("<html>" + this.getLineTerminator());
            ConnectionExportDataProvider.writeStyleSheetTag(bufferedWriter, "../");
            bufferedWriter.write("<body class=\"object\">" + this.getLineTerminator());
            bufferedWriter.write("<div id=\"header\"><h2>" + this._selectedObject.getObjectName() + "</h2>" + this.getLineTerminator());
            bufferedWriter.write(this.getDivTag(displayModel.getName(), this._models));
            this.print(displayModel, bufferedWriter);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }

    public BufferedWriter initFile(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        return bufferedWriter;
    }

    private void print(DisplayModel displayModel, BufferedWriter bufferedWriter) throws IOException {
        this.printGenericQuery(displayModel, bufferedWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGenericQuery(DisplayModel displayModel, BufferedWriter bufferedWriter) throws IOException {
        boolean bl;
        block27: {
            if (displayModel.getQuery() == null || displayModel.getQuery().getSql() == null) {
                this.printColumn(displayModel.getName(), new String[0], bufferedWriter);
                return;
            }
            bl = false;
            String string = QueryUtils.expandQuery((String)displayModel.getQuery().getSql(), this._binds);
            this._binds.putAll(this._selectedObject.getObjectBinds(displayModel.getQuery().getSql()));
            ResultSet resultSet = DBUtil.getInstance().executeQuery(this._selectedObject.getConnection(), string, this._binds);
            try {
                if (resultSet == null) break block27;
                boolean bl2 = false;
                String string2 = displayModel.getStyle();
                String string3 = (String)displayModel.getExtValues().get("TYPE");
                if (string3 != null && string3.equalsIgnoreCase("vertical")) {
                    bl2 = true;
                }
                String[] stringArray = this.printTabColumns(resultSet, displayModel.getName(), bl2, bufferedWriter);
                boolean bl3 = false;
                for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                    String string4 = resultSet.getMetaData().getColumnName(i + 1).toUpperCase();
                    if (!string4.equals("SDEV_LINK_NAME") && !string4.equals("SDEV_LINK_TYPE") && !string4.equals("SDEV_LINK_OWNER")) continue;
                    bl3 = true;
                }
                if (string2 != null && string2.toLowerCase().equals("code")) {
                    bufferedWriter.write("\t<tr><td><pre>" + this.getLineTerminator());
                    while (resultSet.next()) {
                        bufferedWriter.write(this.escape(resultSet.getString(1)));
                    }
                    bufferedWriter.write("</pre>\t</td></tr>" + this.getLineTerminator());
                } else if (bl2 && resultSet.next()) {
                    String[] stringArray2 = this.getColumnsFromResultSet(resultSet.getMetaData());
                    for (int i = 0; i < stringArray2.length; ++i) {
                        bufferedWriter.write("\t<tr>" + this.getLineTerminator());
                        this.printRow(null, stringArray2[i], bufferedWriter);
                        this.printRow(null, resultSet.getObject(stringArray2[i]), bufferedWriter);
                        bufferedWriter.write("\t</tr>" + this.getLineTerminator());
                    }
                } else {
                    while (resultSet.next()) {
                        String string5 = null;
                        if (bl3) {
                            String string6 = resultSet.getString("SDEV_LINK_NAME");
                            String string7 = resultSet.getString("SDEV_LINK_TYPE").toLowerCase();
                            String string8 = resultSet.getString("SDEV_LINK_OWNER");
                            if (this._selectedObject.getSchemaName().equals(string8)) {
                                string5 = "../" + string7 + "/" + string6 + ".html";
                            }
                        }
                        bufferedWriter.write("\t<tr>" + this.getLineTerminator());
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.printRow(string5, resultSet.getObject(stringArray[i]), bufferedWriter);
                        }
                        bufferedWriter.write("\t</tr>" + this.getLineTerminator());
                    }
                }
                bufferedWriter.write("</table></div>");
                bl = true;
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSet == null) {
                    return;
                }
                try {
                    Statement statement = resultSet.getStatement();
                    resultSet.close();
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    return;
                }
            }
        }
        if (!bl) {
            this.printColumn(displayModel.getName(), new String[0], bufferedWriter);
        }
    }

    public String escape(String string) {
        if (string != null) {
            return string.replaceAll("<", "&lt;");
        }
        return string;
    }

    private String[] printTabColumns(ResultSet resultSet, String string, boolean bl, BufferedWriter bufferedWriter) throws SQLException, IOException {
        String[] stringArray = new String[]{};
        if (resultSet != null) {
            stringArray = bl ? new String[]{"Name", "Value"} : this.getColumnsFromResultSet(resultSet.getMetaData());
            this.printColumn(string, stringArray, bufferedWriter);
        }
        return stringArray;
    }

    private String[] getColumnsFromResultSet(ResultSetMetaData resultSetMetaData) throws SQLException {
        String[] stringArray = new String[]{};
        String[] stringArray2 = new String[]{};
        if (resultSetMetaData != null) {
            int n = resultSetMetaData.getColumnCount();
            stringArray = new String[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string = resultSetMetaData.getColumnName(i + 1).toUpperCase();
                if (string.equals("SDEV_LINK_NAME") || string.equals("SDEV_LINK_TYPE") || string.equals("SDEV_LINK_OWNER")) continue;
                stringArray[i] = resultSetMetaData.getColumnName(i + 1);
                ++n2;
            }
            stringArray2 = new String[n2];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        }
        return stringArray2;
    }

    private void printRow(String string, Object object, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<td>");
        if (string != null) {
            bufferedWriter.write("<a href=\"" + string + "\">");
            bufferedWriter.write(object != null ? this.escape(DataTypesUtil.stringValue((Object)object.toString(), (Connection)this._selectedObject.getConnection())) : "null");
            bufferedWriter.write("</a>");
        } else {
            bufferedWriter.write(object != null ? this.escape(DataTypesUtil.stringValue((Object)object.toString(), (Connection)this._selectedObject.getConnection())) : "null");
        }
        bufferedWriter.write("</td>" + this.getLineTerminator());
    }

    private void printColumn(String string, String[] stringArray, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.getLineTerminator() + "<div id=\"" + string + "\"> <table cellpadding=\"0\" cellspacing=\"0\" cellspacing=\"0\" summary=\"\"><tr>" + this.getLineTerminator());
        for (int i = 0; i < stringArray.length; ++i) {
            bufferedWriter.write("\t<th>" + stringArray[i] + "</th>" + this.getLineTerminator());
        }
        bufferedWriter.write("</tr>" + this.getLineTerminator());
    }

    private String getLineTerminator() {
        return System.getProperty("line.separator");
    }

    private String getTabId(List<DisplayModel> list, int n) {
        return list.get(n).getName().replace(' ', '#') + n;
    }

    private String getDivTag(String string, List<DisplayModel> list) {
        StringBuffer stringBuffer = new StringBuffer("<div class=\"tabs clearfix\">" + this.getLineTerminator());
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getQuery() == null) continue;
            stringBuffer.append(this.getLineTerminator());
            String string2 = list.get(i).getName();
            stringBuffer.append("<div class=\"tab\"");
            if (string2.equals(string)) {
                stringBuffer.append(" id=\"current\"");
            }
            String string3 = this._selectedObject.getObjectName();
            try {
                string3 = URLEncoder.encode(this._selectedObject.getObjectName(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
            if (i == 0) {
                stringBuffer.append("><div><a href=\"" + string3 + ".html\">" + string2 + "</a></div></div>");
                continue;
            }
            stringBuffer.append("><div><a href=\"" + string3 + "_" + string2 + ".html\">" + string2 + "</a></div></div>");
        }
        stringBuffer.append(this.getLineTerminator() + "</div></div><br/>" + this.getLineTerminator() + "<div class=\"tab-panes\">");
        return stringBuffer.toString();
    }
}

