/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.BaseNavigatorManager;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.ModelUtil;

public class NavSelectionListener
implements ViewSelectionListener,
MouseListener,
MouseMotionListener,
IResultSetTableDrillDown {
    private Node _pendingNodeSelectionChange;
    private boolean _hasMousePressed;
    private boolean _hasMouseReleased;
    private boolean _hasSelectionChanged;
    private boolean _inRightClick;
    private static NavSelectionListener _instance;
    private String row;

    private NavSelectionListener() {
    }

    public static NavSelectionListener getInstance() {
        return _instance;
    }

    public static void initialize() {
        _instance = new NavSelectionListener();
        Ide.addIdeListener((IdeListener)new L());
    }

    private static void hookNavigator(NavigatorManager navigatorManager) {
        NavigatorWindow navigatorWindow = navigatorManager.getNavigatorWindow();
        navigatorWindow.addViewSelectionListener((ViewSelectionListener)_instance);
        Component component = navigatorWindow.getGUI();
        JTree jTree = navigatorWindow.getTreeExplorer().getJTree();
        boolean bl = true;
        for (MouseListener mouseListener : jTree.getMouseListeners()) {
            if (mouseListener != _instance) continue;
            bl = false;
            break;
        }
        if (bl) {
            jTree.addMouseListener(_instance);
            jTree.addMouseMotionListener(_instance);
        }
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        Element element;
        Element[] elementArray = viewSelectionEvent.getSelection();
        if (elementArray != null && DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK").booleanValue() && elementArray.length == 1 && this.isObjectNode(element = elementArray[0])) {
            this._pendingNodeSelectionChange = (Node)element;
            boolean bl = false;
            if (!this._hasSelectionChanged && this._hasMousePressed && (!this._hasMouseReleased || this._inRightClick)) {
                bl = true;
            }
            if (bl) {
                this._hasSelectionChanged = true;
            } else {
                this.doPendingChanges();
            }
        }
    }

    private boolean isObjectNode(Element element) {
        return element instanceof DatabaseNode || element instanceof AbstractConnectionNode;
    }

    private void whenDatabaseObjectSelected(Node node) {
        if (node instanceof DatabaseConnection || this._inRightClick) {
            return;
        }
        if (node.getClass().getName().endsWith(".PlSqlNode")) {
            int n = -1;
            try {
                n = Integer.parseInt(this.row);
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n > 0) {
                this.open(node.getURL(), n, -1);
            } else {
                this.open(node);
            }
        } else {
            this.open(node);
        }
    }

    public void open(URL uRL) {
        this.open(uRL, -1, -1);
    }

    public void open(final URL uRL, final int n, final int n2) {
        if (DBURLFormatHelper.isDBURL((URL)uRL)) {
            IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){

                public void cancel() {
                }

                public Object doWork() {
                    DatabaseNode databaseNode = DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
                    return databaseNode;
                }

                public void finish(Object object) {
                    NavSelectionListener.this.open((Node)object);
                    if (n > 0) {
                        PlSqlNode plSqlNode = (PlSqlNode)DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
                        TextBuffer textBuffer = plSqlNode.acquireTextBuffer();
                        LineMap lineMap = textBuffer.getLineMap();
                        int n3 = lineMap.getLineStartOffset(n) + n2 - 1;
                        plSqlNode.releaseTextBuffer();
                        int n22 = 1;
                        OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(Context.newIdeContext((Node)plSqlNode), n3, n22);
                        try {
                            NavigationManager navigationManager = NavigationManager.getNavigationManager();
                            if (navigationManager != null) {
                                navigationManager.navigateTo((NavigationPoint)offsetNavigationPoint);
                            } else {
                                offsetNavigationPoint.navigate();
                            }
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                }

                public void preWork() {
                }
            };
            DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Opening", null, 500, iDelayedProgressRunnable);
            delayedProgressRunnable.getDetailComponent();
            ((JTextArea)delayedProgressRunnable.getDetailComponent()).setText("Loading:" + DBURLFormatHelper.getName((URL)uRL));
            delayedProgressRunnable.setCancellable(true);
            delayedProgressRunnable.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Node node) {
        if (node instanceof DatabaseConnection) {
            return;
        }
        ViewerNode viewerNode = ViewerNode.getUnpinnedInstance();
        viewerNode.ensureOpen();
        DBObject dBObject = new DBObject((Element)node);
        boolean bl = DBConfig.getInstance().getBoolean("AUTOPIN");
        if (!this.raiseEditor(node)) {
            DBObject dBObject2;
            boolean bl2;
            boolean bl3;
            EditorManager editorManager = EditorManager.getEditorManager();
            if (viewerNode.getBaseNode() == null) {
                bl3 = true;
                bl2 = this.hasViewer(dBObject);
            } else {
                dBObject2 = viewerNode.getDBObject();
                bl3 = ModelUtil.areDifferent((Object)dBObject2.getObjectType(), (Object)dBObject.getObjectType()) || ModelUtil.areDifferent((Object)dBObject2.getConnectionType(), (Object)dBObject.getConnectionType()) || ModelUtil.areDifferent((Object)dBObject2.getDBVersion(), (Object)dBObject.getDBVersion());
                bl2 = bl3 ? this.hasViewer(dBObject) : true;
            }
            if (!bl2) {
                return;
            }
            if (bl3) {
                this.closeObjectViewer(viewerNode);
            }
            if (!Connections.getInstance().lock(dBObject.getConnectionName())) {
                return;
            }
            Connections.getInstance().unlock(dBObject.getConnectionName());
            viewerNode.setViewedObject(dBObject);
            dBObject2 = Context.newIdeContext((Node)viewerNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions((Context)dBObject2);
            openEditorOptions.setFlags(1);
            WaitCursor waitCursor = Ide.getWaitCursor();
            try {
                viewerNode.setPinned(bl);
                waitCursor.show();
                Editor editor = editorManager.openEditor(openEditorOptions);
                if (editor != null) {
                    View.updateToolbarActions((Toolbar)editor.getToolbar());
                }
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    private boolean hasViewer(DBObject dBObject) {
        boolean bl = false;
        if (this.isObjectNode((Element)dBObject.getNode())) {
            ViewerNode viewerNode = ViewerNode.getTestInstance();
            viewerNode.setViewedObject(dBObject);
            EditorManager editorManager = EditorManager.getEditorManager();
            EditorAddin editorAddin = editorManager.getBestEditorAddin((Node)viewerNode);
            if (editorAddin != null) {
                bl = true;
            }
        }
        return bl;
    }

    private void closeObjectViewer(ViewerNode viewerNode) {
        EditorManager editorManager = EditorManager.getEditorManager();
        List list = editorManager.getAllEditors();
        for (int i = list.size() - 1; i >= 0; --i) {
            Editor editor = (Editor)list.get(i);
            Context context = editor.getContext();
            Node node = context.getNode();
            if (viewerNode == node) continue;
            list.remove(i);
        }
        if (!list.isEmpty()) {
            editorManager.closeEditors(list);
        }
    }

    private DatabaseNode getLastObject(CustomTree customTree) {
        Object object;
        DatabaseNode databaseNode = null;
        if (customTree.getSelectionCount() > 0 && (object = ((ExplorerNode)customTree.getLastSelectedPathComponent()).getUserObject()) instanceof DatabaseNode) {
            databaseNode = (DatabaseNode)object;
        }
        return databaseNode;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DatabaseNode databaseNode;
        CustomTree customTree;
        TreePath treePath;
        if ((DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK").booleanValue() || mouseEvent.getClickCount() == 2) && (treePath = (customTree = (CustomTree)mouseEvent.getSource()).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (databaseNode = this.getLastObject(customTree)) != null) {
            this.whenDatabaseObjectSelected((Node)databaseNode);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        CustomTree customTree = (CustomTree)mouseEvent.getSource();
        DatabaseNode databaseNode = this.getLastObject(customTree);
        if (databaseNode != null) {
            this._pendingNodeSelectionChange = (Node)databaseNode;
        }
        this._inRightClick = mouseEvent.getModifiers() == 4 || mouseEvent.getModifiers() == 8;
        this.cancelPendingChanges();
        this._hasMousePressed = true;
    }

    public boolean raiseEditor(Node node) {
        boolean bl = false;
        List list = EditorManager.getEditorManager().getAllEditors();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof ViewerEditor) || ((ViewerEditor)((Object)list.get(i))).getViewerNode() == null || node != ((ViewerEditor)((Object)list.get(i))).getViewerNode().getBaseNode()) continue;
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(((Editor)list.get(i)).getContext());
            openEditorOptions.setFlags(1);
            EditorManager.getEditorManager().openEditor(openEditorOptions);
            bl = true;
        }
        return bl;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        CustomTree customTree = (CustomTree)mouseEvent.getSource();
        DatabaseNode databaseNode = this.getLastObject(customTree);
        if (databaseNode != null) {
            this._pendingNodeSelectionChange = (Node)databaseNode;
        }
        TreePath treePath = customTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (this._hasSelectionChanged && treePath != null) {
            this.doPendingChanges();
        } else {
            this._hasMouseReleased = true;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.cancelPendingChanges();
        this._hasMousePressed = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void doPendingChanges() {
        Node node = this._pendingNodeSelectionChange;
        this.cancelPendingChanges();
        this.whenDatabaseObjectSelected(node);
    }

    private void cancelPendingChanges() {
        this._pendingNodeSelectionChange = null;
        this._hasMousePressed = false;
        this._hasMouseReleased = false;
        this._hasSelectionChanged = false;
    }

    public void performDrill(Element element, String string) {
        this.cancelPendingChanges();
        this._inRightClick = false;
        this.row = string;
        if (element instanceof Node) {
            this.whenDatabaseObjectSelected((Node)element);
        }
    }

    private static class L
    implements IdeListener {
        private L() {
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
        }

        public void addinsLoaded(IdeEvent ideEvent) {
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
            NavSelectionListener.hookNavigator(DatabaseNavigatorManager.getInstance());
            Ide.getMainWindow().addActiveViewListener(new ActiveViewListener(){

                public void activeViewChanged(ActiveViewEvent activeViewEvent) {
                    View view;
                    if (activeViewEvent.getOldView() != null) {
                        activeViewEvent.getOldView().removeViewSelectionListener((ViewSelectionListener)_instance);
                    }
                    if ((view = activeViewEvent.getNewView()) instanceof NavigatorWindow && ((NavigatorWindow)view).getManager() instanceof BaseNavigatorManager) {
                        NavSelectionListener.hookNavigator(((NavigatorWindow)view).getManager());
                    }
                }
            });
        }
    }
}

