/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.celleditor.RSTableEditorTextField;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicEditorPane;

public class PopupDescribe
implements Controller,
ContextMenuListener {
    static final Logger logger = Logger.getLogger(PopupDescribe.class.getName());
    static final String ACCELERATOR_FILE = "oracle/dbtools/raptor/oviewer/accelerators.xml";
    public static int POPUP_DESCR = Ide.findOrCreateCmdID((String)"popup_describe");
    private IdeAction popupDescr;
    private static PopupDescribe _instance;
    private static DBObject _currentDbObject;

    private PopupDescribe() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCELERATOR_FILE);
        this.createAction();
    }

    public static synchronized PopupDescribe getInstance() {
        if (_instance == null) {
            _instance = new PopupDescribe();
        }
        return _instance;
    }

    public static void showPopup(Context context) {
        if (PopupDescribe.canDescribe(context)) {
            PopupDescribe.showPopup();
        }
    }

    public static void showPopup(Context context, Database database) {
        if (PopupDescribe.canDescribe(context, database)) {
            PopupDescribe.showPopup();
        }
    }

    public static void showPopup(String string, Database database) {
        if (PopupDescribe.canDescribe(string, database)) {
            PopupDescribe.showPopup();
        }
    }

    private static void showPopup() {
        PopupDescribe.showPopup(_currentDbObject);
    }

    public static void showPopup(final DBObject dBObject) {
        ViewerAddin viewerAddin = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
        List<DisplayModel> list = viewerAddin.getModels(dBObject);
        if (list != null && list.size() > 0) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NavSelectionListener.getInstance().open(dBObject.getNode());
                }
            };
            final CustomTabbedPane customTabbedPane = new CustomTabbedPane();
            customTabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (customTabbedPane.getActivePanel().isShowing()) {
                        DisplayPanel displayPanel = (DisplayPanel)customTabbedPane.getActivePanel();
                        displayPanel.refresh(true, true);
                    }
                }
            });
            HelpSystem.getHelpSystem().registerTopic((JComponent)customTabbedPane, "f1_popupdbobjectoverview_html");
            boolean bl = false;
            for (DisplayModel displayModel : list) {
                if (displayModel.getQuery(dBObject.getConnection()) == null) continue;
                displayModel.setConnection(dBObject.getConnection());
                DisplayPanel displayPanel = new DisplayPanel(displayModel, dBObject.getDictionary(), bl);
                customTabbedPane.addTab(displayModel.getIcon(), displayModel.getName(), (Component)displayPanel);
                if (bl) continue;
                bl = true;
                displayPanel.refresh(true);
            }
            customTabbedPane.setPreferredSize(new Dimension(500, 300));
            customTabbedPane.setMinimumSize(new Dimension(500, 300));
            UIUtils.showPanelAsDialog((JPanel)customTabbedPane, (String)dBObject.getObjectName(), (ActionListener)actionListener, (int)7, (boolean)false);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == POPUP_DESCR) {
            PopupDescribe.showPopup(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (context.getView() instanceof Editor && context.getEvent().getSource() instanceof JTextComponent) {
            String string = (String)context.getProperty("Connections.db_name");
            if (string == null) {
                if (context.getView() instanceof IDBEditor) {
                    string = ((IDBEditor)context.getView()).getConnectionName();
                } else {
                    URL uRL = context.getNode().getURL();
                    if (DBURLFormatHelper.isDBURL((URL)uRL)) {
                        string = DBURLFormatHelper.getConnectionName((URL)uRL);
                    }
                }
            }
            if (string != null && Connections.getInstance().isOracle(string)) {
                if (this.popupDescr == null) {
                    this.createAction();
                }
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.popupDescr));
            }
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    private static String scrubDbObjectName(Context context) {
        String string = "";
        if (context.getView() instanceof Editor) {
            Editor editor = (Editor)context.getView();
            Component component = editor.getDefaultFocusComponent();
            if (component instanceof BasicEditorPane) {
                BasicEditorPane basicEditorPane = (BasicEditorPane)editor.getDefaultFocusComponent();
                int n = basicEditorPane.getCaretPosition();
                if (basicEditorPane.getSelectedText() != null) {
                    string = ((BasicEditorPane)editor.getDefaultFocusComponent()).getSelectedText();
                } else {
                    try {
                        int n2 = n - 100 > 0 ? n - 100 : 0;
                        int n3 = n + 100 < basicEditorPane.getDocument().getLength() ? n + 100 : basicEditorPane.getDocument().getLength();
                        String string2 = basicEditorPane.getDocument().getText(n2, n3 - n2);
                        String string3 = string2.substring(0, n - n2);
                        string3 = string3.replaceAll("\r\n|[\r\n\u2028\u2029\u0085]|\t", " ");
                        if (string3.lastIndexOf(" ") > 0) {
                            string3 = string3.substring(string3.lastIndexOf(" ") + 1);
                        }
                        String string4 = string2.substring(n - n2);
                        if ((string4 = string4.replaceAll("\r\n|[\r\n\u2028\u2029\u0085]|\t", " ")).indexOf(" ") > 0) {
                            string4 = string4.substring(0, string4.indexOf(" "));
                        }
                        string = string3 + string4;
                        string = string.trim();
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(PopupDescribe.class.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                    }
                }
            } else if (component instanceof RSTableEditorTextField) {
                return ((RSTableEditorTextField)component).getSelectedText().trim();
            }
        }
        return string;
    }

    private static boolean canDescribe(Context context) {
        if (context.getView() instanceof IDBEditor) {
            return PopupDescribe.canDescribe(context, ((IDBEditor)context.getView()).getDatabase());
        }
        URL uRL = context.getNode().getURL();
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        try {
            return PopupDescribe.canDescribe(context, Connections.getInstance().getDatabase(string));
        }
        catch (DBException dBException) {
            return false;
        }
    }

    private static boolean canDescribe(Context context, Database database) {
        if (context.getView() instanceof Editor) {
            return PopupDescribe.canDescribe(PopupDescribe.scrubDbObjectName(context), database);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canDescribe(String string, Database database) {
        if (string != null && !string.equals("")) {
            if (database != null) {
                _currentDbObject = null;
                _currentDbObject = PopupDescribe.getDBObjectForName(string, database);
                if (_currentDbObject != null) return true;
                logger.info("No Object Found");
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)("No Object Found: " + string), (String)"No Object Found", (String)"f1_noobjectfound_html");
                return false;
            } else {
                Logger.global.warning("No Connection Found");
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"No Connection Found:", (String)"No Connection Found", (String)"f1_noConnectionFound_html");
            }
            return false;
        } else {
            logger.info("No Object Selected");
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"No Object Selected", (String)"No Object Selected", (String)"f1_noobjectselected_html");
        }
        return false;
    }

    private void createAction() {
        if (this.popupDescr == null) {
            this.popupDescr = IdeAction.get((int)POPUP_DESCR, null, (String)Translate.translate((String)"Popup Describe"), null, null, null, null, (boolean)true);
            this.popupDescr.addController((Controller)this);
        }
    }

    private static DBObject getDBObjectForName(String string, Database database) {
        return DBObject.getDBObjectForName((String)string, (Database)database);
    }
}

