/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableBasedViewer
extends ViewerEditor
implements IDBEditor {
    private ResultSetTable _table;
    protected DBObject _dbObject;
    protected DBObject _lastdbObject;
    private IdeAction _refreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");
    private SchemaObjectListener L = new SchemaObjectListener(){

        public void schemaObjectUpdated(DBObjectChange dBObjectChange) {
            TableBasedViewer.this.updateContent(true);
        }
    };

    protected TableBasedViewer() {
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Translate.translate((String)"Refresh"), null, null, (Icon)IdeArb.getIcon((int)373), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                TableBasedViewer.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
        ((Toolbar)super.getFixedTopMargin()).add((ToggleAction)this._refreshAction.newLocalAction((View)this));
    }

    protected abstract String getSelectStatement();

    protected abstract ResultSet getResultSet();

    protected ArrayList<String> getSkipCols() {
        return null;
    }

    public abstract String getDefaultExportName();

    @Override
    protected JComponent createViewerUI() {
        this._table = new ResultSetTable();
        this._table.addColumn(new TableColumn());
        this._table.setAutoResizeMode(0);
        return this._table;
    }

    public Object getEditorAttribute(String string) {
        if (string == "background_color") {
            return this._table.getBackground();
        }
        return super.getEditorAttribute(string);
    }

    public Component getScrollableTopMargin() {
        JTableHeader jTableHeader = this._table.getTableHeader();
        return jTableHeader;
    }

    @Override
    protected void updateContent() {
        this.updateContent(false);
    }

    public DBObject getDBObject() {
        ViewerNode viewerNode = this.getViewerNode();
        return new DBObject((Element)viewerNode);
    }

    protected void updateContent(boolean bl) {
        ViewerNode viewerNode = this.getViewerNode();
        this._dbObject = new DBObject((Element)viewerNode);
        if (bl || this._lastdbObject == null || this._lastdbObject.getNode() == null || this._lastdbObject.getNode() != this._dbObject.getNode()) {
            SchemaObject schemaObject = null;
            SchemaObject schemaObject2 = null;
            if (this._lastdbObject != null) {
                schemaObject = this._lastdbObject.getSchemaObject();
            }
            if (this._dbObject != null) {
                schemaObject2 = this._dbObject.getSchemaObject();
            }
            if (schemaObject != schemaObject2) {
                if (schemaObject != null) {
                    schemaObject.removeObjectListener(this.L);
                }
                if (schemaObject2 != null) {
                    schemaObject2.addObjectListener(this.L);
                }
            }
            this.updateTitle(this._dbObject.getObjectName());
            if (this.getDefaultExportName() == null) {
                this._table.setDefaultExportName(this._dbObject.getObjectName());
            } else {
                this._table.setDefaultExportName(this._dbObject.getObjectName() + this.getDefaultExportName());
            }
            Database database = viewerNode.getDatabase();
            if (database != null) {
                Connection connection = database.getConnection();
                DBUtil dBUtil = new DBUtil();
                ResultSet resultSet = this.getResultSet();
                if (resultSet == null) {
                    String string = this.getSelectStatement();
                    this._table.setSkipCols(this.getSkipCols());
                    this._table.setQuery(connection, null, string, this._dbObject.getObjectBinds(string));
                } else {
                    this._table.setSkipCols(this.getSkipCols());
                    this._table.setQuery(connection, resultSet, null);
                }
            }
            TableBasedViewer.updateToolbarActions((Toolbar)this._toolbar);
            this._lastdbObject = this._dbObject;
        }
    }

    protected ResultSetTableModel getTableModel() {
        return (ResultSetTableModel)this._table.getModel();
    }

    protected JTable getTable() {
        return this._table;
    }

    @Override
    public Object getPrintable() {
        return this._table;
    }

    public Database getDatabase() {
        return this._dbObject.getDatabase();
    }

    public Connection getConnection() {
        return this._dbObject.getConnection();
    }

    public String getConnectionName() {
        return this._dbObject != null ? this._dbObject.getConnectionName() : null;
    }
}

