/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.table.ResultsSetTableContextMenu;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.oviewer.base.CodeTemplatesMenu;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.oviewer.base.PopupDescribe;
import oracle.dbtools.raptor.oviewer.base.RSTableDrillToBaseObject;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerEditorAddin;
import oracle.dbtools.raptor.oviewer.base.ViewerPrintFactory;
import oracle.dbtools.raptor.oviewer.extsearch.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.utils.AbstractFolderedXml;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Resource;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.PrintManager;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerAddin
implements Addin {
    private Logger logger = Logger.getLogger(ViewerAddin.class.getName());
    private static final String CLASS = "class";
    private static final String EDITOR_CLASS = "editorClass";
    private static List<URL> _registeredEditors = new ArrayList<URL>();
    private static List<String> _registeredPackages = new ArrayList<String>();
    private Map<String, List<ViewerEditorAddin>> _editorsAddins = new HashMap<String, List<ViewerEditorAddin>>();
    private Map<String, List<DisplayModel>> _editors = new HashMap<String, List<DisplayModel>>();
    private static Object __LOCK__ = new Object();
    private static Thread s_loader;
    public static final String LOCAL_ACCELERATORS_FILE = "oracle/dbtools/raptor/oviewer/base/accelerators.xml";
    private static Map<String, String[]> s_nodeTypeMap;

    public static synchronized void registerPackage(String string) {
        _registeredPackages.add(string);
    }

    public static synchronized List<String> getRegisteredPackages() {
        return _registeredPackages;
    }

    public static synchronized void registerEditors(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                Logger.getLogger(ViewerAddin.class.getClass().getName()).log(Level.WARNING, malformedURLException2.getStackTrace()[0].toString(), malformedURLException2);
            }
        }
        if (uRL != null) {
            _registeredEditors.add(uRL);
        } else {
            System.err.println("Could not add Viewers:" + string);
        }
    }

    public static synchronized List<URL> getRegisteredEditors() {
        return _registeredEditors;
    }

    public void initialize() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), LOCAL_ACCELERATORS_FILE);
        NavSelectionListener.initialize();
        ResultSetTable.setDrillDown((IResultSetTableDrillDown)NavSelectionListener.getInstance());
        ResultsSetTableContextMenu.getContextMenu().addContextMenuListener((ContextMenuListener)RSTableDrillToBaseObject.getInstance());
        ViewerAddin.registerPackage("oracle.dbtools.raptor.oviewer.base.xml");
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent ideEvent) {
            }

            public void mainWindowClosing(IdeEvent ideEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mainWindowOpened(IdeEvent ideEvent) {
                Object object = __LOCK__;
                synchronized (object) {
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            ViewerAddin.this.loadXMLEditors();
                            Object object = __LOCK__;
                            synchronized (object) {
                                s_loader = null;
                            }
                        }
                    };
                    s_loader = new Thread(runnable, "EditorLoader");
                    s_loader.start();
                }
            }
        });
        PrintManager.getPrintManager().registerDocumentPrintFactory(ViewerEditor.class, ViewerPrintFactory.class);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)PopupDescribe.getInstance());
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(CodeTemplatesMenu.getInstance());
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.raptor.oviewer.navActions");
        IdentifierDefinitionLookup.init();
    }

    public void addTab(String string, String string2, String string3, Class clazz, DisplayModel displayModel) {
        ViewerEditorAddin viewerEditorAddin = new ViewerEditorAddin(string, string2, string3, clazz);
        if (displayModel != null) {
            viewerEditorAddin.setModel(displayModel);
        }
        if (XMLBasedEditor.class.isAssignableFrom(clazz)) {
            String string4 = ViewerAddin.getKey(string2, string3);
            this.registerEditor(viewerEditorAddin, string4);
        }
        if (Ide.isRunning() && EditorManager.getEditorManager() != null) {
            EditorManager.getEditorManager().registerDynamic((EditorAddin)viewerEditorAddin);
        }
    }

    private static String getKey(String string, String string2) {
        if (string == null) {
            string = "Oracle";
        }
        return string + "#" + string2;
    }

    private void registerEditor(ViewerEditorAddin viewerEditorAddin, String string) {
        List<ViewerEditorAddin> list = this._editorsAddins.get(string);
        if (list == null) {
            list = new ArrayList<ViewerEditorAddin>();
            this._editorsAddins.put(string, list);
        }
        list.add(viewerEditorAddin);
    }

    public DisplayModel getModel(DBObject dBObject, int n) {
        String string = null;
        string = dBObject.getKey();
        DisplayModel displayModel = null;
        List<ViewerEditorAddin> list = this.getEditorsAddins(string);
        if (list != null && list.size() > n) {
            displayModel = list.get(n).getModel();
        }
        return displayModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ViewerEditorAddin> getEditorsAddins(String string) {
        Object object = __LOCK__;
        synchronized (object) {
            if (s_loader != null) {
                try {
                    s_loader.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this._editorsAddins.get(string);
    }

    public Map<String, List<DisplayModel>> getXMLEditors() {
        return this._editors;
    }

    public void loadXMLEditors() {
        ArrayList arrayList = DBConfig.getInstance().getExtensions("EDITOR");
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ViewerAddin.registerEditors((String)arrayList.get(i));
            }
        }
        this.loadCommonQueries();
        XMLParser xMLParser = new XMLParser();
        for (String object : ViewerAddin.getRegisteredPackages()) {
            for (URL uRL : FileUtils.getFilesInPackage((String)object, (String)"xml")) {
                try {
                    xMLParser.processXML(uRL.openStream());
                }
                catch (Exception exception) {
                    this.logger.info("Could not load: " + URLFileSystem.getSystemDisplayName((URL)uRL));
                }
            }
        }
        if (System.getProperty("raptor.user.editors") != null) {
            try {
                xMLParser.processXML(new FileInputStream(System.getProperty("raptor.user.editors")));
            }
            catch (Exception exception) {
                System.err.print("Could Not load User Editors:" + exception.getMessage());
            }
        }
        for (URL uRL : ViewerAddin.getRegisteredEditors()) {
            try {
                xMLParser.processXML(uRL.openStream());
            }
            catch (Exception exception) {
                System.err.print("Could Not load User Editors:" + exception.getMessage());
            }
        }
    }

    private void loadCommonQueries() {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse(Resource.getResourceAsStream(this.getClass(), (String)"commonQueries.xml"));
        }
        catch (XMLParseException xMLParseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, xMLParseException.getStackTrace()[0].toString(), xMLParseException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        NodeList nodeList = xMLDocument.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equals("queries")) {
                Query.getQueries((org.w3c.dom.Node)nodeList.item(i));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("query")) {
                Query.getQuery((org.w3c.dom.Node)nodeList.item(i));
                continue;
            }
            if (!nodeList.item(i).getNodeName().equals("display")) continue;
            DisplayModel.getDisplayModel((org.w3c.dom.Node)nodeList.item(i));
        }
    }

    public List<DisplayModel> getModels(Class<? extends Node> clazz) {
        if (!Node.class.isAssignableFrom(clazz)) {
            return null;
        }
        String string = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1);
        String[] stringArray = s_nodeTypeMap.get(string);
        String string2 = ViewerAddin.getKey("Oracle", stringArray[0]);
        ArrayList<DisplayModel> arrayList = new ArrayList<DisplayModel>();
        List<ViewerEditorAddin> list = this.getEditorsAddins(string2);
        for (ViewerEditorAddin viewerEditorAddin : list) {
            arrayList.add(viewerEditorAddin.getModel());
        }
        return arrayList;
    }

    public List<DisplayModel> getModels(DBObject dBObject) {
        String string = ViewerAddin.getKey(dBObject.getConnectionType(), dBObject.getObjectType());
        List<ViewerEditorAddin> list = this.getEditorsAddins(string);
        ArrayList<DisplayModel> arrayList = new ArrayList<DisplayModel>();
        if (list != null) {
            for (ViewerEditorAddin viewerEditorAddin : list) {
                arrayList.add(viewerEditorAddin.getModel());
            }
        }
        return arrayList;
    }

    static {
        s_nodeTypeMap = new HashMap<String, String[]>();
        s_nodeTypeMap.put("TableNode", new String[]{"TABLE"});
        s_nodeTypeMap.put("ViewNode", new String[]{"VIEW"});
        s_nodeTypeMap.put("MViewNode", new String[]{"MATERIALIZED_VIEW"});
        s_nodeTypeMap.put("PlSqlBaseNode", new String[]{"PROCEDURE", "FUNCTION", "PACKAGE", "PACKAGE BODY", "TYPE", "TYPE BODY"});
        s_nodeTypeMap.put("DatabaseLinkNode", new String[]{"DATABASE LINK"});
        s_nodeTypeMap.put("MViewLogNode", new String[]{"MATERIALIZED VIEW LOG"});
        s_nodeTypeMap.put("TriggerNode", new String[]{"TRIGGER"});
        s_nodeTypeMap.put("IndexNode", new String[]{"INDEX"});
        s_nodeTypeMap.put("RecycledObjectNode", new String[]{"RECYCLEBIN"});
        s_nodeTypeMap.put("DirectoryNode", new String[]{"DIRECTORY"});
        s_nodeTypeMap.put("QueueNode", new String[]{"QUEUE"});
        s_nodeTypeMap.put("QueueTableNode", new String[]{"QUEUE TABLE"});
        s_nodeTypeMap.put("JavaNode", new String[]{"JAVA"});
        s_nodeTypeMap.put("XmlSchemaNode", new String[]{"XML SCHEMA"});
    }

    private final class XMLParser
    extends AbstractFolderedXml {
        private XMLParser() {
        }

        public void openFolder(String string, String string2, String string3, org.w3c.dom.Node node) {
        }

        public void closeFolder() {
        }

        public void newNode(org.w3c.dom.Node node) {
            this.newItem(node);
        }

        public DisplayModel createDisplayModelFromEditor(org.w3c.dom.Node node, String string) {
            DisplayModel displayModel = new DisplayModel();
            if (string != null && string.equals("editor")) {
                DisplayModel displayModel2;
                displayModel.setName(XMLHelper.getNodeValue((org.w3c.dom.Node)node, (String)"title"));
                displayModel.setType(XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"vertical"));
                displayModel.setStyle(XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"display"));
                String string2 = XMLHelper.getAttributeNode((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"query"), (String)"id");
                displayModel.populateAttributes(node);
                if (string2 != null && !string2.equals("")) {
                    displayModel.setQueries(QueryCache.getQueries((String)string2));
                } else {
                    displayModel.setQueries(Query.getQueries((org.w3c.dom.Node)node));
                }
                if (XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"bottomquery") != null) {
                    displayModel2 = new DisplayModel();
                    displayModel2.setName(XMLHelper.getNodeValue((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"bottomquery"), (String)"title"));
                    string2 = XMLHelper.getAttributeNode((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"bottomquery"), (String)"query"), (String)"id");
                    if (string2 != null && !string2.equals("")) {
                        displayModel2.setQueries(QueryCache.getQueries((String)string2));
                    } else {
                        displayModel2.setQueries(Query.getQueries((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"bottomquery")));
                    }
                    displayModel.addChild(displayModel2);
                }
                if (XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"subquery") != null) {
                    displayModel2 = new DisplayModel();
                    displayModel2.setQueries(Query.getQueries((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"subquery")));
                    displayModel2.setStyle(XMLHelper.getAttributeNode((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"subquery"), (String)"type"));
                    displayModel.addChild(displayModel2);
                }
            }
            return displayModel;
        }

        public void newItem(org.w3c.dom.Node node) {
            String string;
            String[] stringArray;
            String string2;
            String string3 = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"type");
            String string4 = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"connType") == null ? "Oracle" : XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"connType");
            String string5 = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"objectType");
            if (string5 == null) {
                string2 = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"node");
                stringArray = (String[])s_nodeTypeMap.get(string2);
            } else {
                stringArray = new String[]{string5};
            }
            string2 = null;
            if (node.getNodeName().equals("display")) {
                string2 = DisplayModel.getDisplayModel((org.w3c.dom.Node)node);
            } else if (string3 != null && string3.equals("editor")) {
                string2 = this.createDisplayModelFromEditor(node, string3);
            } else if (string3 != null && string3.equals("sharedQuery")) {
                string = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"id");
                QueryCache.putQuery((String)string, (List)Query.getQueries((org.w3c.dom.Node)node));
            } else {
                string2 = DisplayModel.getDisplayModel((org.w3c.dom.Node)node);
            }
            if (string3 == null || !string3.equals("sharedQuery")) {
                String string6 = string = string2.getExtAttributes() == null ? null : (String)string2.getExtAttributes().get(ViewerAddin.EDITOR_CLASS);
                if (stringArray != null) {
                    for (String string7 : stringArray) {
                        String string8 = ViewerAddin.getKey(string4, string7);
                        if (string8 == null) continue;
                        string2.getExtAttributes().put(ViewerAddin.CLASS, string8);
                        if (ViewerAddin.this._editors.get(string8) == null) {
                            ViewerAddin.this._editors.put(string8, new ArrayList());
                        }
                        if (string == null) {
                            ((List)ViewerAddin.this._editors.get(string8)).add(string2);
                        }
                        Class<?> clazz = null;
                        try {
                            if (string == null) {
                                int n = ((List)ViewerAddin.this._editors.get(string8)).size() - 1;
                                clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("oracle.dbtools.raptor.oviewer.xmleditor.holders.XMLBasedEditor" + n);
                            } else {
                                clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(string);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ViewerAddin.this.logger.severe("Could not Load :" + classNotFoundException.getMessage());
                        }
                        ViewerAddin.this.addTab(string2.getName(), string4, string7, clazz, (DisplayModel)string2);
                    }
                }
            }
        }
    }
}

