/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.editors.DBEditorController;
import oracle.dbtools.raptor.editors.IStatusMessageProvider;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.Log;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.db.Database;

public abstract class ViewerEditor
extends Editor
implements Controller,
IStatusMessageProvider {
    private JComponent _panel;
    protected Toolbar _toolbar;
    private boolean _visible;
    private boolean _inSync;
    private boolean _pinEnabled = true;
    private IdeAction pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID, null, (String)IdeArb.getString((int)78), null, null, (Icon)IdeArb.getIcon((int)78), null, (boolean)true).newLocalAction((View)this);
    private IdeAction _toolbarAction;
    private JMenu _actionMenu;
    private boolean _initActions = false;
    private String _lastStatusbarMessage = "";
    private ToggleToolButton _pinToggle;
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");

    protected abstract JComponent createViewerUI();

    protected abstract void updateContent();

    protected abstract void cleanUp();

    public abstract Object getPrintable();

    public ViewerEditor() {
        this.pinAction.addController((Controller)this);
        Log.status((String)"");
        this.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent viewEvent) {
            }

            public void viewClosed(ViewEvent viewEvent) {
            }

            public void viewDeactivated(ViewEvent viewEvent) {
                ViewerEditor.this._lastStatusbarMessage = Ide.getStatusBar().getText();
            }
        });
    }

    public void open() {
        this.getGUI();
    }

    public Component getGUI() {
        if (this._panel == null) {
            this._panel = this.createViewerUI();
        }
        this.checkPin();
        return this._panel;
    }

    public void checkPin() {
        this.pinAction.setState(((ViewerNode)this.getContext().getNode()).getPinned());
    }

    public void addMenuButton() {
        if (this._toolbarAction == null) {
            JPopupMenu jPopupMenu;
            this._toolbarAction = XMLBasedObjectAction.getInstance().getIdeAction().newLocalAction((View)this);
            if (this.getContext().getNode() instanceof ViewerNode && (jPopupMenu = XMLBasedObjectAction.getInstance().getMenu(((ViewerNode)this.getContext().getNode()).getDBObject())).getComponentCount() > 0) {
                ToolButton toolButton = ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._toolbarAction);
                toolButton.setText("Actions...");
                toolButton.setIcon(IdeArb.getIcon((int)58));
                toolButton.setToolTipText("Available Actions");
                this._toolbarAction.putValue("BUTTON", (Object)toolButton);
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == ViewerNode.RELATION_NODE_CHANGED_MESSAGE_ID) {
            this.whenDbNodeChanged();
        } else if (n == ViewerNode.RELATION_NODE_MODIFIED_MESSAGE_ID && this.isVisible()) {
            this.updateContent();
        }
    }

    public Component getFixedTopMargin() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            if (this._pinEnabled) {
                this._pinToggle = this._toolbar.addToggleButton((ToggleAction)this.pinAction);
                ViewerNode viewerNode = (ViewerNode)this.getContext().getNode();
                this.pinAction.setState(viewerNode.getPinned());
                if (!viewerNode.getPinned()) {
                    this._pinToggle.setIcon(IdeArb.getIcon((int)175));
                } else {
                    this._pinToggle.setIcon(RaptorImagesArb.getIcon((int)68));
                }
            }
        }
        return this._toolbar;
    }

    public void editorShown() {
        this.whenVisibilityChanges(true);
    }

    public void editorHidden() {
        this.whenVisibilityChanges(false);
    }

    public boolean isVisible() {
        return this._visible;
    }

    private void whenVisibilityChanges(boolean bl) {
        this._visible = bl;
        if (this._visible) {
            if (!this._inSync) {
                this.whenDbNodeChanged();
            }
            ViewerEditor.updateToolbarActions((Toolbar)this._toolbar);
            if (!this._initActions) {
                this.addMenuButton();
                this._initActions = true;
            }
        }
    }

    protected void whenDbNodeChanged() {
        if (this.isVisible() && this.getContext().getNode() instanceof ViewerNode) {
            ((ViewerNode)this.getContext().getNode()).addNodeListener(new NodeListener(){

                public void nodeWillClose(NodeEvent nodeEvent) {
                    ViewerEditor.this.cleanUp();
                }
            });
            ViewerNode viewerNode = this.getViewerNode();
            Context context = this.getContext();
            Node node = viewerNode.getBaseNode();
            context.setSelection(new Element[]{node});
            this.updateContent();
        } else {
            this._inSync = false;
        }
    }

    public ViewerNode getViewerNode() {
        return this.getViewerNode(this.getContext());
    }

    private ViewerNode getViewerNode(Context context) {
        if (context.getNode() instanceof ViewerNode) {
            return (ViewerNode)context.getNode();
        }
        return null;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID) {
            ideAction.setEnabled(true);
            if (context.getNode() instanceof ViewerNode) {
                ViewerNode viewerNode = (ViewerNode)context.getNode();
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID && this._pinEnabled) {
            ViewerNode viewerNode;
            viewerNode.setPinned(!(viewerNode = (ViewerNode)context.getNode()).getPinned());
            if (!viewerNode.getPinned()) {
                this._pinToggle.setIcon(IdeArb.getIcon((int)175));
            } else {
                this._pinToggle.setIcon(RaptorImagesArb.getIcon((int)68));
            }
            View.updateToolbarActions((Toolbar)context.getView().getToolbar());
            return true;
        }
        return false;
    }

    public boolean isPinEnabled() {
        return this._pinEnabled;
    }

    public void setPinEnabled(boolean bl) {
        this._pinEnabled = bl;
    }

    public Context getContext(EventObject eventObject) {
        Database database;
        ViewerNode viewerNode;
        Context context = super.getContext(eventObject);
        if (context != null && (viewerNode = this.getViewerNode(context)) != null && (database = viewerNode.getDatabase()) != null) {
            context.setProperty("Connections.db_name", (Object)Connections.getInstance().getConnectionName(database));
        }
        return context;
    }

    public void close() {
        super.close();
        this.cleanUp();
    }

    public Controller getController() {
        return DBEditorController.getInstance();
    }

    public String getStatusMessage() {
        return this._lastStatusbarMessage;
    }
}

