/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.AddinManager;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;
import oracle.javatools.util.ModelUtil;

class ViewerEditorAddin
extends EditorAddin {
    private Logger logger = Logger.getLogger(ViewerEditorAddin.class.getName());
    public static float INIT_WEIGHT = 0.5f;
    public static float DELTA_WEIGHT = 0.001f;
    private static float _weight = INIT_WEIGHT;
    private final String m_label;
    private String m_connType;
    private String m_objType;
    private final Class m_editorClass;
    private float m_myWeight;
    private DisplayModel _model;

    public String toString() {
        return this.m_connType + "#" + this.m_objType;
    }

    public ViewerEditorAddin(String string, String string2, String string3, Class clazz) {
        this.m_label = string;
        this.m_connType = string2;
        this.m_objType = string3;
        this.m_editorClass = clazz;
        this.m_myWeight = _weight;
        _weight -= DELTA_WEIGHT;
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec(this.m_label, null, null);
    }

    public Class getEditorClass() {
        return this.m_editorClass;
    }

    public boolean restoreAtStartup() {
        return false;
    }

    public float getEditorWeight() {
        return this.m_myWeight;
    }

    public float getEditorWeight(Element element) {
        Object object;
        float f = Float.NaN;
        DBObject dBObject = null;
        if (element instanceof ViewerNode) {
            object = (ViewerNode)element;
            dBObject = ((ViewerNode)((Object)object)).getDBObject();
        }
        if (dBObject != null && dBObject.isValid()) {
            if ("TABLE".equals(this.m_objType)) {
                this.m_objType = "TABLE";
            }
            if (ModelUtil.areEqual((Object)(this.m_connType + "#" + this.m_objType), (Object)dBObject.getKey())) {
                if (XMLBasedEditor.class.isAssignableFrom(this.m_editorClass) && !(element instanceof PlSqlNode)) {
                    object = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
                    this.logger.finer("Checking:" + this.m_editorClass.toString());
                    int n = Integer.parseInt(this.m_editorClass.toString().substring(this.m_editorClass.toString().lastIndexOf(114) + 1));
                    DisplayModel displayModel = ((ViewerAddin)object).getModel(dBObject, n);
                    if (displayModel == null) {
                        return f;
                    }
                    Query query = displayModel.getQuery(dBObject.getConnection());
                    if (query != null) {
                        String string = (String)displayModel.getExtValues().get("requiredProp");
                        if (string != null) {
                            String string2 = string.split(":")[0].toUpperCase();
                            String string3 = string.split(":")[1].toUpperCase();
                            String string4 = (String)dBObject.getDictionary().get(string2);
                            if (string4 != null && string4.equalsIgnoreCase(string3)) {
                                f = this.m_myWeight;
                            }
                        } else {
                            f = this.m_myWeight;
                        }
                    }
                } else if (!(element instanceof PlSqlNode)) {
                    f = this.m_myWeight;
                }
            }
        }
        return f;
    }

    public DisplayModel getModel() {
        return this._model;
    }

    public void setModel(DisplayModel displayModel) {
        this._model = displayModel;
    }
}

