/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.resource.IdeArb;
import oracle.javatools.db.Database;
import oracle.javatools.util.ModelUtil;

public class ViewerNode
extends Node
implements IViewerNode,
Observer {
    public static final int RELATION_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(ViewerNode.class.getName() + ".relationNodeChanged"));
    public static final int RELATION_NODE_MODIFIED_MESSAGE_ID = UpdateMessage.newMessageID((String)(ViewerNode.class.getName() + ".relationNodeModified"));
    private static final String PROTOCOL = "ide.viewernode";
    private static ViewerNode INSTANCE;
    private static ViewerNode TEST_INSTANCE;
    private static int _nodeId;
    private boolean _pinned = true;
    private DBObject _dbObject;
    private Database _database;
    private ArrayList _dirtyComponents = new ArrayList(1);
    private static List<ViewerNode> _instances;

    public static ViewerNode getTestInstance() {
        if (TEST_INSTANCE == null) {
            TEST_INSTANCE = new ViewerNode();
        }
        return TEST_INSTANCE;
    }

    public static ViewerNode createInstance() {
        INSTANCE = new ViewerNode();
        _instances.add(INSTANCE);
        return INSTANCE;
    }

    public static synchronized ViewerNode getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ViewerNode.createInstance();
        }
        return INSTANCE;
    }

    public static ViewerNode getUnpinnedInstance() {
        if (!ViewerNode.getInstance().getPinned() && ViewerNode.getInstance().isOpen()) {
            return ViewerNode.getInstance();
        }
        for (int i = 0; i < _instances.size(); ++i) {
            ViewerNode viewerNode = _instances.get(i);
            if (viewerNode.getPinned()) continue;
            INSTANCE = viewerNode;
            return viewerNode;
        }
        return ViewerNode.createInstance();
    }

    public ViewerNode() {
        URL uRL = URLFactory.newURL((String)PROTOCOL, (String)("ViewerNode" + _nodeId++));
        this.setURL(uRL);
        this.setPinned(false);
        this.getAttributes().set(ElementAttributes.SAVEABLE | ElementAttributes.CLOSEABLE);
    }

    public String getShortLabel() {
        String string = "";
        if (this._database != null) {
            String string2;
            Node node = this._dbObject.getNode();
            string = string2 = node.getShortLabel();
        }
        return string;
    }

    public Icon getIcon() {
        return this._dbObject.getNode().getIcon();
    }

    public String getLongLabel() {
        if (this._dbObject != null) {
            String string = this._dbObject.getNode().getLongLabel();
            return string;
        }
        return "no viewable object";
    }

    public void setPinned(boolean bl) {
        if (this._pinned != bl) {
            this._pinned = bl;
        }
    }

    public boolean getPinned() {
        return this._pinned;
    }

    public void setViewedObject(DBObject dBObject) {
        if (this.checkCanChange()) {
            if (this._dbObject != null) {
                this._dbObject.getNode().detach((Observer)this);
            }
            this._database = dBObject.getDatabase();
            this._dbObject = dBObject;
            if (this._dbObject.getNode() != null) {
                this._dbObject.getNode().attach((Observer)this);
            }
            this.notifyObservers((Object)this, new UpdateMessage(RELATION_NODE_CHANGED_MESSAGE_ID, (Object)this));
            this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
            this.setOpen(this._dbObject.getNode() != null);
        }
    }

    protected void closeImpl() throws IOException {
        _instances.remove((Object)this);
        this.markDirty(false);
    }

    private boolean checkCanChange() {
        boolean bl = true;
        if (this.isDirty()) {
            try {
                String string = MessageFormat.format(IdeArb.getString((int)97), this.getLongLabel());
                int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string, (String)this.getLongLabel(), null);
                switch (n) {
                    case 1: {
                        this.save();
                        break;
                    }
                    case 0: {
                        this.revert();
                        break;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                bl = false;
            }
        }
        return bl;
    }

    public Node getBaseNode() {
        return this._dbObject != null ? this._dbObject.getNode() : null;
    }

    public Database getDatabase() {
        return this._database;
    }

    public DBObject getDBObject() {
        return this._dbObject;
    }

    public void addDirtyComponent(DirtyComponent dirtyComponent) {
        if (!this._dirtyComponents.contains(dirtyComponent)) {
            this._dirtyComponents.add(dirtyComponent);
            this.markDirty(true);
        }
    }

    public void removeDirtyComponent(DirtyComponent dirtyComponent) {
        if (this._dirtyComponents.remove(dirtyComponent) && this._dirtyComponents.isEmpty()) {
            this.markDirty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            this.notifyObservers(object, new UpdateMessage(RELATION_NODE_MODIFIED_MESSAGE_ID, (Object)this));
        } else if (updateMessage.getMessageID() == UpdateMessage.OBJECT_RELOADED && object == this.getBaseNode() && this.getBaseNode() instanceof TextNode) {
            Context context = Context.newIdeContext((Element)this.getBaseNode());
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            openEditorOptions.setFlags(1);
            WaitCursor waitCursor = Ide.getWaitCursor();
            context.setProject(Ide.getDefaultProject());
            try {
                waitCursor.show();
                EditorManager.getEditorManager().openEditor(openEditorOptions);
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    protected void openImpl() throws IOException {
        INSTANCE = this;
    }

    protected void revertImpl() throws IOException {
        this._dirtyComponents.clear();
    }

    protected void saveImpl() throws IOException {
        for (int i = 0; i < this._dirtyComponents.size(); ++i) {
            DirtyComponent dirtyComponent = (DirtyComponent)this._dirtyComponents.get(i);
            dirtyComponent.save(this);
        }
        this._dirtyComponents.clear();
    }

    static {
        URLFileSystem.registerHelper((String)PROTOCOL, (URLFileSystemHelper)new FileSystemHelper());
        _nodeId = 0;
        _instances = new ArrayList<ViewerNode>(1);
    }

    private static final class FileSystemHelper
    extends URLFileSystemHelper {
        private FileSystemHelper() {
        }

        public String getPlatformPathName(URL uRL) {
            ViewerNode viewerNode = INSTANCE;
            for (ViewerNode viewerNode2 : _instances) {
                URL uRL2 = viewerNode2.getURL();
                if (!ModelUtil.areEqual((Object)uRL.getPath(), (Object)uRL2.getPath())) continue;
                viewerNode = viewerNode2;
                break;
            }
            return viewerNode != null ? viewerNode.getLongLabel() : "Viewer Node";
        }
    }

    public static interface DirtyComponent {
        public void save(ViewerNode var1) throws IOException;
    }
}

