/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.extsearch;

import java.awt.Component;
import java.awt.Point;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.insight.IdentifiersDb;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.extsearch.Query;
import oracle.dbtools.raptor.oviewer.extsearch.URLListRenderer;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.AbstractBrowseClickPlugin;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;

public class IdentifierDefinitionLookup
extends AbstractBrowseClickPlugin
implements Controller {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public static final int DEF_LOOKUP_ID = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.oviewer.extsearch.IdentifierDefinitionLookup.DEF_LOOKUP_ID");
    private static final String ACCELERATOR_FILE = "oracle/dbtools/raptor/oviewer/extsearch/accelerators.xml";
    private static IdentifierDefinitionLookup instance = null;
    ParseNode id;
    ParseNode def;
    Action action;
    Context ctx;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DEF_LOOKUP_ID) {
            Node node = context.getNode();
            View view = context.getView();
            if (node instanceof PlSqlNode) {
                PlSqlNode plSqlNode = (PlSqlNode)node;
                BasicEditorPane basicEditorPane = (BasicEditorPane)view.getGUI();
                String string = plSqlNode.getConnectionName() != null ? plSqlNode.getConnectionName() : DBURLFormatHelper.getConnectionName((URL)plSqlNode.getURL());
                int n2 = basicEditorPane.getCaretPosition();
                this.logger.info("Context menu declaration offset:" + n2);
                this.parseIdentifierAtOffset(n2, plSqlNode.parser, string, basicEditorPane);
                if (this.action != null) {
                    this.action.eval(plSqlNode);
                }
            } else if (view instanceof FindableEditor) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DEF_LOOKUP_ID) {
            ideAction.setEnabled(this.isAvailable(context));
            return true;
        }
        return false;
    }

    private boolean isAvailable(Context context) {
        Node node = context.getNode();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            if (plSqlNode.parser != null && plSqlNode.parser.output != null) {
                return true;
            }
        }
        return false;
    }

    public static void init() {
        if (instance == null) {
            instance = new IdentifierDefinitionLookup(null);
        }
        IdeAction ideAction = IdeAction.get((int)DEF_LOOKUP_ID, null, (String)"Open Declaration", null, null, null, null, null, (boolean)true);
        ideAction.addController((Controller)instance);
        JMenuItem jMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)ideAction);
        CtxMenuListener ctxMenuListener = new CtxMenuListener(jMenuItem);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)ctxMenuListener);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)instance)).getClass().getClassLoader(), ACCELERATOR_FILE);
    }

    private static boolean isMenuAvailable(Context context) {
        Node node = context.getNode();
        return node instanceof PlSqlNode;
    }

    protected void parseIdentifierAtOffset(int n, BackgroundParser backgroundParser, String string, BasicEditorPane basicEditorPane) {
        this.action = null;
        this.logger.info("Source offset:" + n);
        this.id = this.getIdentifierEntry(n, backgroundParser);
        if (this.id == null) {
            return;
        }
        this.logger.info("Identifier: [" + this.id.from + "," + this.id.to + ")");
        this.def = this.getIdentifierDefinition(this.id, backgroundParser);
        if (this.def != null && this.def.from <= this.id.from && this.id.to <= this.def.to && this.def.contains(IdentifiersDb.instance.from_table_reference_or_subquery)) {
            this.action = new Action.TABLE(backgroundParser, this.id, string);
            return;
        }
        if (this.def != null) {
            this.logger.info("Found local definition: [" + this.def.from + "," + this.def.to + ")");
            this.action = new Action.LOCAL(backgroundParser, this.def, basicEditorPane);
            return;
        }
        ParseNode parseNode = backgroundParser.output.parent(this.id.from, this.id.to);
        if (this.id.contains(IdentifiersDb.instance.procedure_call) || parseNode.contains(IdentifiersDb.instance.procedure_call)) {
            this.action = new Action.PLSQL(backgroundParser, this.id, string);
            return;
        }
    }

    private static void goToTable(String string, String string2, String string3) {
        Query query = new Query(string){

            public int limit() {
                return 2;
            }
        };
        query.prepareObject(string2, "TABLE", string3);
        query.prepareObject(string2, "VIEW", string3);
        URL uRL = query.fetch();
        URLListRenderer.goTo(uRL);
    }

    private static void goToPlSql(String string, String string2, String string3, PlSqlNode plSqlNode) {
        URL uRL;
        Query query = new Query(string){

            public int limit() {
                return 10;
            }
        };
        if (string2 == null) {
            query.prepareAllObjects(string3, "FUNCTION");
            query.prepareAllObjects(string3, "PROCEDURE");
            uRL = plSqlNode.getNodeInstance();
            DatabaseObject databaseObject = (DatabaseObject)uRL.getDescriptor();
            String string4 = databaseObject.getType();
            if (!"PROCEDURE".equals(string4) && !"FUNCTION".equals(string4)) {
                query.prepareAllSource((String)plSqlNode.getProperty("NAME"), string3);
            }
        } else {
            query.prepareAllSource(string2, string3);
        }
        uRL = query.fetch();
        URLListRenderer.goTo(uRL);
    }

    public ParseNode getIdentifierEntry(int n, BackgroundParser backgroundParser) {
        if (backgroundParser.src == null) {
            return null;
        }
        for (int i = 0; i < backgroundParser.src.size(); ++i) {
            LexerToken lexerToken = (LexerToken)backgroundParser.src.get(i);
            if (lexerToken.begin > n || n > lexerToken.end || lexerToken.type == Token.WS) continue;
            if (lexerToken.type != Token.IDENTIFIER) {
                return null;
            }
            ParseNode parseNode = backgroundParser.output.leafAtPos(i);
            ParseNode parseNode2 = backgroundParser.output.parent(parseNode.from, parseNode.to);
            boolean bl = false;
            for (ParseNode parseNode3 : parseNode2.children()) {
                if (!parseNode3.contains(IdentifiersDb.instance.aggr)) continue;
                bl = true;
                break;
            }
            if (parseNode2.contains(IdentifiersDb.instance.expanded_n) || parseNode2.contains(IdentifiersDb.instance.name) && !bl) {
                return parseNode2;
            }
            return parseNode;
        }
        return null;
    }

    public ParseNode getIdentifierDefinition(ParseNode parseNode, BackgroundParser backgroundParser) {
        Map map = IdentifiersDb.instance.collectIdentifiers(backgroundParser.output);
        return IdentifiersDb.getIdentifierDefinition((ParseNode)parseNode, (List)backgroundParser.src, (Map)map);
    }

    IdentifierDefinitionLookup(Context context) {
        this.ctx = context;
    }

    protected NumberRange getIdentifierAtOffset(int n) {
        Node node = this.ctx.getNode();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            String string = plSqlNode.getConnectionName() != null ? plSqlNode.getConnectionName() : DBURLFormatHelper.getConnectionName((URL)plSqlNode.getURL());
            View view = this.ctx.getView();
            BasicEditorPane basicEditorPane = (BasicEditorPane)view.getGUI();
            this.parseIdentifierAtOffset(n, plSqlNode.parser, string, basicEditorPane);
            if (this.action != null) {
                return new NumberRange(((LexerToken)plSqlNode.parser.src.get((int)this.id.from)).begin, ((LexerToken)plSqlNode.parser.src.get((int)(this.id.to - 1))).end);
            }
            return null;
        }
        return null;
    }

    protected void performDeclarationClick(Point point) {
        if (this.action != null) {
            Node node = this.ctx.getNode();
            PlSqlNode plSqlNode = (PlSqlNode)node;
            this.action.eval(plSqlNode);
        }
    }

    static abstract class Action {
        Action() {
        }

        abstract void eval(PlSqlNode var1);

        static class PLSQL
        extends Action {
            BackgroundParser parser;
            ParseNode id;
            String connName;

            PLSQL(BackgroundParser backgroundParser, ParseNode parseNode, String string) {
                this.parser = backgroundParser;
                this.id = parseNode;
                this.connName = string;
            }

            void eval(PlSqlNode plSqlNode) {
                String string = null;
                String string2 = ((LexerToken)this.parser.src.get((int)this.id.from)).content;
                if (this.id.from > 1 && ".".equals(((LexerToken)this.parser.src.get((int)(this.id.from + 1))).content)) {
                    string = ((LexerToken)this.parser.src.get((int)this.id.from)).content;
                    string2 = ((LexerToken)this.parser.src.get((int)(this.id.from + 2))).content;
                }
                IdentifierDefinitionLookup.goToPlSql(this.connName, string, string2, plSqlNode);
            }
        }

        static class LOCAL
        extends Action {
            BackgroundParser parser;
            ParseNode def;
            BasicEditorPane panel;

            LOCAL(BackgroundParser backgroundParser, ParseNode parseNode, BasicEditorPane basicEditorPane) {
                this.parser = backgroundParser;
                this.def = parseNode;
                this.panel = basicEditorPane;
            }

            void eval(PlSqlNode plSqlNode) {
                NumberRange numberRange = new NumberRange(((LexerToken)this.parser.src.get((int)this.def.from)).begin, ((LexerToken)this.parser.src.get((int)this.def.from)).end);
                if (numberRange != null) {
                    this.panel.setSelectionStart(numberRange.start);
                    this.panel.setSelectionEnd(numberRange.end);
                }
            }
        }

        static class TABLE
        extends Action {
            BackgroundParser parser;
            ParseNode id;
            String connName;

            TABLE(BackgroundParser backgroundParser, ParseNode parseNode, String string) {
                this.parser = backgroundParser;
                this.id = parseNode;
                this.connName = string;
            }

            void eval(PlSqlNode plSqlNode) {
                String string = null;
                if (this.id.from + 3 == this.id.to) {
                    string = ((LexerToken)this.parser.src.get((int)this.id.from)).content;
                }
                IdentifierDefinitionLookup.goToTable(this.connName, ((LexerToken)this.parser.src.get((int)(this.id.to - 1))).content, string);
            }
        }
    }

    private static final class CtxMenuListener
    implements ContextMenuListener {
        private JMenuItem mi;

        CtxMenuListener(JMenuItem jMenuItem) {
            this.mi = jMenuItem;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Context context;
            Context context2 = context = contextMenu == null ? null : contextMenu.getContext();
            if (context == null) {
                return;
            }
            if (IdentifierDefinitionLookup.isMenuAvailable(context)) {
                contextMenu.add((Component)this.mi);
            }
        }
    }
}

