/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.extsearch;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.util.Util;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private static final Logger logger = Logger.getLogger(Query.class.getName());
    private String connectionName;
    private StringBuffer query = new StringBuffer();
    private List binds = new ArrayList();
    private final String QUERY_ALL_OBJECTS = "select null name, -1 LINE, -1 COL, null USAGE, object_type TYPE, OWNER, object_type OBJECT_TYPE, OBJECT_NAME \n from sys.all_objects where rownum <= " + this.limit();
    private static final String OBJ_LIKE_CRITERIA = " and object_name like ? ";
    private static final String OBJ_CRITERIA = " and object_name = ? ";
    private static final String OBJECT_TYPE_CRITERIA = " and object_type = ? ";
    private static final String OWNER_CRITERIA = " and owner = ? ";
    private final String QUERY_ALL_COLUMNS = "select c.column_name name, -1 LINE, -1 COL, null USAGE, o.object_type TYPE, c.OWNER, o.object_type OBJECT_TYPE, c.table_NAME OBJECT_NAME \n from sys.all_tab_columns c, all_objects o \n where c.table_name=o.object_name and c.owner = o.owner and rownum <= " + this.limit();
    private static final String COL_LIKE_CRITERIA = " and c.column_name like ? ";
    private final String QUERY_ALL_IDENTIFIERS = "select name, LINE, COL, USAGE, TYPE, OWNER, OBJECT_TYPE, OBJECT_NAME \n from sys.all_identifiers where rownum <= " + this.limit();
    private static final String NAME_LIKE_CRITERIA = " and name like ? ";
    private static final String USAGE_CRITERIA = " and usage = ? ";
    private static final String TYPE_CRITERIA = " and type = ? ";
    private final String QUERY_ALL_SOURCE = "select text name, LINE, instr(upper(text),?) COL, null USAGE, TYPE, OWNER, type OBJECT_TYPE, name OBJECT_NAME \n from sys.all_source where rownum <= " + this.limit() + " \n" + " and upper(text) like upper(?) and name not like 'BIN$%' \n" + " and (instr(text,'--')<=0 or instr(text,'--')>instr(upper(text),upper(?))) \n" + " and (instr(text,'/*')<=0 or instr(text,'/*')>instr(upper(text),upper(?)))";
    private static final String NAME_CRITERIA = " and name = ? ";
    boolean prepareAllIdCalled = false;

    public Query(String string) {
        this.connectionName = string;
    }

    public int limit() {
        return 500;
    }

    private static String limit(String string, int n) {
        return "select * from (" + string + ") where rownum <= " + n;
    }

    private String limit(String string) {
        return Query.limit(string, this.limit());
    }

    public void prepareAllObjects(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ALL_OBJECTS;
        if (string != null && !"".equals(string) && string.indexOf(46) > 0) {
            String string4 = string.substring(0, string.indexOf(46));
            string = string.substring(string.indexOf(46) + 1);
            string3 = string3 + OWNER_CRITERIA;
            this.binds.add(string4.toUpperCase());
        }
        if (string != null && !"".equals(string)) {
            string3 = string3 + OBJ_LIKE_CRITERIA;
            this.binds.add(string.toUpperCase());
        }
        if (string2 != null && !"ALL".equals(string2) && !"".equals(string2)) {
            string3 = string3 + OBJECT_TYPE_CRITERIA;
            this.binds.add(string2.toUpperCase());
        }
        this.query.append(string3);
    }

    public void prepareObject(String string, String string2, String string3) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string4 = this.QUERY_ALL_OBJECTS;
        if (string != null && !"".equals(string)) {
            string4 = string4 + OBJ_CRITERIA;
            this.binds.add(string.toUpperCase());
        }
        if (string2 != null && !"ALL".equals(string2) && !"".equals(string2)) {
            string4 = string4 + OBJECT_TYPE_CRITERIA;
            this.binds.add(string2.toUpperCase());
        }
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + OWNER_CRITERIA;
            this.binds.add(string3.toUpperCase());
        }
        this.query.append(string4);
    }

    public void prepareAllColumns(String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string2 = this.QUERY_ALL_COLUMNS;
        if (string != null && !"".equals(string)) {
            string2 = string2 + COL_LIKE_CRITERIA;
            this.binds.add(string);
        }
        this.query.append(string2);
    }

    public void prepareAllIdentifiers(String string, String string2, String string3) {
        if (this.prepareAllIdCalled) {
            return;
        }
        this.prepareAllIdCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string4 = this.QUERY_ALL_IDENTIFIERS;
        if (string != null && !"".equals(string)) {
            string4 = string4 + NAME_LIKE_CRITERIA;
            this.binds.add(string);
        }
        if (string2 != null && !"ALL".equals(string2) && !"".equals(string2)) {
            string4 = string4 + TYPE_CRITERIA;
            this.binds.add(string2);
        }
        if (string3 != null && !"ALL".equals(string3) && !"".equals(string3)) {
            string4 = string4 + USAGE_CRITERIA;
            this.binds.add(string3);
        }
        this.query.append(string4);
    }

    public void prepareAllSource(String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_ALL_SOURCE);
        this.binds.add(string);
        this.binds.add("%" + string + "%");
        this.binds.add(string);
        this.binds.add(string);
    }

    public void prepareAllSource(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append("select * from (" + this.QUERY_ALL_SOURCE);
        this.query.append("\n and type like 'PACKAGE%'");
        this.query.append(NAME_CRITERIA);
        this.query.append("\n) where col = 1 or substr(name/*text*/,col-1,1)=' '");
        this.query.append("\n order by type, line");
        this.binds.add(string2);
        this.binds.add("%" + string2 + "%");
        this.binds.add(string2);
        this.binds.add(string2);
        this.binds.add(string.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<URL> fetch(String string) {
        long l = System.currentTimeMillis();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = DBUtil.getConnectionResolver().getConnection(this.connectionName);
            statement = connection.prepareStatement("select * from ( \n" + this.query.toString() + "\n ) where rownum <= " + this.limit() + "order by name, CASE WHEN USAGE = 'DECLARATION' OR " + "USAGE = 'DEFINITION' THEN 0 ELSE 1 END, usage, type, owner, object_name, line, col");
            for (int i = 1; i <= this.binds.size(); ++i) {
                statement.setObject(i, this.binds.get(i - 1));
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string2;
                if (resultSet.getRow() >= this.limit()) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)("Displaying " + this.limit() + "records only." + "\n Please refine your search criteria"), (String)"Too many objects", null);
                }
                URL uRL = null;
                int n = resultSet.getInt("LINE");
                if (n >= 0) {
                    int n2 = resultSet.getInt("COL");
                    string2 = resultSet.getString("USAGE");
                    String string3 = resultSet.getString("TYPE");
                    String string4 = resultSet.getString("NAME");
                    if (n2 <= 0) {
                        n2 = string4.toUpperCase().indexOf(string.toUpperCase()) + 1;
                    }
                    String string5 = "" + Util.pair((int)n, (int)n2) + "," + string2 + "," + string3 + "," + string4 + '\uffff' + string;
                    uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this.connectionName, (String)string5, (String)resultSet.getString("OWNER"), (String)resultSet.getString("OBJECT_TYPE")), (String)resultSet.getString("OBJECT_NAME"));
                } else {
                    String string6 = resultSet.getString("OBJECT_NAME");
                    string2 = resultSet.getString("NAME");
                    if (string2 != null) {
                        string6 = string6 + "." + string2;
                    }
                    uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this.connectionName, null, (String)resultSet.getString("OWNER"), (String)resultSet.getString("OBJECT_TYPE")), (String)string6);
                }
                if (uRL == null) continue;
                arrayList.add(uRL);
            }
        }
        catch (DBException dBException) {
            logger.severe(this.query.toString());
            logger.severe(dBException.getMessage());
        }
        catch (SQLException sQLException) {
            logger.severe(this.query.toString());
            logger.severe(sQLException.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        long l2 = System.currentTimeMillis();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL fetch() {
        URL uRL;
        long l = System.currentTimeMillis();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = DBUtil.getConnectionResolver().getConnection(this.connectionName);
            statement = connection.prepareStatement(this.query.toString());
            for (int i = 1; i <= this.binds.size(); ++i) {
                statement.setObject(i, this.binds.get(i - 1));
            }
            resultSet = statement.executeQuery();
            resultSet.next();
            uRL = null;
            int n = resultSet.getInt("LINE");
            if (n < 0) {
                String string = resultSet.getString("OBJECT_NAME");
                String string2 = resultSet.getString("NAME");
                if (string2 != null) {
                    string = string + "." + string2;
                }
                URL uRL2 = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this.connectionName, null, (String)resultSet.getString("OWNER"), (String)resultSet.getString("OBJECT_TYPE")), (String)string);
                return uRL2;
            }
            int n2 = resultSet.getInt("COL");
            String string = resultSet.getString("USAGE");
            String string3 = resultSet.getString("TYPE");
            String string4 = resultSet.getString("NAME");
            String string5 = "" + Util.pair((int)n, (int)n2) + "," + string + "," + string3 + "," + string4;
            uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this.connectionName, (String)string5, (String)resultSet.getString("OWNER"), (String)resultSet.getString("OBJECT_TYPE")), (String)resultSet.getString("OBJECT_NAME"));
            URL uRL3 = uRL;
            return uRL3;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 17011) {
                uRL = null;
                return uRL;
            }
            logger.severe(this.query.toString());
            logger.severe(sQLException.getMessage());
        }
        catch (DBException dBException) {
            logger.severe(this.query.toString());
            logger.severe(dBException.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            long l2 = System.currentTimeMillis();
        }
        return null;
    }
}

