/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.extsearch;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.oviewer.extsearch.Query;
import oracle.dbtools.raptor.oviewer.extsearch.URLListRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;

public class SearchPanel
extends JPanel {
    private DBConnectionComboBox _dbSelector;
    static final String[] identifierTypes = new String[]{"ALL", "ASSOC ARRAY", "BFILE DATATYPE", "BLOB DATATYPE", "BOOLEAN DATATYPE", "CHARACTER DATATYPE", "CLOB DATATYPE", "CONSTANT", "DATE DATATYPE", "EXCEPTION", "FORMAL IN", "FUNCTION", "INDEX TABLE", "INTERVAL DATATYPE", "NESTED TABLE", "NUMBER DATATYPE", "OBJECT", "OPAQUE", "PACKAGE", "PROCEDURE", "RECORD", "REFCURSOR", "SUBTYPE", "TIME DATATYPE", "TIMESTAMP DATATYPE", "UROWID", "VARIABLE", "VARRAY"};
    static final String allSource = "ALL SOURCE";
    static final String[] objTypes = new String[]{"ALL", "VIEW", "SYNONYM", "INDEX", "TYPE", "TABLE", "PACKAGE", "PACKAGE BODY", "INDEX PARTITION", "TABLE PARTITION", "LIBRARY", "SEQUENCE", "TYPE BODY", "FUNCTION", "PROCEDURE", "TRIGGER", "COLUMN"};
    static final String[] identifierUsages = new String[]{"ALL", "ASSIGNMENT", "CALL", "DECLARATION", "DEFINITION", "REFERENCE"};
    JLabel lblConnection = new JLabel("Connection:");
    JLabel lblName = new JLabel();
    JLabel lblType = new JLabel();
    JLabel lblUsage = new JLabel();
    JTextField fldName = new JTextField();
    JComboBox cmbType = new JComboBox();
    JComboBox cmbUsage = new JComboBox();
    JButton lookupButton = new JButton("Lookup", RaptorImagesArb.getIcon((int)57));
    private JList _results;
    private Logger logger = Logger.getLogger(SearchPanel.class.getName());
    private DefaultListModel _model;
    private boolean includeIds = true;
    private URLListRenderer ulr = new URLListRenderer();
    IObjectActionListener dropListener = new IObjectActionListener(){

        public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            URL uRL = dBObject.getURL();
            URL uRL2 = null;
            Enumeration enumeration = SearchPanel.this._model.elements();
            while (enumeration.hasMoreElements()) {
                uRL2 = (URL)enumeration.nextElement();
                if (uRL2 != uRL) continue;
                SearchPanel.this._model.removeElement(uRL2);
            }
        }
    };

    public SearchPanel() {
        super(new GridBagLayout());
        this.createGUI();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_extendedsearch_html");
    }

    public URL getSelectedURL() {
        if (this._results.getSelectedIndex() > -1) {
            return (URL)((DefaultListModel)this._results.getModel()).getElementAt(this._results.getSelectedIndex());
        }
        return null;
    }

    private void initCmbType() {
        this.cmbType.removeAllItems();
        this.cmbType.setEditable(true);
        for (String string : objTypes) {
            this.cmbType.addItem(string);
        }
        if (this.includeIds) {
            for (String string : identifierTypes) {
                this.cmbType.addItem(string);
            }
        } else {
            this.cmbType.addItem(allSource);
        }
    }

    private void initCmbUsage() {
        this.cmbUsage.removeAllItems();
        this.cmbUsage.setEditable(true);
        if (this.includeIds) {
            for (String string : identifierUsages) {
                this.cmbUsage.addItem(string);
            }
        }
    }

    private void createGUI() {
        String[] stringArray;
        this._dbSelector = new DBConnectionComboBox();
        this._dbSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SearchPanel.this._dbSelector.getCurrentConnectionName();
                try {
                    Database database = Connections.getInstance().getDatabase(string);
                    if (database == null) {
                        return;
                    }
                    Connection connection = database.getConnection();
                    SearchPanel.this.includeIds = connection.getMetaData().getDatabaseMajorVersion() >= 11;
                    SearchPanel.this.initCmbType();
                    SearchPanel.this.initCmbUsage();
                }
                catch (DBException dBException) {
                    SearchPanel.this.logger.severe(dBException.getMessage());
                }
                catch (SQLException sQLException) {
                    SearchPanel.this.logger.severe(sQLException.getMessage());
                }
            }
        });
        this._model = new DefaultListModel();
        this._results = new JList(this._model);
        for (String string : stringArray = this._dbSelector.getConnNames()) {
            if (Connections.getInstance().isOracle(string)) continue;
            this._dbSelector.removeConnection(string);
        }
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)"Name:");
        ResourceUtils.resLabel((JLabel)this.lblType, (Component)this.cmbType, (String)"Type:");
        ResourceUtils.resLabel((JLabel)this.lblUsage, (Component)this.cmbUsage, (String)"Usage:");
        this.initCmbType();
        this.initCmbUsage();
        ObjectActionController.addListener((IObjectActionListener)this.dropListener);
        this.lookupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this._dbSelector.getCurrentConnection();
                if (Connections.getInstance().isConnectionOpen(SearchPanel.this._dbSelector.getCurrentConnectionName())) {
                    SearchPanel.this.doSearch();
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Please select db connection", (String)"Mising info", null);
                }
            }
        });
        this._results.setCellRenderer(this.ulr);
        this.add((Component)this.lblConnection, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 38, 0));
        this.add((Component)this._dbSelector.getJComboBox(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.fldName.setText("");
        this.add((Component)this.lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 38, 0));
        this.add((Component)this.lblType, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 46, 0));
        this.add((Component)this.lblUsage, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 46, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 151, 0));
        this.add((Component)this.cmbType, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 89, 0));
        this.add((Component)this.cmbUsage, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 89, 0));
        this.add((Component)this.lookupButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 89, 0));
        this.add((Component)new JScrollPane(this._results), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 1, new Insets(1, 1, 0, 0), 0, 0));
    }

    private void doSearch() {
        DefaultListModel defaultListModel = new DefaultListModel();
        JList jList = new JList(defaultListModel);
        this.ulr.cleanCache();
        IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;

            public void cancel() {
                this._isCanceled = true;
            }

            public Object doWork() {
                String string;
                String string2 = SearchPanel.this._dbSelector.getCurrentConnectionName();
                Query query = new Query(string2);
                String string3 = SearchPanel.this.fldName.getText().toUpperCase();
                String string4 = (String)SearchPanel.this.cmbType.getSelectedItem();
                if (string4 != null) {
                    string4 = string4.toUpperCase();
                }
                if ((string = (String)SearchPanel.this.cmbUsage.getSelectedItem()) != null) {
                    string = string.toUpperCase();
                }
                for (String string5 : objTypes) {
                    if (!string5.equals(string4) || "COLUMN".equals(string5)) continue;
                    query.prepareAllObjects(string3, string4);
                    break;
                }
                if ("COLUMN".equals(string4) || "ALL".equals(string4)) {
                    query.prepareAllColumns(string3);
                }
                if (SearchPanel.allSource.equals(string4) && string3.length() > 0) {
                    query.prepareAllSource(string3);
                }
                for (String string5 : identifierTypes) {
                    if (!string5.equals(string4) || !SearchPanel.this.includeIds) continue;
                    query.prepareAllIdentifiers(string3, string4, string);
                    break;
                }
                for (String string5 : identifierUsages) {
                    if (!string5.equals(string) || "ALL".equals(string5) || !SearchPanel.this.includeIds) continue;
                    query.prepareAllIdentifiers(string3, string4, string);
                    break;
                }
                return query.fetch(string3);
            }

            public void finish(Object object) {
                DefaultListModel defaultListModel = (DefaultListModel)SearchPanel.this._results.getModel();
                defaultListModel.clear();
                ArrayList arrayList = (ArrayList)object;
                for (URL uRL : arrayList) {
                    defaultListModel.addElement(uRL);
                }
            }

            public void preWork() {
            }
        };
        DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Searching", null, 500, iDelayedProgressRunnable, jList);
        delayedProgressRunnable.setCancellable(true);
        delayedProgressRunnable.start();
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(1);
    }
}

