/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.search.URLListRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;

public class RecentObjectsPanel
extends JPanel
implements ConnectionListener {
    private DefaultListModel _model;
    private JList _list;

    public RecentObjectsPanel() {
        super(new GridBagLayout());
        this.init();
        Connections.getInstance().addConnectionListener((ConnectionListener)this);
    }

    public URL getSelectedURL() {
        if (this._list.getSelectedIndex() > -1) {
            return (URL)((DefaultListModel)this._list.getModel()).getElementAt(this._list.getSelectedIndex());
        }
        return null;
    }

    private void init() {
        this._model = new DefaultListModel();
        this._list = new JList(this._model);
        this._list.setCellRenderer(new URLListRenderer());
        this.add((Component)new JScrollPane(this._list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 1, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_finddbrecent_html");
        final Observer observer = new Observer(){

            public void update(Object object, UpdateMessage updateMessage) {
                if (updateMessage.getMessageID() == ViewerNode.RELATION_NODE_CHANGED_MESSAGE_ID) {
                    URL uRL;
                    ViewerNode viewerNode = (ViewerNode)((Object)object);
                    String string = viewerNode.getDBObject().getConnectionName();
                    if (Connections.getInstance().isOracle(string) && ((uRL = viewerNode.getDBObject().getNode().getURL()).getProtocol().equals("sqldev.nav") || uRL.getProtocol().equals("sqldev.worksheet"))) {
                        URL uRL2 = null;
                        boolean bl = true;
                        for (int i = 0; i < RecentObjectsPanel.this._model.getSize(); ++i) {
                            uRL2 = (URL)RecentObjectsPanel.this._model.get(i);
                            if (!uRL2.equals(uRL)) continue;
                            bl = false;
                        }
                        if (bl) {
                            System.out.println(uRL);
                            RecentObjectsPanel.this._model.add(0, uRL);
                            RecentObjectsPanel.this._list.setSelectedIndex(0);
                        }
                    }
                }
            }
        };
        Node.addNodeListenerForType(ViewerNode.class, (NodeListener)new NodeListener(){

            public void nodeWillOpen(NodeEvent nodeEvent) {
                nodeEvent.getNode().attach(observer);
            }
        });
        IObjectActionListener iObjectActionListener = new IObjectActionListener(){

            public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            }

            public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            }

            public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            }

            public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
                URL uRL = dBObject.getURL();
                URL uRL2 = null;
                Enumeration enumeration = RecentObjectsPanel.this._model.elements();
                while (enumeration.hasMoreElements()) {
                    uRL2 = (URL)enumeration.nextElement();
                    if (uRL2 != uRL) continue;
                    System.out.println(uRL2);
                    RecentObjectsPanel.this._model.removeElement(uRL2);
                    URLListRenderer.removeIcon(uRL2);
                }
            }
        };
        ObjectActionController.addListener((IObjectActionListener)iObjectActionListener);
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
        this.processConnectionModification(connectionEvent);
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        this.processConnectionModification(connectionEvent);
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
        this.processConnectionModification(connectionEvent);
    }

    private void processConnectionModification(ConnectionEvent connectionEvent) {
        URL uRL = null;
        String string = connectionEvent.getConnectionName();
        Enumeration enumeration = this._model.elements();
        while (enumeration.hasMoreElements()) {
            uRL = (URL)enumeration.nextElement();
            String string2 = DBURLFormatHelper.getConnectionName((URL)uRL);
            if (!string2.equals(string)) continue;
            this._model.removeElement(uRL);
            URLListRenderer.removeIcon(uRL);
        }
    }
}

