/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.search.URLListRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.Version;

public class SearchPanel
extends JPanel {
    private DBConnectionComboBox _dbSelector;
    private JTextField _search;
    private JList _results;
    private Logger logger = Logger.getLogger(SearchPanel.class.getName());
    private DefaultListModel _model;
    IObjectActionListener dropListener = new IObjectActionListener(){

        public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            URL uRL = dBObject.getURL();
            URL uRL2 = null;
            Enumeration enumeration = SearchPanel.this._model.elements();
            while (enumeration.hasMoreElements()) {
                uRL2 = (URL)enumeration.nextElement();
                if (!uRL2.equals(uRL)) continue;
                SearchPanel.this._model.removeElement(uRL2);
            }
        }
    };

    public SearchPanel() {
        super(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_finddbobject_html");
    }

    public URL getSelectedURL() {
        if (this._results.getSelectedIndex() > -1) {
            return (URL)((DefaultListModel)this._results.getModel()).getElementAt(this._results.getSelectedIndex());
        }
        return null;
    }

    public void createGUI() {
        this._dbSelector = new DBConnectionComboBox(){

            public void addConnection(String string) {
                if (Connections.getInstance().isOracle(string)) {
                    super.addConnection(string);
                }
            }
        };
        this._dbSelector.getAccessibleContext().setAccessibleName("Db Selection");
        this._model = new DefaultListModel();
        this._results = new JList(this._model);
        this._results.getAccessibleContext().setAccessibleName("Results:");
        this._search = new JTextField();
        this._search.getAccessibleContext().setAccessibleName("Object Name:");
        ObjectActionController.addListener((IObjectActionListener)this.dropListener);
        this._search.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SearchPanel.this._dbSelector.getCurrentConnection();
                    if (Connections.getInstance().isConnectionOpen(SearchPanel.this._dbSelector.getCurrentConnectionName())) {
                        SearchPanel.this.doSearch();
                    }
                }
            }
        });
        this._results.setCellRenderer(new URLListRenderer());
        this.add((Component)this._dbSelector.getJComboBox(), new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.add((Component)this._search, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 18, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this._results), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 1, 0, 0), 0, 0));
    }

    private void doSearch() {
        final DefaultListModel defaultListModel = new DefaultListModel();
        final JList jList = new JList(defaultListModel);
        IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;

            public void cancel() {
                this._isCanceled = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() {
                Object object;
                String string = SearchPanel.this._dbSelector.getCurrentConnectionName();
                ArrayList<URL> arrayList = new ArrayList<URL>();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("OWNER", "SYS");
                hashMap.put("OBJECT_NAME", "DBA_OBJECTS");
                String string2 = DBUtil.getInstance().executeOracleReturnOneCol(string, "select count(1) from sys.all_objects where owner = :OWNER and object_name = :OBJECT_NAME", hashMap);
                String string3 = " select object_name,owner,object_type from ";
                string3 = string2.equals("0") ? string3 + " sys.all_objects" : string3 + " sys.dba_objects";
                hashMap.clear();
                try {
                    if (DBUtil.checkVersion((String)string, null, (Version)new Version("10.0")) && SearchPanel.this._search.getText().startsWith("/") && (SearchPanel.this._search.getText().endsWith("/") || SearchPanel.this._search.getText(SearchPanel.this._search.getText().length() - 2, 1).startsWith("/"))) {
                        object = null;
                        if (SearchPanel.this._search.getText().endsWith("i")) {
                            string3 = string3 + " where REGEXP_LIKE(owner || '.'|| object_name,:NAME,'i') ";
                            object = SearchPanel.this._search.getText().substring(1, SearchPanel.this._search.getText().length() - 2);
                        } else {
                            string3 = string3 + " where REGEXP_LIKE(owner || '.'|| object_name,:NAME) ";
                            object = SearchPanel.this._search.getText().substring(1, SearchPanel.this._search.getText().length() - 1);
                        }
                        hashMap.put("NAME", object);
                        SearchPanel.this.logger.info("Using regex:" + (String)object);
                    } else {
                        if (SearchPanel.this._search.getText().indexOf(".") > 0) {
                            string3 = string3 + " where owner like :OWNER";
                            string3 = string3 + " and object_name like :NAME";
                            object = SearchPanel.this._search.getText().split("\\.");
                            hashMap.put("OWNER", SearchPanel.this.scrubBind(object[0]));
                            hashMap.put("NAME", SearchPanel.this.scrubBind(object[1]));
                        } else {
                            string3 = string3 + " where object_name like :NAME";
                            hashMap.put("NAME", SearchPanel.this.scrubBind(SearchPanel.this._search.getText()));
                        }
                        if (DBConfig.getInstance().getBoolean("SEARCH_AUTO_WILDCARD").booleanValue()) {
                            hashMap.put("NAME", (String)hashMap.get("NAME") + "%");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, numberFormatException.getStackTrace()[0].toString(), numberFormatException);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                }
                string3 = string3 + " order by owner,object_name";
                object = SearchPanel.this._dbSelector.getCurrentConnection();
                synchronized (object) {
                    ResultSet resultSet = DBUtil.getInstance().executeQuery(string, string3, hashMap);
                    try {
                        while (resultSet.next() && !this._isCanceled) {
                            URL uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)resultSet.getString("OWNER"), (String)resultSet.getString("OBJECT_TYPE")), (String)resultSet.getString("OBJECT_NAME"));
                            if (uRL == null) continue;
                            arrayList.add(uRL);
                            if (resultSet.getRow() % 10 != 0) continue;
                            final int n = resultSet.getRow();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    defaultListModel.addElement("Found " + n + " Objects\n");
                                    jList.setSelectedIndex(defaultListModel.getSize());
                                }
                            });
                        }
                    }
                    catch (SQLException sQLException) {
                        ExceptionHandler.handleException((Exception)sQLException);
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.getStatement().close();
                                resultSet.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                return arrayList;
            }

            public void finish(Object object) {
                DefaultListModel defaultListModel2 = (DefaultListModel)SearchPanel.this._results.getModel();
                defaultListModel2.clear();
                ArrayList arrayList = (ArrayList)object;
                for (URL uRL : arrayList) {
                    defaultListModel2.addElement(uRL);
                }
            }

            public void preWork() {
            }
        };
        DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Searching", null, 500, iDelayedProgressRunnable, jList);
        delayedProgressRunnable.setCancellable(true);
        delayedProgressRunnable.start();
    }

    private String scrubBind(String string) {
        if (string.length() > 0 && string.charAt(0) == '\"' && string.charAt(string.length()) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }
}

