/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.search;

import java.awt.Component;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.dbtools.raptor.oviewer.search.SearchPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.Layout;
import oracle.javatools.icons.OracleIcons;

public class SearchWindow
extends DockableWindow {
    static final String VIEW_ID = "oracle-dbtools-raptor-nav-search-Window";
    private Logger logger = Logger.getLogger(SearchWindow.class.getName());
    private Controller _controller;
    private SearchPanel _gui;

    public SearchWindow() {
        super("oracle-dbtools-raptor-nav-search-TYPE.oracle-dbtools-raptor-nav-search-Window");
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new SController();
        }
        return this._controller;
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = new SearchPanel();
            this._gui.createGUI();
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._gui, "f1_finddbobject_html");
        return this._gui;
    }

    public int getDefaultVisibility(Layout layout) {
        return 3;
    }

    public String getTabName() {
        return "Search";
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"find.png");
    }

    public String getTitleName() {
        return "Find Database Object";
    }

    public String getIdImpl() {
        return "oracle-dbtools-raptor-nav-search-TYPE.oracle-dbtools-raptor-nav-search-Window";
    }

    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        this.logger.info("Search Context");
        if (this._gui.getSelectedURL() != null) {
            context.setProperty("ObjectAction.DBOBJECT", (Object)new DBObject(this._gui.getSelectedURL()));
        }
        return context;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_finddbsearch_html");
    }

    class SController
    implements Controller {
        SController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    }
}

