/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.search;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import oracle.dbtools.raptor.dialogs.BasicObjectModifier;
import oracle.dbtools.raptor.format.ui.ExportContextMenuListener;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;

public class URLListRenderer
extends DefaultListCellRenderer {
    private Logger logger = Logger.getLogger(URLListRenderer.class.getName());
    final MouseListener openOnClick = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getSource();
            int n = jList.locationToIndex(mouseEvent.getPoint());
            ListModel listModel = jList.getModel();
            Object e = jList.getModel().getElementAt(n);
            jList.setSelectedIndex(n);
            if (e instanceof URL) {
                URL uRL = (URL)e;
                if (mouseEvent.getButton() == 1) {
                    NavSelectionListener.getInstance().open(uRL);
                } else if (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) {
                    DBObject dBObject = new DBObject(uRL);
                    ContextMenu contextMenu = new ContextMenu();
                    contextMenu.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance());
                    contextMenu.addContextMenuListener((ContextMenuListener)ExportContextMenuListener.getInstance());
                    Context context = new Context();
                    context.setEvent((EventObject)mouseEvent);
                    context.setNode(dBObject.getNode());
                    context.setProperty("ObjectAction.DBOBJECT", (Object)dBObject);
                    contextMenu.show(context);
                }
            }
        }
    };
    private static Map<URL, Icon> s_iconCache = new HashMap<URL, Icon>();

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object != null && object instanceof URL) {
            URL uRL = (URL)object;
            String string = DBURLFormatHelper.getConnectionName((URL)uRL);
            String string2 = null;
            if (Connections.getInstance().getConnectionInfo(string) != null) {
                String string3 = string2 = string == null ? null : Connections.getInstance().getConnectionInfo(string).getProperty("user");
                if (string2 != null && !string2.equals(DBURLFormatHelper.getSchema((URL)uRL))) {
                    jLabel.setText(DBURLFormatHelper.getSchema((URL)uRL) + "." + DBURLFormatHelper.getName((URL)uRL));
                } else {
                    jLabel.setText(DBURLFormatHelper.getName((URL)uRL));
                }
                jLabel.putClientProperty("URL", uRL);
                jLabel.setIcon(URLListRenderer.getIcon(uRL));
                boolean bl3 = true;
                for (MouseListener mouseListener : jList.getMouseListeners()) {
                    if (mouseListener != this.openOnClick) continue;
                    bl3 = false;
                }
                if (bl3) {
                    jList.addMouseListener(this.openOnClick);
                }
            } else {
                jLabel.setText("");
            }
        }
        return jLabel;
    }

    private static Icon getIcon(URL uRL) {
        Icon icon = s_iconCache.get(uRL);
        if (icon == null) {
            icon = DBURLFormatHelper.getIcon((URL)uRL);
            s_iconCache.put(uRL, icon);
        }
        return icon;
    }

    static void removeIcon(URL uRL) {
        s_iconCache.remove(uRL);
    }
}

