/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.table;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.IProgressFeedback;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.plugins.EditorPlugin;

public class DDLViewer
extends ViewerEditor {
    protected BasicEditorPane _code;
    protected DBObject _lastdbObject;
    protected DBObject _dbObject;
    protected IdeAction _refreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");

    protected JComponent createViewerUI() {
        this.setCodeArea(EditorFactory.createIdeEditorPane());
        BasicDocument basicDocument = (BasicDocument)this.getCodeArea().getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
        this.getCodeArea().setEditable(false);
        this.getCodeArea().setCaretPosition(0);
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this.getCodeArea().installPlugin((EditorPlugin)lineGutterPlugin);
        JScrollPane jScrollPane = new JScrollPane((Component)this.getCodeArea(), 22, 32);
        jScrollPane.setRowHeaderView((Component)lineGutterPlugin);
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Translate.translate((String)"Refresh"), null, null, (Icon)IdeArb.getIcon((int)373), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                DDLViewer.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
        ((Toolbar)super.getFixedTopMargin()).add((ToggleAction)this._refreshAction.newLocalAction((View)this));
        return jScrollPane;
    }

    protected String getBinds() {
        return null;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    protected void updateContent(boolean bl) {
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode != null) {
            this._dbObject = viewerNode.getDBObject();
        }
        if (bl || this._dbObject != null && (this._lastdbObject == null || this._lastdbObject.getObjectName() != this._dbObject.getObjectName())) {
            this.getCodeArea().setEditable(true);
            ProgressRunnable progressRunnable = new ProgressRunnable(){

                protected void doCancel() {
                    super.doCancel();
                    DDLViewer.this.getCodeArea().setText("--Generation of DDL was cancelled");
                }

                protected Object doWork() throws Exception {
                    return DDLGenerator.getInstance().getDDL(DDLViewer.this._dbObject);
                }

                protected void finish(Object object) {
                    if (object != null) {
                        DDLViewer.this.getCodeArea().setText(object.toString());
                    } else {
                        DDLViewer.this.getCodeArea().setText("--Generation of DDL was cancelled");
                    }
                }
            };
            IProgressFeedback iProgressFeedback = new IProgressFeedback(){

                public void feedback(String string) {
                    Log.status((String)string);
                }
            };
            progressRunnable.setTitle(Translate.translate((String)"Generating DDL...."));
            progressRunnable.setCancelable(true);
            try {
                progressRunnable.start(true);
            }
            catch (ProgressException progressException) {
                this.getCodeArea().setText("--Generation of DDL was cancelled");
            }
            this.getCodeArea().setEditable(false);
            this.getCodeArea().setCaretPosition(0);
            this._lastdbObject = this._dbObject;
        }
    }

    public Object getPrintable() {
        return this.getCodeArea();
    }

    protected void cleanUp() {
    }

    public Object getEditorAttribute(String string) {
        boolean bl = false;
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    protected void setCodeArea(BasicEditorPane basicEditorPane) {
        this._code = basicEditorPane;
    }

    protected BasicEditorPane getCodeArea() {
        return this._code;
    }
}

