/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.EditableResultSetTable;
import oracle.dbtools.raptor.controls.FilterAutoCompleter;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.table.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.models.EditableResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.oviewer.OBResourcesArb;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.table.SortColumnPicker;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.dbtools.raptor.utils.SQLExceptionListener;
import oracle.dbtools.raptor.utils.SQLExceptionListenerRegistry;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomException;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class DataEditor
extends ViewerEditor
implements Controller,
ViewerNode.DirtyComponent,
IDBEditor,
IActionUpdater,
SQLExceptionListener {
    private Logger logger = Logger.getLogger(DataEditor.class.getName());
    private static final String QUERY_NAME = "SELECT * FROM {0}";
    private static final String QUERY_SCHEMA_AND_NAME = "SELECT * FROM {0}.{1}";
    private Component _rowHeader;
    private EditableResultSetTable _tblData = new EditableResultSetTable((IActionUpdater)this);
    private Component view = null;
    protected CopyableResultSetTableAdapter _adapter;
    static final int INSERT_ROW_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.insert");
    static final int DELETE_ROW_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.delete");
    static final int COMMIT_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.commit");
    static final int ROLLBACK_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.rollback");
    static final int SORT_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.sort");
    static final int REFRESH_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.refresh");
    static final int FILTER_DATA_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.filter.data");
    private boolean _opened = false;
    private String _tableName = null;
    private String _schemaName = null;
    private JButton sortButton;
    private JLabel filterLabel;
    private JComboBox filter;
    private static final String DEFAULT_FILTER_TEXT = Translate.translate((String)"Enter Where Clause");
    private SortColumnPicker sortPanel = new SortColumnPicker();
    private DBObject _dbObject;
    private volatile NamedSwingWorker _worker;
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"Table-filters");
    private static final String ROOT_TAG = "Filters";
    private static Font fontPlain;
    private static Font fontBold;
    protected boolean DML_DEFER_COMMIT_DEFER = true;
    protected boolean DML_IMMIDIATE_COMMIT_DEFER = false;
    protected boolean DML_IMMIDIATE_COMMIT_IMMIDIATE = false;
    protected DBConfig dbConfig = null;
    private boolean _commited = true;
    private boolean isValidFilter = true;

    public DataEditor() {
        this._rowHeader = this._tblData.getRowHeader();
        this.dbConfig = DBConfig.getInstance();
        this.setCommitProps();
        this.dbConfig.addStructureChangeListener((StructureChangeListener)new OVPreferenceChangeListener());
        this._tblData.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataEditor.this.updateSelection();
            }
        });
        this._tblData.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataEditor.this.updateVisibleActions();
            }
        });
        this._tblData.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataEditor.this.updateVisibleActions();
                DataEditor.this._tblData.getRowHeader().repaint();
                DataEditor.this._tblData.repaint();
            }
        });
        this.registerTable((JTable)this._tblData);
        this._tblData.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionEvent.getValueIsAdjusting() && DataEditor.this.getChanged() && this.isPostOnRowChange()) {
                    DataEditor.this.save();
                    DataEditor.this.updateVisibleActions();
                }
            }

            private boolean isPostOnRowChange() {
                return DataEditor.this.DML_IMMIDIATE_COMMIT_DEFER || DataEditor.this.DML_IMMIDIATE_COMMIT_IMMIDIATE;
            }
        });
        this._tblData.setResultSetInvalidEventHandler(new ResultSetTable.ResultSetInvalidEventHandler(){

            public void resultSetInvalidated(ResultSetTableModel.ResultSetInvalidEvent resultSetInvalidEvent) {
                DataEditor.this.logger.log(Level.WARNING, "Result is not usable any longer, DataEditor refreshing");
                DataEditor.this.refreshData(true);
            }
        });
        DataEditor.initActions();
        this.sortButton = new JButton((Action)IdeAction.find((int)SORT_CMD_ID).newLocalAction((View)this));
        this.sortButton.setToolTipText(Translate.translate((String)"Sort"));
        this.filterLabel = new JLabel(CreateDialogArb.getString((int)527));
        this.filter = new JComboBox<Object>(new Object[]{""});
        this.filter.setEditable(true);
        new FilterAutoCompleter((JTextComponent)this.filter.getEditor().getEditorComponent()){

            protected Object[] getPullDownList() {
                ArrayList arrayList = null;
                try {
                    arrayList = DataEditor.this.getPersistedFilters();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (arrayList != null) {
                    return arrayList.toArray();
                }
                return new Object[0];
            }
        };
        this.filter.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    DataEditor.this.filterData(DataEditor.this.getFilterClause());
                }
            }
        });
        Dimension dimension = this.filter.getSize();
        this.logger.info(dimension.toString());
        this._tblData.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                    int n = jTableHeader.getResizingColumn() != null ? jTableHeader.getResizingColumn().getModelIndex() : -1;
                    TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                    int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    if (n2 != -1 && n == -1 && DataEditor.this._tblData.isColSortable(n2)) {
                        DataEditor.this._tblData.setOrderBy(n2);
                        DataEditor.this.refreshData();
                        DataEditor.this.synchSortPanel();
                    }
                }
            }
        });
        IdeAction.get((int)COMMIT_CHANGES_CMD_ID).addController((Controller)this);
        IdeAction.get((int)ROLLBACK_CHANGES_CMD_ID).addController((Controller)this);
        SQLExceptionListenerRegistry.addListener((SQLExceptionListener)this);
    }

    public void open() {
        Object object;
        boolean bl = false;
        this.isValidFilter = true;
        DBObject dBObject = new DBObject((Element)this.getViewerNode());
        if (dBObject != null) {
            this._dbObject = dBObject;
            this._tblData.setDefaultExportName(dBObject.getObjectName());
            object = dBObject.getDatabase();
            try {
                String string = DBUtil.getInstance().addQuotes(this.getConnection(), dBObject.getSchemaName());
                String string2 = DBUtil.getInstance().addQuotes(this.getConnection(), dBObject.getObjectName());
                if (!string.equals(this._schemaName) || !string2.equals(this._tableName)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._getTableData(!this._opened);
        if (!this._opened) {
            this._tblData.showLogPage(false);
            this._opened = true;
        }
        if (bl) {
            this.synchSortPanel();
            object = this.getPersistedFilters();
            if (object != null) {
                ((ArrayList)object).add(0, "");
                this.filter.setModel(new DefaultComboBoxModel<Object>(((ArrayList)object).toArray()));
            } else {
                this.filter.setModel(new DefaultComboBoxModel<Object>(new Object[]{""}));
            }
        }
    }

    private void initSortPanel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._tblData.getColumnCount(); ++i) {
            if (!this._tblData.isColSortable(i)) continue;
            arrayList.add(this._tblData.getColumnDBName(i));
        }
        this.sortPanel.init(arrayList);
    }

    private void synchSortPanel() {
        if (this._tblData.getModel() instanceof EditableResultSetTableModel) {
            this.initSortPanel();
            String string = ((EditableResultSetTableModel)this._tblData.getModel()).getOrderByClause();
            if (string != null && !string.equals("")) {
                this.sortPanel.setOrderBy(string);
                if (fontBold == null) {
                    fontBold = this.sortButton.getFont().deriveFont(1);
                    fontPlain = this.sortButton.getFont();
                }
                this.sortButton.setFont(fontBold);
            } else {
                if (fontPlain == null) {
                    fontPlain = this.sortButton.getFont();
                }
                this.sortButton.setFont(fontPlain);
            }
        }
    }

    public void close() {
        this._tblData.closeModel();
        SQLExceptionListenerRegistry.removeListener((SQLExceptionListener)this);
    }

    public boolean rollbackChanges() {
        boolean bl = this._tblData.discardChanges();
        if (bl) {
            try {
                this.getConnection().rollback();
                this._tblData.setCommited(true);
                this.markDirty(false);
                this.refreshView();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return bl;
    }

    public boolean insertRow() {
        boolean bl = this._tblData.insertRow();
        if (bl) {
            this.markDirty(true);
        }
        return bl;
    }

    public boolean deleteRow() {
        boolean bl = this._tblData.deleteRow();
        if (bl) {
            this.markDirty(true);
        }
        return bl;
    }

    public Controller getController() {
        return this;
    }

    public Component getScrollableLeftMargin() {
        return this._rowHeader;
    }

    public Component getScrollableTopMargin() {
        return this._tblData.getTableHeader();
    }

    public Component getGUI() {
        if (this.view == null) {
            this._createGUI();
        }
        this.checkPin();
        return this.view;
    }

    public boolean isEditable() {
        String string;
        Connections connections = Connections.getInstance();
        return connections.isOracle(string = this.getConnectionName()) || connections.isTimesTen(string);
    }

    public Component getFixedTopMargin() {
        if (this._toolbar == null) {
            String string = this.getViewerNode().getDBObject().getObjectType();
            super.getFixedTopMargin();
            if (this.isEditable()) {
                this._toolbar.add((ToggleAction)IdeAction.get((int)REFRESH_CMD_ID).newLocalAction((View)this));
                this._toolbar.add((ToggleAction)IdeAction.get((int)INSERT_ROW_CMD_ID).newLocalAction((View)this));
                this._toolbar.add((ToggleAction)IdeAction.get((int)DELETE_ROW_CMD_ID).newLocalAction((View)this));
                this._toolbar.add((ToggleAction)IdeAction.get((int)COMMIT_CHANGES_CMD_ID).newLocalAction((View)this));
                this._toolbar.add((ToggleAction)IdeAction.get((int)ROLLBACK_CHANGES_CMD_ID).newLocalAction((View)this));
                this._toolbar.addSeparator();
                this._toolbar.add((Component)this.sortButton);
                this._toolbar.addSeparator();
                this._toolbar.add((Component)this.filterLabel);
                this._toolbar.add((Component)this.filter);
                this.filter.setSize(200, 0);
            } else {
                this._toolbar.add((ToggleAction)IdeAction.get((int)REFRESH_CMD_ID).newLocalAction((View)this));
                this._toolbar.addSeparator();
                this._toolbar.add((Component)this.sortButton);
                this._toolbar.addSeparator();
                this._toolbar.add((Component)this.filterLabel);
                this._toolbar.add((Component)this.filter);
                this.filter.setSize(200, 0);
            }
        }
        return this._toolbar;
    }

    public Component getDefaultFocusComponent() {
        return this._tblData;
    }

    public Object getEditorAttribute(String string) {
        if (string.equals("menu_id")) {
            return "Ta&ble";
        }
        return super.getEditorAttribute(string);
    }

    private void refreshData() {
        this.refreshData(false);
    }

    private void refreshData(boolean bl) {
        block8: {
            block7: {
                this.isValidFilter = true;
                this._tblData.setWhere(this.getFilterClause());
                if (!this.getChanged()) break block7;
                String string = MessageFormat.format(IdeArb.getString((int)97), this._tableName);
                int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string, (String)this._tableName, null);
                switch (n) {
                    case 1: {
                        if (!this.save()) {
                            return;
                        }
                        break block8;
                    }
                    case 0: {
                        if (!this.rollbackChanges()) {
                            return;
                        }
                        break block8;
                    }
                    default: {
                        if (bl) {
                            this.rollbackChanges();
                        }
                        return;
                    }
                }
            }
            this.refreshView();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (DataEditor.this.isValidFilter) {
                        String string = DataEditor.this.getFilterClause();
                        boolean bl = false;
                        for (int i = 0; i < DataEditor.this.filter.getItemCount(); ++i) {
                            if (!DataEditor.this.filter.getItemAt(i).equals(string)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            if (DataEditor.this.filter.getItemCount() >= 51) {
                                DataEditor.this.filter.removeItemAt(DataEditor.this.filter.getItemCount() - 1);
                            }
                            DataEditor.this.filter.insertItemAt(string, 1);
                            DataEditor.this.filter.setSelectedItem(string);
                            DataEditor.this.persistFilters();
                        }
                    }
                }
            });
        }
    }

    private void sortData() {
        Object[] objectArray;
        if (this.getChanged()) {
            objectArray = MessageFormat.format(IdeArb.getString((int)97), this._tableName);
            int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)objectArray, (String)this._tableName, null);
            switch (n) {
                case 1: {
                    if (this.save()) break;
                    return;
                }
                case 0: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        objectArray = new Object[]{CreateDialogArb.getString((int)522), CreateDialogArb.getString((int)523)};
        JOptionPane jOptionPane = new JOptionPane(null, -1, 0, null, objectArray, objectArray[0]);
        jOptionPane.add(this.sortPanel);
        ArrayList<SortColumnPicker.SortCol> arrayList = this.sortPanel.getToList();
        ArrayList<SortColumnPicker.SortCol> arrayList2 = this.sortPanel.getFromList();
        JDialog jDialog = jOptionPane.createDialog((Component)Ide.getMainWindow(), CreateDialogArb.getString((int)526));
        jDialog.setSize(new Dimension(500, 400));
        jDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        jDialog.setVisible(true);
        if (jOptionPane.getValue() != null && jOptionPane.getValue().equals(CreateDialogArb.getString((int)522))) {
            this.logger.info(jOptionPane.getValue().toString());
            this._tblData.setOrderBy(this.sortPanel.getOrderBy());
            this._tblData.setWhere(this.getFilterClause());
            this.refreshView();
            this.synchSortPanel();
        } else {
            this.sortPanel.setToList(arrayList);
            this.sortPanel.setFromList(arrayList2);
        }
    }

    private void _getTableData(boolean bl) {
        DBObject dBObject = new DBObject((Element)this.getViewerNode());
        if (dBObject != null) {
            Database database = dBObject.getDatabase();
            try {
                String string = DBUtil.getInstance().addQuotes(dBObject.getConnection(), dBObject.getSchemaName());
                String string2 = DBUtil.getInstance().addQuotes(dBObject.getConnection(), dBObject.getObjectName());
                if (!bl && string.equals(this._schemaName) && string2.equals(this._tableName) && dBObject.getConnectionName().equals(this._dbObject.getConnectionName())) {
                    return;
                }
                this._commited = true;
                this._schemaName = string;
                this._tableName = string2;
                String string3 = MessageFormat.format(QUERY_SCHEMA_AND_NAME, string, string2);
                if (this._tblData.getModel() instanceof ResultSetTableModel) {
                    ((ResultSetTableModel)this._tblData.getModel()).setSchemaName(string);
                }
                boolean bl2 = this.isEditable();
                if (dBObject.getObjectType().equals("VIEW")) {
                    DBUtil dBUtil = DBUtil.getInstance();
                    dBUtil.setRaiseError(false);
                    String string4 = dBUtil.executeOracleReturnOneCol(dBObject.getConnectionName(), "select rowid from " + DBUtil.enquote((String)string) + "." + string2 + " where rownum = 1", (Map)null);
                    if (string4 == null) {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    this._tblData.setQuery(database.getConnection(), null, string3, true, database, this.getViewerNode().getDBObject());
                    ((EditableResultSetTableModel)this._tblData.getModel()).setColumnModel(this._tblData.getColumnModel());
                } else {
                    this._tblData.setQuery(database.getConnection(), null, string3, false, database, this.getViewerNode().getDBObject());
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "_getTableData", exception.getLocalizedMessage());
            }
        }
    }

    public boolean canRefreshView() {
        return true;
    }

    public void refreshView() {
        this._tblData.refresh();
    }

    public boolean validSelection() {
        return this._tblData.getSelectedRowCount() > 0;
    }

    public boolean getChanged() {
        return this._tblData.getChanged();
    }

    public boolean isUnSaved() {
        return this.getChanged() || this.isUnCommited();
    }

    private void _createGUI() {
        this.view = this._tblData;
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        keyStrokeOptions.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DataEditor.this.updateKeyMap(Ide.getSettings().getKeyStrokeOptions());
            }
        });
        this.updateKeyMap(keyStrokeOptions);
    }

    protected final void registerTable(JTable jTable) {
        this._adapter = jTable != null ? new CopyableResultSetTableAdapter(jTable) : null;
    }

    public final CopyableResultSetTableAdapter getCopyableJTableAdapter() {
        return this._adapter;
    }

    private void markDirty(boolean bl) {
        ViewerNode viewerNode = this.getViewerNode();
        if (bl) {
            viewerNode.addDirtyComponent(this);
        } else {
            viewerNode.removeDirtyComponent(this);
        }
    }

    private boolean save() {
        try {
            try {
                if (this.getConnection().isClosed()) {
                    throw new IOException(OBResourcesArb.getString(3));
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getLocalizedMessage());
            }
            boolean bl = this._tblData.save();
            if (bl) {
                this._commited = false;
                if (this.DML_IMMIDIATE_COMMIT_IMMIDIATE) {
                    this.commit();
                } else if (this.DML_IMMIDIATE_COMMIT_DEFER) {
                    this.markDirty(true);
                } else if (this.DML_DEFER_COMMIT_DEFER) {
                    // empty if block
                }
                return true;
            }
            if (this._tblData.getUpdatedByAnotherUser()) {
                String string = ConnectionArb.getString((int)95) + "\n" + ConnectionArb.getString((int)105);
                boolean bl2 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)ConnectionArb.getString((int)105), null);
                if (bl2) {
                    this.rollbackChanges();
                }
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, OBResourcesArb.getString(4), iOException.getLocalizedMessage());
        }
        return false;
    }

    public void save(ViewerNode viewerNode) throws IOException {
        if (!this.save()) {
            throw new IOException(OBResourcesArb.getString(4));
        }
        if (!this._commited) {
            this.commit();
        }
    }

    protected JComponent createViewerUI() {
        return this._tblData;
    }

    protected void updateContent() {
        this.open();
        this.updateVisibleActions();
    }

    private static void createActions() {
        IdeAction.get((int)INSERT_ROW_CMD_ID, null, (String)ConnectionArb.getString((int)101), null, null, (Icon)OBResourcesArb.getIcon(0), null, (boolean)true);
        IdeAction.get((int)DELETE_ROW_CMD_ID, null, (String)ConnectionArb.getString((int)102), null, null, (Icon)OracleIcons.getIcon((String)"delete.png"), null, (boolean)true);
        IdeAction.get((int)COMMIT_CHANGES_CMD_ID, null, (String)ConnectionArb.getString((int)103), null, null, (Icon)OracleIcons.getIcon((String)"commit.png"), null, (boolean)true);
        IdeAction.get((int)ROLLBACK_CHANGES_CMD_ID, null, (String)ConnectionArb.getString((int)104), null, null, (Icon)OracleIcons.getIcon((String)"rollback.png"), null, (boolean)true);
        IdeAction.get((int)SORT_CMD_ID, null, (String)CreateDialogArb.getString((int)525), null, null, (Icon)ConnectionArb.getIcon((int)91), null, (boolean)true);
        IdeAction.get((int)REFRESH_CMD_ID, null, (String)CreateDialogArb.getString((int)524), null, null, (Icon)IdeArb.getIcon((int)373), null, (boolean)true);
        IdeAction.get((int)FILTER_DATA_CMD_ID, (String)Translate.translate((String)"Filter Data"), (String)StringUtils.stripMnemonic((String)Translate.translate((String)"Filter Data")));
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        this._tblData.setCommited(this._commited);
        super.updateVisibleActions(updateMessage);
        DataEditor.updateToolbarActions((Toolbar)this._toolbar);
        this.sortPanel.setSupportsOrderingNulls(this.supportsOrderingNulls());
    }

    public boolean update(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (view != this) {
            return false;
        }
        int n = ideAction.getCommandId();
        if (n == INSERT_ROW_CMD_ID) {
            ideAction.setEnabled(this._tblData.getValid() && !this._tblData.getUpdatedByAnotherUser());
        } else if (n == DELETE_ROW_CMD_ID) {
            ideAction.setEnabled(this._tblData.getValid() && this.validSelection() && !this._tblData.getUpdatedByAnotherUser());
        } else if (n == COMMIT_CHANGES_CMD_ID) {
            ideAction.setEnabled(this.getViewerNode().isDirty() && !this._tblData.getUpdatedByAnotherUser());
        } else if (n == ROLLBACK_CHANGES_CMD_ID) {
            ideAction.setEnabled(this.getViewerNode().isDirty());
        } else if (n == SORT_CMD_ID || n == FILTER_DATA_CMD_ID) {
            ideAction.setEnabled(true);
        } else if (n == 17) {
            ideAction.setEnabled(this._adapter.canCut());
        } else if (n == 18) {
            ideAction.setEnabled(this._adapter.canCopy());
        } else if (n == 19) {
            ideAction.setEnabled(this._adapter.canPaste());
        } else {
            this.markDirty(!this._tblData.getValid() || this.isUnSaved());
            return super.update(ideAction, context);
        }
        this.markDirty(!this._tblData.getValid() || this.isUnSaved());
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (view != this) {
            return false;
        }
        int n = ideAction.getCommandId();
        if (n == INSERT_ROW_CMD_ID) {
            this.insertRow();
        } else if (n == DELETE_ROW_CMD_ID) {
            this.deleteRow();
        } else if (n == COMMIT_CHANGES_CMD_ID) {
            if (this.save()) {
                this.commit();
                this.refreshView();
                this.markDirty(false);
            }
        } else if (n == ROLLBACK_CHANGES_CMD_ID) {
            this.rollbackChanges();
        } else if (n == SORT_CMD_ID) {
            this.sortData();
        } else if (n == REFRESH_CMD_ID) {
            this.refreshData();
        } else if (n == FILTER_DATA_CMD_ID) {
            this.filter.requestFocus();
        } else if (n == 17) {
            if (this._adapter.canCut()) {
                this._adapter.copyToClipboard(true);
            }
        } else if (n == 18) {
            if (this._adapter.canCopy()) {
                this._adapter.copyToClipboard();
            }
        } else if (n == 19) {
            this._adapter.pasteToJTable();
        } else {
            return super.handleEvent(ideAction, context);
        }
        return true;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == ViewerNode.RELATION_NODE_MODIFIED_MESSAGE_ID) {
            if (this.isVisible()) {
                this._getTableData(true);
            }
        } else if (n == ViewerNode.RELATION_NODE_CHANGED_MESSAGE_ID) {
            if (this.isVisible()) {
                if (this.isUnSaved()) {
                    this.commit();
                }
                super.update(object, updateMessage);
            }
        } else {
            super.update(object, updateMessage);
        }
    }

    public Object getPrintable() {
        return this._tblData;
    }

    public Database getDatabase() {
        if (this._dbObject != null) {
            return this._dbObject.getDatabase();
        }
        return null;
    }

    public Connection getConnection() {
        if (this._dbObject != null) {
            return this._dbObject.getConnection();
        }
        return null;
    }

    public String getConnectionName() {
        return this._dbObject != null ? this._dbObject.getConnectionName() : null;
    }

    protected void cleanUp() {
        this._commited = true;
        if (this._tblData.getModel() instanceof ResultSetTableModel) {
            ((ResultSetTableModel)this._tblData.getModel()).close();
        }
    }

    public void updateActions() {
        this.updateVisibleActions();
    }

    private boolean supportsOrderingNulls() {
        String string;
        Connections connections = Connections.getInstance();
        return !connections.isTimesTen(string = this.getConnectionName());
    }

    private void persistFilters() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.filter.getItemCount(); ++i) {
            object = (String)this.filter.getItemAt(i);
            if (object == null || ((String)object).equals("")) continue;
            arrayList.add(object);
        }
        final URL uRL = this._getSaveURL();
        object = Object2Dom.newInstance();
        object.setNamespaceURI(NAMESPACE_URI);
        this._worker = new NamedSwingWorker("SaveSettings", (Object2Dom)object, arrayList){
            final /* synthetic */ Object2Dom val$o2d;
            final /* synthetic */ ArrayList val$filters;
            {
                this.val$o2d = object2Dom;
                this.val$filters = arrayList;
                super(string);
            }

            public Object construct() {
                try {
                    if (uRL != null) {
                        this.val$o2d.toDocument((Object)this.val$filters, DataEditor.ROOT_TAG, uRL);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                return this;
            }
        };
        this._worker.start();
    }

    private URL _getSaveURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        if (extensionRegistry.findExtension("oracle.sqldeveloper") != null) {
            URL uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper");
            String string = this._tblData.getSql();
            if (string != null) {
                if (string.lastIndexOf("ORDER BY") > -1) {
                    string = string.substring(0, string.lastIndexOf("ORDER BY")).trim();
                }
                return URLFactory.newURL((URL)uRL, (String)(string.hashCode() + "SavedFilters.xml"));
            }
        }
        return null;
    }

    private ArrayList getPersistedFilters() {
        ArrayList arrayList = null;
        try {
            URL uRL = this._getSaveURL();
            if (uRL != null) {
                Object2Dom object2Dom = Object2Dom.newInstance();
                arrayList = (ArrayList)object2Dom.toObject(uRL);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Object2DomException object2DomException) {
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private void updateKeyMap(KeyStrokeOptions keyStrokeOptions) {
        UIUtils.addIdeKeyBindings((JComponent)this._tblData, (int)1, (String)"oracle/dbtools/raptor/oviewer/base/accelerators.xml");
    }

    public static void initActions() {
        DataEditor.createActions();
    }

    private void commit() {
        block8: {
            try {
                try {
                    if (this.getConnection().isClosed()) {
                        throw new SQLException(OBResourcesArb.getString(3));
                    }
                }
                catch (SQLException sQLException) {
                    boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)(sQLException.getMessage() + "\n" + OBResourcesArb.getString(5)), (String)OBResourcesArb.getString(1), null);
                    if (bl) {
                        this.markDirty(false);
                        this._commited = true;
                        this.updateVisibleActions();
                        try {
                            this.getViewerNode().close();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                        }
                        return;
                    }
                    return;
                }
                this._tblData.commit();
                this._commited = true;
                this._tblData.setCommited(true);
                this.markDirty(false);
                this.updateVisibleActions();
            }
            catch (SQLException sQLException) {
                boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)(sQLException.getMessage() + "\n" + OBResourcesArb.getString(2)), (String)OBResourcesArb.getString(1), null);
                if (!bl || !this.rollbackChanges()) break block8;
                this._tblData.setCommited(true);
            }
        }
    }

    private boolean isUnCommited() {
        return !this._tblData.isCommited();
    }

    private void setCommitProps() {
        boolean bl = this.dbConfig.getBoolean("DATAEDITOR_POSTONROWCHANGE");
        boolean bl2 = this.dbConfig.getBoolean("DATAEDITOR_AUTOCOMMIT");
        if (!bl) {
            this.DML_DEFER_COMMIT_DEFER = true;
            this.DML_IMMIDIATE_COMMIT_DEFER = false;
            this.DML_IMMIDIATE_COMMIT_IMMIDIATE = false;
        } else if (bl && !bl2) {
            this.DML_DEFER_COMMIT_DEFER = false;
            this.DML_IMMIDIATE_COMMIT_DEFER = true;
            this.DML_IMMIDIATE_COMMIT_IMMIDIATE = false;
        } else if (bl && bl2) {
            this.DML_DEFER_COMMIT_DEFER = false;
            this.DML_IMMIDIATE_COMMIT_DEFER = false;
            this.DML_IMMIDIATE_COMMIT_IMMIDIATE = true;
        }
    }

    private void filterData(String string) {
        this._tblData.setWhere(string);
        this.refreshData();
    }

    private String getFilterClause() {
        if (this.filter.hasFocus()) {
            return this.filter.getSelectedItem().toString();
        }
        return this.filter.getEditor().getItem().toString();
    }

    public boolean handleSQLError(String string, SQLException sQLException) {
        if (this._tblData.getWhereClause() != null && !this._tblData.getWhereClause().equals("")) {
            this.isValidFilter = false;
            ExceptionHandler.handleException((Exception)sQLException, (String)this._tblData.getSql(), (int)0);
            return true;
        }
        this.isValidFilter = true;
        return false;
    }

    private class OVPreferenceChangeListener
    extends StructureChangeListener {
        private OVPreferenceChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            Object var2_2 = null;
            for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                String string = changeInfo.getPropertyLocalName();
                if (!"DATAEDITOR_POSTONROWCHANGE".equals(string) && !"DATAEDITOR_AUTOCOMMIT".equals(string)) continue;
                DataEditor.this.setCommitProps();
            }
        }
    }
}

