/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.xmleditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.DisplayCodeEditor;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.DisplayResultTable;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.dbtools.util.objectpriv.PermissionRegistry;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.LineGutterPlugin;

public class XMLBasedEditor
extends ViewerEditor
implements FindableEditor,
IDBEditor,
Controller,
StatusProvider {
    protected DBObject _dbObject;
    protected DBObject _lastdbObject;
    protected DisplayModel _editor;
    private IdeAction _refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Translate.translate((String)"Refresh"), null, null, (Icon)IdeArb.getIcon((int)373), null, (boolean)true).newLocalAction((View)this);
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_XML_Editor");
    private IdeAction _editDBNodeAction;
    static final int EDIT_DBNODE_CMD_ID = Ide.findOrCreateCmdID((String)"Edit_DBNode_XML_Editor");
    private int _lastRow = -1;
    private JPopupMenu _gridCtxMenu;
    private DisplayPanel _panel;
    private JLabel _connName;
    private JLabel _ownerName;
    private JLabel _objName;
    private JComponent[] _statusBarCells;
    private BasicEditorPane _lastBasicEditorPane;

    public XMLBasedEditor() {
        this._refreshAction.addController((Controller)this);
        this._editDBNodeAction = IdeAction.get((int)EDIT_DBNODE_CMD_ID, null, (String)Translate.translate((String)"Edit"), null, null, (Icon)RaptorImage.getIcon((String)"edit_code.png"), null, (boolean)true).newLocalAction((View)this);
        this._editDBNodeAction.addController((Controller)this);
    }

    public synchronized Icon getTabIcon() {
        return this._editor.getIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_EDITOR_CMD_ID) {
            this.updateContent(true);
            return true;
        }
        if (n == EDIT_DBNODE_CMD_ID) {
            if (this.getDatabaseNode() instanceof TextNode) {
                Context context2 = Context.newIdeContext((Element)this.getDatabaseNode());
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
                openEditorOptions.setFlags(1);
                WaitCursor waitCursor = Ide.getWaitCursor();
                context2.setProject(Ide.getDefaultProject());
                try {
                    waitCursor.show();
                    EditorManager.getEditorManager().openEditor(openEditorOptions);
                }
                finally {
                    waitCursor.hide();
                }
                return true;
            }
            UIUtils.editNodeWizard((DatabaseNode)this.getDatabaseNode());
            return true;
        }
        return super.handleEvent(ideAction, context);
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (PermissionRegistry.canAlter((DBObject)new DBObject((Element)context.getNode()))) {
            this._editDBNodeAction.setEnabled(true);
        } else {
            this._editDBNodeAction.setEnabled(false);
        }
        if (this.checkForMigrationObjectEditable(context)) {
            this._editDBNodeAction.setEnabled(true);
        }
        if (context.getView() == this) {
            if (ideAction.getCommandId() == 23) {
                ideAction.setEnabled(false);
            }
            return true;
        }
        return super.update(ideAction, context);
    }

    protected JComponent createViewerUI() {
        Object var1_1 = null;
        this._dbObject = this.getContext().getNode() instanceof ViewerNode ? ((ViewerNode)this.getContext().getNode()).getDBObject() : new DBObject((Element)this.getContext().getNode());
        if (!(this._dbObject.getObjectType().equals("INDEX") || this._dbObject.getObjectType().equals("SYNONYM") || this._dbObject.getObjectType().equals("MATERIALIZED VIEW LOG") || this._dbObject.getObjectType().equals("RECYCLEBIN") || this._dbObject.getObjectType().equals("DIRECTORY") || this._dbObject.getObjectType().equals("PUBLIC_SYNONYM") || this._dbObject.getObjectType().startsWith("APEX") || this._dbObject.getObjectType().startsWith("JAVA") || this._dbObject.getObjectType().startsWith("XML SCHEMA") || !this._dbObject.isOracle() && !this.checkForMigrationObjectEditable(this.getContext()))) {
            ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._editDBNodeAction);
        }
        ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._refreshAction);
        ViewerAddin viewerAddin = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
        int n = Integer.parseInt(((Object)((Object)this)).getClass().toString().substring(((Object)((Object)this)).getClass().toString().lastIndexOf(114) + 1));
        this._editor = viewerAddin.getModel(this._dbObject, n);
        this._editor.setConnName(this._dbObject.getConnectionName());
        this._panel = new DisplayPanel(this._editor, this._dbObject.getDictionary(), true);
        BasicEditorPane basicEditorPane = ((DisplayAdapter)this._panel.getMainUI()).getCodeEditor();
        if (this._panel.getMainUI() instanceof DisplayAdapter && ((DisplayAdapter)this._panel.getMainUI()).getCodeEditor() != null) {
            return (JComponent)((DisplayAdapter)this._panel.getMainUI()).getCodeEditor().getParent().getParent();
        }
        if (!this._editor.hasChildren() && this._panel.getMainUI().getUI() instanceof JTable) {
            return this._panel.getMainUI().getUI();
        }
        return this._panel;
    }

    private DatabaseNode getDatabaseNode() {
        ViewerNode viewerNode = this.getViewerNode();
        return (DatabaseNode)(viewerNode != null ? viewerNode.getBaseNode() : this.getContext().getNode());
    }

    public Object getEditorAttribute(String string) {
        boolean bl = true;
        if (this._editor.hasChildren() || this._panel.getMainUI() instanceof DisplayAdapter && ((DisplayAdapter)this._panel.getMainUI()).getCodeEditor() != null) {
            bl = false;
        }
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public Component getScrollableTopMargin() {
        if (!this._editor.hasChildren() && this._panel.getMainUI() instanceof DisplayResultTable) {
            JTable jTable = (JTable)this._panel.getMainUI().getUI();
            return jTable.getTableHeader();
        }
        return null;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    protected void updateContent(boolean bl) {
        Node node = this.getContext().getNode();
        node.attach(new Observer(){

            public void update(Object object, UpdateMessage updateMessage) {
            }
        });
        this._dbObject = node instanceof ViewerNode ? ((ViewerNode)node).getDBObject() : new DBObject((Element)node);
        if (bl || this._lastdbObject == null || !this._dbObject.checkQualifiedNameEquals(this._lastdbObject) || this._dbObject.getSchemaObject() != this._lastdbObject.getSchemaObject()) {
            if (!bl) {
                this._panel.clear();
            }
            String string = this._dbObject.getConnectionName();
            HashMap hashMap = this._dbObject.getDictionary();
            this._editor.setConnName(string);
            this._panel.setMainPanelBinds(hashMap);
            this._lastdbObject = this._dbObject;
            this._panel.refresh(bl);
            this.updateToolbar();
        }
    }

    public void updateToolbar() {
    }

    public BasicEditorPane getFocusedEditorPane() {
        Component component = this._panel.getFocusedComponent();
        Component[] componentArray = this._panel.getComponents();
        if (component != null) {
            BasicEditorPane basicEditorPane = this._lastBasicEditorPane = component instanceof BasicEditorPane ? (BasicEditorPane)component : null;
        }
        if (this._lastBasicEditorPane == null && this._panel.getMainUI() instanceof DisplayCodeEditor) {
            this._lastBasicEditorPane = ((DisplayCodeEditor)this._panel.getMainUI()).getCodeEditor();
        }
        return this._lastBasicEditorPane;
    }

    public Object getPrintable() {
        return this._panel;
    }

    public Database getDatabase() {
        return this._dbObject.getDatabase();
    }

    public Connection getConnection() {
        return this._dbObject.getConnection();
    }

    public String getConnectionName() {
        return this._dbObject.getConnectionName();
    }

    public void cleanUp() {
        this._panel.close();
        if (this._editor != null) {
            this._editor.setConnName(null);
            this._editor.setConnection(null);
        }
    }

    public void attachGutterMenu(BasicEditorPane basicEditorPane, final LineGutterPlugin lineGutterPlugin) {
        this._gridCtxMenu = new JPopupMenu("Context Menu");
        JMenuItem jMenuItem = new JMenuItem("Toggle Line Numbers");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorProperties editorProperties = EditorProperties.getProperties();
                boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                editorProperties.putBooleanProperty("show-line-numbers", bl);
            }
        });
        this._gridCtxMenu.add(jMenuItem);
        lineGutterPlugin.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                if ((n & 8) != 0 || (n & 4) != 0) {
                    XMLBasedEditor.this._gridCtxMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        basicEditorPane.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                if ((n & 8) != 0 || (n & 4) != 0) {
                    XMLBasedEditor.this._gridCtxMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public String getStatus() {
        return this.getDisplayConnectionName() + " " + this._dbObject.getSchemaName() + "." + this._dbObject.getObjectName();
    }

    private String getDisplayConnectionName() {
        return Connections.getDisplayName((String)this._dbObject.getConnectionName());
    }

    public JComponent[] getCustomCells() {
        if (this._connName == null) {
            this._connName = new JLabel();
            this._connName.setToolTipText("Connection");
        }
        if (this._ownerName == null) {
            this._ownerName = new JLabel();
            this._ownerName.setToolTipText("Schema");
        }
        if (this._objName == null) {
            this._objName = new JLabel();
            this._objName.setToolTipText("Object Name");
        }
        if (this._statusBarCells == null) {
            this._statusBarCells = new JComponent[3];
            this._statusBarCells[0] = this._connName;
            this._statusBarCells[1] = this._ownerName;
            this._statusBarCells[2] = this._objName;
        }
        this._connName.setText(this.getDisplayConnectionName());
        this._ownerName.setText(this._dbObject.getSchemaName());
        this._objName.setText(this._dbObject.getObjectName());
        return this._statusBarCells;
    }

    public boolean isExpandable(JComponent jComponent) {
        return false;
    }

    public boolean checkForMigrationObjectEditable(Context context) {
        IViewerNode iViewerNode = (IViewerNode)context.getNode();
        Node node = iViewerNode.getBaseNode();
        if (node instanceof DatabaseNode) {
            DatabaseNode databaseNode = (DatabaseNode)node;
            String string = (String)databaseNode.getProperty("TYPE");
            String string2 = (String)databaseNode.getProperty("ConnectionType");
            if (string.indexOf("MD_PROCEDURE") >= 0 || string.indexOf("MD_TRIGGER") >= 0 || string.indexOf("MD_VIEW") >= 0 || string.indexOf("MD_FUNCTION") >= 0 && "MIGREPO".equals(string2) || "MIGREPOC".equals(string2)) {
                return true;
            }
        }
        return false;
    }
}

