/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.MnemonicUtils;
import oracle.help.java.util.Version;

public class AboutBox
extends JDialog
implements ActionListener {
    private static final String _KEY_CLOSE = "CLOSE";
    public static final String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private JButton _okButton;

    public AboutBox(Frame frame) {
        super(frame);
        this.setModal(true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this.setTitle(resourceBundle.getString("aboutbox.title"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridLayout(0, 1, 4, 4));
        jPanel.add(new JLabel(resourceBundle.getString("aboutbox.namestring"), 0));
        jPanel.add(new JLabel(Version.getVersion(), 0));
        String string = resourceBundle.getString("aboutbox.copyright");
        jPanel.add(new JLabel(string, 0));
        this.getContentPane().add((Component)jPanel, "Center");
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.setBorder((Border)new EmptyBorder(0, 10, 10, 10));
        this._okButton = MnemonicUtils.createButton(resourceBundle.getString("aboutbox.ok"));
        this._okButton.addActionListener(this);
        dialogButtonBar.add((Component)this._okButton);
        this.getContentPane().add((Component)dialogButtonBar, "South");
        this.addWindowListener(new AboutBoxCloser());
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, _KEY_CLOSE, KeyStroke.getKeyStroke(27, 0), 1);
        this.validate();
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)frame);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._okButton || _KEY_CLOSE.equals(actionEvent.getActionCommand())) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private class AboutBoxCloser
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            AboutBox.this.setVisible(false);
            AboutBox.this.dispose();
        }
    }
}

