/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.favoritesNavigator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.library.Library;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;

public class DefaultFavoritesModel
extends FavoritesModel {
    private static final String _HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<favorites>";
    private static final String _FOOTER = "\n</favorites>";

    public DefaultFavoritesModel(URL uRL, Library library) {
        super(uRL, library);
    }

    protected void restoreFavorites() {
        try {
            File file = new File(this.getLocation().getFile());
            if (file.exists()) {
                InputStream inputStream = this.getLocation().openStream();
                Parser parser = ParserFactory.createParser((InputStream)inputStream);
                this._processFavorites(parser.getRoot().getFirstChild());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void saveFavorites() {
        try {
            OutputStream outputStream = new FileOutputStream(this.getLocation().getFile());
            outputStream = new BufferedOutputStream(outputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            outputStreamWriter.write(_HEADER);
            this._writeFavoriteItemChildren(this.getFavoritesRoot(), outputStreamWriter, "  ");
            outputStreamWriter.write(_FOOTER);
            outputStreamWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void _processFavorites(XMLNode xMLNode) throws XMLParseException {
        if (xMLNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xMLNode.getTokenValue().equalsIgnoreCase("favorites")) {
            throw new XMLParseException("Toplevel tag is not favorites: " + xMLNode.getTokenValue());
        }
        for (xMLNode = xMLNode.getFirstChild(); xMLNode != null; xMLNode = xMLNode.getNextSibling()) {
            this._processFavoriteItem(xMLNode, this.getFavoritesRoot());
        }
    }

    private void _processFavoriteItem(XMLNode xMLNode, TopicTreeNode topicTreeNode) throws XMLParseException {
        if (!xMLNode.getTokenValue().equalsIgnoreCase("favoriteitem")) {
            throw new XMLParseException("Tag is not favoriteitem: " + xMLNode.getTokenValue());
        }
        String string = xMLNode.getTokenProperty("text");
        String string2 = xMLNode.getTokenProperty("target");
        String string3 = xMLNode.getTokenProperty("hstitle");
        String string4 = xMLNode.getTokenProperty("url");
        FavoritesModel.FavoriteItemTopicTreeNode favoriteItemTopicTreeNode = new FavoritesModel.FavoriteItemTopicTreeNode(this, string, string2, string3, string4);
        topicTreeNode.addChild((TopicTreeNode)favoriteItemTopicTreeNode);
        for (xMLNode = xMLNode.getFirstChild(); xMLNode != null; xMLNode = xMLNode.getNextSibling()) {
            this._processFavoriteItem(xMLNode, favoriteItemTopicTreeNode);
        }
    }

    private void _writeFavoriteItemChildren(TopicTreeNode topicTreeNode, Writer writer, String string) throws IOException {
        Iterator iterator = topicTreeNode.getChildren().iterator();
        while (iterator.hasNext()) {
            this._writeFavoriteItem((FavoritesModel.FavoriteItemTopicTreeNode)((Object)iterator.next()), writer, string);
        }
    }

    private void _writeFavoriteItem(FavoritesModel.FavoriteItemTopicTreeNode favoriteItemTopicTreeNode, Writer writer, String string) throws IOException {
        writer.write("\n" + string + "<" + "favoriteitem");
        this._writeAttributeValue("text", favoriteItemTopicTreeNode.getTopic().getLabel(), writer);
        this._writeAttributeValue("target", favoriteItemTopicTreeNode.target, writer);
        this._writeAttributeValue("hstitle", favoriteItemTopicTreeNode.hstitle, writer);
        this._writeAttributeValue("url", favoriteItemTopicTreeNode.url, writer);
        if (favoriteItemTopicTreeNode.hasChildren()) {
            writer.write(">");
            this._writeFavoriteItemChildren(favoriteItemTopicTreeNode, writer, string + "  ");
            writer.write("\n" + string + "</" + "favoriteitem" + ">");
        } else {
            writer.write("/>");
        }
    }

    private void _writeAttributeValue(String string, String string2, Writer writer) throws IOException {
        if (string2 != null) {
            writer.write(" " + string + "=\"" + string2 + "\"");
        }
    }
}

