/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DBAdapterBundle;

public abstract class AbstractConnectionCreator
implements ConnectionCreator {
    private ResourceBundle m_bundle;

    protected ResourceBundle getBundle() {
        if (this.m_bundle == null) {
            this.m_bundle = ResourceBundle.getBundle(DBAdapterBundle.class.getName());
        }
        return this.m_bundle;
    }

    public boolean shouldEncrypt(String propName) {
        return "password".equals(propName);
    }

    public boolean shouldPromptForPassword(Properties props) {
        String savePass;
        String pass = props.getProperty("password");
        return pass == null && (savePass = props.getProperty("SavePassword")) != null && Boolean.valueOf(savePass) == false;
    }

    protected void setCustomProperties(Properties connProps, Properties jdbcProps) {
    }

    public Connection getConnection(Properties props) throws SQLException {
        Connection conn;
        block14: {
            String url;
            String username = props.getProperty("user");
            String password = props.getProperty("password");
            if (!this.hasLength(password) && !this.allowNullPassword()) {
                throw new SQLException(this.getBundle().getString("ERROR_MISSING_PASS"), "");
            }
            String driverClassName = props.getProperty("driver");
            if (!this.hasLength(driverClassName)) {
                driverClassName = this.getDriverClassName(props);
            }
            if (!this.hasLength(url = props.getProperty("customUrl"))) {
                url = this.getConnectionURL(props);
            }
            Driver driver = null;
            try {
                ClassLoader cl = DatabaseProvider.getClassLoader(driverClassName);
                Class<?> cls = Class.forName(driverClassName, true, cl);
                driver = (Driver)cls.newInstance();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (ClassNotFoundException cne) {
                throw new SQLException(this.getBundle().getString("ERROR_DRIVER_CLASS_NOT_FOUND"));
            }
            catch (Throwable t) {
                SQLException ex = new SQLException(t.getLocalizedMessage());
                ex.initCause(t);
                throw ex;
            }
            Properties jdbcProps = new Properties();
            String role = props.getProperty("role");
            if (this.hasLength(role)) {
                jdbcProps.put("internal_logon", role);
            }
            if (this.hasLength(username)) {
                jdbcProps.put("user", username);
            }
            if (this.hasLength(password)) {
                jdbcProps.put("password", password);
            }
            this.setCustomProperties(props, jdbcProps);
            conn = null;
            try {
                conn = driver.connect(url, jdbcProps);
            }
            catch (UnsatisfiedLinkError e) {
                throw new SQLException(e.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                if (!(driver instanceof OracleDriver)) break block14;
                throw new SQLException(this.getBundle().getString("ERROR_UNSUPPORTED_ORACLE_VERSION"));
            }
        }
        if (conn == null) {
            throw new SQLException(this.getBundle().getString("ERROR_INVALID_URL"));
        }
        return conn;
    }

    protected boolean allowNullPassword() {
        return false;
    }

    protected boolean hasLength(String s) {
        return s != null && s.length() > 0;
    }

    protected String getPropertyOrThrow(Properties props, String name) throws SQLException {
        if (props.containsKey(name)) {
            String value = props.getProperty(name);
            if (this.hasLength(value)) {
                return value;
            }
            throw new SQLException("Required property '" + name + "' has an empty value on the DatabaseProvider");
        }
        throw new SQLException("Required property '" + name + "' is not set on the DatabaseProvider");
    }

    public String getConnectionURL(Properties props) throws SQLException {
        return props.getProperty("customUrl");
    }

    public String getDriverClassName(Properties props) throws SQLException {
        return props.getProperty("driver");
    }
}

