/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public abstract class AbstractOracleConnCreator
extends AbstractConnectionCreator {
    protected AbstractOracleConnCreator() {
    }

    protected void setCustomProperties(Properties connProps, Properties jdbcProps) {
        super.setCustomProperties(connProps, jdbcProps);
        AbstractOracleConnCreator.setSessionProps(jdbcProps);
    }

    private static void setSessionProps(Properties jdbcProps) {
        String osuser = System.getProperty("user.name", "UNKNOWN");
        String terminal = System.getProperty("jdbc.terminal", "UNKNOWN");
        String machine = "UNKNOWN";
        try {
            machine = System.getProperty("jdbc.machine", InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            // empty catch block
        }
        String programDefault = System.getProperty("java.vm.name");
        try {
            Class<?> ide = Class.forName("oracle.ide.Ide");
            Method m = ide.getMethod("getProgramShortName", null);
            programDefault = (String)m.invoke(ide, null);
        }
        catch (Throwable t) {
            // empty catch block
        }
        String program = System.getProperty("jdbc.program", programDefault);
        String pidDefault = "UNKNOWN";
        String jvm = System.getProperty("java.vm.name");
        if (!(System.getProperty("disablePIDCheck") != null || jvm != null && jvm.equals("OJVM Client VM"))) {
            try {
                pidDefault = ManagementFactory.getRuntimeMXBean().getName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String process = System.getProperty("jdbc.process", pidDefault);
        jdbcProps.setProperty("v$session.terminal", terminal);
        jdbcProps.setProperty("v$session.machine", machine);
        jdbcProps.setProperty("v$session.osuser", osuser);
        jdbcProps.setProperty("v$session.program", program);
        jdbcProps.setProperty("v$session.process", process);
        jdbcProps.setProperty("oracle.net.CONNECT_TIMEOUT", "300000");
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        AbstractOracleConnCreator.setSessionProps(props);
        AbstractOracleConnCreator.dumpProps(props);
        System.out.println("\nSystem Properties:");
        AbstractOracleConnCreator.dumpProps(System.getProperties());
    }

    private static void dumpProps(Properties props) {
        for (Object key : props.keySet()) {
            System.out.println(key + "\t => \t" + props.get(key));
        }
    }
}

