/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

public class DatabaseProviderFactory
implements ObjectFactory {
    static final String PROVIDER_FACTORY_CLASS = DatabaseProviderFactory.class.getName();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj instanceof Reference) {
            ConnectionCreator cc;
            Reference ref = (Reference)obj;
            DatabaseProvider provider = name != null && name.size() > 0 ? new DatabaseProvider(name.get(name.size() - 1), null) : new DatabaseProvider();
            RefAddr typeAddr = ref.get("subtype");
            provider.setProperty("subtype", typeAddr == null ? null : (String)typeAddr.getContent());
            try {
                cc = DatabaseProvider.getCreator(provider);
            }
            catch (SQLException sqe) {
                cc = null;
            }
            boolean hasNonCredStoreEncryption = false;
            boolean hasCredStoreEncryption = false;
            Enumeration<RefAddr> iter = ref.getAll();
            while (iter.hasMoreElements()) {
                String refValue;
                String refName;
                RefAddr next = iter.nextElement();
                if (next instanceof SecureRefAddr) {
                    SecureRefAddr secRef = (SecureRefAddr)next;
                    refName = secRef.getName();
                    refValue = secRef.getValue();
                    hasCredStoreEncryption = true;
                } else {
                    refName = next.getType();
                    String v = (String)next.getContent();
                    if (cc != null && cc.shouldEncrypt(refName)) {
                        refValue = DatabaseProviderHelper.comingIn(v);
                        hasNonCredStoreEncryption = true;
                    } else {
                        refValue = v;
                    }
                }
                provider.setProperty(refName, refValue);
            }
            if (hasNonCredStoreEncryption && !hasCredStoreEncryption) {
                provider.setProperty("INTERNAL_STRINGS_TO_FILE", "true");
            }
            return provider;
        }
        return null;
    }
}

