/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class MySQLConnectionCreator
extends AbstractConnectionCreator {
    public static final String MYSQL_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    public static final String SUBTYPE_MYSQL = "MYSQL";

    protected boolean allowNullPassword() {
        return true;
    }

    public Connection getConnection(Properties props) throws SQLException {
        return super.getConnection(props);
    }

    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (this.hasLength(driverClassName)) {
            return driverClassName;
        }
        return MYSQL_DRIVER_CLASS;
    }

    public String getConnectionURL(Properties props) throws SQLException {
        String customURL = super.getConnectionURL(props);
        if (this.hasLength(customURL)) {
            return customURL;
        }
        String hostname = this.getPropertyOrThrow(props, "hostname");
        String port = props.getProperty("port");
        String dbase = props.getProperty("dataSourceName");
        if (port != null) {
            return "jdbc:mysql://" + hostname + ":" + port + "/" + dbase;
        }
        if (hostname != null) {
            return "jdbc:mysql://" + hostname + "/" + dbase;
        }
        if (!this.hasLength(customURL) && !this.hasLength(hostname)) {
            throw new SQLException("No URL specified for third-party JDBC driver");
        }
        return customURL;
    }
}

