/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class CMHelper {
    private static final String CONNECTION_ID = "oracle.adf.rc.connectionId";
    private static final String CONNECTION_NAME = "ConnectionName";
    private static final String DEPLOY_PASSWORD = "DeployPassword";
    private static final String URL = "URL";
    private static final String HOSTNAME = "HOSTNAME";
    private static final String SID = "SID";
    private static final String JDBC_PORT = "JDBC_PORT";
    private static final String JDBC_DRIVER = "JdbcDriver";
    private static final String ORACLE_JDBC_TYPE = "ORACLE_JDBC_TYPE";
    private static final String PASSWORD = "password";
    private static final String ROLE = "Role";
    private static final String USERNAME = "user";
    private static final String CONNECTION_TYPE = "ConnectionType";
    public static final String CONN_ORACLE_JDBC = "JDBC";
    public static final String CONN_ORACLE_LITE = "ORACLE_LITE";
    public static final String CONN_JDBC_ODBC = "JDBC_ODBC";
    public static final String CONN_OTHER_JDBC = "OTHER_JDBC";
    public static final String CONN_MYSQL = "MYSQL";
    public static final String CONN_BI_JDBC = "BI_JDBC";
    public static final String CONN_FTP = "FTP";
    public static final String CONN_JNDI = "JNDI";
    private static final String ODBC_DSN = "DSN";
    private static final String EXTRA_PARAMS = "EXTRA_PARAMS";
    private static final String SERVICE_NAME = "ServiceName";
    private static final String ALL_SCHEMAS = "AllSchemas";
    private static final Map<String, String> s_props = new HashMap<String, String>();

    static {
        s_props.put(CONNECTION_TYPE, "subtype");
        s_props.put(HOSTNAME, "hostname");
        s_props.put(JDBC_PORT, "port");
        s_props.put(SID, "sid");
        s_props.put(SERVICE_NAME, "serviceName");
        s_props.put(ODBC_DSN, "dataSourceName");
        s_props.put(JDBC_DRIVER, "driver");
        s_props.put(ROLE, "role");
        s_props.put(URL, "customUrl");
        s_props.put(EXTRA_PARAMS, "parameters");
        s_props.put(ORACLE_JDBC_TYPE, "oraDriverType");
    }

    private CMHelper() {
    }

    public static Referenceable createReferenceFromDescriptor(Properties cd) {
        DatabaseProvider ref = new DatabaseProvider();
        for (Object ikey : cd.keySet()) {
            String value;
            String key;
            if (!(ikey instanceof String)) continue;
            if (ikey.equals(CONNECTION_TYPE)) {
                String driverClass;
                key = "subtype";
                String connectionType = cd.getProperty(CONNECTION_TYPE);
                value = connectionType.equals(CONN_ORACLE_JDBC) ? ((driverClass = cd.getProperty(JDBC_DRIVER)) == null || driverClass.contains("Oracle") ? "oraJDBC" : "thirdParty") : (connectionType.equals(CONN_OTHER_JDBC) ? "thirdParty" : (connectionType.equals(CONN_ORACLE_LITE) ? "oraLite" : (connectionType.equals(CONN_JDBC_ODBC) ? "ODBCBridge" : (connectionType.equals(CONN_MYSQL) ? CONN_MYSQL : connectionType))));
            } else if (ikey.equals(CONNECTION_NAME)) {
                key = null;
                value = null;
            } else {
                key = s_props.containsKey((String)ikey) ? s_props.get((String)ikey) : (String)ikey;
                value = key.equals("driver") && cd.getProperty((String)ikey).equals("oracle.jdbc.driver.OracleDriver") ? "oracle.jdbc.OracleDriver" : cd.getProperty((String)ikey);
            }
            if (key == null) continue;
            ref.setProperty(key, value);
        }
        if (ref.getProperty(PASSWORD) != null && ref.getProperty("SavePassword") == null) {
            ref.setProperty("SavePassword", String.valueOf(true));
        }
        if (ref.getProperty(PASSWORD) == null) {
            ref.setProperty("SavePassword", String.valueOf(false));
        }
        return ref;
    }

    public static Properties createDescriptorFromReference(Referenceable conn) {
        Properties cd = new Properties();
        Reference ref = null;
        try {
            ref = conn.getReference();
        }
        catch (NamingException ex) {
            Properties properties = cd;
            return properties;
        }
        Enumeration<RefAddr> addrs = ref.getAll();
        while (addrs.hasMoreElements()) {
            RefAddr ra = addrs.nextElement();
            String type = null;
            String value = null;
            if (ra instanceof SecureRefAddr) {
                SecureRefAddr sra = (SecureRefAddr)ra;
                type = sra.getName();
                value = sra.getValue();
            } else {
                type = ra.getType();
                value = (String)ra.getContent();
            }
            if (type.equals(CONNECTION_ID)) {
                cd.setProperty(CONNECTION_NAME, value);
                continue;
            }
            if (type.equals(CONNECTION_TYPE)) {
                cd.setProperty(CONNECTION_TYPE, value);
                continue;
            }
            if (type.equals("subtype")) {
                String subtype = value;
                if (value.equals("oraJDBC")) {
                    subtype = CONN_ORACLE_JDBC;
                } else if (value.equals("thirdParty")) {
                    subtype = CONN_OTHER_JDBC;
                } else if (value.equals("oraLite")) {
                    subtype = CONN_ORACLE_LITE;
                } else if (value.equals("ODBCBridge")) {
                    subtype = CONN_JDBC_ODBC;
                } else if (value.equals(CONN_MYSQL)) {
                    subtype = CONN_MYSQL;
                }
                cd.setProperty(CONNECTION_TYPE, subtype);
                continue;
            }
            if (type.equals(USERNAME)) {
                cd.setProperty(USERNAME, value);
                continue;
            }
            if (type.equals(PASSWORD)) {
                cd.setProperty(PASSWORD, value);
                continue;
            }
            if (type.equals(DEPLOY_PASSWORD)) {
                cd.setProperty(DEPLOY_PASSWORD, value);
                continue;
            }
            if (type.equals("role")) {
                cd.setProperty(ROLE, value);
                continue;
            }
            if (type.equals("sid")) {
                cd.setProperty(SID, value);
                continue;
            }
            if (type.equals("serviceName")) {
                cd.setProperty(SERVICE_NAME, value);
                continue;
            }
            if (type.equals("oraDriverType")) {
                cd.setProperty(ORACLE_JDBC_TYPE, value);
                continue;
            }
            if (type.equals("port")) {
                cd.setProperty(JDBC_PORT, value);
                continue;
            }
            if (type.equals("hostname")) {
                cd.setProperty(HOSTNAME, value);
                continue;
            }
            if (type.equals("customUrl")) {
                cd.setProperty(URL, value);
                continue;
            }
            if (type.equals("driver")) {
                cd.setProperty(JDBC_DRIVER, value);
                continue;
            }
            if (type.equals("dataSourceName")) {
                cd.setProperty(ODBC_DSN, value);
                continue;
            }
            if (type.equals("parameters")) {
                cd.setProperty(EXTRA_PARAMS, value);
                continue;
            }
            if (!type.equals("allSchemas")) continue;
            cd.setProperty(ALL_SCHEMAS, value);
        }
        return cd;
    }
}

