/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.processes;

import java.io.Closeable;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.pipeline.controller.Util;

public class XSDSchemaBuilder
extends Process {
    public void initialize() {
        Input input = this.getInput("schema");
        input.supportType(0);
        input.supportType(2);
        input.supportType(8);
    }

    public void execute() throws PipelineException {
        XMLSchema xMLSchema;
        block18: {
            Source source = this.getInputSource("schema");
            String string = (String)this.getInParamValue("baseURL");
            XSDBuilder xSDBuilder = null;
            xMLSchema = null;
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                try {
                    xSDBuilder = new XSDBuilder();
                    Closeable closeable = streamSource.getInputStream();
                    if (closeable != null && string != null) {
                        xMLSchema = xSDBuilder.build(closeable, Util.createURL(string));
                        break block18;
                    }
                    closeable = streamSource.getReader();
                    if (closeable != null && string != null) {
                        xMLSchema = xSDBuilder.build((Reader)closeable, Util.createURL(string));
                        break block18;
                    }
                    this.error(30005, 17, new String[]{"schema"});
                }
                catch (Exception exception) {
                    if (!this.ignoreError("xmlschema")) {
                        this.error(30001, 17, exception);
                    }
                    try {
                        this.info(30000, new String[]{"XSDSchemaBuilder", exception.getMessage()});
                        XMLDocument xMLDocument = this.getErrorDocument("xmlschema", true);
                        xMLSchema = xSDBuilder.build(xMLDocument, Util.createURL(string));
                    }
                    catch (Exception exception2) {
                        this.error(30006, 17, exception2);
                    }
                }
            } else if (source instanceof DOMSource) {
                DOMSource dOMSource = (DOMSource)source;
                if (string != null) {
                    try {
                        xSDBuilder = new XSDBuilder();
                        if (!(dOMSource.getNode() instanceof XMLDocument)) {
                            throw new PipelineException("Schema of type XMLDocument required.");
                        }
                        xMLSchema = xSDBuilder.build((XMLDocument)dOMSource.getNode(), Util.createURL(string));
                    }
                    catch (Exception exception) {
                        if (!this.ignoreError("xmlschema")) {
                            this.error(30001, 17, exception);
                        }
                        try {
                            this.info(30000, new String[]{"XSDSchemaBuilder", exception.getMessage()});
                            XMLDocument xMLDocument = this.getErrorDocument("xmlschema", true);
                            xMLSchema = xSDBuilder.build(xMLDocument, Util.createURL(string));
                        }
                        catch (Exception exception3) {
                            this.error(30006, 17, exception3);
                        }
                    }
                }
            } else {
                this.error(30002, 17, new String[]{"StreamSource and DOMSource"});
            }
        }
        this.setOutParam("xmlschema", xMLSchema);
    }
}

