/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transx;

import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class LangTag {
    int form;
    public static final int NONE = 0;
    public static final int STANDARD = 1;
    public static final int UPPERCASE = 2;
    public static final int LOWERCASE = 3;

    private LangTag(int n) {
        this.form = n;
    }

    static LangTag getInstance(int n) {
        return new LangTag(n);
    }

    String normalize(String string) {
        switch (this.form) {
            case 1: {
                return this.toStandardForm(string);
            }
            case 2: {
                return this.toUpperCase(string);
            }
            case 3: {
                return this.toLowerCase(string);
            }
        }
        return string;
    }

    String toUpperCase(String string) {
        return string.toUpperCase(Locale.US);
    }

    String toLowerCase(String string) {
        return string.toLowerCase(Locale.US);
    }

    String toStandardForm(String string) {
        CharSequence charSequence;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-_ \t\n\r\f", true);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().toLowerCase(Locale.US));
        }
        if (vector.size() >= 3) {
            charSequence = (String)vector.elementAt(2);
            if (((String)charSequence).length() == 2) {
                vector.set(2, ((String)charSequence).toUpperCase(Locale.US));
            } else if (((String)charSequence).length() == 4) {
                vector.set(2, this.toTitleCase((String)charSequence));
            }
        }
        charSequence = new StringBuffer();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((StringBuffer)charSequence).append((String)enumeration.nextElement());
        }
        return ((StringBuffer)charSequence).toString();
    }

    private String toTitleCase(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = stringBuffer.charAt(0);
        stringBuffer.setCharAt(0, Character.toTitleCase(c));
        return stringBuffer.toString();
    }
}

