/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLStylesheetProcessor;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLInsertRequestHandler
extends XSQLActionHandlerImpl {
    private static final int MINBATCH = 0;
    private static final String TABLE = "table";
    private static final String TRANSFORM = "transform";
    private static final String DATEFORMAT = "date-format";
    private static final String BATCHSIZE = "commit-batch-size";
    private static final String COLUMNS = "columns";
    private static final String COMMIT = "commit";
    private static final String INS_STATUS_ELT = "insert-request";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAction(Node node) throws SQLException {
        Object object;
        if (!this.requiredConnectionProvided(node)) {
            return;
        }
        Element element = this.getActionElement();
        XSQLPageRequest xSQLPageRequest = this.getPageRequest();
        OracleXMLSave oracleXMLSave = null;
        String string = this.getAttributeAllowingParam(TABLE, element);
        Object object2 = this.getAttributeAllowingParam(TRANSFORM, element);
        String string2 = this.getAttributeAllowingParam(DATEFORMAT, element);
        String string3 = this.getAttributeAllowingParam(COLUMNS, element);
        String string4 = this.getAttributeAllowingParam(BATCHSIZE, element);
        String string5 = this.getAttributeAllowingParam(COMMIT, element);
        if (object2 != null && !((String)object2).equals("")) {
            if (XSQLUtil.untrustedAbsoluteStylesheetURL((String)object2)) {
                this.reportError(node, Res.format(25118, (String)object2));
                return;
            }
            object = xSQLPageRequest.translateURL((String)object2);
            if (object == null) {
                this.reportError(node, Res.format(25123, (String)object2));
                return;
            }
            object2 = object;
        } else {
            object2 = null;
        }
        if (string == null || string.equals("")) {
            this.reportMissingAttribute(node, TABLE);
            return;
        }
        object = this.getPageRequest().getPostedDocument();
        Object object3 = null;
        if (object != null) {
            try {
                String[] stringArray;
                object3 = object2 != null && !((String)object2).equals("") ? XSQLStylesheetProcessor.processToDocument((Document)object, (String)object2, this.getPageRequest()) : object;
                oracleXMLSave = new OracleXMLSave(this.getPageRequest().getJDBCConnection(), string);
                oracleXMLSave.setIgnoreCase(true);
                if (string2 != null && !string2.equals("")) {
                    oracleXMLSave.setDateFormat(string2);
                }
                if (string3 != null && !string3.equals("") && (stringArray = XSQLUtil.tokenizeIntoArray(string3)) != null) {
                    oracleXMLSave.setUpdateColumnList(stringArray);
                }
                if (string4 != null && !string4.equals("")) {
                    try {
                        int n = Integer.parseInt(string4);
                        if (n > 0) {
                            oracleXMLSave.setCommitBatch(n);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                int n = oracleXMLSave.insertXML((Document)object3);
                if (string5 == null || !string5.equalsIgnoreCase("NO")) {
                    this.getPageRequest().getJDBCConnection().commit();
                }
                this.reportStatus(node, "rows", "" + n);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.reportError(node, Res.format(25113, (String)object2));
            }
            catch (IOException iOException) {
                this.reportError(node, Res.format(25113, (String)object2));
            }
            catch (SQLException sQLException) {
                this.reportError(node, sQLException.getMessage());
            }
            catch (OracleXMLSQLException oracleXMLSQLException) {
                this.reportError(node, oracleXMLSQLException.getMessage());
            }
            catch (Exception exception) {
                this.reportError(node, exception.getMessage());
            }
            finally {
                if (oracleXMLSave != null) {
                    oracleXMLSave.close();
                }
            }
        } else {
            this.reportStatus(node, "result", Res.getString(25115));
        }
    }
}

