/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLActionHandler;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XSQLActionHandlerImpl
implements XSQLActionHandler {
    private static final String XSQL_ERROR_ELT = "xsql-error";
    private static final String SUPPRESS_STMT_ATTR = "error-statement";
    private static final String XSQL_STATUS_ELT = "xsql-status";
    private static final String XSQL_ACTION_ATTR = "action";
    private static final String XSQL_MESSAGE_ELT = "message";
    private static final String XSQL_STMT_ELT = "statement";
    private static final String XSQL_ERROR_CODE = "code";
    private static final String BINDPARAMS = "bind-params";
    private static final String N = "N";
    private static final String NO = "NO";
    private static final String DEFAULT_TABLE_OF_VARCHAR_TYPE = "XSQL_TABLE_OF_VARCHAR";
    private static final String ERROR_PARAM = "error-param";
    private static final String ERROR_PARAM_VALUE = "Error";
    private XSQLPageRequest env = null;
    private XMLElement actionElement = null;

    protected XSQLPageRequest getPageRequest() {
        return this.env;
    }

    protected Element getActionElement() {
        return this.actionElement;
    }

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        this.env = xSQLPageRequest;
        this.actionElement = (XMLElement)element;
        element.normalize();
    }

    protected void reportFatalError(String string) throws SQLException {
        this.getPageRequest().signalError(string);
        throw new SQLException();
    }

    protected void reportErrorIncludingStatement(Node node, String string, String string2) {
        node.appendChild(this.makeErrorElement(string2, string));
    }

    protected void reportErrorIncludingStatement(Node node, String string, int n, String string2) {
        this.setErrorStatusParamIfPresent();
        node.appendChild(this.makeErrorElement(string2, string, n));
    }

    protected void addResultElement(Node node, String string, String string2) {
        Document document = this.actionElement.getOwnerDocument();
        Element element = null;
        try {
            element = document.createElement(string);
            if (string2 != null) {
                Text text = document.createTextNode(string2);
                element.appendChild(text);
            }
            node.appendChild(element);
        }
        catch (DOMException dOMException) {
            this.reportError(node, "Result element name '" + string + "' is not a valid XML Element name.");
        }
    }

    protected boolean requiredConnectionProvided(Node node) {
        if (this.getPageRequest().getJDBCConnection() == null) {
            this.reportError(node, "No connection attribute specified on document element.");
            return false;
        }
        return true;
    }

    protected int getDefaultFetchSize() {
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        return xSQLConfigManager.getDefaultRowPrefetch();
    }

    protected void reportError(Node node, String string) {
        this.setErrorStatusParamIfPresent();
        node.appendChild(this.makeErrorElement(string, null));
    }

    protected void reportMissingAttribute(Node node, String string) {
        this.setErrorStatusParamIfPresent();
        node.appendChild(this.makeErrorElement(Res.format(25100, string), null));
    }

    protected void reportStatus(Node node, String string, String string2) {
        node.appendChild(this.makeStatusElement(string, string2));
    }

    private Element makeStatusElement(String string, String string2) {
        Document document = this.actionElement.getOwnerDocument();
        Element element = document.createElement(XSQL_STATUS_ELT);
        element.setAttribute(XSQL_ACTION_ATTR, "xsql:" + this.actionElement.getLocalName());
        if (string != null) {
            element.setAttribute(string, string2 != null ? string2 : "");
        }
        return element;
    }

    private Element makeErrorElement(String string, String string2) {
        return this.makeErrorElement(string, string2, 0);
    }

    private Element makeErrorElement(String string, String string2, int n) {
        Text text;
        Element element;
        Document document = this.actionElement.getOwnerDocument();
        Element element2 = document.createElement(XSQL_ERROR_ELT);
        if (n != 0) {
            element2.setAttribute(XSQL_ERROR_CODE, new Integer(n).toString());
        }
        element2.setAttribute(XSQL_ACTION_ATTR, "xsql:" + this.actionElement.getLocalName());
        String string3 = this.getAttributeAllowingParam(SUPPRESS_STMT_ATTR, this.getActionElement());
        if (string2 != null && (string3 == null || string3.equals("") || string3 != null && !string3.equalsIgnoreCase(N) && !string3.equalsIgnoreCase(NO))) {
            element = document.createElement(XSQL_STMT_ELT);
            text = document.createTextNode(string2);
            element.appendChild(text);
            element2.appendChild(element);
        }
        if (string != null) {
            element = document.createElement(XSQL_MESSAGE_ELT);
            text = document.createTextNode(string);
            element.appendChild(text);
            element2.appendChild(element);
        }
        return element2;
    }

    protected String getAttributeAllowingParam(String string, Element element) {
        Attr attr = (Attr)element.getAttributes().getNamedItem(string);
        if (attr == null) {
            return null;
        }
        String string2 = attr.getValue();
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while ((n = string2.indexOf("{@")) >= 0 && (n2 = string2.indexOf("}", n)) != 0) {
            Object object;
            string3 = string2.substring(n + 2, n2);
            Object object2 = null;
            if (XSQLUtil.isArrayParamName(string3)) {
                object = this.variableValues(string3 = XSQLUtil.arrayParamName(string3), element, string);
                if (object != null) {
                    int n3 = ((String[])object).length;
                    if (n3 == 1) {
                        object2 = object[0];
                    } else if (n3 > 1) {
                        object2 = XSQLUtil.commaSeparatedListOfValues((String[])object, false);
                    }
                }
            } else {
                object2 = this.variableValue(string3, element, string);
            }
            if (object2 != null && ((String)object2).indexOf("{@" + string3) >= 0) {
                object2 = "";
            }
            object = new StringBuffer(100);
            ((StringBuffer)object).append(string2.substring(0, n)).append((String)object2).append(string2.substring(n2 + 1));
            string2 = ((StringBuffer)object).toString();
        }
        return string2;
    }

    protected String getAttribute(String string, Element element) {
        Attr attr = (Attr)element.getAttributes().getNamedItem(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    protected void appendCopyOfSecondaryDocument(Node node, Document document) {
        if (node == null || document == null) {
            return;
        }
        Element element = document.getDocumentElement();
        XMLElement xMLElement = (XMLElement)((XMLElement)element).cloneNode(true);
        XMLDocument xMLDocument = (XMLDocument)node.getOwnerDocument();
        if (xMLDocument != null) {
            xMLElement = (XMLElement)xMLDocument.adoptNode((Node)xMLElement);
        }
        node.appendChild((Node)xMLElement);
    }

    protected void appendSecondaryDocument(Node node, Document document) {
        if (node == null || document == null) {
            return;
        }
        Element element = document.getDocumentElement();
        document.removeChild(element);
        XMLDocument xMLDocument = (XMLDocument)node.getOwnerDocument();
        if (xMLDocument != null) {
            element = (Element)xMLDocument.adoptNode((Node)element);
        }
        node.appendChild(element);
    }

    protected String variableValue(String string, Element element) {
        return this.variableValue(string, element, null);
    }

    protected String[] variableValues(String string, Element element) {
        return this.variableValues(string, element, null);
    }

    private String[] variableValues(String string, Element element, String string2) {
        Object object;
        String[] stringArray = this.env.getParameterValues(string);
        if (stringArray != null) {
            return stringArray;
        }
        Element element2 = element;
        if (string2 != null && string.equals(string2)) {
            object = element.getParentNode();
            if (object instanceof Document) {
                return null;
            }
            element2 = (Element)object;
        }
        while (true) {
            Object object2;
            object = element2.getNamespaceURI();
            String string3 = null;
            string3 = object != null && ((String)object).equals("urn:oracle-xsql") ? this.getAttributeAllowingParam(string, element2) : this.getAttribute(string, element2);
            if (string3 != null) {
                object2 = XSQLUtil.tokenizeIntoArrayUsingCommasIfPresent(string3);
                if (object2 == null) {
                    return null;
                }
                return object2;
            }
            object2 = element2.getParentNode();
            if (object2 instanceof Document) break;
            element2 = (Element)object2;
        }
        return null;
    }

    private String variableValue(String string, Element element, String string2) {
        Object object;
        String string3 = this.env.getParameter(string);
        if (string3 != null) {
            return string3;
        }
        Element element2 = element;
        if (string2 != null && string.equals(string2)) {
            object = element.getParentNode();
            if (object instanceof Document) {
                return "";
            }
            element2 = (Element)object;
        }
        while (true) {
            if ((string3 = (object = element2.getNamespaceURI()) != null && ((String)object).equals("urn:oracle-xsql") ? this.getAttributeAllowingParam(string, element2) : this.getAttribute(string, element2)) != null) {
                return string3;
            }
            Node node = element2.getParentNode();
            if (node instanceof Document) break;
            element2 = (Element)node;
        }
        return "";
    }

    protected String getActionElementContent() {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        string = this.valueOfFirstNonEmptyTextNodeChildOf((Element)this.actionElement);
        while ((n = string.indexOf("{@")) >= 0 && (n2 = string.indexOf("}", n)) != 0) {
            Object object;
            string2 = string.substring(n + 2, n2);
            Object object2 = null;
            if (XSQLUtil.isArrayParamName(string2)) {
                object = this.variableValues(string2 = XSQLUtil.arrayParamName(string2), (Element)this.actionElement);
                if (object != null) {
                    int n3 = ((String[])object).length;
                    if (n3 == 1) {
                        object2 = object[0];
                    } else if (n3 > 1) {
                        object2 = XSQLUtil.commaSeparatedListOfValues((String[])object, false);
                    }
                }
            } else {
                object2 = this.variableValue(string2, (Element)this.actionElement);
            }
            if (object2 != null && ((String)object2).indexOf("{@" + string2) >= 0) {
                object2 = "";
            }
            object = new StringBuffer(100);
            ((StringBuffer)object).append(string.substring(0, n)).append((String)object2).append(string.substring(n2 + 1));
            string = ((StringBuffer)object).toString();
        }
        return string;
    }

    protected String firstColumnOfFirstRow(Node node, String string) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        if (string != null && !string.equals("")) {
            if (!this.requiredConnectionProvided(node)) {
                return null;
            }
            try {
                String string2 = null;
                preparedStatement = this.getPageRequest().getJDBCConnection().prepareStatement(string);
                this.handleBindVariables(preparedStatement);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
                resultSet.close();
                preparedStatement.close();
                return string2 != null ? string2 : "";
            }
            catch (SQLException sQLException) {
                this.reportErrorIncludingStatement(node, string, sQLException.getErrorCode(), sQLException.getMessage());
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected String[] firstNColumnsOfFirstRow(Node node, String string, int n) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        if (string != null && !string.equals("")) {
            if (!this.requiredConnectionProvided(node)) {
                return null;
            }
            String[] stringArray = new String[n];
            int n2 = 0;
            try {
                preparedStatement = this.getPageRequest().getJDBCConnection().prepareStatement(string);
                this.handleBindVariables(preparedStatement);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    for (int i = 1; i <= n; ++i) {
                        stringArray[i - 1] = resultSet.getString(i);
                        ++n2;
                    }
                }
                resultSet.close();
                preparedStatement.close();
                return stringArray;
            }
            catch (SQLException sQLException) {
                if (n2 > 0) {
                    this.reportErrorIncludingStatement(node, string, Res.format(25120, new Integer(n).toString()));
                } else {
                    this.reportErrorIncludingStatement(node, string, sQLException.getErrorCode(), sQLException.getMessage());
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private String valueOfFirstNonEmptyTextNodeChildOf(Element element) {
        Node node = element.getFirstChild();
        if (node == null) {
            return "";
        }
        do {
            String string;
            short s;
            if ((s = node.getNodeType()) != 3 && s != 4 || (string = node.getNodeValue().trim()) == null || string.equals("")) continue;
            return string;
        } while ((node = node.getNextSibling()) != null);
        return "";
    }

    protected String getDefaultOWAFetchStyle() {
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        return xSQLConfigManager.getDefaultOWAFetchStyle();
    }

    protected void handleBindVariables(PreparedStatement preparedStatement) throws SQLException {
        this.handleBindVariables(preparedStatement, 0);
    }

    protected void handleBindVariables(PreparedStatement preparedStatement, int n) throws SQLException {
        ArrayDescriptor arrayDescriptor = null;
        if (preparedStatement == null) {
            return;
        }
        String string = this.getAttributeAllowingParam(BINDPARAMS, this.getActionElement());
        if (string != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n2 = 0;
            XSQLPageRequest xSQLPageRequest = this.getPageRequest();
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                ++n2;
                String string2 = stringTokenizer.nextToken();
                if (XSQLUtil.isArrayParamName(string2)) {
                    string2 = XSQLUtil.arrayParamName(string2);
                    object = this.env.getJDBCConnection();
                    if (object != null && this.env.isOracleDriver()) {
                        String[] stringArray = this.variableValues(string2, this.getActionElement());
                        if (stringArray == null) {
                            preparedStatement.setNull(n2 + n, 2003, DEFAULT_TABLE_OF_VARCHAR_TYPE);
                            continue;
                        }
                        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
                        if (arrayDescriptor == null) {
                            arrayDescriptor = new ArrayDescriptor(DEFAULT_TABLE_OF_VARCHAR_TYPE, (Connection)object);
                        }
                        ((OraclePreparedStatement)preparedStatement).setARRAY(n2 + n, new ARRAY(arrayDescriptor, (Connection)object, (Object)stringArray));
                        continue;
                    }
                }
                if ((object = this.variableValue(string2, this.getActionElement())) == null) {
                    preparedStatement.setNull(n2 + n, 12);
                    continue;
                }
                preparedStatement.setString(n2 + n, (String)object);
            }
        }
    }

    protected int getBindVariableCount() throws SQLException {
        int n = 0;
        String string = this.getAttributeAllowingParam(BINDPARAMS, this.getActionElement());
        if (string != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n;
            }
        }
        return n;
    }

    protected String valueOfXPathInPostedXML(String string) throws XSLException {
        XMLDocument xMLDocument = (XMLDocument)this.getPageRequest().getPostedDocument();
        if (xMLDocument != null) {
            Element element = this.getActionElement();
            if (element == null) {
                return xMLDocument.valueOf(string);
            }
            return xMLDocument.valueOf(string, (NSResolver)element);
        }
        return "";
    }

    protected void setErrorStatusParamIfPresent() {
        String string = this.getAttributeAllowingParam(ERROR_PARAM, this.getActionElement());
        if (string != null && !string.equals("")) {
            this.env.setPageParam(string, ERROR_PARAM_VALUE);
        }
    }
}

