/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLPageRequestImpl;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XSQLCommandLinePageRequest
extends XSQLPageRequestImpl {
    private static final String ORATST = "-oratst";
    private static final String TILDE = ":";
    private String[] args;
    private int argsUsed = 0;
    private String outputFileName = null;
    private Dictionary extraParameters = null;

    private XSQLCommandLinePageRequest(URL uRL, Dictionary dictionary, Dictionary dictionary2, XSQLPageRequest xSQLPageRequest, PrintWriter printWriter, OutputStream outputStream) {
        this.setTopRequest(xSQLPageRequest);
        this.pageurl = uRL.toString();
        this.parameters = dictionary;
        this.extraParameters = dictionary2;
        if (printWriter != null) {
            this.out = printWriter;
        } else if (outputStream != null) {
            this.outStream = outputStream;
        }
    }

    public XSQLCommandLinePageRequest(String[] stringArray) {
        this.args = stringArray;
        this.setupErrorWriter();
        if (stringArray.length >= 2 && stringArray[1].indexOf("=") < 0 && !stringArray[1].equals(ORATST)) {
            this.argsUsed = 2;
            this.outputFileName = stringArray[1];
        } else {
            this.argsUsed = 1;
        }
        this.parseCommandLineAttributes();
        this.setupPageURL();
    }

    protected void setupOutputStream() {
        if (this.outputFileName != null) {
            try {
                this.outStream = new FileOutputStream(this.outputFileName);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.setupOutputStream();
    }

    protected void setupWriter() {
        if (this.outputFileName != null) {
            try {
                if (this.outputEncoding != null) {
                    try {
                        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFileName), this.outputEncoding));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (this.out == null) {
                    this.out = new PrintWriter(new FileWriter(this.outputFileName));
                }
            }
            catch (IOException iOException) {
                this.signalError(25010, new String[]{this.args[1]}, null);
                super.setupWriter();
            }
        } else {
            super.setupWriter();
        }
    }

    public String getParameter(String string) {
        String string2 = super.getParameter(string);
        if (string2 != null) {
            return string2;
        }
        if (this.extraParameters != null && (string2 = XSQLUtil.stringParamValue(this.extraParameters.get(string))) != null) {
            return string2;
        }
        if (!(this.parameters == null || string.equals("xml-stylesheet") && this.isIncluded)) {
            return (String)this.parameters.get(string);
        }
        return null;
    }

    public String[] getParameterValues(String string) {
        String[] stringArray = super.getParameterValues(string);
        if (stringArray != null) {
            return stringArray;
        }
        if (this.extraParameters != null && (stringArray = XSQLUtil.stringParamValues(this.extraParameters.get(string))) != null) {
            return stringArray;
        }
        if (!(this.parameters == null || string.equals("xml-stylesheet") && this.isIncluded)) {
            Object v = this.parameters.get(string);
            if (v instanceof String) {
                return new String[]{(String)v};
            }
            if (v instanceof String[]) {
                return (String[])v;
            }
        }
        return null;
    }

    protected void setupPageURL() {
        if (this.requiredParametersOk()) {
            URL uRL = this.createURL(this.args[0]);
            this.pageurl = uRL != null ? uRL.toString() : null;
        }
    }

    private URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Cannot create url for: " + string);
                System.exit(0);
            }
        }
        return uRL;
    }

    public boolean useConnectionPooling() {
        return false;
    }

    public String getUserAgent() {
        String string = this.getParameter("useragent");
        return string == null ? "commandline" : string;
    }

    public String translateURL(String string) {
        URL uRL = null;
        String string2 = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = this.getSourceDocumentURI();
            try {
                URL uRL2 = new URL(string3);
                string3 = uRL2.toString();
                if (string3.startsWith("file:/")) {
                    int n = string3.indexOf("/");
                    int n2 = string3.indexOf("/", n + 1);
                    int n3 = string3.lastIndexOf("/");
                    String string4 = string3.substring(0, n2);
                    String string5 = string3.substring(0, n3 + 1);
                    string2 = string.charAt(0) == '/' ? string4 + string : string5 + string;
                } else {
                    String string6 = uRL2.getProtocol();
                    String string7 = uRL2.getHost();
                    int n = uRL2.getPort();
                    String string8 = n != -1 ? TILDE + new Integer(n).toString() : "";
                    String string9 = string6 + "://" + string7 + string8;
                    string2 = string.charAt(0) == '/' ? string9 + string : string3.substring(0, string3.lastIndexOf(47) + 1) + string;
                }
                return string2;
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        return uRL.toString();
    }

    public String getRequestType() {
        return "Command Line";
    }

    public boolean requiredParametersOk() {
        return this.args.length >= 1;
    }

    public String usageMessage() {
        return "xsql xsqlFileURI [outFileName] [param1=value1 ... paramN=valueN]";
    }

    private void parseCommandLineAttributes() {
        String string = "=";
        this.parameters = new Hashtable();
        int n = this.args.length;
        if (n > this.argsUsed) {
            for (int i = this.argsUsed; i < n; ++i) {
                String[] stringArray;
                Object v;
                char c;
                String string2 = this.args[i];
                if (string2.equals(ORATST)) {
                    string = TILDE;
                    continue;
                }
                int n2 = string2.indexOf(string);
                if (n2 < 0) continue;
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1);
                if (string4 != null && !string4.equals("") && (c = string4.charAt(0)) == '\"') {
                    string4 = string4.substring(1, string4.length() - 1);
                }
                if ((v = this.parameters.get(string3)) == null) {
                    this.parameters.put(string3, string4);
                    continue;
                }
                if (v instanceof String[]) {
                    stringArray = (String[])v;
                    int n3 = stringArray.length;
                    String[] stringArray2 = new String[n3 + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n3);
                    stringArray2[n3] = string4;
                    this.parameters.put(string3, stringArray2);
                    continue;
                }
                stringArray = new String[]{(String)v, string4};
                this.parameters.put(string3, stringArray);
            }
        }
    }

    public Document getPostedDocument() {
        String string;
        Document document = super.getPostedDocument();
        if (document == null && (string = this.getParameter("posted-xml")) != null) {
            URL uRL = this.createURL(string);
            if (uRL != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                try {
                    Document document2 = XSQLParserHelper.parse(uRL, printWriter);
                    if (document2 != null) {
                        super.setPostedDocument(document2);
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
                catch (SAXParseException sAXParseException) {
                    this.signalError(25016, null, new Object[]{sAXParseException});
                    return null;
                }
                catch (SAXException sAXException) {
                    return null;
                }
            }
            return this.getPostedDocument();
        }
        return document;
    }

    public XSQLPageRequest createNestedRequest(String string, URL uRL, Dictionary dictionary, PrintWriter printWriter, OutputStream outputStream) {
        Object object;
        Dictionary dictionary2 = null;
        if (this.extraParameters != null) {
            if (dictionary == null) {
                dictionary2 = this.extraParameters;
            } else {
                object = this.extraParameters.keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    if (dictionary.get(string2) != null) continue;
                    dictionary.put(string2, this.extraParameters.get(string2));
                }
                dictionary2 = dictionary;
            }
        } else {
            dictionary2 = dictionary;
        }
        object = this.getTopRequest();
        return new XSQLCommandLinePageRequest(uRL, this.parameters, dictionary2, (XSQLPageRequest)(object != null ? object : this), printWriter, outputStream);
    }
}

