/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xsql.XSQLConnectionManagerFactory;
import oracle.xml.xsql.XSQLErrorHandler;
import oracle.xml.xsql.XSQLErrorHandlerImpl;
import oracle.xml.xsql.XSQLInitializationException;
import oracle.xml.xsql.XSQLLoggerFactory;
import oracle.xml.xsql.XSQLNamedConnection;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLServletPageRequest;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XSQLConfigManager {
    private static final String DEFAULT_CHARSET = "8859_1";
    private static final String DEFAULT_CONFIG_FILE_NAME = "XSQLConfig.xml";
    private static final String CONFIG_FILE_SYSTEMPARAM = "xsql.config";
    private Hashtable namedConnections = new Hashtable(5);
    private Hashtable userDefinedHandlers = new Hashtable(5);
    private Hashtable userDefinedSerializers = new Hashtable(5);
    private Hashtable noCharsetMimeTypes = new Hashtable(5);
    private Hashtable xslTrustedHosts = new Hashtable(5);
    private boolean dumpPoolAllowed = false;
    private Integer xsqlResultFragmentCacheSize = new Integer(40);
    private Integer xsqlPageCacheSize = new Integer(20);
    private Integer stylesheetPageCacheSize = new Integer(20);
    private Integer stylesheetPoolInitial = new Integer(1);
    private Integer stylesheetPoolIncrement = new Integer(1);
    private Integer stylesheetPoolTimeout = new Integer(60);
    private Integer connectionPoolInitial = new Integer(1);
    private Integer connectionPoolIncrement = new Integer(1);
    private Integer outputBufferSize = new Integer(0);
    private Integer connectionPoolTimeout = new Integer(60);
    private Integer defaultRowPrefetch = new Integer(50);
    private Boolean reloadConfigFileOnError = new Boolean(true);
    private Boolean preserveWhitespace = Boolean.TRUE;
    private String baseCharSet = "8859_1";
    private String configFileNameToUse = null;
    private static final String OWA_FETCHSTYLE_CLOB = "CLOB";
    private static final String OWA_FETCHSTYLE_TABLE = "TABLE";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private String defaultOWAFetchStyle = "CLOB";
    private boolean defaultAllowXSLOverride = false;
    private boolean pageTiming = false;
    private boolean actionTiming = false;
    private boolean allowAnyHost = false;
    private static final String defaultConnManagerFactoryName = "oracle.xml.xsql.XSQLConnectionManagerFactoryImpl";
    private static final String defaultErrorHandlerClassName = "oracle.xml.xsql.XSQLErrorHandlerImpl";
    private XSQLConnectionManagerFactory defaultConnManagerFactory = null;
    private XSQLLoggerFactory xsqlLoggerFactory = null;
    private XSQLErrorHandler currentErrorHandler = new XSQLErrorHandlerImpl();
    private XSQLErrorHandler defaultErrorHandler = null;
    private static boolean loadedConfig = false;
    private static XSQLConfigManager xcm = null;

    public boolean pageTimingInfo() {
        return this.pageTiming;
    }

    public boolean actionTimingInfo() {
        return this.actionTiming;
    }

    public String getBaseCharsetForConversion() {
        return this.baseCharSet;
    }

    public boolean isTrustedHost(String string) {
        if (this.allowAnyHost) {
            return true;
        }
        if (string != null && !string.equals("")) {
            if (string.equals("localhost") || string.equals("127.0.0.1")) {
                return true;
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                String string2 = inetAddress.getHostAddress();
                return this.xslTrustedHosts.get(string2) != null;
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
        return false;
    }

    public boolean defaultAllowClientOverride() {
        return this.defaultAllowXSLOverride;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public boolean isCustomLoggerFactoryProvided() {
        return this.xsqlLoggerFactory != null;
    }

    public XSQLLoggerFactory getLoggerFactory() {
        return this.xsqlLoggerFactory;
    }

    public XSQLConnectionManagerFactory getDefaultConnectionManagerFactory() {
        return this.defaultConnManagerFactory;
    }

    public XSQLErrorHandler getErrorHandler() {
        return this.currentErrorHandler;
    }

    public XSQLErrorHandler getDefaultErrorHandler() {
        if (this.defaultErrorHandler == null) {
            XSQLErrorHandlerImpl xSQLErrorHandlerImpl = new XSQLErrorHandlerImpl();
            this.defaultErrorHandler = xSQLErrorHandlerImpl;
        }
        return this.defaultErrorHandler;
    }

    public int getDefaultRowPrefetch() {
        return this.defaultRowPrefetch;
    }

    public String getDefaultOWAFetchStyle() {
        return this.defaultOWAFetchStyle;
    }

    public int getConnectionPoolTimeout() {
        return this.connectionPoolTimeout * 1000;
    }

    public int getConnectionPoolInitial() {
        return this.connectionPoolInitial;
    }

    public int getConnectionPoolIncrement() {
        return this.connectionPoolIncrement;
    }

    public int getStylesheetPoolTimeout() {
        return this.stylesheetPoolTimeout * 1000;
    }

    public int getStylesheetPoolInitial() {
        return this.stylesheetPoolInitial;
    }

    public int getStylesheetPoolIncrement() {
        return this.stylesheetPoolIncrement;
    }

    public int getXSQLPageCacheSize() {
        return this.xsqlPageCacheSize;
    }

    public int getXSQLResultFragmentCacheSize() {
        return this.xsqlResultFragmentCacheSize;
    }

    public int getStylesheetPageCacheSize() {
        return this.stylesheetPageCacheSize;
    }

    public static XSQLConfigManager getManager() {
        if (xcm == null) {
            xcm = new XSQLConfigManager();
        }
        return xcm;
    }

    public static void insureConfigurationIsLoaded(XSQLPageRequest xSQLPageRequest) {
        if (!loadedConfig) {
            XSQLConfigManager.getManager().reloadConfigFile(xSQLPageRequest);
        }
    }

    public boolean dumpPoolAllowed() {
        return this.dumpPoolAllowed;
    }

    public boolean preserveWhitespace() {
        return this.preserveWhitespace == Boolean.TRUE;
    }

    public boolean ignoreCharsetForMime(String string) {
        return this.noCharsetMimeTypes.get(string) != null;
    }

    public Hashtable getNamedConnections() {
        return this.namedConnections;
    }

    public XSQLNamedConnection getNamedConnection(XSQLPageRequest xSQLPageRequest, String string) {
        XSQLNamedConnection xSQLNamedConnection = (XSQLNamedConnection)this.namedConnections.get(string);
        if (xSQLNamedConnection == null && (this.reloadConfigFileOnError.equals(Boolean.TRUE) || !loadedConfig)) {
            this.reloadConfigFile(xSQLPageRequest);
        }
        return (XSQLNamedConnection)this.namedConnections.get(string);
    }

    public Hashtable getUserDefinedHandlers() {
        return this.userDefinedHandlers;
    }

    public Hashtable getUserDefinedSerializers() {
        return this.userDefinedSerializers;
    }

    private XSQLConfigManager() {
    }

    synchronized void reset() {
        loadedConfig = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reloadConfigFile(XSQLPageRequest xSQLPageRequest) {
        Object object;
        Object object2;
        Document document = null;
        Object var3_3 = null;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        if (this.configFileNameToUse == null) {
            object2 = System.getProperty(CONFIG_FILE_SYSTEMPARAM);
            if (object2 != null) {
                this.configFileNameToUse = object2;
            }
            if (xSQLPageRequest.getRequestType().equals("Servlet")) {
                object2 = null;
                object = (XSQLServletPageRequest)xSQLPageRequest;
                object2 = ((XSQLServletPageRequest)object).getCustomConfigFileName();
                if (object2 != null) {
                    this.configFileNameToUse = object2;
                }
            }
        }
        if (this.configFileNameToUse == null) {
            this.configFileNameToUse = DEFAULT_CONFIG_FILE_NAME;
        }
        try {
            inputStream = this.readConfigFileFromClassPath(this.configFileNameToUse);
            if (inputStream == null) {
                xSQLPageRequest.signalError(25003, new String[]{this.configFileNameToUse}, null);
                throw new XSQLInitializationException();
            }
            bufferedInputStream = new BufferedInputStream(inputStream);
            document = XSQLParserHelper.parse(bufferedInputStream, null, printWriter);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            xSQLPageRequest.signalError(25003, new String[]{this.configFileNameToUse}, null);
            throw new XSQLInitializationException();
        }
        catch (SAXParseException sAXParseException) {
            xSQLPageRequest.signalError(25020, new String[]{this.configFileNameToUse}, new Object[]{sAXParseException});
            throw new XSQLInitializationException();
        }
        catch (SAXException sAXException) {
            xSQLPageRequest.signalError(25020, new String[]{this.configFileNameToUse}, null);
            throw new XSQLInitializationException();
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        loadedConfig = true;
        object2 = new Hashtable(5);
        if (document != null) {
            NodeList nodeList;
            String string;
            Node node;
            Object object3;
            Object object4;
            Object object5;
            Hashtable<String, String> hashtable;
            Object object6;
            String string2;
            Hashtable<String, String> hashtable2;
            String string3;
            Object object7;
            Properties properties;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Integer n;
            block198: {
                Object object12;
                block197: {
                    block196: {
                        Object object13;
                        block195: {
                            block194: {
                                Object object14;
                                object = XSQLUtil.valueOf(document, "/XSQLConfig/processor/reload-connections-on-error");
                                this.reloadConfigFileOnError = new Boolean(((String)object).equalsIgnoreCase("yes"));
                                try {
                                    n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/result-cache-size"));
                                    object14 = this.xsqlResultFragmentCacheSize;
                                    synchronized (object14) {
                                        this.xsqlResultFragmentCacheSize = n;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                try {
                                    n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/page-cache-size"));
                                    object14 = this.xsqlPageCacheSize;
                                    synchronized (object14) {
                                        this.xsqlPageCacheSize = n;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                try {
                                    n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-cache-size"));
                                    object14 = this.stylesheetPageCacheSize;
                                    synchronized (object14) {
                                        this.stylesheetPageCacheSize = n;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                try {
                                    n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-pool/initial"));
                                    object14 = this.stylesheetPoolInitial;
                                    synchronized (object14) {
                                        this.stylesheetPoolInitial = n;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                try {
                                    n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-pool/increment"));
                                    object14 = this.stylesheetPoolIncrement;
                                    synchronized (object14) {
                                        this.stylesheetPoolIncrement = n;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                try {
                                    n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-pool/timeout-seconds"));
                                    object14 = this.stylesheetPoolTimeout;
                                    synchronized (object14) {
                                        this.stylesheetPoolTimeout = n;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                try {
                                    n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/initial"));
                                    object14 = this.connectionPoolInitial;
                                    synchronized (object14) {
                                        this.connectionPoolInitial = n;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                object14 = null;
                                try {
                                    object14 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-manager/factory");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (object14 != null && !((String)object14).equals("")) {
                                    try {
                                        object13 = XSQLUtil.classForName((String)object14);
                                        object12 = (XSQLConnectionManagerFactory)((Class)object13).newInstance();
                                        if (this.defaultConnManagerFactory != null) {
                                            object11 = this.defaultConnManagerFactory;
                                            synchronized (object11) {
                                                this.defaultConnManagerFactory = object12;
                                                break block194;
                                            }
                                        }
                                        this.defaultConnManagerFactory = object12;
                                    }
                                    catch (InstantiationException instantiationException) {
                                        this.customFactoryLoadError((String)object14);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        this.customFactoryLoadError((String)object14);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        this.customFactoryLoadError((String)object14);
                                    }
                                    catch (ClassCastException classCastException) {
                                        this.customFactoryLoadError((String)object14);
                                    }
                                }
                            }
                            if (this.defaultConnManagerFactory == null) {
                                try {
                                    object13 = XSQLUtil.classForName(defaultConnManagerFactoryName);
                                    object12 = (XSQLConnectionManagerFactory)((Class)object13).newInstance();
                                    if (this.defaultConnManagerFactory != null) {
                                        object11 = this.defaultConnManagerFactory;
                                        synchronized (object11) {
                                            this.defaultConnManagerFactory = object12;
                                            break block195;
                                        }
                                    }
                                    this.defaultConnManagerFactory = object12;
                                }
                                catch (InstantiationException instantiationException) {
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.defaultConnManagerFactory == null) {
                            System.err.println("Fatal error. Cannot create connection manager factory: oracle.xml.xsql.XSQLConnectionManagerFactoryImpl");
                            throw new RuntimeException("Fatal error. Cannot create connection manager factory: oracle.xml.xsql.XSQLConnectionManagerFactoryImpl");
                        }
                        object13 = null;
                        try {
                            object13 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/error-handler/class");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (object13 != null && !((String)object13).equals("")) {
                            try {
                                object12 = XSQLUtil.classForName((String)object13);
                                object11 = (XSQLErrorHandler)((Class)object12).newInstance();
                                if (this.currentErrorHandler != null) {
                                    object10 = this.currentErrorHandler;
                                    synchronized (object10) {
                                        this.currentErrorHandler = object11;
                                        break block196;
                                    }
                                }
                                this.currentErrorHandler = object11;
                            }
                            catch (InstantiationException instantiationException) {
                                this.customErrorHandlerError((String)object13);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                this.customErrorHandlerError((String)object13);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                this.customErrorHandlerError((String)object13);
                            }
                            catch (ClassCastException classCastException) {
                                this.customErrorHandlerError((String)object13);
                            }
                        }
                    }
                    if (this.currentErrorHandler == null) {
                        try {
                            object12 = XSQLUtil.classForName(defaultErrorHandlerClassName);
                            object11 = (XSQLErrorHandler)((Class)object12).newInstance();
                            if (this.currentErrorHandler != null) {
                                object10 = this.currentErrorHandler;
                                synchronized (object10) {
                                    this.currentErrorHandler = object11;
                                    break block197;
                                }
                            }
                            this.currentErrorHandler = object11;
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                }
                if (this.currentErrorHandler == null) {
                    System.err.println("Fatal error. Cannot create error writer: oracle.xml.xsql.XSQLErrorHandlerImpl");
                    throw new RuntimeException("Fatal error. Cannot create error writer: oracle.xml.xsql.XSQLErrorHandlerImpl");
                }
                object12 = null;
                try {
                    object12 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/logger/factory");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object12 != null && !((String)object12).equals("")) {
                    try {
                        object11 = XSQLUtil.classForName((String)object12);
                        object10 = (XSQLLoggerFactory)((Class)object11).newInstance();
                        if (this.xsqlLoggerFactory != null) {
                            object9 = this.xsqlLoggerFactory;
                            synchronized (object9) {
                                this.xsqlLoggerFactory = object10;
                                break block198;
                            }
                        }
                        this.xsqlLoggerFactory = object10;
                    }
                    catch (InstantiationException instantiationException) {
                        this.customLoggerError((String)object12);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.customLoggerError((String)object12);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.customLoggerError((String)object12);
                    }
                    catch (ClassCastException classCastException) {
                        this.customLoggerError((String)object12);
                    }
                }
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/increment"));
                object11 = this.stylesheetPoolIncrement;
                synchronized (object11) {
                    this.connectionPoolIncrement = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/increment"));
                object11 = this.stylesheetPoolIncrement;
                synchronized (object11) {
                    this.connectionPoolIncrement = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/timeout-seconds"));
                object11 = this.connectionPoolTimeout;
                synchronized (object11) {
                    this.connectionPoolTimeout = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object11 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/dump-allowed");
            this.dumpPoolAllowed = ((String)object11).equalsIgnoreCase("yes");
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/default-fetch-size"));
                object10 = this.defaultRowPrefetch;
                synchronized (object10) {
                    this.defaultRowPrefetch = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/servlet/output-buffer-size"));
                object10 = this.outputBufferSize;
                synchronized (object10) {
                    this.outputBufferSize = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object10 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/timing-info/action");
            object9 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/timing-info/page");
            this.actionTiming = object10 != null && (((String)object10).equalsIgnoreCase("y") || ((String)object10).equalsIgnoreCase("yes"));
            this.pageTiming = object9 != null && (((String)object9).equalsIgnoreCase("y") || ((String)object9).equalsIgnoreCase("yes"));
            XMLNode xMLNode = (XMLNode)document;
            String string4 = XSQLUtil.valueOf(xMLNode, "/XSQLConfig/http/proxyhost");
            if (string4 != null && !xMLNode.equals((Object)"")) {
                object8 = XSQLUtil.valueOf(xMLNode, "/XSQLConfig/http/proxyport");
                if (((String)object8).equals("")) {
                    object8 = "80";
                }
                Properties properties2 = properties = System.getProperties();
                synchronized (properties2) {
                    properties.put("proxySet", TRUE);
                    properties.put("proxyHost", string4);
                    properties.put("proxyPort", object8);
                }
            }
            object8 = XSQLUtil.select(document, "/XSQLConfig/servlet/suppress-mime-charset/media-type");
            properties = new Hashtable(5);
            if (object8 != null && object8.getLength() > 0) {
                int n2 = object8.getLength();
                for (int i = 0; i < n2; ++i) {
                    object7 = (Element)object8.item(i);
                    object7.normalize();
                    string3 = object7.getFirstChild().getNodeValue();
                    ((Hashtable)properties).put(string3, string3);
                }
                hashtable2 = this.noCharsetMimeTypes;
                synchronized (hashtable2) {
                    this.noCharsetMimeTypes = properties;
                }
            }
            this.defaultAllowXSLOverride = !(string2 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/security/stylesheet/defaults/allow-client-style")).equalsIgnoreCase("no");
            object8 = XSQLUtil.select(document, "/XSQLConfig/processor/security/stylesheet/trusted-hosts/host");
            hashtable2 = new Hashtable<String, String>(5);
            object7 = null;
            string3 = null;
            try {
                object7 = InetAddress.getLocalHost();
                string3 = ((InetAddress)object7).getHostAddress();
                hashtable2.put(string3, "x");
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (object8 != null && object8.getLength() > 0) {
                int n3 = object8.getLength();
                for (int i = 0; i < n3; ++i) {
                    Element element = (Element)object8.item(i);
                    element.normalize();
                    object6 = element.getFirstChild().getNodeValue();
                    if (object6 == null) continue;
                    if (((String)object6).trim().equals("*")) {
                        this.allowAnyHost = true;
                        continue;
                    }
                    try {
                        object7 = InetAddress.getByName((String)object6);
                        string3 = ((InetAddress)object7).getHostAddress();
                        hashtable2.put(string3, "x");
                        continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                hashtable = this.xslTrustedHosts;
                synchronized (hashtable) {
                    this.xslTrustedHosts = hashtable2;
                }
            }
            NodeList nodeList2 = XSQLUtil.select(document, "/XSQLConfig/actiondefs/action");
            hashtable = new Hashtable<String, String>(10);
            if (nodeList2 != null && nodeList2.getLength() > 0) {
                int n4 = nodeList2.getLength();
                for (int i = 0; i < n4; ++i) {
                    object5 = (Element)nodeList2.item(i);
                    object4 = XSQLUtil.valueOf((Element)object5, "elementname");
                    object3 = XSQLUtil.valueOf((Element)object5, "handlerclass");
                    hashtable.put((String)object4, (String)object3);
                }
                object6 = this.userDefinedHandlers;
                synchronized (object6) {
                    this.userDefinedHandlers = hashtable;
                }
            }
            if ((node = XSQLUtil.selectFirst(document, "/XSQLConfig/processor/character-set-conversion")) != null) {
                object6 = XSQLUtil.valueOf(node, "default-charset");
                if (object6 != null && !((String)object6).equals("")) {
                    this.baseCharSet = object6;
                } else {
                    object5 = (XMLElement)node;
                    if (XSQLUtil.selectFirst(object5, "none") != null) {
                        this.baseCharSet = null;
                    }
                }
            }
            if ((node = XSQLUtil.selectFirst(document, "/XSQLConfig/processor/owa")) != null && (object6 = XSQLUtil.valueOf(node, "fetch-style")) != null && ((String)object6).equalsIgnoreCase(OWA_FETCHSTYLE_TABLE)) {
                object5 = this.defaultOWAFetchStyle;
                synchronized (object5) {
                    this.defaultOWAFetchStyle = OWA_FETCHSTYLE_TABLE;
                }
            }
            if ((node = XSQLUtil.selectFirst(document, "/XSQLConfig/processor/xml-parsing")) != null && (object6 = XSQLUtil.valueOf(node, "preserve-whitespace")) != null) {
                object5 = this.preserveWhitespace;
                synchronized (object5) {
                    this.preserveWhitespace = ((String)object6).equalsIgnoreCase(FALSE) ? Boolean.FALSE : Boolean.TRUE;
                }
            }
            nodeList2 = XSQLUtil.select(document, "/XSQLConfig/serializerdefs/serializer");
            hashtable = new Hashtable<String, String>(5);
            if (nodeList2 != null && nodeList2.getLength() > 0) {
                int n5 = nodeList2.getLength();
                for (int i = 0; i < n5; ++i) {
                    object4 = (Element)nodeList2.item(i);
                    object3 = XSQLUtil.valueOf((Element)object4, "name");
                    string = XSQLUtil.valueOf((Element)object4, "class");
                    hashtable.put((String)object3, string);
                }
                object5 = this.userDefinedSerializers;
                synchronized (object5) {
                    this.userDefinedSerializers = hashtable;
                }
            }
            if ((nodeList = XSQLUtil.select(document, "/XSQLConfig/connectiondefs/connection")) != null && nodeList.getLength() > 0) {
                int n6 = nodeList.getLength();
                for (int i = 0; i < n6; ++i) {
                    object3 = (Element)nodeList.item(i);
                    string = XSQLUtil.valueOf((Element)object3, "@name");
                    String string5 = XSQLUtil.valueOf((Element)object3, "driver");
                    String string6 = XSQLUtil.valueOf((Element)object3, "dburl");
                    String string7 = XSQLUtil.valueOf((Element)object3, "username");
                    String string8 = XSQLUtil.valueOf((Element)object3, "password");
                    String string9 = XSQLUtil.valueOf((Element)object3, "autocommit");
                    Boolean bl = null;
                    if (string9 != null) {
                        if (string9.equalsIgnoreCase(TRUE)) {
                            bl = Boolean.TRUE;
                        } else if (string9.equalsIgnoreCase(FALSE)) {
                            bl = Boolean.FALSE;
                        }
                    }
                    XSQLNamedConnection xSQLNamedConnection = new XSQLNamedConnection(string5, string6, string7, string8, bl);
                    ((Hashtable)object2).put(string, xSQLNamedConnection);
                }
            }
            Hashtable hashtable3 = this.namedConnections;
            synchronized (hashtable3) {
                this.namedConnections = object2;
            }
        }
    }

    private void customFactoryLoadError(String string) {
        System.err.println("Failed to create custom connection manager factory: " + string + ". Using default.");
    }

    private void customErrorHandlerError(String string) {
        System.err.println("Failed to create custom error writer: " + string + ". Using default.");
    }

    private void customLoggerError(String string) {
        System.err.println("Failed to create custom logger: " + string + ".");
    }

    private InputStream readConfigFileFromClassPath(String string) {
        if (string.startsWith("/")) {
            string = "/" + string;
        }
        Thread thread = Thread.currentThread();
        InputStream inputStream = null;
        try {
            Method method = thread.getClass().getMethod("getContextClassLoader", null);
            ClassLoader classLoader = (ClassLoader)method.invoke((Object)thread, null);
            inputStream = classLoader.getResourceAsStream(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream(string);
        }
        return inputStream;
    }
}

