/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Blob;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLProcessor;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLTokenManager;
import oracle.xml.binxml.BinXMLVocabularyManager;
import oracle.xml.binxml.BinXMLXDBSchemaEntityResolver;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.parser.v2.DTD;
import oracle.xml.scalable.PageManager;
import oracle.xml.scalable.PageManagerPool;
import oracle.xml.util.XMLError;
import org.xml.sax.EntityResolver;

public class BinXMLProcessorImpl
implements BinXMLProcessor {
    BinXMLMetadataProvider xdb;
    XMLError err = new XMLError();
    BinXMLVocabularyManager vocabManager = new BinXMLVocabularyManager();
    BinXMLTokenManager tokenManager;
    boolean debug = false;

    BinXMLProcessorImpl(BinXMLMetadataProvider binXMLMetadataProvider) {
        this.tokenManager = new BinXMLTokenManager(this);
        this.vocabManager.setMetadataProvider(binXMLMetadataProvider);
        this.tokenManager.setMetadataProvider(binXMLMetadataProvider);
        this.xdb = binXMLMetadataProvider;
        this.vocabManager.setXMLError(this.err);
        this.tokenManager.setXMLError(this.err);
        if (this.xdb instanceof DBBinXMLMetadataProviderImpl) {
            BinXMLXDBSchemaEntityResolver binXMLXDBSchemaEntityResolver = new BinXMLXDBSchemaEntityResolver();
            try {
                binXMLXDBSchemaEntityResolver.setMetaRepos((DBBinXMLMetadataProviderImpl)this.xdb);
            }
            catch (BinXMLException binXMLException) {
                // empty catch block
            }
            this.vocabManager.setEntityResolver(binXMLXDBSchemaEntityResolver);
            ((DBBinXMLMetadataProviderImpl)this.xdb).setXMLError(this.err);
        }
    }

    BinXMLProcessorImpl() {
        this.vocabManager.setXMLError(this.err);
        this.tokenManager = new BinXMLTokenManager(this);
        this.tokenManager.setXMLError(this.err);
    }

    XMLError getXMLError() {
        return this.err;
    }

    public void setDebugMode(boolean bl) {
        this.debug = bl;
        this.vocabManager.setDebugMode(bl);
    }

    boolean getDebugMode() {
        return this.debug;
    }

    public BinXMLStream createBinXMLStream(Blob blob) throws BinXMLException {
        BinXMLStreamImpl binXMLStreamImpl = new BinXMLStreamImpl(this);
        try {
            binXMLStreamImpl.setBlob(blob);
        }
        catch (IOException iOException) {
            throw new BinXMLException(iOException.getMessage());
        }
        return binXMLStreamImpl;
    }

    public BinXMLStream createBinXMLStream(InputStream inputStream) throws BinXMLException {
        BinXMLStreamImpl binXMLStreamImpl = new BinXMLStreamImpl(this);
        binXMLStreamImpl.setInputStream(inputStream);
        return binXMLStreamImpl;
    }

    public BinXMLStream createBinXMLStream(OutputStream outputStream) throws BinXMLException {
        BinXMLStreamImpl binXMLStreamImpl = new BinXMLStreamImpl(this);
        binXMLStreamImpl.setOutputStream(outputStream);
        return binXMLStreamImpl;
    }

    public BinXMLStream createBinXMLStream(File file) throws BinXMLException {
        BinXMLStreamImpl binXMLStreamImpl = new BinXMLStreamImpl(this);
        try {
            binXMLStreamImpl.setFile(file);
        }
        catch (IOException iOException) {
            throw new BinXMLException(iOException.getMessage());
        }
        return binXMLStreamImpl;
    }

    public BinXMLStream createBinXMLStream(byte[] byArray) throws BinXMLException {
        BinXMLStreamImpl binXMLStreamImpl = new BinXMLStreamImpl(this);
        binXMLStreamImpl.setByteArray(byArray);
        return binXMLStreamImpl;
    }

    public BinXMLStream createBinXMLStream(URL uRL) throws BinXMLException {
        BinXMLStreamImpl binXMLStreamImpl = new BinXMLStreamImpl(this);
        try {
            binXMLStreamImpl.setURL(uRL);
        }
        catch (IOException iOException) {
            throw new BinXMLException(iOException.getMessage());
        }
        return binXMLStreamImpl;
    }

    public BinXMLStream createBinXMLStream() throws BinXMLException {
        return new BinXMLStreamImpl(this);
    }

    public void setPageManagerPool(PageManagerPool pageManagerPool) throws BinXMLException {
    }

    public void setEntityResolver(EntityResolver entityResolver) throws BinXMLException {
        if (entityResolver instanceof BinXMLXDBSchemaEntityResolver && this.xdb instanceof DBBinXMLMetadataProviderImpl) {
            ((BinXMLXDBSchemaEntityResolver)entityResolver).setMetaRepos((DBBinXMLMetadataProviderImpl)this.xdb);
        }
        this.vocabManager.setEntityResolver(entityResolver);
    }

    public void saveSchema(URL uRL) throws BinXMLException {
        this.vocabManager.saveSchema(uRL);
    }

    public void registerSchema(URL uRL) throws BinXMLException {
        this.vocabManager.registerSchema(uRL);
    }

    public void registerSchema(String string, Reader reader) throws BinXMLException {
        this.vocabManager.registerSchema(string, reader, null);
    }

    public void registerSchema(URL uRL, Reader reader) throws BinXMLException {
        this.vocabManager.registerSchema(uRL, reader);
    }

    public void registerSchema(InputStream inputStream) throws BinXMLException {
    }

    public void registerDTD(URL uRL, String string) throws BinXMLException {
    }

    public void registerDTD(DTD dTD) throws BinXMLException {
    }

    public long getTokenId(String string, String string2, boolean bl) throws BinXMLException {
        return this.tokenManager.getTokenId(string, string2, bl);
    }

    public QName getTokenName(long l) throws BinXMLException {
        return this.tokenManager.getTokenName(l);
    }

    BinXMLVocabularyManager getVocabularyManager() {
        return this.vocabManager;
    }

    BinXMLTokenManager getTokenManager() {
        return this.tokenManager;
    }

    PageManager getPageManager() {
        return null;
    }

    byte[] getGUID() {
        return null;
    }

    public void setMetadataRepository(BinXMLMetadataProvider binXMLMetadataProvider) throws BinXMLException {
        this.vocabManager.setMetadataProvider(binXMLMetadataProvider);
        this.tokenManager.setMetadataProvider(binXMLMetadataProvider);
    }
}

