/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.comp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.Stack;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLStream;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.util.QxName;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CXMLParser
implements CXMLConstants {
    ContentHandler contentHandler;
    ErrorHandler errorHandler;
    Stack qnames = new Stack();

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String string) throws IOException, SAXException {
        BufferedInputStream bufferedInputStream = null;
        BinaryStream binaryStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            binaryStream = new CXMLStream();
            binaryStream.setObjectInput(new ObjectInputStream(bufferedInputStream));
            this.parse(((CXMLStream)binaryStream).getInfosetReader());
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (binaryStream != null) {
                binaryStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ObjectInput objectInput) throws IOException, SAXException {
        CXMLStream cXMLStream = null;
        try {
            cXMLStream = new CXMLStream();
            cXMLStream.setObjectInput(objectInput);
            this.parse(cXMLStream.getInfosetReader());
        }
        finally {
            if (cXMLStream != null) {
                cXMLStream.close();
            }
        }
    }

    void parse(InfosetReader infosetReader) throws IOException, SAXException {
        block13: while (infosetReader.hasNext()) {
            infosetReader.next();
            switch (infosetReader.getEventType()) {
                case 7: {
                    this.contentHandler.startDocument();
                    continue block13;
                }
                case 1: {
                    QxName qxName = (QxName)infosetReader.getQName();
                    this.qnames.push(qxName);
                    this.contentHandler.startElement(qxName.getNamespaceURI(), qxName.getLocalPart(), qxName.getQName(), infosetReader.getAttributes());
                    continue block13;
                }
                case 4: 
                case 12: {
                    this.contentHandler.characters(infosetReader.getData(), infosetReader.getDataStart(), infosetReader.getDataLength());
                    continue block13;
                }
                case 6: {
                    this.contentHandler.ignorableWhitespace(infosetReader.getData(), infosetReader.getDataStart(), infosetReader.getDataLength());
                    continue block13;
                }
                case 11: {
                    continue block13;
                }
                case 3: {
                    QxName qxName = (QxName)infosetReader.getQName();
                    String string = infosetReader.getValue();
                    this.contentHandler.processingInstruction(qxName.getLocalPart(), string);
                    continue block13;
                }
                case 5: {
                    continue block13;
                }
                case 2: {
                    QxName qxName = (QxName)this.qnames.pop();
                    if (qxName == null) continue block13;
                    this.contentHandler.endElement(qxName.getNamespaceURI(), qxName.getLocalPart(), qxName.getQName());
                    continue block13;
                }
                case 8: {
                    this.contentHandler.endDocument();
                    continue block13;
                }
                case 14: {
                    this.qnames.push(null);
                    continue block13;
                }
                case 9: 
                case 15: {
                    continue block13;
                }
            }
            throw new SAXException("Error parsing stream " + infosetReader.getEventType());
        }
    }
}

