/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.SchemaResolver;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDIdConstraintTable;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLMultiHandler;
import oracle.xml.util.FastVector;
import oracle.xml.util.QxNameHash;
import oracle.xml.util.XMLProperties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XSDValidator
extends XMLMultiHandler
implements XSDConstantValues {
    private String charAll;
    private Hashtable idConstraints;
    private HashMap idTable;
    private Locator locator;
    private ContentHandler cntHandler;
    private SAXAttrList saxAttrList;
    private XMLError err;
    private String lastNodeName;
    private XMLProperties xmlProp;
    private XSDNode rootNode;
    private QName rootElement;
    private QName rootType;
    private String nilVal;
    private boolean fixedSchema;
    private boolean isJAXP;
    private String slocation;
    private String nnslocation;
    private boolean deep;
    private XMLSchema schema;
    private XSDBuilder xsdBuilder;
    private URL baseUrl;
    private NSResolver nsResolver;
    private EntityResolver entResolver;
    private SchemaResolver schemaResolver;
    private State[] st = new State[this.stateMax];
    private int curState;
    private State state;
    private int stateMax = 50;
    private XSDElement elementNode;
    private Vector nsDecl;
    private int nslen;
    private int elementDepth = -1;
    private XSDElement parentNode;
    private int lastEvent;
    private QName keyName;
    private QName anyName;
    private XSDDataValue dataValue;
    private String lexicalValue;
    private XSDGroup simpleTypeGroup;
    private XSDAttrGroup attrGroup;
    private XSDAttribute[] attrDefs;
    private ArrayList attrDecls;
    private String xsiNS;
    private DocumentBuilder docBuilder;
    private boolean internalDOM;
    private int buildNode;
    static final int STAG = 1;
    static final int ETAG = 2;
    static final int CHARS = 3;
    static final String _error = "error";

    public XSDValidator() throws XSDException {
        for (int i = 0; i < this.stateMax; ++i) {
            this.st[i] = new State();
        }
        this.anyName = XSDAny.ANY_NAME;
        this.keyName = null;
        this.dataValue = new XSDDataValue();
        this.curState = 0;
        this.state = this.st[this.curState];
        this.nsDecl = new Vector(10);
        this.attrDefs = new XSDAttribute[20];
        this.attrDecls = new ArrayList(10);
        this.nslen = -1;
        this.nilVal = null;
        this.parentNode = null;
        XSDAny xSDAny = new XSDAny();
        xSDAny.processContents = "strict";
        xSDAny.namespace = "##any";
        xSDAny.maxOccurs = 0x7FFFFFF8;
        this.state.set(xSDAny, null);
        this.state.length = 1;
        this.state.status = 18;
        this.simpleTypeGroup = new XSDGroup();
        this.simpleTypeGroup.order = 0;
        this.simpleTypeGroup.minOccurs = 1;
        this.simpleTypeGroup.maxOccurs = 1;
        this.simpleTypeGroup.addParticleNode(new XSDSimpleType());
        this.simpleTypeGroup.pathTable = new HashMap();
        this.buildNode = -1;
        this.docBuilder = null;
        this.internalDOM = false;
        this.err = new XMLError();
        this.saxAttrList = new SAXAttrList(4);
        this.deep = true;
    }

    public void reset() {
        this.curState = 0;
        this.nslen = -1;
        this.nilVal = null;
        this.state = this.st[this.curState];
        this.state.status = 18;
        this.parentNode = null;
        this.slocation = null;
        this.nnslocation = null;
        if (this.idConstraints != null) {
            this.idConstraints.clear();
        }
        if (this.idTable != null) {
            this.idTable.clear();
        }
        if (!this.fixedSchema) {
            this.schema = null;
            this.xsdBuilder = null;
            this.elementDepth = -1;
        } else {
            this.elementDepth = 0;
        }
    }

    public void setError(XMLError xMLError) throws SAXException {
        this.err = xMLError;
    }

    public void setXMLProperties(XMLProperties xMLProperties) {
        this.xmlProp = xMLProperties;
    }

    public void setXMLSchema(XMLSchema xMLSchema) throws SAXException {
        this.setXMLSchema(xMLSchema, true);
    }

    private void setXMLSchema(XMLSchema xMLSchema, boolean bl) throws SAXException {
        this.schema = xMLSchema;
        if (!this.schema.isPathTableBuilt()) {
            try {
                this.schema.buildSchemaPathTable();
            }
            catch (Exception exception) {
                this.error(24000, "build schema path tables", false);
            }
        }
        if (this.elementDepth < 0) {
            this.elementDepth = 0;
        }
        this.fixedSchema = bl;
        this.xsiNS = "http://www.w3.org/2001/XMLSchema-instance";
    }

    public Object setXMLProperty(String string, Object object) {
        try {
            if (string.equals("validationMode")) {
                String string2 = ((String)object).intern();
                if (string2 == "ORACLE_XSD_LaxValidation") {
                    return this.setMode("lax", false) ? object : null;
                }
                if (string2 == "ORACLE_XSD_StrictValidation") {
                    return this.setMode("strict", false) ? object : null;
                }
                if (string2 == "ORACLE_XSD_AutoValidation" && !this.fixedSchema) {
                    return this.setMode("strict", true) ? object : null;
                }
                return null;
            }
            if (string.equals("fixedSchema")) {
                this.setXMLSchema((XMLSchema)object, true);
            } else if (string.equals("baseURL")) {
                this.baseUrl = (URL)object;
            } else if (string.equals("nsResolver")) {
                this.nsResolver = (NSResolver)object;
            } else if (string.equals("entityResolver")) {
                this.entResolver = (EntityResolver)object;
                if (this.xsdBuilder != null) {
                    this.xsdBuilder.setEntityResolver(this.entResolver);
                }
            } else if (string.equals("Schema Resolver")) {
                this.schemaResolver = (SchemaResolver)object;
            } else if (string.equals("ORACLE_XSD_DeepValidation")) {
                this.deep = object == Boolean.TRUE;
            } else if (string.equals("ORACLE_XSD_Root_Node")) {
                if (object == null) {
                    this.rootNode = null;
                } else {
                    if (!(object instanceof XSDElement || object instanceof XSDComplexType || object instanceof XSDSimpleType)) {
                        return null;
                    }
                    if (!this.fixedSchema) {
                        this.setXMLSchema(((XSDNode)object).getOwnerSchema(), true);
                    } else if (this.schema != ((XSDNode)object).getOwnerSchema() || this.rootElement != null || this.rootType != null) {
                        return null;
                    }
                    this.rootNode = (XSDNode)object;
                }
            } else if (string.equals("ORACLE_XSD_Root_Element")) {
                if (object == null) {
                    this.rootElement = null;
                } else {
                    if (!(object instanceof QName) || this.rootNode != null) {
                        return null;
                    }
                    this.rootElement = (QName)object;
                }
            } else if (string.equals("ORACLE_XSD_Root_Type")) {
                if (object == null) {
                    this.rootType = null;
                } else {
                    if (!(object instanceof QName) || this.rootNode != null) {
                        return null;
                    }
                    this.rootType = (QName)object;
                }
            } else {
                return null;
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public XMLSchema getXMLSchema() {
        return this.schema;
    }

    public void setJAXP(boolean bl) {
        this.isJAXP = bl;
        if (this.xsdBuilder != null) {
            this.xsdBuilder.setJAXP(bl);
        }
    }

    private boolean setMode(String string, boolean bl) {
        if (this.curState != 0) {
            return false;
        }
        XSDNode xSDNode = this.state.curItem();
        if (!(xSDNode instanceof XSDAny)) {
            return false;
        }
        ((XSDAny)xSDNode).processContents = string;
        this.elementDepth = bl ? -1 : 0;
        return true;
    }

    public String getCurrentMode() {
        if (this.curState == 0) {
            return "lax";
        }
        return this.state.getCurrentMode();
    }

    public XSDNode getTypeDefinition() {
        return this.state.getTypeNode();
    }

    public XSDElement getElementDeclaration() {
        return this.state.getElementNode();
    }

    public XSDElement getParentDeclaration() {
        if (this.curState == 0) {
            return null;
        }
        return this.parentNode;
    }

    public boolean elementNilled() {
        return this.nilVal == "true";
    }

    public ArrayList getAttrTypes() {
        return this.attrDecls;
    }

    public void startDocument() throws SAXException {
        this.reset();
        super.startDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        String string5;
        SAXAttrList sAXAttrList = XMLContentHandler.createSAXAttrList(attributes, this.saxAttrList);
        if (this.nilVal == "true" && this.elementDepth >= 0) {
            this.error(24062, string2, false);
        } else {
            this.nilVal = null;
        }
        if (this.state.fixedVal != null || this.state.defaultVal != null) {
            this.error(24534, string2, false);
        }
        String string6 = null;
        int n = sAXAttrList.getLength();
        HashMap hashMap = null;
        ++this.nslen;
        if (this.nslen < this.nsDecl.size()) {
            hashMap = (HashMap)this.nsDecl.elementAt(this.nslen);
            hashMap.clear();
        } else {
            hashMap = new HashMap(5);
            this.nsDecl.addElement(hashMap);
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string7 = sAXAttrList.getPrefix(i);
                string5 = sAXAttrList.getLocalName(i);
                String string8 = sAXAttrList.getValue(i).intern();
                string4 = sAXAttrList.getURI(i);
                if (this.equals(string5, "xmlns")) {
                    hashMap.put("", string8);
                    continue;
                }
                if (this.equals(string7, "xmlns")) {
                    hashMap.put(string5, string8);
                    continue;
                }
                if (!this.equals(string4, "http://www.w3.org/2001/XMLSchema-instance")) continue;
                if (this.equals(string5, "nil")) {
                    this.nilVal = string8.trim().intern();
                    continue;
                }
                if (this.equals(string5, "type")) {
                    string6 = string8;
                    continue;
                }
                if (this.equals(string5, "schemaLocation")) {
                    if (!this.fixedSchema) {
                        this.processSchemaLocation(string8, false);
                        continue;
                    }
                    this.slocation = string8;
                    continue;
                }
                if (this.equals(string5, "noNamespaceSchemaLocation")) {
                    if (!this.fixedSchema) {
                        this.processSchemaLocation(string8, true);
                        continue;
                    }
                    this.nnslocation = string8;
                    continue;
                }
                this.error(24535, string7 + ":" + string5, false);
            }
        }
        if (this.elementDepth == -1) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        ++this.elementDepth;
        string4 = string;
        string5 = string2;
        this.lastNodeName = string2;
        if (this.isJAXP && this.curState == 0 && this.fixedSchema && this.schema.getElement(string4, string5) == null) {
            if (this.slocation != null) {
                this.processSchemaLocation(this.slocation, false);
            }
            if (this.nnslocation != null) {
                this.processSchemaLocation(this.nnslocation, true);
            }
        }
        this.sTag(string5, string4, string6, 24534);
        if (!(this.state.isFake() || n <= 0 && this.attrGroup == null)) {
            this.validateAttribute(sAXAttrList);
        }
        super.startElement(string, string2, string3, attributes);
        if (this.buildNode > 0) {
            this.docBuilder.startElement(string, string2, string3, attributes);
        }
        if (this.elementNode != null && this.elementNode.identities != null) {
            if (this.docBuilder == null) {
                this.docBuilder = new DocumentBuilder();
                this.docBuilder.setDocumentLocator(this.locator);
                this.docBuilder.startDocument();
                this.docBuilder.startElement("", "root", "root", attributes);
                this.internalDOM = true;
                this.buildNode = this.curState;
                this.docBuilder.startElement(string, string2, string3, attributes);
            } else if (this.internalDOM && this.buildNode < 0) {
                this.buildNode = this.curState;
                this.docBuilder.startElement(string, string2, string3, attributes);
            }
            XMLElement xMLElement = (XMLElement)this.docBuilder.getCurrentNode();
            this.addIdentityConstraint(xMLElement);
            this.elementNode = null;
        }
        this.lastEvent = 1;
    }

    private void validateAttribute(SAXAttrList sAXAttrList) {
        XSDAttribute xSDAttribute;
        String string;
        String string2;
        String string3;
        int n;
        XSDSimpleType xSDSimpleType = null;
        XSDAny xSDAny = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = sAXAttrList.getLength();
        this.attrDecls.clear();
        if (this.attrGroup != null) {
            this.attrDefs = this.attrGroup.copyAttrDefs(this.attrDefs);
            xSDAny = this.attrGroup.getWildcard();
            n3 = this.attrGroup.getVectorSize();
        }
        for (n = 0; n < n4; ++n) {
            string3 = sAXAttrList.getPrefix(n);
            string2 = sAXAttrList.getLocalName(n);
            String string4 = sAXAttrList.getValue(n);
            string = sAXAttrList.getURI(n);
            if (this.equals(string2, "xmlns") || this.equals(string3, "xmlns") || this.equals(string, "http://www.w3.org/2001/XMLSchema-instance")) {
                this.attrDecls.add(null);
                continue;
            }
            xSDAttribute = null;
            for (int i = n2; i < n3; ++i) {
                if (!this.attrDefs[i].getTargetNS().equals(string) || !this.equals(this.attrDefs[i].getName(), string2)) continue;
                xSDAttribute = this.attrDefs[i];
                this.attrDefs[i] = this.attrDefs[n2];
                this.attrDefs[n2++] = xSDAttribute;
                break;
            }
            if (xSDAttribute == null && xSDAny != null && xSDAny.isMatched(string)) {
                XSDNode xSDNode = xSDAny.getMatchingAttr(this.schema, string, string2);
                if (xSDNode == null) {
                    this.attrDecls.add(null);
                    this.error(24538, string == "" ? string2 : string + ":" + string2, false);
                    continue;
                }
                if (xSDNode == FAKE_NODE) {
                    this.attrDecls.add(null);
                    continue;
                }
                xSDAttribute = (XSDAttribute)xSDNode;
            }
            this.attrDecls.add(xSDAttribute);
            if (xSDAttribute == null) {
                this.error(24535, string == "" ? string2 : string + ":" + string2, false);
                continue;
            }
            xSDSimpleType = (XSDSimpleType)xSDAttribute.getType();
            if (xSDSimpleType == null) {
                this.attrDecls.set(n, null);
                this.error2(24523, string4, string == "" ? string2 : string + ":" + string2);
                continue;
            }
            if (xSDAttribute.fixedVal != null && !xSDAttribute.fixedVal.equals(xSDSimpleType.getCanonicalForm(string4))) {
                this.error2(24533, string4, xSDAttribute.fixedVal);
            }
            try {
                xSDSimpleType = xSDSimpleType.validateValue(string4, this);
            }
            catch (XSDException xSDException) {
                if (xSDException.getErrorId() == 24000) {
                    this.error2(24000, xSDException.getErrorPara1(), string4);
                }
                this.error2(24523, string4, string == "" ? string2 : string + ":" + string2);
            }
            catch (Exception exception) {
                this.error2(24523, string4, string == "" ? string2 : string + ":" + string2);
            }
            this.attrDecls.set(n, xSDSimpleType);
        }
        for (n = n2; n < n3; ++n) {
            xSDAttribute = this.attrDefs[n];
            string = xSDAttribute.getTargetNS();
            String string5 = xSDAttribute.getName();
            string3 = this.getDeclaredPrefix(string);
            String string6 = string2 = string3.equals("") ? string5 : string3 + ":" + string5;
            if (xSDAttribute.isRequired()) {
                this.error(24536, string == "" ? string5 : string + ":" + string5, false);
                continue;
            }
            if (xSDAttribute.defaultVal != null) {
                this.attrDecls.add(xSDAttribute.getType());
                sAXAttrList.addAttr(string3, string5, string2, xSDAttribute.defaultVal, false, 0, string);
                continue;
            }
            if (xSDAttribute.fixedVal == null) continue;
            this.attrDecls.add(xSDAttribute.getType());
            sAXAttrList.addAttr(string3, string5, string2, xSDAttribute.fixedVal, false, 0, string);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.elementDepth == -1) {
            this.nilVal = null;
            --this.nslen;
            super.endElement(string, string2, string3);
            return;
        }
        if (this.lastEvent == 3) {
            this.chars(this.charAll);
        } else {
            this.chars(null);
        }
        this.eTag(string2);
        this.nilVal = null;
        --this.nslen;
        super.endElement(string, string2, string3);
        if (this.buildNode > 0) {
            this.docBuilder.endElement(string, string2, string3);
        }
        if (this.curState < this.buildNode) {
            this.buildNode = -1;
        }
        --this.elementDepth;
        if (this.elementDepth == 0) {
            try {
                this.validateIDConstraint();
            }
            catch (XSDException xSDException) {
                this.error(24506, xSDException.getMessage(), false);
            }
            this.elementDepth = -1;
        }
        this.lastEvent = 2;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.elementDepth == -1) {
            super.characters(cArray, n, n2);
            return;
        }
        String string = new String(cArray, n, n2);
        if (string.length() > 0) {
            this.collectChars(string);
            this.lastEvent = 3;
        }
        super.characters(cArray, n, n2);
    }

    private void collectChars(String string) {
        this.charAll = this.lastEvent != 3 ? string : this.charAll + string;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    void processSchemaLocation(String string, boolean bl) throws SAXException {
        int n = string.length();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        String string2 = null;
        if (this.xsdBuilder == null) {
            try {
                this.xsdBuilder = new XSDBuilder();
                this.xsdBuilder.setJAXP(this.isJAXP);
                if (this.entResolver != null) {
                    this.xsdBuilder.setEntityResolver(this.entResolver);
                }
            }
            catch (Exception exception) {
                this.xsdBuilder = null;
                this.error(24101, string, false);
                return;
            }
        }
        while (n2 < n) {
            Object object;
            String string3;
            while (n2 < n && cArray[n2] == ' ') {
                ++n2;
            }
            if (n2 >= n) break;
            String string4 = "";
            int n3 = n2;
            if (!bl) {
                while (n2 < n && cArray[n2] != ' ') {
                    ++n2;
                }
                if (n2 >= n) break;
                string4 = new String(cArray, n3, n2 - n3);
                while (n2 < n && cArray[n2] == ' ') {
                    ++n2;
                }
                if (n2 >= n) break;
            }
            n3 = n2;
            while (n2 < n && cArray[n2] != ' ') {
                ++n2;
            }
            string2 = string3 = new String(cArray, n3, n2 - n3);
            try {
                object = this.baseUrl != null ? new URL(this.baseUrl, string3) : new URL(string3);
                string2 = ((URL)object).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            try {
                Object object2;
                object = null;
                if (string3.startsWith("#")) {
                    object2 = null;
                    DocumentBuilder documentBuilder = this.getDocumentBuilder();
                    if (documentBuilder != null) {
                        object2 = documentBuilder.getDocument();
                    }
                    if (object2 != null) {
                        object = this.xsdBuilder.build((XMLDocument)object2, string3, string4, this.baseUrl);
                    } else {
                        this.err.error2(24101, 1, string4, string3);
                    }
                } else if (this.entResolver != null) {
                    object2 = null;
                    if (this.isJAXP) {
                        object2 = this.entResolver.resolveEntity(null, string2);
                    } else {
                        object2 = this.entResolver.resolveEntity(null, string3);
                        if (object2 == null && !string3.equals(string2)) {
                            object2 = this.entResolver.resolveEntity(null, string2);
                        }
                    }
                    if (object2 != null) {
                        object = this.xsdBuilder.build((InputSource)object2);
                    }
                }
                if (object == null) {
                    object = this.xsdBuilder.build(string4, new URL(string2));
                }
                if (object == null) continue;
                this.setXMLSchema((XMLSchema)object, false);
            }
            catch (Exception exception) {
                try {
                    this.err.setException(exception);
                    this.err.error2(24500, 1, string4, string3);
                }
                catch (Exception exception2) {}
            }
        }
    }

    DocumentBuilder getDocumentBuilder() {
        if (this.xmlProp != null) {
            String string = "oracle.xml.parser.DocumentBuilder";
            DocumentBuilder documentBuilder = (DocumentBuilder)this.xmlProp.getXMLProperty(string);
            return documentBuilder;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void sTag(String string, String string2, String string3, int n) {
        void var6_9;
        XSDNode xSDNode;
        XSDNode xSDNode2;
        block28: {
            Object var6_5 = null;
            if (this.state.isFake()) {
                if (this.equals(this.state.tag, "lax")) {
                    XSDNode xSDNode3;
                    XSDElement xSDElement = this.schema.getElement(string2, string);
                    if (xSDElement != null) {
                        this.pushState(xSDElement, string, string3);
                        return;
                    }
                    if (string3 != null && (xSDNode3 = this.getXsiType(string3)) != null) {
                        this.pushState(xSDNode3, string, null);
                        return;
                    }
                }
                this.pushState(FAKE_NODE, this.state.tag, null);
                return;
            }
            if (this.state.isDone()) {
                this.error(n, string, false);
                this.pushState(FAKE_NODE, _error, null);
                return;
            }
            if (this.state.pathTable == null) {
                if (this.curState != 0) {
                    this.error(n, string, false);
                    this.pushState(FAKE_NODE, _error, null);
                    return;
                }
                xSDNode2 = this.state.curItem();
            } else {
                this.keyName = QxNameHash.create(string2, string, "", string);
                while (true) {
                    int n2;
                    int[] nArray;
                    if ((nArray = (int[])this.state.pathTable.get(this.keyName)) == null) {
                        int[] nArray2 = (int[])this.state.pathTable.get(this.anyName);
                        n2 = this.state.eligible(nArray2, string2);
                    } else {
                        n2 = this.state.eligible(nArray, null);
                    }
                    if (n2 > -1) {
                        int n3;
                        while ((xSDNode2 = this.state.getItem(n3 = this.state.getBranch(n2))).isNodeType(5)) {
                            this.pushGroup((XSDGroup)xSDNode2, this.state.getOffset(n3));
                        }
                        break block28;
                    }
                    if (this.curState <= 1 || !this.state.isNestedGroup() || !this.state.isAccepted()) break;
                    this.state = this.popState(false);
                }
                this.error(n, string, false);
                this.pushState(FAKE_NODE, _error, null);
                return;
            }
        }
        if (this.curState == 0) {
            if (this.rootElement != null) {
                void var7_17;
                String string4 = this.rootElement.getNamespaceURI();
                String string5 = this.rootElement.getLocalPart();
                if (string4 == null) {
                    String string6 = "";
                }
                if ((xSDNode2 = this.schema.getElement((String)var7_17, string5)) == null) {
                    this.error(24002, string5, false);
                    this.pushState(FAKE_NODE, _error, null);
                    return;
                }
            } else if (this.rootType != null) {
                void var7_20;
                String string7 = this.rootType.getNamespaceURI();
                String string8 = this.rootType.getLocalPart();
                if (string7 == null) {
                    String string9 = "";
                }
                if ((xSDNode2 = this.schema.getType((String)var7_20, string8)) == null) {
                    this.error(24538, string8, false);
                    this.pushState(FAKE_NODE, _error, null);
                    return;
                }
            } else if (this.rootNode != null) {
                xSDNode2 = this.rootNode;
            }
        }
        if ((xSDNode = xSDNode2.getMatchingNode(this.schema, string2, string)) == null && this.curState == 0 && string3 != null) {
            XSDNode xSDNode4 = this.getXsiType(string3);
        }
        if (var6_9 == null) {
            if (xSDNode2 instanceof XSDAny) {
                this.error(24538, string, false);
            } else {
                this.error(n, string, false);
            }
            this.pushState(FAKE_NODE, _error, null);
            return;
        }
        if (var6_9 == FAKE_NODE) {
            string = ((XSDAny)xSDNode2).processContents;
        }
        this.pushState((XSDNode)var6_9, string, string3);
    }

    private void chars(String string) throws SAXException {
        this.lexicalValue = null;
        if (string != null && this.nilVal == "true") {
            this.error(24062, this.lastNodeName, false);
        }
        if (string == null) {
            if (this.nilVal == "true") {
                this.state.status = 20;
                return;
            }
            if (this.state.defaultVal != null) {
                string = this.state.defaultVal;
            } else if (this.state.fixedVal != null) {
                string = this.state.fixedVal;
            }
            if (string != null) {
                super.characters(string.toCharArray(), 0, string.length());
            } else {
                string = "";
            }
        }
        if (this.state.isFake()) {
            return;
        }
        if (this.state.content == 13) {
            if (this.state.fixedVal != null && !this.state.fixedVal.equals(string)) {
                this.error2(24533, string, this.state.fixedVal);
            }
            return;
        }
        if (this.state.content == 11 && this.state.status != 20) {
            XSDSimpleType xSDSimpleType;
            if (this.state.fixedVal != null && !this.state.fixedVal.equals(string)) {
                this.error2(24533, string, this.state.fixedVal);
            }
            if ((xSDSimpleType = (XSDSimpleType)this.state.getSimpleType()) == null) {
                this.error2(24525, string, this.lastNodeName);
            }
            try {
                xSDSimpleType.validateValue(string, this);
                this.lexicalValue = xSDSimpleType.processWS(string);
                string = xSDSimpleType.getCanonicalForm(string);
            }
            catch (XSDException xSDException) {
                if (xSDException.getErrorId() == 24000) {
                    this.error2(24000, xSDException.getErrorPara1(), this.lastNodeName);
                }
                this.error2(24525, string, this.lastNodeName);
            }
            catch (Exception exception) {
                this.error2(24525, string, this.lastNodeName);
            }
        } else {
            if (string == null || string.trim().equals("")) {
                return;
            }
            this.error2(24525, string, this.lastNodeName);
        }
        if (this.buildNode > 0) {
            this.docBuilder.characters(string.toCharArray(), 0, string.length());
        }
        this.state.status = 20;
    }

    private void eTag(String string) {
        String string2;
        if (this.state.isFake()) {
            this.state = this.equals(this.state.tag, _error) ? this.pop() : this.popState(false);
            return;
        }
        boolean bl = false;
        do {
            string2 = this.state.tag;
            boolean bl2 = bl = bl || !this.state.isAccepted();
            if (bl && this.equals(string2, string)) {
                this.state.status = 19;
            } else if (string2 != null && !this.equals(string2, string)) {
                bl = true;
                break;
            }
            this.state = this.popState(false);
        } while (!this.equals(string2, string));
        while (this.state.isNestedGroup() && this.state.isDone()) {
            this.state = this.popState(false);
        }
        if (bl) {
            this.error(24521, string, true);
        }
    }

    private State popState(boolean bl) {
        while (this.curState >= 0) {
            boolean bl2 = this.state.isAccepted();
            this.state = this.pop();
            if (bl2) {
                int n = this.state.cur;
                this.state.numOccur[n] = this.state.numOccur[n] + 1;
            }
            this.state.setStatus();
            if (this.state.isDone() && this.state.isNestedGroup()) continue;
            break;
        }
        return this.state;
    }

    private XSDNode getXsiType(String string) {
        string = string.trim();
        String string2 = this.getPrefix(string);
        String string3 = this.resolve(string2);
        String string4 = this.getName(string);
        return this.schema.getType(string3, string4);
    }

    private void pushGroup(XSDGroup xSDGroup, int n) {
        State state = this.state;
        this.state = this.push();
        this.state.elemNode = state.elemNode;
        this.state.typeNode = state.typeNode;
        this.state.set(xSDGroup, null, state.content);
        this.state.nullable = false;
        this.state.fixedVal = null;
        this.state.defaultVal = null;
        this.state.basePosition = state.basePosition + n;
        this.state.pathTable = state.pathTable;
        this.state.level = state.level + 1;
        this.state.viLevel = state.viLevel;
        this.state.elemList = state.elemList;
    }

    private boolean pushState(XSDNode xSDNode, String string, String string2) {
        XSDNode xSDNode2;
        int n = 21;
        this.attrGroup = null;
        this.parentNode = this.curState == 0 ? null : this.state.elemNode;
        this.state = this.push();
        this.state.elemNode = null;
        if (xSDNode == FAKE_NODE || !this.deep && this.curState > 1) {
            this.state.typeNode = null;
            this.state.set(FAKE_NODE, string);
            return true;
        }
        if (xSDNode.nodeType == 3) {
            this.elementNode = (XSDElement)xSDNode;
            if (this.elementNode.isAbstract()) {
                this.error(24060, string, false);
            }
            this.state.elemNode = this.elementNode;
            BitSet bitSet = (BitSet)xSDNode.getProperties().clone();
            this.state.nullable = this.elementNode.isNillable();
            this.state.fixedVal = this.elementNode.fixedVal;
            this.state.defaultVal = this.elementNode.defaultVal;
            xSDNode = this.elementNode.getType();
            bitSet.or(xSDNode.getProperties());
            if (this.nilVal != null && !this.state.nullable) {
                this.error(24061, string, false);
            }
            if (string2 != null) {
                xSDNode2 = this.getXsiType(string2);
                if (xSDNode2 == null) {
                    this.error(24065, string2, false);
                } else if (!xSDNode2.isSubstitutableFor(xSDNode, bitSet.get(2), bitSet.get(1))) {
                    this.error2(24540, string2, xSDNode.getName());
                } else {
                    xSDNode = xSDNode2;
                }
            }
        }
        if (xSDNode.isNodeType(1)) {
            this.state.typeNode = xSDNode;
            xSDNode2 = (XSDComplexType)xSDNode;
            if (((XSDComplexType)xSDNode2).isAbstract()) {
                this.error(24011, string, false);
            }
            n = ((XSDComplexType)xSDNode2).content;
            this.attrGroup = ((XSDComplexType)xSDNode2).getAttrGroup();
            xSDNode = ((XSDComplexType)xSDNode2).getGroup();
        } else if (xSDNode.isNodeType(2)) {
            this.state.typeNode = xSDNode;
            if (((XSDSimpleType)xSDNode).isAbstract()) {
                this.error(24011, string, false);
            }
            n = 11;
            this.simpleTypeGroup.setParticleNode((XSDParticleNode)((Object)xSDNode), 0);
            xSDNode = this.simpleTypeGroup;
        }
        this.state.set((XSDGroup)xSDNode, string, n);
        return true;
    }

    private State pop() {
        return this.st[--this.curState];
    }

    private State push() {
        if (++this.curState == this.stateMax) {
            State[] stateArray = this.st;
            this.stateMax *= 2;
            this.st = new State[this.stateMax];
            System.arraycopy(stateArray, 0, this.st, 0, this.curState);
            for (int i = this.curState; i < this.stateMax; ++i) {
                this.st[i] = new State();
            }
        }
        this.state = this.st[this.curState];
        this.state.fixedVal = null;
        this.state.defaultVal = null;
        this.state.nullable = false;
        return this.state;
    }

    void checkQName(String string, XSDDataValue xSDDataValue) {
        String string2 = this.getPrefix(string);
        String string3 = this.getName(string);
        String string4 = this.resolve(string2);
        xSDDataValue.setQNameValue(string, string4, string3);
    }

    void checkID(String string) {
        if (this.idTable == null) {
            this.idTable = new HashMap();
        }
        if (this.idTable.get(string) == null) {
            this.idTable.put(string, string);
        } else {
            this.error(24071, string, false);
        }
    }

    void addIDRef(String string) {
        if (this.idTable == null) {
            this.idTable = new HashMap();
        }
        if (!this.idTable.containsKey(string)) {
            this.idTable.put(string, null);
        }
    }

    private String getPrefix(String string) {
        int n = string.length();
        int n2 = string.lastIndexOf(58);
        if (n2 < 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    private String getName(String string) {
        int n = string.length();
        int n2 = string.lastIndexOf(58);
        if (n2 < 0) {
            return string;
        }
        return string.substring(n2 + 1, n);
    }

    String getDeclaredPrefix(String string) {
        HashMap hashMap;
        int n;
        if (string == null || string.equals("")) {
            return "";
        }
        String string22 = null;
        for (n = this.nslen; n >= 0; --n) {
            hashMap = (HashMap)this.nsDecl.elementAt(n);
            if (!hashMap.containsKey(string)) continue;
            for (String string22 : hashMap.keySet()) {
                if (!string.equals(hashMap.get(string22))) continue;
                return string22;
            }
        }
        n = 0;
        while (true) {
            Object object = null;
            string22 = "ns" + String.valueOf(n);
            for (int i = this.nslen; i >= 0 && (object = (String)(hashMap = (HashMap)this.nsDecl.elementAt(i)).get(string22)) == null; --i) {
            }
            if (object == null) {
                hashMap = (HashMap)this.nsDecl.elementAt(this.nslen);
                hashMap.put(string22, string);
                return string22;
            }
            ++n;
        }
    }

    public String resolve(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (int i = this.nslen; i >= 0; --i) {
            HashMap hashMap = (HashMap)this.nsDecl.elementAt(i);
            String string2 = (String)hashMap.get(string);
            if (string2 == null) continue;
            return string2;
        }
        if (string == "") {
            return "";
        }
        this.error(24129, string, false);
        return "";
    }

    XSDDataValue getDataValue() {
        return this.dataValue;
    }

    public String getLexicalValue() {
        return this.lexicalValue;
    }

    void addIdentityConstraint(XMLElement xMLElement) {
        if (!this.equals(xMLElement.getNodeLocalName(), this.elementNode.name)) {
            return;
        }
        XSDIdentity[] xSDIdentityArray = this.elementNode.getIdentities();
        int n = this.elementNode.getNIdentities();
        if (xSDIdentityArray == null) {
            return;
        }
        String string = null;
        if (this.idConstraints == null) {
            this.idConstraints = new Hashtable();
        }
        for (int i = 0; i < n; ++i) {
            XSDIdentity xSDIdentity = xSDIdentityArray[i];
            string = xSDIdentity.getExpandedName();
            if (string == "") {
                this.error(24000, "Identity constraint name missing", false);
                continue;
            }
            XSDIdConstraintTable xSDIdConstraintTable = (XSDIdConstraintTable)this.idConstraints.get(string);
            if (xSDIdConstraintTable == null) {
                xSDIdConstraintTable = new XSDIdConstraintTable(xSDIdentityArray[i]);
            }
            xSDIdConstraintTable.addElement(xMLElement);
            this.idConstraints.put(string, xSDIdConstraintTable);
        }
    }

    private void validateIDConstraint() throws XSDException {
        Object object;
        Object object22;
        if (this.idTable != null && this.idTable.containsValue(null)) {
            for (Object object22 : this.idTable.keySet()) {
                if (this.idTable.get(object22) != null) continue;
                this.error(24070, (String)object22, false);
            }
        }
        if (this.idConstraints == null) {
            return;
        }
        Enumeration<Object> enumeration = this.idConstraints.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            object22 = (XSDIdConstraintTable)this.idConstraints.get(object);
            ((XSDIdConstraintTable)object22).validateIdConstraints();
        }
        enumeration = this.idConstraints.elements();
        while (enumeration.hasMoreElements()) {
            object22 = (XSDIdConstraintTable)enumeration.nextElement();
            if (((XSDIdConstraintTable)object22).definition.getNodeType() != 24) continue;
            object = ((XSDIdConstraintTable)object22).definition.getRefer();
            if (object == null) {
                throw new XSDException("Empty key reference");
            }
            XSDIdConstraintTable xSDIdConstraintTable = (XSDIdConstraintTable)this.idConstraints.get(object);
            if (xSDIdConstraintTable == null) {
                throw new XSDException("Reference to null keys");
            }
            ((XSDIdConstraintTable)object22).validateKeyref(xSDIdConstraintTable);
        }
    }

    private void error(int n, String string, boolean bl) {
        this.sendError(n, this.err.getMessage1(n, string), bl);
        if (this.err.getDOMErrorOption()) {
            this.sendDOMError(this.err.getMessage1(n, string), string);
        }
    }

    private void error2(int n, String string, String string2) {
        this.sendError(n, this.err.getMessage2(n, string, string2), false);
        if (this.err.getDOMErrorOption()) {
            this.sendDOMError(this.err.getMessage2(n, string, string2), string2);
        }
    }

    private void sendError(int n, String string, boolean bl) {
        if (bl) {
            this.state.status = 17;
        }
        if (this.locator != null) {
            this.err.setLocator(this.locator);
        }
        this.err.error(n, 1, string);
        if (n == 24506) {
            this.err.resetLineColInfo();
        }
    }

    private void sendDOMError(String string, String string2) {
        if (this.locator != null) {
            this.err.setLocator((DOMLocator)this.locator);
            this.err.flushNodes(string, string2);
        }
    }

    private boolean equals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private class State {
        String tag;
        int numSize = 20;
        int[] numOccur = new int[this.numSize];
        int cur;
        int status;
        int length;
        int basePosition;
        int level;
        byte[] viLevel;
        HashMap pathTable;
        FastVector elemList;
        XSDElement elemNode;
        XSDNode typeNode;
        XSDNode group;
        int content;
        int order;
        boolean nullable;
        String fixedVal;
        String defaultVal;

        private State() {
        }

        void set(XSDGroup xSDGroup, String string, int n) {
            this.tag = string;
            this.cur = 0;
            this.content = n;
            this.status = 17;
            this.group = xSDGroup;
            this.order = xSDGroup.order;
            this.length = xSDGroup.length();
            if (this.numOccur.length < this.length) {
                this.numOccur = new int[this.length + 10];
            }
            for (int i = 0; i < this.length; ++i) {
                this.numOccur[i] = 0;
            }
            if (xSDGroup.topGroup) {
                this.pathTable = xSDGroup.pathTable;
                this.viLevel = xSDGroup.viLevel;
                this.elemList = xSDGroup.elemList;
                this.basePosition = 0;
                this.level = 1;
            }
        }

        void set(XSDNode xSDNode, String string) {
            this.tag = string;
            this.status = 17;
            this.group = xSDNode;
        }

        boolean isTopGroup() {
            if (this.group.isNodeType(5)) {
                return ((XSDGroup)this.group).topGroup;
            }
            return false;
        }

        XSDNode getSimpleType() {
            XSDNode xSDNode = this.curItem();
            if (xSDNode.name == "#xmlAttr") {
                ++this.cur;
                xSDNode = this.curItem();
            }
            return xSDNode.isNodeType(2) ? xSDNode : null;
        }

        XSDNode curItem() {
            if (this.group instanceof XSDGroup) {
                return (XSDNode)((Object)((XSDGroup)this.group).item(this.cur));
            }
            return this.group;
        }

        XSDElement getElementNode() {
            return this.elemNode;
        }

        XSDNode getTypeNode() {
            return this.typeNode;
        }

        String getCurrentMode() {
            if (this.group != XSDConstantValues.FAKE_NODE) {
                return "strict";
            }
            return this.tag;
        }

        boolean isFake() {
            return this.group == XSDConstantValues.FAKE_NODE;
        }

        boolean isNestedGroup() {
            return this.tag == null;
        }

        boolean isDone() {
            return this.status == 20;
        }

        int curStatus() {
            return this.nodeStatus(this.cur);
        }

        boolean isCurDone() {
            return this.nodeStatus(this.cur) == 20;
        }

        boolean isAccepted() {
            if (this.status == 17) {
                this.setStatus();
            }
            return this.status == 19 || this.status == 20;
        }

        XSDNode getItem(int n) {
            if (this.group instanceof XSDGroup) {
                this.cur = n;
                return (XSDNode)((Object)((XSDGroup)this.group).item(n));
            }
            return this.group;
        }

        int eligible(int[] nArray, String string) {
            if (nArray == null) {
                return -1;
            }
            block5: for (int n : nArray) {
                int n2;
                XSDAny xSDAny;
                if (string != null && !(xSDAny = (XSDAny)this.elemList.elementAt(n)).isMatched(string) || this.viLevel[n] > this.level || (n2 = this.getBranch(n)) < 0) continue;
                int n3 = this.nodeStatus(this.cur);
                if (n2 == this.cur && n3 != 20) {
                    return n;
                }
                switch (this.order) {
                    case 0: {
                        while (this.nodeStatus(this.cur) >= 19 && this.cur < n2) {
                            ++this.cur;
                            if (n2 != this.cur) continue;
                            return n;
                        }
                        continue block5;
                    }
                    case 2: {
                        if (this.status == 17 || n3 < 19 || this.numOccur[n2] != 0) continue block5;
                        return n;
                    }
                    case 1: {
                        if (this.status != 17) continue block5;
                        return n;
                    }
                }
            }
            return -1;
        }

        int getOffset(int n) {
            return ((XSDGroup)this.group).getOffset(n);
        }

        int getBranch(int n) {
            if (n < this.basePosition) {
                return -1;
            }
            return ((XSDGroup)this.group).getBranch(n - this.basePosition);
        }

        void setStatus() {
            int n = 0;
            if (this.group instanceof XSDGroup) {
                n = ((XSDGroup)this.group).order;
            }
            switch (n) {
                case 0: {
                    this.status = 20;
                    block17: for (int i = this.cur; i < this.length; ++i) {
                        switch (this.nodeStatus(i)) {
                            case 18: {
                                this.status = 18;
                                continue block17;
                            }
                            case 19: {
                                this.status = this.status == 20 ? 19 : this.status;
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    if (this.status != 17) {
                        this.status = this.nodeStatus(this.cur);
                        break;
                    }
                    this.status = 18;
                    block18: for (int i = 0; i < this.length; ++i) {
                        switch (this.nodeStatus(i)) {
                            case 20: {
                                this.status = 20;
                                continue block18;
                            }
                            case 19: {
                                this.status = this.status == 18 ? 19 : this.status;
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    this.status = 20;
                    block19: for (int i = 0; i < this.length; ++i) {
                        switch (this.nodeStatus(i)) {
                            case 18: {
                                this.status = 18;
                                continue block19;
                            }
                            case 19: {
                                this.status = this.status == 20 ? 19 : this.status;
                            }
                        }
                    }
                    break;
                }
                default: {
                    this.status = 20;
                }
            }
        }

        int nodeStatus(int n) {
            int n2 = this.numOccur[n];
            if (this.group instanceof XSDGroup) {
                if (n2 >= ((XSDGroup)this.group).maxOccurs(n)) {
                    return 20;
                }
                if (((XSDGroup)this.group).isOptional(n)) {
                    return 19;
                }
                if (n2 < ((XSDGroup)this.group).minOccurs(n)) {
                    return 18;
                }
                return 19;
            }
            if (this.group instanceof XSDParticleNode) {
                if (n2 < ((XSDParticleNode)((Object)this.group)).getMinOccurs()) {
                    return 18;
                }
                if (n2 < ((XSDParticleNode)((Object)this.group)).getMaxOccurs()) {
                    return 19;
                }
            }
            return 20;
        }
    }
}

