/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.xml.comp.CXMLReader;
import oracle.xml.comp.CXMLStream;
import oracle.xml.comp.CXMLWriter;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLCharReader;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;

public class XMLEntity
extends XMLNSNode
implements Entity,
Externalizable {
    private char cdata;
    boolean inStack = false;
    boolean expanderef = true;
    private XMLCharReader reader;
    private String encoding;
    private String inputEncoding;
    private String version;
    static final int PARAMETER_ENTITY = 65536;
    static final int PARSED_ENTITY = 131072;
    private static final int ENTITY_DTD = 0;
    private static final int ENTITY_QXNAME = 1;
    private static final int ENTITY_VALUE = 2;
    private static final int ENTITY_SYSID = 3;
    private static final int ENTITY_PUBID = 4;
    private static final int ENTITY_NOTATION = 5;
    private static final int ENTITY_FIRSTCHILD = 6;
    private static final int ENTITY_LASTCHILD = 7;
    private static final int ENTITY_DATASZ = 8;

    private native String xdbGetNotationName(long var1, long var3);

    private native String xdbGetPublicId(long var1, long var3);

    private native String xdbGetSystemId(long var1, long var3);

    public XMLEntity() {
    }

    XMLEntity(String string, boolean bl) {
        QxName qxName = QxNameHash.create("", string, "", string);
        this.xdkSetQxName(qxName);
        if (bl) {
            this.setNodeFlag(65536);
        }
    }

    XMLEntity(XMLDocument xMLDocument) {
        super(xMLDocument);
    }

    XMLEntity(String string, boolean bl, int n, boolean bl2) {
        this(string, bl);
        this.cdata = (char)n;
        this.xdkSetNodeValue(String.valueOf(this.cdata));
        if (bl2) {
            this.setNodeFlag(131072);
        }
    }

    public short getNodeType() {
        return 6;
    }

    public String getNodeName() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetQxName().getQName();
            }
            case 2: {
                return this.xdbGetNodeName(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public String getNodeValue() throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                if (this.hasChildNodes()) {
                    return this.getText();
                }
                return this.xdkGetNodeValue();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public String getPublicId() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetPublicId();
            }
            case 2: {
                return this.xdbGetPublicId(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public String getSystemId() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetSystemId();
            }
            case 2: {
                return this.xdbGetSystemId(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public String getNotationName() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetNotation();
            }
            case 2: {
                return this.xdbGetNotationName(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getInputEncoding() {
        switch (this.flags & 3) {
            case 1: {
                return this.inputEncoding;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public void setInputEncoding(String string) {
        switch (this.flags & 3) {
            case 1: {
                this.inputEncoding = string;
                return;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
    }

    public String getXmlEncoding() {
        switch (this.flags & 3) {
            case 1: {
                return this.encoding;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public void setXmlEncoding(String string) {
        switch (this.flags & 3) {
            case 1: {
                this.encoding = string;
                return;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
    }

    public String getXmlVersion() {
        switch (this.flags & 3) {
            case 1: {
                return this.version;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public void setXmlVersion(String string) {
        switch (this.flags & 3) {
            case 1: {
                this.version = string;
                break;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
    }

    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        XMLEntity xMLEntity = (XMLEntity)xMLDocument.createNodeFromType((short)6);
        xMLEntity.xdkSetDTD(this.xdkGetDTD());
        xMLEntity.xdkSetQxName(this.xdkGetQxName());
        xMLEntity.xdkSetNodeValue(this.xdkGetNodeValue());
        xMLEntity.xdkSetSystemId(this.xdkGetSystemId());
        xMLEntity.xdkSetPublicId(this.xdkGetPublicId());
        xMLEntity.xdkSetNotation(this.xdkGetNotation());
        xMLEntity.cdata = this.cdata;
        xMLEntity.setNodeFlag(128, this.isNodeFlag(128));
        if ((n & 8) == 8 || !this.hasChildNodes()) {
            return xMLEntity;
        }
        for (XMLNode xMLNode = (XMLNode)this.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
            xMLEntity.appendChild(xMLNode.xdkCopyNode(xMLDocument, n));
        }
        return xMLEntity;
    }

    XMLCharReader getReader(XMLReader xMLReader) throws IOException {
        String string = this.xdkGetNodeValue();
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.reader == null) {
            this.reader = new XMLCharReader(string, xMLReader.getSystemId(), xMLReader.getPublicId());
        } else {
            this.reader.reset(string);
        }
        this.reader.setPrevReader(xMLReader.input);
        return this.reader;
    }

    void setURL(String string) {
        this.xdkSetSystemId(string);
    }

    void setNotationName(String string) {
        this.xdkSetNotation(string);
    }

    public void setNodeValue(String string) {
        switch (this.flags & 3) {
            case 1: {
                this.xdkSetNodeValue(string);
                return;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(128)) {
            xMLOutputStream.writeChars("<!ENTITY ");
            if (this.isNodeFlag(65536)) {
                xMLOutputStream.writeChars("% ");
            }
            xMLOutputStream.writeChars(this.getNodeName() + " ");
            if (this.getPublicId() != null) {
                xMLOutputStream.writeChars(" PUBLIC ");
                xMLOutputStream.writeQuotedString(this.getPublicId());
                xMLOutputStream.writeChars(" ");
                xMLOutputStream.writeQuotedString(this.getSystemId());
                if (this.getNotationName() != null) {
                    xMLOutputStream.writeChars(" NDATA " + this.getNotationName());
                }
            } else if (this.getSystemId() != null) {
                xMLOutputStream.writeChars(" SYSTEM ");
                xMLOutputStream.writeQuotedString(this.getSystemId());
                if (this.getNotationName() != null) {
                    xMLOutputStream.writeChars(" NDATA " + this.getNotationName());
                }
            } else {
                xMLOutputStream.writeQuotedString(this.getNodeValue());
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
            xMLOutputStream.flush();
        }
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new XMLDOMException(3, 21003, this.getXMLError(), XMLUtil.nodeTypeToString(n), XMLUtil.nodeTypeToString(this.getNodeType()));
    }

    int getLength() {
        String string = this.xdkGetNodeValue();
        if (this.cdata > '\u0000') {
            return -1;
        }
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    char getChar(int n) {
        String string = this.xdkGetNodeValue();
        if (string == null) {
            return this.cdata;
        }
        return string.charAt(n);
    }

    boolean isParameterEntity() {
        return this.isNodeFlag(65536);
    }

    boolean isExternalEntity() {
        return this.getSystemId() != null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CXMLStream cXMLStream = new CXMLStream();
        cXMLStream.setObjectOutput(objectOutput);
        CXMLWriter cXMLWriter = (CXMLWriter)cXMLStream.getInfosetWriter();
        cXMLWriter.init();
        this.writeNodeInfo(cXMLWriter, true, false);
        cXMLWriter.close();
        cXMLStream.close();
    }

    void writeNodeInfo(InfosetWriter infosetWriter, boolean bl, boolean bl2) {
        if (!(infosetWriter instanceof CXMLWriter)) {
            return;
        }
        try {
            CXMLWriter cXMLWriter = (CXMLWriter)infosetWriter;
            cXMLWriter.writeByte(17);
            cXMLWriter.writeUTF(this.getNodeName());
            cXMLWriter.writeUTF(this.getSystemId());
            cXMLWriter.writeUTF(this.getPublicId());
            cXMLWriter.writeUTF(this.getNotationName());
            cXMLWriter.writeUTF(this.getNodeValue());
            cXMLWriter.writeChar(this.cdata);
            cXMLWriter.writeBoolean(this.isNodeFlag(65536));
            cXMLWriter.writeBoolean(this.isNodeFlag(131072));
            cXMLWriter.writeBoolean(this.isNodeFlag(128));
            cXMLWriter.writeByte(22);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException, EOFException {
        CXMLStream cXMLStream = new CXMLStream();
        cXMLStream.setObjectInput(objectInput);
        CXMLReader cXMLReader = (CXMLReader)cXMLStream.getInfosetReader();
        cXMLReader.init();
        this.readNodeInfo(cXMLReader, true);
    }

    void readNodeInfo(InfosetReader infosetReader, boolean bl) {
        if (!(infosetReader instanceof CXMLReader)) {
            return;
        }
        try {
            CXMLReader cXMLReader = (CXMLReader)infosetReader;
            byte by = cXMLReader.readByte();
            String string = cXMLReader.readUTF();
            QxName qxName = QxNameHash.create("", string, "", string);
            this.xdkSetQxName(qxName);
            this.xdkSetSystemId(cXMLReader.readUTF());
            this.xdkSetPublicId(cXMLReader.readUTF());
            this.setNotationName(cXMLReader.readUTF());
            this.setNodeValue(cXMLReader.readUTF());
            this.cdata = cXMLReader.readChar();
            this.setNodeFlag(65536, cXMLReader.readBoolean());
            this.setNodeFlag(131072, cXMLReader.readBoolean());
            this.setNodeFlag(128, cXMLReader.readBoolean());
            cXMLReader.readByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    DTD xdkGetDTD() {
        return (DTD)this.data[(int)this.nodeId + 0];
    }

    void xdkSetDTD(DTD dTD) {
        this.data[(int)this.nodeId + 0] = dTD;
    }

    QxName xdkGetQxName() {
        return (QxName)this.data[(int)this.nodeId + 1];
    }

    void xdkSetQxName(QxName qxName) {
        this.data[(int)this.nodeId + 1] = qxName;
    }

    String xdkGetNodeValue() {
        return (String)this.data[(int)this.nodeId + 2];
    }

    void xdkSetNodeValue(String string) {
        this.data[(int)this.nodeId + 2] = string;
    }

    String xdkGetSystemId() {
        return (String)this.data[(int)this.nodeId + 3];
    }

    void xdkSetSystemId(String string) {
        this.data[(int)this.nodeId + 3] = string;
    }

    String xdkGetPublicId() {
        return (String)this.data[(int)this.nodeId + 4];
    }

    void xdkSetPublicId(String string) {
        this.data[(int)this.nodeId + 4] = string;
    }

    String xdkGetNotation() {
        return (String)this.data[(int)this.nodeId + 5];
    }

    void xdkSetNotation(String string) {
        this.data[(int)this.nodeId + 5] = string;
    }

    XMLNode xdkGetFirstChild() {
        return (XMLNode)this.data[(int)this.nodeId + 6];
    }

    void xdkSetFirstChild(Object object) {
        this.data[(int)this.nodeId + 6] = object;
    }

    XMLNode xdkGetLastChild() {
        return (XMLNode)this.data[(int)this.nodeId + 7];
    }

    void xdkSetLastChild(Object object) {
        this.data[(int)this.nodeId + 7] = object;
    }

    int xdkGetNodeArraySize() {
        return 8;
    }
}

