/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.xpath.XPathStep;

public class StreamingXPath {
    ArrayList stepList;
    StepNode[] result;
    int length;
    InfosetReader reader;

    private StreamingXPath(ArrayList arrayList, InfosetReader infosetReader) {
        this.stepList = arrayList;
        this.length = this.stepList.size();
        this.result = new StepNode[this.length + 1];
        this.reader = infosetReader;
        for (int i = 0; i < this.length; ++i) {
            this.result[i + 1] = new StepNode((XPathStep)this.stepList.get(i));
        }
        this.result[0] = new StepNode(null);
        this.result[0].setOffset(this.reader.getOffset());
    }

    public static StreamingXPath evaluate(InfosetReader infosetReader, ArrayList arrayList) {
        return new StreamingXPath(arrayList, infosetReader);
    }

    public boolean next() {
        if (this.result[0].getOffset() == null) {
            return false;
        }
        this.getNext(this.length);
        return this.result[this.length].getOffset() != null;
    }

    private void getNext(int n) {
        if (n == 0) {
            this.result[0].reset();
            return;
        }
        while (this.getOffset(n - 1) != null) {
            StepNode stepNode = this.result[n];
            if (stepNode.getNext(this.reader, this.getOffset(n - 1))) {
                return;
            }
            this.getNext(n - 1);
            stepNode.reset();
        }
    }

    public int getDepth() {
        return this.length;
    }

    public InfosetReader.Offset getOffset(int n) {
        return this.result[n].getOffset();
    }

    public InfosetReader.Offset getOffset() {
        return this.result[this.length].getOffset();
    }

    class StepNode {
        XPathStep step;
        InfosetReader.Offset offset;
        Stack ancestors;
        int count;
        boolean desc;

        StepNode(XPathStep xPathStep) {
            this.step = xPathStep;
            this.offset = null;
            this.count = 0;
            if (this.step != null) {
                this.desc = this.step.isDescendantStep();
            }
            if (this.desc) {
                this.ancestors = new Stack();
            }
        }

        void setOffset(InfosetReader.Offset offset) {
            this.offset = offset;
        }

        InfosetReader.Offset getOffset() {
            return this.offset;
        }

        void reset() {
            this.offset = null;
            this.count = 0;
            if (this.desc) {
                this.ancestors.clear();
            }
        }

        boolean getNext(InfosetReader infosetReader, InfosetReader.Offset offset) {
            if (this.offset == null) {
                this.count = 0;
                infosetReader.seek(offset);
                infosetReader.next();
            } else {
                infosetReader.seek(this.offset);
                infosetReader.skip();
            }
            int n = infosetReader.getEventType();
            this.offset = null;
            while (n != 2) {
                if (n == 1 && this.matchNode()) {
                    this.offset = infosetReader.getOffset();
                    return true;
                }
                infosetReader.skip();
                n = infosetReader.getEventType();
            }
            return false;
        }

        boolean getDescNext(InfosetReader infosetReader, InfosetReader.Offset offset) {
            InfosetReader.Offset offset2 = null;
            offset2 = this.offset == null ? offset : this.offset;
            this.ancestors.push(offset2);
            this.offset = null;
            infosetReader.seek(offset2);
            infosetReader.next();
            while (offset2 != null) {
                int n = infosetReader.getEventType();
                while (n != 2) {
                    if (n == 1) {
                        if (this.matchNode()) {
                            this.offset = infosetReader.getOffset();
                            return true;
                        }
                        offset2 = infosetReader.getOffset();
                        this.ancestors.push(offset2);
                        infosetReader.next();
                        n = infosetReader.getEventType();
                        continue;
                    }
                    infosetReader.skip();
                    n = infosetReader.getEventType();
                }
                if (this.ancestors.isEmpty()) {
                    offset2 = null;
                    continue;
                }
                offset2 = (InfosetReader.Offset)this.ancestors.pop();
                infosetReader.next();
            }
            return false;
        }

        boolean matchNode() {
            QName qName = StreamingXPath.this.reader.getQName();
            if (this.step.matchQName(qName.getNamespaceURI(), qName.getLocalPart())) {
                ++this.count;
            } else {
                return false;
            }
            return this.step.filter(this.count, StreamingXPath.this.reader.getAttributes());
        }
    }
}

