/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controls.FocusHierarchyEvent;
import oracle.ide.controls.FocusHierarchyListener;
import oracle.ide.editor.Editor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.MainWindowImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveViewHandlerImpl
implements FocusHierarchyListener,
ChangeListener,
MainWindowImpl.ControllerContextImpl {
    private static final boolean DEBUG_TRACE_VIEW_CHANGES = Boolean.valueOf(Ide.getProperty((String)"DEBUG_TRACE_VIEW_CHANGES", (String)"false"));
    private static final boolean DEBUG_TRACE_FOCUS_CHANGES = Boolean.valueOf(Ide.getProperty((String)"DEBUG_TRACE_FOCUS_CHANGES", (String)"false"));
    private View _lastActiveView;
    private Hashtable _componentToView;
    private Hashtable _viewToComponent;
    private Hashtable _componentToControllerProvider;
    private ArrayList _activeViewListeners;
    private HashMap _cachedControllerStacks;

    private void $init$() {
        this._componentToView = new Hashtable();
        this._viewToComponent = new Hashtable();
        this._componentToControllerProvider = new Hashtable();
        this._activeViewListeners = new ArrayList(2);
        this._cachedControllerStacks = new HashMap();
    }

    ActiveViewHandlerImpl() {
        this.$init$();
    }

    public synchronized void addDependant(Component component, View view) {
        this._componentToView.put(component, view);
        this._viewToComponent.put(view, component);
        this.clearControllerStacksCache();
    }

    public synchronized void removeDependant(View view) {
        block5: {
            if (view != null) {
                try {
                    Component component = (Component)this._viewToComponent.remove(view);
                    if (component == null) break block5;
                    this._componentToView.remove(component);
                    this.clearControllerStacksCache();
                    if (view == this.getLastActiveView()) {
                        this.solveActiveView(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Assert.println((String)"ActiveViewHandlerImpl.removeDependant(View) - view cannot be null");
                Assert.printStackTrace();
            }
        }
    }

    public synchronized void removeDependant(Component component) {
        View view = (View)this._componentToView.get(component);
        if (view != null) {
            this.removeDependant(view);
        } else {
            Assert.println((String)"ActiveViewHandlerImpl.removeDependant(Component) - component is not registered");
            Assert.printStackTrace();
        }
    }

    public synchronized void addControllerProvider(Component component, ControllerProvider controllerProvider) {
        this._componentToControllerProvider.put(component, controllerProvider);
        this.clearControllerStacksCache();
    }

    public synchronized void removeControllerProvider(Component component) {
        this._componentToControllerProvider.remove(component);
        this.clearControllerStacksCache();
    }

    public synchronized void addActiveViewListener(ActiveViewListener l) {
        if (!this._activeViewListeners.contains(l)) {
            this._activeViewListeners.add(l);
        }
    }

    public synchronized void removeActiveViewListener(ActiveViewListener l) {
        this._activeViewListeners.remove(l);
    }

    private synchronized void fireActiveViewChanged(ActiveViewEvent e) {
        int count = this._activeViewListeners.size();
        ActiveViewListener[] listeners = this._activeViewListeners.toArray(new ActiveViewListener[count]);
        int i = 0;
        while (i < count) {
            try {
                long startTime = System.nanoTime();
                listeners[i].activeViewChanged(e);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("ActiveViewListener.activeViewChanged", listeners[i].getClass().getName(), endTime - startTime);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((Throwable)ex);
            }
            ++i;
        }
    }

    private void cacheControllerStack(View view, List retControllerStack) {
        this._cachedControllerStacks.put(view, retControllerStack);
    }

    private Object getCachedControllerStack(View view) {
        return this._cachedControllerStacks.get(view);
    }

    private void clearControllerStacksCache() {
        this._cachedControllerStacks.clear();
    }

    public View getLastActiveView() {
        return this._lastActiveView;
    }

    private void setActiveView(View activeView) {
        if (activeView != null && activeView != this._lastActiveView) {
            this.clearControllerStacksCache();
            if (DEBUG_TRACE_VIEW_CHANGES) {
                Assert.println((String)("Changing active view from " + (this._lastActiveView == null ? "null" : this._lastActiveView.getId()) + " to " + activeView.getId()));
            }
            if (this._lastActiveView != null) {
                try {
                    this._lastActiveView.deactivate();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ActiveViewEvent e = new ActiveViewEvent((Object)this, this._lastActiveView, activeView);
            this._lastActiveView = activeView;
            if (this._lastActiveView != null) {
                try {
                    this._lastActiveView.activate();
                    this._lastActiveView.updateSelection();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            this.fireActiveViewChanged(e);
        }
    }

    public void focusGained(FocusHierarchyEvent event) {
        this.trace("focusGained", event);
        ArrayList list = event.getHierarchy();
        if (list.size() > 0) {
            this.addTabbedPaneChangeListener(list);
            Component c = (Component)list.get(0);
            this.solveActiveView(c);
        }
    }

    public void focusLost(FocusHierarchyEvent event) {
        this.trace("focusLost", event);
        ArrayList list = event.getHierarchy();
        if (list.size() > 0) {
            this.removeTabbedPaneChangeListener(list);
        }
    }

    private void trace(String focusEventName, FocusHierarchyEvent event) {
        if (DEBUG_TRACE_FOCUS_CHANGES) {
            ArrayList hierarchy = event.getHierarchy();
            Component focusedComponent = (Component)hierarchy.get(0);
            System.out.println("-------------------------- " + focusEventName);
            ArrayList<String> lines = new ArrayList<String>(20);
            while (focusedComponent != null) {
                String className = focusedComponent.getClass().getName();
                lines.add(className);
                focusedComponent = focusedComponent.getParent();
            }
            int n = lines.size();
            int i = n - 1;
            while (i >= 0) {
                int j = 0;
                while (j < n - i) {
                    System.out.print("  ");
                    ++j;
                }
                String s = (String)lines.get(i);
                System.out.println(s);
                --i;
            }
            System.out.flush();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component source = (Component)e.getSource();
        if (source.hasFocus()) {
            this.solveActiveView(source);
        }
    }

    private void addTabbedPaneChangeListener(List list) {
        int i = 0;
        while (i < list.size()) {
            Component c = (Component)list.get(i);
            if (c instanceof JTabbedPane) {
                JTabbedPane tabbedPane = (JTabbedPane)c;
                tabbedPane.addChangeListener(this);
                break;
            }
            ++i;
        }
    }

    private void removeTabbedPaneChangeListener(List list) {
        int i = 0;
        while (i < list.size()) {
            Component c = (Component)list.get(i);
            if (c instanceof JTabbedPane) {
                JTabbedPane tabbedPane = (JTabbedPane)c;
                tabbedPane.removeChangeListener(this);
                break;
            }
            ++i;
        }
    }

    private void solveActiveView(Component component) {
        View activeView = this.findActiveView(component);
        if (component != null && component.getClass().getName().endsWith("ZoomComboBox") && activeView instanceof Editor) {
            return;
        }
        this.setActiveView(activeView);
    }

    private View findActiveView(Component focusedComponent) {
        View activeView = null;
        if (focusedComponent != null) {
            Component c = focusedComponent;
            while (activeView == null && c != null) {
                Object dependantView = this._componentToView.get(c);
                if (dependantView != null) {
                    View view = (View)dependantView;
                    if (activeView == null) {
                        activeView = view;
                    }
                }
                c = c.getParent();
            }
        } else {
            IdeMainWindow mainWindow = Ide.getMainWindow();
            activeView = mainWindow.getIdeMainWindowView();
        }
        return activeView;
    }

    public List getControllerProviders(View view) {
        ArrayList retControllerStack;
        Object cachedControllerStack = this.getCachedControllerStack(view);
        if (cachedControllerStack == null) {
            Component currentLevel;
            Component viewComponent = (Component)this._viewToComponent.get(view);
            retControllerStack = null;
            if (viewComponent != null) {
                currentLevel = viewComponent;
            } else {
                IdeMainWindow mainWindow = Ide.getMainWindow();
                currentLevel = mainWindow;
            }
            currentLevel = currentLevel.getParent();
            while (currentLevel != null) {
                Object controllerProvider = this._componentToControllerProvider.get(currentLevel);
                if (controllerProvider == null) {
                    controllerProvider = this._componentToView.get(currentLevel);
                }
                if (controllerProvider != null) {
                    if (retControllerStack == null) {
                        retControllerStack = new ArrayList(2);
                    }
                    retControllerStack.add(controllerProvider);
                }
                currentLevel = currentLevel.getParent();
            }
            if (retControllerStack == null) {
                retControllerStack = Collections.EMPTY_LIST;
            }
            this.cacheControllerStack(view, retControllerStack);
        } else {
            retControllerStack = (ArrayList)cachedControllerStack;
        }
        return retControllerStack;
    }

    EventListener[] getListeners(Class listenerType) {
        return this._activeViewListeners.toArray(new EventListener[this._activeViewListeners.size()]);
    }

    List<View> getVisibleViews() {
        ArrayList<View> views = new ArrayList<View>();
        Enumeration iter = this._viewToComponent.keys();
        while (iter.hasMoreElements()) {
            View view = (View)iter.nextElement();
            if (view == null || !view.isVisible()) continue;
            views.add(view);
        }
        views.add(Ide.getMainWindow().getIdeMainWindowView());
        return views;
    }
}

