/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import oracle.ide.Ide;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.JDK;

public class IdeImpl {
    private static final String X_COORD_PROP = "MainWindow.x";
    private static final String Y_COORD_PROP = "MainWindow.y";
    private static final String WIDTH_PROP = "MainWindow.width";
    private static final String HEIGHT_PROP = "MainWindow.height";

    private IdeImpl() {
    }

    public static Rectangle getStartupCoordinates() {
        String sH;
        String sW;
        String sY;
        String sX;
        Rectangle r = new Rectangle();
        boolean restoreDefaultSize = true;
        if (!JDK.WA_ORABUG_1963899 && (sX = Ide.getProperty((String)X_COORD_PROP)) != null && (sY = Ide.getProperty((String)Y_COORD_PROP)) != null && (sW = Ide.getProperty((String)WIDTH_PROP)) != null && (sH = Ide.getProperty((String)HEIGHT_PROP)) != null) {
            try {
                r.x = Integer.parseInt(sX);
                r.y = Integer.parseInt(sY);
                r.width = Integer.parseInt(sW);
                r.height = Integer.parseInt(sH);
                Rectangle[] screenBounds = GraphicsUtils.getScreenBounds();
                int i = 0;
                while (restoreDefaultSize && i < screenBounds.length) {
                    Rectangle screenBound = screenBounds[i];
                    if (screenBound.contains(r.x, r.y) || screenBound.contains(r.x + r.width, r.y)) {
                        restoreDefaultSize = false;
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (restoreDefaultSize) {
            Toolkit kit = Toolkit.getDefaultToolkit();
            Dimension dim = kit.getScreenSize();
            int nxMargin = dim.width / 15;
            int nyMargin = dim.height / 15;
            r.setBounds(nxMargin, nyMargin, dim.width - 2 * nxMargin, dim.height - 2 * nyMargin);
        }
        return r;
    }

    static void updatePosAndSize(Rectangle r) {
        Ide.setProperty((String)X_COORD_PROP, (String)Integer.toString(r.x));
        Ide.setProperty((String)Y_COORD_PROP, (String)Integer.toString(r.y));
        Ide.setProperty((String)WIDTH_PROP, (String)Integer.toString(r.width));
        Ide.setProperty((String)HEIGHT_PROP, (String)Integer.toString(r.height));
    }
}

