/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideimpl.resource.IdeImplMenuArb;
import oracle.ideri.util.Product;

public final class IdeMenus {
    private static final Menubar menuMgr = Ide.getMenubar();

    public static JMenu findJMenu(String menuID) {
        String string = menuID = menuID != null ? menuID.trim() : null;
        if (menuID == null || menuID.length() == 0) {
            return null;
        }
        return MenuManager.getJMenu((String)menuID);
    }

    public static JMenu findOrCreateJMenu(String menuID) {
        JMenu menu = IdeMenus.findJMenu(menuID);
        if (menu != null) {
            return menu;
        }
        if (menuID.equals("File")) {
            menu = IdeMenus.createFileMenu();
        } else if (menuID.equals("Edit")) {
            menu = IdeMenus.createEditMenu();
        } else if (menuID.equals("Search")) {
            menu = IdeMenus.createSearchMenu();
        } else if (menuID.equals("View")) {
            menu = IdeMenus.createViewMenu();
        } else if (menuID.equals("Navigate")) {
            menu = IdeMenus.createNavigateMenu();
        } else if (menuID.equals("Tools")) {
            menu = IdeMenus.createToolsMenu();
        } else if (menuID.equals("Help")) {
            menu = IdeMenus.createHelpMenu();
        }
        if (menu != null) {
            MenuManager.putJMenu((String)menuID, (JMenu)menu);
            menuMgr.add((Component)menu);
        }
        return menu;
    }

    public static JMenuItem createMenuItem(int cmdID, String cmdStr, String label, String actionCategory, Integer labelMnemonic, ArrayResourceBundle bundle, int iconKey, Object data, boolean enabled, float weight) {
        String cmd = AddinManager.getAddinManager().getCommand(cmdID, cmdStr);
        IdeAction action = IdeAction.get((int)cmdID, (String)cmd, (String)label, (String)actionCategory, (Integer)labelMnemonic, (ArrayResourceBundle)bundle, (int)iconKey, (Object)data, (boolean)enabled);
        return Ide.getMenubar().createMenuItem((ToggleAction)action, weight);
    }

    public static JMenuItem createMenuItem(Controller controller, int cmdID, String cmdStr, String label, String actionCategory, Integer labelMnemonic, ArrayResourceBundle bundle, int iconKey, Object data, boolean enabled, float weight) {
        String cmd = AddinManager.getAddinManager().getCommand(cmdID, cmdStr);
        IdeAction action = IdeAction.get((int)cmdID, (String)cmd, (String)label, (String)actionCategory, (Integer)labelMnemonic, (ArrayResourceBundle)bundle, (int)iconKey, (Object)data, (boolean)enabled);
        action.addController(controller);
        return Ide.getMenubar().createMenuItem((ToggleAction)action, weight);
    }

    public static JMenuItem createMenuItem(IdeAction action, float weight) {
        return menuMgr.createMenuItem((ToggleAction)action, weight);
    }

    public static JMenu loadFileMenu() {
        JMenu fileMenu = IdeMenus.findJMenu("File");
        if (fileMenu == null && (fileMenu = IdeMenus.findOrCreateJMenu("File")) != null) {
            menuMgr.add((Component)IdeMenus.createExitMenuItem(), fileMenu, MenuConstants.SECTION_FILE_EXIT);
        }
        menuMgr.add((Component)IdeMenus.createOpenMenuItem(), fileMenu, 1.0f);
        JMenu reopenMenu = IdeMenus.createReopenMenu();
        MenuManager.putJMenu((String)"FileReopen", (JMenu)reopenMenu);
        menuMgr.add((Component)reopenMenu, fileMenu, 1.0f);
        menuMgr.add((Component)IdeMenus.createCloseMenuItem(), fileMenu, MenuConstants.SECTION_FILE_CLOSE);
        menuMgr.add((Component)IdeMenus.createCloseAllMenuItem(), fileMenu, MenuConstants.SECTION_FILE_CLOSE);
        menuMgr.add((Component)IdeMenus.createSaveMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add((Component)IdeMenus.createSaveAsMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add((Component)IdeMenus.createSaveAllMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add((Component)IdeMenus.createRenameMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add((Component)IdeMenus.createReloadAllMenuItem(), fileMenu, MenuConstants.SECTION_FILE_SAVE);
        if (!Product.isRaptor()) {
            menuMgr.add((Component)IdeMenus.createRemoveFromDiskMenuItem(), fileMenu, MenuConstants.SECTION_FILE_ERASE_REMOVE);
        }
        return fileMenu;
    }

    private static JMenu createFileMenu() {
        return menuMgr.createMenu(IdeArb.getString((int)24), IdeArb.getInteger((int)137), 1.0f, MenuConstants.SECTION_FILE_ADDINS);
    }

    private static JMenuItem createOpenMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileOpenAction(), MenuConstants.WEIGHT_FILE_OPEN);
    }

    private static JMenu createReopenMenu() {
        return menuMgr.createSubMenu(IdeArb.getString((int)151), IdeArb.getInteger((int)448), MenuConstants.WEIGHT_FILE_REOPEN);
    }

    private static JMenuItem createCloseMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileCloseAction(), MenuConstants.WEIGHT_FILE_CLOSE);
    }

    private static JMenuItem createCloseAllMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileCloseAllAction(), MenuConstants.WEIGHT_FILE_CLOSE_ALL);
    }

    private static JMenuItem createSaveMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileSaveAction(), MenuConstants.WEIGHT_FILE_SAVE);
    }

    private static JMenuItem createSaveAsMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileSaveAsAction(), MenuConstants.WEIGHT_FILE_SAVE_AS);
    }

    private static JMenuItem createSaveAllMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileSaveAllAction(), MenuConstants.WEIGHT_FILE_SAVE_ALL);
    }

    private static JMenuItem createRenameMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileRenameAction(), MenuConstants.WEIGHT_FILE_RENAME);
    }

    private static JMenuItem createRemoveFromDiskMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileRemoveFromDiskAction(), MenuConstants.WEIGHT_FILE_ERASE);
    }

    private static JMenuItem createExitMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileExitAction(), MenuConstants.WEIGHT_FILE_EXIT);
    }

    private static JMenuItem createReloadAllMenuItem() {
        JMenuItem mi = IdeMenus.createMenuItem(IdeActions.getFileReloadNodesAction(), MenuConstants.WEIGHT_FILE_RELOAD);
        boolean visible = Ide.getEnvironOptions().getAutoReloadExtMod() ^ true;
        mi.setVisible(visible);
        return mi;
    }

    public static JMenu loadEditMenu() {
        JMenu editMenu = IdeMenus.findOrCreateJMenu("Edit");
        menuMgr.add((Component)IdeMenus.createUndoMenuItem(), editMenu, 1.0f);
        menuMgr.add((Component)IdeMenus.createRedoMenuItem(), editMenu, 1.0f);
        menuMgr.add((Component)IdeMenus.createCutMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add((Component)IdeMenus.createCopyMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add((Component)IdeMenus.createCopyPathMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add((Component)IdeMenus.createPasteMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add((Component)IdeMenus.createExtendedPasteMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add((Component)IdeMenus.createDeleteMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add((Component)IdeMenus.createSelectAllMenuItem(), editMenu, MenuConstants.SECTION_EDIT_SELECT_ALL);
        menuMgr.add((Component)IdeMenus.createPropertiesMenuItem(), editMenu, MenuConstants.SECTION_EDIT_PROPERTIES);
        menuMgr.add((Component)IdeMenus.createDuplicateSelectionMenuItem(), editMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add((Component)IdeMenus.createSelectWrapMenuItem(), editMenu, MenuConstants.SECTION_EDIT_SELECT_ALL);
        return editMenu;
    }

    private static JMenu createEditMenu() {
        return menuMgr.createMenu(IdeArb.getString((int)458), IdeArb.getInteger((int)334), MenuConstants.WEIGHT_EDIT_MENU, MenuConstants.SECTION_EDIT_ADDINS);
    }

    private static JMenuItem createUndoMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditUndoAction(), 1.0f);
    }

    private static JMenuItem createRedoMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditRedoAction(), MenuConstants.WEIGHT_EDIT_REDO);
    }

    private static JMenuItem createCutMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditCutAction(), MenuConstants.WEIGHT_EDIT_CUT);
    }

    private static JMenuItem createCopyMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditCopyAction(), MenuConstants.WEIGHT_EDIT_COPY);
    }

    private static JMenuItem createCopyPathMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditCopyPathAction(), MenuConstants.WEIGHT_EDIT_COPY_PATH);
    }

    private static JMenuItem createPasteMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditPasteAction(), MenuConstants.WEIGHT_EDIT_PASTE);
    }

    private static JMenuItem createExtendedPasteMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditExtendedPasteAction(), MenuConstants.WEIGHT_EDIT_EXTENDED_PASTE);
    }

    private static JMenuItem createDuplicateSelectionMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditDuplicateSelectionAction(), MenuConstants.WEIGHT_EDIT_DUPLICATE_SELECTION);
    }

    private static JMenuItem createDeleteMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditDeleteAction(), MenuConstants.WEIGHT_EDIT_DELETE);
    }

    private static JMenuItem createSelectWrapMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditSelectWrapAction(), MenuConstants.WEIGHT_EDIT_SELECT_WRAP);
    }

    private static JMenuItem createSelectAllMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditSelectAllAction(), MenuConstants.WEIGHT_EDIT_SELECT_ALL);
    }

    private static JMenuItem createPropertiesMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditPropertiesAction(), MenuConstants.WEIGHT_EDIT_PROPERTIES);
    }

    public static void loadSearchMenu() {
        if (Product.isRaptor()) {
            JMenu searchMenu = IdeMenus.findOrCreateJMenu("Edit");
            menuMgr.add((Component)IdeMenus.createFindMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_FIND);
            menuMgr.add((Component)IdeMenus.createSearchAgainMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_FIND);
            menuMgr.add((Component)IdeMenus.createSearchBackwardMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_FIND);
            menuMgr.add((Component)IdeMenus.createIncrementalSearchForwardMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_INCREMENTAL_FIND);
            menuMgr.add((Component)IdeMenus.createIncrementalSearchBackwardMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_INCREMENTAL_FIND);
            menuMgr.add((Component)IdeMenus.createReplaceMenuItem(), searchMenu, MenuConstants.SECTION_EDIT_FIND);
        } else {
            JMenu searchMenu = IdeMenus.findOrCreateJMenu("Search");
            menuMgr.add((Component)IdeMenus.createFindMenuItem(), searchMenu, 1.0f);
            menuMgr.add((Component)IdeMenus.createSearchAgainMenuItem(), searchMenu, 1.0f);
            menuMgr.add((Component)IdeMenus.createSearchBackwardMenuItem(), searchMenu, 1.0f);
            menuMgr.add((Component)IdeMenus.createIncrementalSearchForwardMenuItem(), searchMenu, MenuConstants.SECTION_SEARCH_INCREMENTAL_FIND);
            menuMgr.add((Component)IdeMenus.createIncrementalSearchBackwardMenuItem(), searchMenu, MenuConstants.SECTION_SEARCH_INCREMENTAL_FIND);
            menuMgr.add((Component)IdeMenus.createReplaceMenuItem(), searchMenu, 1.0f);
        }
    }

    private static JMenu createSearchMenu() {
        return menuMgr.createMenu(IdeArb.getString((int)422), IdeArb.getInteger((int)118), MenuConstants.WEIGHT_SEARCH_MENU, MenuConstants.SECTION_SEARCH_ADDINS);
    }

    private static JMenuItem createFindMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchFindAction(), 1.0f);
    }

    private static JMenuItem createSearchAgainMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchFindNextAction(), MenuConstants.WEIGHT_SEARCH_FIND_NEXT);
    }

    private static JMenuItem createSearchBackwardMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchFindPreviousAction(), MenuConstants.WEIGHT_SEARCH_FIND_PREVIOUS);
    }

    private static JMenuItem createIncrementalSearchForwardMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchIncrementalFindForwardAction(), MenuConstants.WEIGHT_SEARCH_INCREMENTAL_FIND_FORWARD);
    }

    private static JMenuItem createIncrementalSearchBackwardMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchIncrementalFindBackwardAction(), MenuConstants.WEIGHT_SEARCH_INCREMENTAL_FIND_BACKWARD);
    }

    private static JMenuItem createReplaceMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchReplaceAction(), MenuConstants.WEIGHT_SEARCH_REPLACE);
    }

    private static JMenuItem createSearchSourcePathMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getSearchFindInFilesAction(), MenuConstants.WEIGHT_SEARCH_FIND_IN_FILES);
    }

    private static JMenuItem createReplaceSourcePathMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getReplaceInFilesAction(), MenuConstants.WEIGHT_SEARCH_REPLACE_IN_FILES);
    }

    public static JMenu loadViewMenu() {
        JMenu viewMenu = IdeMenus.findOrCreateJMenu("View");
        JMenu optionsMenu = IdeMenus.createViewOptionsSubMenu();
        MenuManager.putJMenu((String)"ViewOptions", (JMenu)optionsMenu);
        menuMgr.add((Component)IdeMenus.createNewViewMenuItem(), optionsMenu, 1.0f);
        menuMgr.add((Component)IdeMenus.createFreezeMenuItem(), optionsMenu, 1.0f);
        JMenu toolbarsMenu = IdeMenus.createToolbarsSubMenu();
        MenuManager.putJMenu((String)"ViewToolbars", (JMenu)toolbarsMenu);
        toolbarsMenu.add(IdeMenus.createMainToolbarMenuItem());
        menuMgr.add((Component)optionsMenu, viewMenu, 1.0f);
        menuMgr.add((Component)toolbarsMenu, viewMenu, MenuConstants.SECTION_VIEW_TOOLBAR);
        menuMgr.add((Component)IdeMenus.createStatusBarMenuItem(), viewMenu, MenuConstants.SECTION_VIEW_TOOLBAR);
        menuMgr.add((Component)IdeMenus.createRefreshMenuItem(), viewMenu, MenuConstants.SECTION_VIEW_REFRESH);
        return viewMenu;
    }

    private static JMenu createViewMenu() {
        return menuMgr.createMenu(IdeArb.getString((int)30), IdeArb.getInteger((int)63), MenuConstants.WEIGHT_VIEW_MENU, MenuConstants.SECTION_VIEW_ADDINS);
    }

    private static JMenu createViewOptionsSubMenu() {
        return menuMgr.createSubMenu(IdeArb.getString((int)490), IdeArb.getInteger((int)128), 1.0f);
    }

    private static JMenuItem createNewViewMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewNewViewAction(), 1.0f);
    }

    private static JMenuItem createFreezeMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewFreezeAction(), 1.0f);
    }

    private static JMenu createToolbarsSubMenu() {
        return menuMgr.createSubMenu(IdeImplMenuArb.getString(1), IdeImplMenuArb.getInteger(0));
    }

    private static JMenuItem createMainToolbarMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewMainToolbarAction(), MenuConstants.WEIGHT_VIEW_TOOLBARS_MAIN);
    }

    private static JMenuItem createStatusBarMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewStatusBarAction(), MenuConstants.WEIGHT_VIEW_STATUS_BAR);
    }

    private static JMenuItem createRefreshMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewRefreshAction(), MenuConstants.WEIGHT_VIEW_REFRESH);
    }

    public static JMenu loadNavigateMenu() {
        JMenu navigateMenu = IdeMenus.findOrCreateJMenu("Navigate");
        menuMgr.add((Component)IdeMenus.createNextMsgMenuItem(), navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_MESSAGE);
        menuMgr.add((Component)IdeMenus.createPrevMsgMenuItem(), navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_MESSAGE);
        menuMgr.add((Component)IdeMenus.createGotoLineNumberMenuItem(), navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
        menuMgr.add((Component)IdeMenus.createBrowseSymbolMenuItem(), navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
        return navigateMenu;
    }

    private static JMenu createNavigateMenu() {
        return menuMgr.createMenu(IdeArb.getString((int)481), IdeArb.getInteger((int)493), MenuConstants.WEIGHT_NAVIGATE_MENU, MenuConstants.SECTION_NAVIGATE_ADDINS);
    }

    private static JMenuItem createNextMsgMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getNavigateGoToNextMessageAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_NEXT_MESSAGE);
    }

    private static JMenuItem createPrevMsgMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getNavigateGoToPreviousMessageAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_PREVIOUS_MESSAGE);
    }

    private static JMenuItem createGotoLineNumberMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getNavigateGoToLineAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_LINE);
    }

    private static JMenuItem createBrowseSymbolMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getNavigateGoToClassAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
    }

    public static JMenu loadToolsMenu() {
        JMenu toolsMenu = IdeMenus.findOrCreateJMenu("Tools");
        menuMgr.add((Component)IdeMenus.createPreferencesMenuItem(), toolsMenu, MenuConstants.SECTION_TOOLS_PREFERENCES);
        if (Product.isJDeveloper()) {
            menuMgr.add((Component)IdeMenus.createProjectPropertiesMenuItem(), toolsMenu, MenuConstants.SECTION_TOOLS_PROJECT_PROPERTIES);
            menuMgr.add((Component)IdeMenus.createDefaultProjectPropertiesMenuItem(), toolsMenu, MenuConstants.SECTION_TOOLS_PROJECT_PROPERTIES);
            menuMgr.sortSectionByName(toolsMenu, MenuConstants.SECTION_TOOLS_ADDINS);
        }
        return toolsMenu;
    }

    private static JMenu createToolsMenu() {
        return menuMgr.createMenu(IdeArb.getString((int)281), IdeArb.getInteger((int)465), MenuConstants.WEIGHT_TOOLS_MENU, MenuConstants.SECTION_TOOLS_ADDINS);
    }

    private static JMenuItem createPreferencesMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getToolsPreferencesAction(), MenuConstants.WEIGHT_TOOLS_PREFERENCES);
    }

    private static JMenuItem createProjectPropertiesMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getToolsProjectPropertiesAction(), MenuConstants.WEIGHT_TOOLS_PROJECT_PROPERTIES);
    }

    private static JMenuItem createDefaultProjectPropertiesMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getToolsDefaultProjectPropertiesAction(), MenuConstants.WEIGHT_TOOLS_DEFAULT_PROJECT_PROPERTIES);
    }

    public static JMenu loadHelpMenu() {
        JMenu helpMenu = IdeMenus.findOrCreateJMenu("Help");
        menuMgr.add((Component)IdeMenus.createAboutMenuItem(), helpMenu, MenuConstants.SECTION_HELP_ABOUT);
        return helpMenu;
    }

    private static JMenu createHelpMenu() {
        return menuMgr.createMenu(IdeArb.getString((int)80), IdeArb.getInteger((int)271), MenuConstants.WEIGHT_HELP_MENU, MenuConstants.SECTION_HELP_ADDINS);
    }

    private static JMenuItem createAboutMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getHelpAboutAction(), 1.0f);
    }
}

