/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.IdeProperties;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.Assert;
import oracle.ide.util.JDK;
import oracle.ideimpl.plaf.ImageIconUIResource;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.ui.internal.theme.SkyBluer;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.ThemeColorScheme;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public final class IdeUIManagerImpl
extends IdeUIManager
implements Addin {
    private static final IdeUIManagerImpl INSTANCE = new IdeUIManagerImpl();
    private boolean _blockLookAndFeelChange;
    private static final String OLAF2_NAME = "oracle.bali.ewt.olaf2.OracleLookAndFeel";
    private static final String DEFAULT_THEME_NAME = "skin:fusionblue";
    private static final String CLASSIC_THEME_NAME = "oracle.javatools.ui.internal.theme.DefaultTheme";
    private static final String FONT_SIZE_PROP = "Ide.FontSize";
    private IdeUIManager.ThemeInfo[] _plasticThemes;

    private void $init$() {
        this._blockLookAndFeelChange = true;
    }

    private IdeUIManagerImpl() {
        this.$init$();
        this.initialize();
    }

    public static IdeUIManagerImpl getInstance() {
        return INSTANCE;
    }

    public static boolean isXPStyle() {
        if (!IdeUIManagerImpl.isWindowsXPorGreater() || Boolean.getBoolean("swing.noxp")) {
            return false;
        }
        return Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
    }

    private static String systemLanguage() {
        String oldLanguage = System.getProperty("ide.old.user.language");
        if (oldLanguage != null) {
            return oldLanguage;
        }
        return Locale.getDefault().getLanguage();
    }

    public static boolean isWindowsRegistryFontSupported() {
        if (!PlatformUtils.isWindows()) {
            return false;
        }
        if (!JDK.HAS_BUG_WINDOWS_REGISTRY_FONT_MULTIBYTE_SUPPORT) {
            return true;
        }
        String supportedLanguagesProp = System.getProperty("windows.shell.font.languages", Locale.ENGLISH.getLanguage());
        String[] supportedLanguages = supportedLanguagesProp.split("[,\\s]");
        String language = IdeUIManagerImpl.systemLanguage();
        int i = 0;
        while (i < supportedLanguages.length) {
            String supportedLanguage = supportedLanguages[i];
            if (language.equalsIgnoreCase(supportedLanguage)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLookAndFeel(String lafClass, String themeClass) {
        if (JDK.HAS_BUG_4765282) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalPolicy(new PatchedLayoutFocusTraversalPolicy(null));
        }
        boolean ret = false;
        String defaultLaf = System.getProperty("swing.defaultlaf");
        if (ModelUtil.hasLength((String)defaultLaf) && this._setLookAndFeel(defaultLaf, themeClass, true)) {
            ret = true;
        }
        if (!ret && ModelUtil.hasLength((String)lafClass) && this._setLookAndFeel(lafClass, themeClass, true)) {
            ret = true;
        }
        if (!ret) {
            ret = this._setDefaultLookAndFeel(themeClass);
        }
        if (ret) {
            this.updateLookAndFeelDefaults();
        }
    }

    public IdeUIManager.ThemeInfo[] getInstalledThemes(String lafClassName) {
        if (IdeUIManagerImpl.isThemedLookAndFeelClassName(lafClassName)) {
            return this.getPlasticThemes();
        }
        return new IdeUIManager.ThemeInfo[0];
    }

    public IdeUIManager.ThemeInfo getCurrentTheme(String lafClassName) {
        if (IdeUIManagerImpl.isThemedLookAndFeelClassName(lafClassName)) {
            PlasticTheme theme = PlasticLookAndFeel.getMyCurrentTheme();
            if (theme instanceof ThemeColorScheme) {
                Theme t = Themes.getActiveTheme();
                return new IdeUIManager.ThemeInfo(t.getName(), "skin:" + t.getId());
            }
            return new IdeUIManager.ThemeInfo(theme.getName(), theme.getClass().getName());
        }
        return null;
    }

    public IdeUIManager.ThemeInfo getDefaultTheme(String lafClassName) {
        String defaultTheme = DEFAULT_THEME_NAME;
        if (IdeUIManagerImpl.isThemedLookAndFeelClassName(lafClassName)) {
            if (defaultTheme.startsWith("skin:") && defaultTheme.length() > "skin:".length()) {
                String themeName = defaultTheme.substring("skin:".length());
                Theme t = this.getTheme(themeName);
                if (t != null) {
                    return new IdeUIManager.ThemeInfo(t.getName(), defaultTheme);
                }
                defaultTheme = CLASSIC_THEME_NAME;
            }
            PlasticTheme theme = this.createPlasticTheme(defaultTheme);
            return new IdeUIManager.ThemeInfo(theme.getName(), theme.getClass().getName());
        }
        return null;
    }

    public void initialize() {
        this.registerLookAndFeelListener();
        SkyBluer.setWindowsRegistryFontSupported((boolean)IdeUIManagerImpl.isWindowsRegistryFontSupported());
        File[] f = IdeUIManagerImpl.listThemeJars();
        if (f == null || f.length == 0) {
            System.setProperty("ide.thereAreNoThemes", "true");
        }
        this.installDefaultTheme();
        ArrayList<UIManager.LookAndFeelInfo> lafs = new ArrayList<UIManager.LookAndFeelInfo>();
        lafs.add(new UIManager.LookAndFeelInfo("Oracle", OLAF2_NAME));
        if (PlatformUtils.isWindows() || PlatformUtils.isMac()) {
            String systemLafClassName = UIManager.getSystemLookAndFeelClassName();
            UIManager.LookAndFeelInfo[] curLafs = UIManager.getInstalledLookAndFeels();
            int i = 0;
            while (i < curLafs.length) {
                UIManager.LookAndFeelInfo laf = curLafs[i];
                if (ModelUtil.areEqual((Object)systemLafClassName, (Object)laf.getClassName())) {
                    lafs.add(laf);
                    break;
                }
                ++i;
            }
        }
        UIManager.setInstalledLookAndFeels(lafs.toArray(new UIManager.LookAndFeelInfo[lafs.size()]));
        if (JDK.IS_JDK15) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                Class<?> c = ge.getClass();
                Method m = c.getMethod("preferProportionalFonts", null);
                m.invoke((Object)ge, null);
            }
            catch (Exception ex) {
                System.err.println("Unable to set proportional fonts.");
            }
        }
    }

    private void registerLookAndFeelListener() {
        UIManager.addPropertyChangeListener(new 1());
    }

    private static boolean isWindowsXPorGreater() {
        return PlatformUtils.isAtLeastWindowsXP();
    }

    private static boolean isOracleLookAndFeelClassName(String className) {
        return className.equals(OLAF2_NAME);
    }

    private static boolean isPlasticLookAndFeelClassName(String className) {
        return className.equals("com.jgoodies.looks.plastic.PlasticXPLookAndFeel") || className.equals("com.jgoodies.looks.plastic.Plastic3DLookAndFeel") || className.equals("com.jgoodies.looks.plastic.PlasticLookAndFeel");
    }

    private static boolean isThemedLookAndFeelClassName(String className) {
        return IdeUIManagerImpl.isOracleLookAndFeelClassName(className) || IdeUIManagerImpl.isPlasticLookAndFeelClassName(className);
    }

    private boolean _setDefaultLookAndFeel(String theme) {
        String lafClass = PlatformUtils.isMac() ? UIManager.getSystemLookAndFeelClassName() : OLAF2_NAME;
        return this._setLookAndFeel(lafClass, theme, false);
    }

    private void installDefaultTheme() {
        Properties p = new Properties();
        BufferedInputStream bis = null;
        try {
            try {
                bis = new BufferedInputStream(IdeUIManagerImpl.class.getResource("defaulttheme.properties").openStream());
                p.load(bis);
                Themes.setDefaultTheme((Theme)new Theme(p));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _setLookAndFeel(String className, String themeClassName, boolean assertStackTrace) {
        if (!ModelUtil.hasLength((String)className)) {
            return false;
        }
        try {
            String plasticTheme;
            if (!(!IdeUIManagerImpl.isThemedLookAndFeelClassName(className) || ModelUtil.hasLength((String)(plasticTheme = System.getProperty("plastic.theme"))) && this.setPlasticTheme(plasticTheme))) {
                if (!ModelUtil.hasLength((String)themeClassName)) {
                    themeClassName = DEFAULT_THEME_NAME;
                }
                this.setPlasticTheme(themeClassName);
            }
            this._blockLookAndFeelChange = false;
            UIManager.setLookAndFeel(className);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            if (assertStackTrace) {
                Assert.printStackTrace((Throwable)ex);
            } else {
                ex.printStackTrace();
            }
        }
        finally {
            this._blockLookAndFeelChange = true;
        }
        this._blockLookAndFeelChange = true;
        return false;
    }

    private String getBaseFileName(File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            return name.substring(0, lastDot);
        }
        return null;
    }

    private IdeUIManager.ThemeInfo[] getPlasticThemes() {
        if (this._plasticThemes == null) {
            HashSet<IdeUIManager.ThemeInfo> themes = new HashSet<IdeUIManager.ThemeInfo>();
            File[] files = IdeUIManagerImpl.listThemeJars();
            if (files != null) {
                File[] fileArray = files;
                int n = 0;
                while (n < fileArray.length) {
                    File themeJar = fileArray[n];
                    String id = this.getBaseFileName(themeJar);
                    if (id != null) {
                        Theme t = this.getTheme(id);
                        themes.add(new IdeUIManager.ThemeInfo(t.getName(), "skin:" + id));
                    }
                    ++n;
                }
            }
            String[] themeClasses = new String[]{CLASSIC_THEME_NAME, "oracle.javatools.ui.internal.theme.DesertBlue", "oracle.javatools.ui.internal.theme.DesertBluer", "oracle.javatools.ui.internal.theme.DesertGreen", "oracle.javatools.ui.internal.theme.DesertRed", "oracle.javatools.ui.internal.theme.DesertYellow", "oracle.javatools.ui.internal.theme.ExperienceBlue", "oracle.javatools.ui.internal.theme.ExperienceBluer", "oracle.javatools.ui.internal.theme.ExperienceGreen", "oracle.javatools.ui.internal.theme.SkyBlue", "oracle.javatools.ui.internal.theme.SkyBluer", "oracle.javatools.ui.internal.theme.SkyGreen", "oracle.javatools.ui.internal.theme.SkyKrupp", "oracle.javatools.ui.internal.theme.SkyPink", "oracle.javatools.ui.internal.theme.SkyRed", "oracle.javatools.ui.internal.theme.SkyYellow"};
            int i = 0;
            while (i < themeClasses.length) {
                String themeClassName = themeClasses[i];
                PlasticTheme theme = this.createPlasticTheme(themeClassName);
                if (theme != null) {
                    IdeUIManager.ThemeInfo info = new IdeUIManager.ThemeInfo(theme.getName(), theme.getClass().getName());
                    themes.add(info);
                }
                ++i;
            }
            this._plasticThemes = themes.toArray(new IdeUIManager.ThemeInfo[themes.size()]);
        }
        return this._plasticThemes;
    }

    public static File[] listThemeJars() {
        File themesDir = IdeUIManagerImpl.getThemesDirectory();
        File[] files = themesDir.listFiles(new 2());
        return files;
    }

    private PlasticTheme createPlasticTheme(String className) {
        if (className.startsWith("oracle.ideimpl.plaf.theme") && className.length() > "oracle.ideimpl.plaf.theme".length()) {
            return this.createPlasticTheme(className.replace("oracle.ideimpl.plaf.theme", "oracle.javatools.ui.internal.theme"));
        }
        try {
            Class<?> themeClass = Class.forName(className);
            PlasticTheme plasticTheme = (PlasticTheme)themeClass.newInstance();
            return plasticTheme;
        }
        catch (Exception ex) {
            Assert.println((String)("Exception creating theme " + className));
            Assert.println((String)("        " + ex));
            PlasticTheme plasticTheme = null;
            return plasticTheme;
        }
    }

    private boolean setPlasticTheme(String className) {
        if (className != null && className.startsWith("skin:") && className.length() > "skin:".length()) {
            String themeName = className.substring("skin:".length());
            Theme t = this.getTheme(themeName);
            if (t == null) {
                return this.setPlasticTheme(CLASSIC_THEME_NAME);
            }
            Themes.setActiveTheme((Theme)t);
            PlasticTheme colorScheme = this.createPlasticTheme(ThemeColorScheme.class.getName());
            if (colorScheme != null) {
                PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)colorScheme);
                Ide.addIdeListener((IdeListener)new 3());
                return true;
            }
            return false;
        }
        PlasticTheme theme = this.createPlasticTheme(className);
        if (theme != null) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)theme);
            return true;
        }
        return false;
    }

    private static File getThemesDirectory() {
        return new File(Ide.getOracleHomeDirectory() + "/ide/themes/");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Theme getTheme(String themeName) {
        File themeFile = new File(IdeUIManagerImpl.getThemesDirectory() + "/" + themeName + ".jar");
        if (!themeFile.isFile()) {
            ExtensionRegistry.getExtensionRegistry().getLogger().severe("Theme " + themeFile + " is missing!");
            return null;
        }
        URL themeProperties = URLFactory.newJarURL((File)themeFile, (String)"META-INF/theme.properties");
        BufferedInputStream bis = null;
        try {
            Properties p = new Properties();
            bis = new BufferedInputStream(URLFileSystem.openInputStream((URL)themeProperties));
            p.load(bis);
            Theme result = new Theme(p);
            URLClassLoader cl = new URLClassLoader(new URL[]{themeFile.toURL()});
            result.setClassLoader((ClassLoader)cl);
            result.setId(themeName);
            Theme theme = result;
            return theme;
        }
        catch (IOException e) {
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to load theme " + themeFile, e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bis == null) return null;
        try {
            bis.close();
            return null;
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    private void updateLookAndFeelDefaults() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        Class<?> c = laf.getClass();
        String className = c.getName();
        this.updateDefaultFontSizes(laf.getID());
        this.updateBasicLookAndFeelDefaults();
        if (IdeUIManagerImpl.isOracleLookAndFeelClassName(className)) {
            this.updateOracleLookAndFeelDefaults();
        } else if (IdeUIManagerImpl.isPlasticLookAndFeelClassName(className)) {
            this.updatePlasticLookAndFeelDefaults();
        } else if (className.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
            this.updateWindowsLookAndFeelDefaults();
        } else if (className.equals("apple.laf.AquaLookAndFeel")) {
            this.updateMacOSLookAndFeelDefaults();
        }
    }

    private void updateBasicLookAndFeelDefaults() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        new StatusBar();
        Object statusBarUI = uiDefaults.get("EWTStatusBarUI");
        Object[] extraDefaults = new Object[]{"oracle.ide.controls.StatusBarControlUI", statusBarUI};
        uiDefaults.putDefaults(extraDefaults);
        String[] iconKeys = new String[]{"Tree.leafIcon", "Tree.openIcon", "Tree.closedIcon", "FileView.directoryIcon", "FileView.hardDriveIcon", "FileView.fileIcon", "FileChooser.upFolderIcon", "FileChooser.newFolderIcon", "FileChooser.listViewIcon", "FileChooser.detailsViewIcon"};
        int i = 0;
        while (i < iconKeys.length) {
            this.replaceIcon(uiDefaults, iconKeys[i]);
            ++i;
        }
        if (Boolean.getBoolean("oracle.menu.item.inset.fix")) {
            UIDefaults defs = UIManager.getDefaults();
            defs.put("MenuItem.checkIcon", new NullIcon(-8, 0));
            defs.put("Menu.checkIcon", new NullIcon(-8, 0));
            defs.put("RadioButtonMenuItem.arrowIcon", new NullIcon(0, 0));
            defs.put("CheckBoxMenuItem.arrowIcon", new NullIcon(0, 0));
        }
        this.removeF8BindingFromTable(uiDefaults);
    }

    private void removeF8BindingFromTable(UIDefaults uiDefaults) {
        Object inputMap = uiDefaults.get("Table.ancestorInputMap");
        if (!(inputMap instanceof InputMap)) {
            return;
        }
        KeyStroke ks = KeyStroke.getKeyStroke("F8");
        ((InputMap)inputMap).remove(ks);
    }

    private void updateOracleLookAndFeelDefaults() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        Options.setUseNarrowButtons((boolean)false);
        UIDefaults.ProxyLazyValue splitPaneBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicBorders", "getSplitPaneBorder");
        InsetsUIResource defaultButtonMargin = LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(1, 14, 1, 14) : new InsetsUIResource(2, 14, 2, 14);
        UIDefaults.ProxyLazyValue fileViewArchiveIcon = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getPlasticArchiveIcon");
        Object[] modifiedDefaults = new Object[]{"Menu.crossMenuMnemonic", Boolean.FALSE, "SplitPane.border", splitPaneBorder, "Button.margin", defaultButtonMargin, "ToggleButton.margin", defaultButtonMargin};
        uiDefaults.putDefaults(modifiedDefaults);
        Object[] extraDefaults = new Object[]{"oracle.ide.controls.StatusBarControlUI", "oracle.ideimpl.plaf.WindowsEWTStatusBarUI", "oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground", uiDefaults.get("control"), "oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground", uiDefaults.get("controlText"), "FileView.archiveIcon", fileViewArchiveIcon, "ToolTipUI", "oracle.javatools.ui.plaf.WordWrappingToolTipUI"};
        uiDefaults.putDefaults(extraDefaults);
        if (Themes.isThemed()) {
            int sbWidth = Themes.getActiveTheme().getGlobalProperties().getInt("scrollbar.width");
            sbWidth = Math.max(sbWidth, 10);
            uiDefaults.put("ScrollBar.width", (Object)sbWidth);
            uiDefaults.put("ScrollBarUI", "oracle.javatools.ui.plaf.theme.ThemedPlasticScrollBarUI");
            uiDefaults.put("TableHeaderUI", "oracle.javatools.ui.plaf.theme.ThemedTableHeaderUI");
            uiDefaults.put("ToolBarUI", "oracle.javatools.ui.plaf.theme.ThemedToolBarUI");
            uiDefaults.put("MenuUI", "oracle.javatools.ui.plaf.theme.ThemedMenuUI");
            uiDefaults.put("ToolBarSeparatorUI", "oracle.javatools.ui.plaf.theme.ThemedToolBarSeparatorUI");
            Color selTreeCol = Themes.getActiveTheme().getGlobalProperties().getColor("Tree.selectionUnfocusedBackground");
            if (selTreeCol != null) {
                uiDefaults.put("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground", selTreeCol);
            }
        }
    }

    private void updatePlasticLookAndFeelDefaults() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        UIDefaults.ProxyLazyValue menuBarBorder = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getPlasticMenuBarBorder");
        UIDefaults.ProxyLazyValue toolBarBorder = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getPlasticToolBarBorder");
        UIDefaults.ProxyLazyValue fileViewArchiveIcon = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getPlasticArchiveIcon");
        Object[] modifiedDefaults = new Object[]{"MenuBar.border", menuBarBorder, "ToolBar.border", toolBarBorder, "TabbedPaneUI", "javax.swing.plaf.metal.MetalTabbedPaneUI", "PasswordFieldUI", "oracle.bali.ewt.olaf2.OraclePasswordFieldUI", "TextFieldUI", "oracle.bali.ewt.olaf2.OracleTextFieldUI"};
        uiDefaults.putDefaults(modifiedDefaults);
        Object[] extraDefaults = new Object[]{"oracle.ide.controls.StatusBarControlUI", "oracle.ideimpl.plaf.WindowsEWTStatusBarUI", "oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground", uiDefaults.get("control"), "oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground", uiDefaults.get("controlText"), "FileView.archiveIcon", fileViewArchiveIcon};
        uiDefaults.putDefaults(extraDefaults);
        if (JDK.HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST) {
            uiDefaults.put("ListUI", "oracle.bali.ewt.olaf2.OracleListUI");
        }
    }

    private void updateMacOSLookAndFeelDefaults() {
        String s = "javax.swing.plaf.metal.MetalIconFactory";
        Font font = UIManager.getFont("Label.font");
        Font dirtyFont = new Font("Verdana", font.getStyle(), font.getSize());
        Object[] macDefaults = new Object[]{"FileChooser.upFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserUpFolderIcon"), "FileChooser.newFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserNewFolderIcon"), "FileChooser.detailsViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserDetailViewIcon"), "FileChooser.listViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserListViewIcon"), "Oracle.dirtyFont", dirtyFont, "Menu.shortcutKeys", null};
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        uiDefaults.putDefaults(macDefaults);
        IdeProperties props = Ide.getIdeProperties();
        props.setProperty("Ide.DefaultDialogHeight", "550");
    }

    private void updateWindowsLookAndFeelDefaults() {
        4 processor = new 4();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(processor);
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        InsetsUIResource menuInsets = new InsetsUIResource(1, 1, 1, 1);
        Color windowTextColor = uiDefaults.getColor("windowText");
        UIDefaults.ProxyLazyValue menuBarBorder = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getWindowsMenuBarBorder");
        UIDefaults.ProxyLazyValue toolBarBorder = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getWindowsToolBarBorder");
        UIDefaults.ProxyLazyValue fileViewArchiveIcon = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getWindowsArchiveIcon");
        Object[] modifiedDefaults = new Object[]{"Desktop.background", new ColorUIResource(96, 96, 96), "EditorPane.selectionBackground", new ColorUIResource(0, 0, 128), "CheckBox.foreground", windowTextColor, "Label.foreground", windowTextColor, "RadioButton.foreground", windowTextColor, "Table.focusCellForeground", windowTextColor, "Table.foreground", windowTextColor, "TitledBorder.titleColor", windowTextColor, "LabelUI", "javax.swing.plaf.metal.MetalLabelUI", "Label.disabledForeground", new ColorUIResource(153, 153, 153), "MenuBar.border", menuBarBorder, "CheckBoxMenuItem.margin", menuInsets, "Menu.margin", menuInsets, "MenuItem.margin", menuInsets, "RadioButtonMenuItem.margin", menuInsets, "ToolBar.border", toolBarBorder, "CheckBoxMenuItemUI", "oracle.ideimpl.plaf.WindowsCheckBoxMenuItemUI", "ComboBoxUI", "oracle.ideimpl.plaf.WindowsComboBoxUI", "MenuUI", "oracle.ideimpl.plaf.WindowsMenuUI", "MenuItemUI", "oracle.ideimpl.plaf.WindowsMenuItemUI", "PasswordFieldUI", "oracle.ideimpl.plaf.WindowsPasswordFieldUI", "RadioButtonMenuItemUI", "oracle.ideimpl.plaf.WindowsRadioButtonMenuItemUI", "TextFieldUI", "oracle.ideimpl.plaf.WindowsTextFieldUI", "ToolBarUI", "oracle.ideimpl.plaf.WindowsToolBarUI", "TreeUI", "oracle.ideimpl.plaf.WindowsTreeUI", "SingleRowTabbedPaneUI", "oracle.ide.controls.SingleRowTabbedPaneUI"};
        uiDefaults.putDefaults(modifiedDefaults);
        Object[] extraDefaults = new Object[]{"oracle.ide.controls.StatusBarControlUI", "oracle.ideimpl.plaf.WindowsEWTStatusBarUI", "oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground", uiDefaults.get("control"), "oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground", uiDefaults.get("controlText"), "FileView.archiveIcon", fileViewArchiveIcon};
        uiDefaults.putDefaults(extraDefaults);
        if (JDK.IS_JDK141) {
            String checkBoxMarginKey = "CheckBox.margin";
            Insets checkBoxMargin = uiDefaults.getInsets("CheckBox.margin");
            if (checkBoxMargin != null) {
                InsetsUIResource newCheckBoxMargin = new InsetsUIResource(checkBoxMargin.top, 0, checkBoxMargin.bottom, checkBoxMargin.right);
                uiDefaults.put("CheckBox.margin", newCheckBoxMargin);
            }
        }
        if (!JDK.IS_JDK142) {
            uiDefaults.put("SpinnerUI", "oracle.ideimpl.plaf.WindowsSpinnerUI");
        }
        if (JDK.HAS_BUG_4753146) {
            uiDefaults.put("Button.showMnemonics", Boolean.TRUE);
        }
        if (JDK.HAS_BUG_4674205) {
            uiDefaults.put("Table.focusCellHighlightBorder", new ColorlessDashedBorder());
            uiDefaults.put("Tree.focusBorder", new ColorlessDashedBorder());
        }
        if (JDK.HAS_BUG_4749792) {
            uiDefaults.put("SplitPane.highlight", uiDefaults.getColor("Button.highlight"));
        }
        if (JDK.HAS_BUG_4551985) {
            Object[] moreDefaults = new Object[]{"MenuBar.background", uiDefaults.get("control")};
            uiDefaults.putDefaults(moreDefaults);
        }
        if (JDK.HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST) {
            uiDefaults.put("ListUI", "oracle.ideimpl.plaf.WindowsListUI");
        }
        if (!IdeUIManagerImpl.isWindowsRegistryFontSupported()) {
            Iterator it = uiDefaults.keySet().iterator();
            while (it.hasNext()) {
                Font font;
                String key = it.next().toString();
                if (!key.toLowerCase().endsWith("font") || (font = uiDefaults.getFont(key)) == null || !font.getFontName().equalsIgnoreCase("tahoma")) continue;
                int style = font.getStyle();
                int size = font.getSize();
                FontUIResource newFont = new FontUIResource("Dialog", style, size);
                uiDefaults.put(key, newFont);
            }
        }
        if (JDK.HAS_BUG_2645826) {
            Object messageBoxFont = uiDefaults.get("OptionPane.font");
            Object wrongSystemFont = uiDefaults.get("Button.font");
            for (Map.Entry entry : uiDefaults.entrySet()) {
                Object font;
                String key = entry.getKey().toString();
                if (!key.toLowerCase().endsWith("font") || (font = entry.getValue()) != wrongSystemFont) continue;
                uiDefaults.put(key, messageBoxFont);
            }
        }
        uiDefaults.put("RadioButtonMenuItem.checkIcon", new WindowsRadioButtonMenuItemIcon(null));
        IdeUIManagerImpl.setDefaultLookAndFeelDecorated(true);
    }

    private static void setDefaultLookAndFeelDecorated(boolean decorated) {
        JDialog.setDefaultLookAndFeelDecorated(decorated);
        JFrame.setDefaultLookAndFeelDecorated(decorated);
    }

    private void replaceIcon(UIDefaults uiDefaults, Object key) {
        Icon icon = uiDefaults.getIcon(key);
        if (icon != null && !(icon instanceof ImageIcon)) {
            ImageIconUIResource newIcon = new ImageIconUIResource(icon);
            uiDefaults.put(key, newIcon);
        }
    }

    private void updateDefaultFontSizes(String lafID) {
        if (lafID == null) {
            return;
        }
        int size = this.getFontSize(lafID);
        if (size <= 0) {
            return;
        }
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Integer fontSize = size;
        Enumeration en = defaults.keys();
        while (en.hasMoreElements()) {
            Font font;
            Object key = en.nextElement();
            if (!(key instanceof String) || !((String)key).toLowerCase().endsWith("font") || (font = defaults.getFont(key)) == null || size == font.getSize()) continue;
            String fontName = font.getName();
            Integer fontStyle = font.getStyle();
            UIDefaults.ProxyLazyValue defaultFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{fontName, fontStyle, fontSize});
            defaults.put(key, defaultFont);
        }
    }

    private int getFontSize(String lafID) {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String val = null;
        if (language.length() > 0 && (val = Ide.getProperty((String)("Ide.FontSize." + lafID + "." + language))) == null) {
            val = Ide.getProperty((String)("Ide.FontSize." + language));
        }
        if (val == null && (val = Ide.getProperty((String)("Ide.FontSize." + lafID))) == null) {
            val = Ide.getProperty((String)FONT_SIZE_PROP);
        }
        if (val != null) {
            try {
                int n = Integer.parseInt(val);
                return n;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return 0;
    }

    public static Border getPlasticMenuBarBorder() {
        Border outerBorder = JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES);
        Border innerBorder = BorderFactory.createEmptyBorder(0, 1, 0, 1);
        return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
    }

    public static Border getPlasticToolBarBorder() {
        Border outerBorder = JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES);
        Border innerBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
    }

    public static Border getWindowsMenuBarBorder() {
        Border innerBorder;
        Border outerBorder;
        if (IdeUIManagerImpl.isXPStyle()) {
            outerBorder = JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES);
            innerBorder = BorderFactory.createEmptyBorder(2, 3, 2, 3);
        } else {
            outerBorder = BasicBorders.getMenuBarBorder();
            innerBorder = BorderFactory.createEmptyBorder(2, 0, 2, 0);
        }
        return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
    }

    public static Border getWindowsToolBarBorder() {
        if (IdeUIManagerImpl.isXPStyle()) {
            Border outerBorder = JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES);
            Border innerBorder = BorderFactory.createEmptyBorder(0, 2, 0, 2);
            return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
        }
        return JavatoolsBorderFactory.createBottomBorder((Color)SystemColor.controlShadow);
    }

    public static Icon getWindowsArchiveIcon() {
        return IdeUIManagerImpl.getArchiveIcon(3, 1);
    }

    public static Icon getPlasticArchiveIcon() {
        return IdeUIManagerImpl.getArchiveIcon(3, 1);
    }

    private static Icon getArchiveIcon(int xOffset, int yOffset) {
        return new OverlayIcon(UIManager.getIcon("FileView.directoryIcon"), (Icon)new ZipperIcon(xOffset, yOffset));
    }

    static boolean ra$_blockLookAndFeelChange(IdeUIManagerImpl ideUIManagerImpl) {
        return ideUIManagerImpl._blockLookAndFeelChange;
    }

    static void wa$_blockLookAndFeelChange(IdeUIManagerImpl ideUIManagerImpl, boolean bl) {
        ideUIManagerImpl._blockLookAndFeelChange = bl;
    }

    final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (!IdeUIManagerImpl.ra$_blockLookAndFeelChange(IdeUIManagerImpl.this)) {
                return;
            }
            if (!"lookAndFeel".equals(evt.getPropertyName())) {
                return;
            }
            try {
                IdeUIManagerImpl.wa$_blockLookAndFeelChange(IdeUIManagerImpl.this, false);
                LookAndFeel oldLookAndFeel = (LookAndFeel)evt.getOldValue();
                if (oldLookAndFeel != null) {
                    try {
                        UIManager.setLookAndFeel(oldLookAndFeel);
                    }
                    catch (UnsupportedLookAndFeelException e) {
                        throw new IllegalStateException(e);
                    }
                }
                SecurityException e = new SecurityException("Non-UIManager attempt to change the look and feel to " + evt.getNewValue());
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                int n = 0;
                while (n < stackTraceElementArray.length) {
                    StackTraceElement ste = stackTraceElementArray[n];
                    if (ste.getClassName().equals("abbot.util.AWTFixtureHelper")) {
                        return;
                    }
                    ++n;
                }
                FeedbackManager.reportException((Throwable)e);
            }
            finally {
                IdeUIManagerImpl.wa$_blockLookAndFeelChange(IdeUIManagerImpl.this, true);
            }
        }
    }

    static final class 2
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    }

    final class 3
    implements IdeListener {
        public void addinsLoaded(IdeEvent e) {
        }

        public void mainWindowOpened(IdeEvent e) {
            Ide.removeIdeListener((IdeListener)this);
            ((JComponent)Ide.getMainWindow().getContentPane()).setOpaque(false);
        }

        public void mainWindowClosing(IdeEvent e) {
        }
    }

    final class 4
    implements KeyEventPostProcessor {
        public boolean postProcessKeyEvent(KeyEvent e) {
            return e.isConsumed() && e.getKeyCode() == 18 && e.getID() == 401 && e.getSource() instanceof ColorChoice;
        }
    }

    private static class WindowsRadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            if (b.isSelected()) {
                g.fillRect(x + 1, y, 4, 6);
                g.fillRect(x, y + 1, 6, 4);
            }
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 6;
        }

        private WindowsRadioButtonMenuItemIcon() {
        }

        WindowsRadioButtonMenuItemIcon(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ZipperIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int H = 11;
        private static final int W = 3;
        private int xOffset;
        private int yOffset;

        public ZipperIcon() {
            this(0, 0);
        }

        public ZipperIcon(int xOffset, int yOffset) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        public int getIconWidth() {
            return 3 + this.xOffset;
        }

        public int getIconHeight() {
            return 11 + this.yOffset;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawLine((x += this.xOffset) + 1, (y += this.yOffset) + 4, x + 1, y + 4);
            int i = 5;
            while (i < 11) {
                g.drawLine(x, y + i, x, y + i);
                i += 2;
            }
            g.setColor(Color.lightGray);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.drawLine(x + 1, y + 3, x + 1, y + 3);
            int i2 = 4;
            while (i2 < 11) {
                g.drawLine(x, y + i2, x, y + i2);
                g.drawLine(x + 2, y + i2, x + 2, y + i2);
                i2 += 2;
            }
            g.setColor(Color.gray);
            g.drawLine(x + 1, y, x + 1, y);
            g.drawLine(x, y + 1, x, y + 3);
            g.drawLine(x + 1, y + 5, x + 1, y + 11);
            g.setColor(Color.darkGray);
            g.drawLine(x + 2, y + 1, x + 2, y + 3);
            int i3 = 5;
            while (i3 < 11) {
                g.drawLine(x + 2, y + i3, x + 2, y + i3);
                i3 += 2;
            }
            g.setColor(Color.white);
            g.drawLine(x + 1, y + 2, x + 1, y + 2);
        }
    }

    private static class PatchedLayoutFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        protected boolean accept(Component aComponent) {
            return aComponent instanceof JScrollBar ? false : super.accept(aComponent);
        }

        private PatchedLayoutFocusTraversalPolicy() {
        }

        PatchedLayoutFocusTraversalPolicy(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ColorlessDashedBorder
    extends LineBorder
    implements UIResource {
        public ColorlessDashedBorder() {
            super(null, 1);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BasicGraphicsUtils.drawDashedRect(g, x, y, width, height);
        }
    }
}

