/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.ide.IdeArgs;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;
import oracle.ide.log.QueuedLoggingHandler;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.DefaultIdeCore;
import oracle.ideimpl.DefaultIdeStarter;
import oracle.ideri.util.Product;

public final class Main {
    private Main() {
    }

    private static void setupLogging() {
        if (System.getProperty("java.util.logging.config.class") != null) {
            return;
        }
        if (System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        if (Boolean.getBoolean("ide.standard.logging")) {
            return;
        }
        boolean debug = Boolean.getBoolean("ide.debugbuild");
        File configFile = new File(new File(System.getProperty("user.dir")), "logging" + (debug ? "-debug" : "") + ".conf");
        if (!configFile.exists()) {
            return;
        }
        BufferedInputStream bis = null;
        try {
            try {
                bis = new BufferedInputStream(new FileInputStream(configFile));
                LogManager.getLogManager().readConfiguration(bis);
                QueuedLoggingHandler qHandler = new QueuedLoggingHandler();
                qHandler.setLevel(Level.INFO);
                Logger.global.getParent().addHandler((Handler)qHandler);
            }
            catch (IOException e) {
                System.err.println("Failed to load IDE logging configuration " + configFile);
                e.printStackTrace();
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void main(String[] args) {
        Main.setupLogging();
        long start = System.nanoTime();
        new Main().start(args);
        PerformanceLogger.get().log("startupTime", "", System.nanoTime() - start);
    }

    private void start(String[] arguments) {
        try {
            DefaultIdeStarter starter;
            String productID = Product.getProductID();
            if (productID == null) {
                productID = "oracle.ide";
            }
            String command = System.getProperty("ide.command");
            String starterTypeName = System.getProperty("ide.starter.class");
            if (starterTypeName != null) {
                Class<?> type = Class.forName(starterTypeName);
                starter = (IdeStarter)type.newInstance();
            } else {
                starter = new DefaultIdeStarter();
            }
            DefaultIdeCore ideCore = new DefaultIdeCore(new IdeArgs(arguments), productID);
            starter.startIde(command, arguments, ideCore);
            String runnerTypeName = System.getProperty("ide.runner.class");
            if (runnerTypeName != null) {
                ClassLoader extensionClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> type = Class.forName(runnerTypeName, true, extensionClassLoader);
                IdeRunner runner = (IdeRunner)type.newInstance();
                runner.runCommand((IdeStarter)starter);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

