/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.condition;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.Condition;
import oracle.ideimpl.condition.ConditionSpec;

public class ConditionManager {
    private static Map<String, Class> conditions = new LinkedHashMap<String, Class>();
    private static Map<String, ConditionSpec> specs = new LinkedHashMap<String, ConditionSpec>();

    private ConditionManager() {
    }

    public static Condition newInstance(ConditionSpec spec) {
        Class conditionClass = ConditionManager.getConditionClass(spec);
        Condition condition = ConditionManager.newConditionInstance(conditionClass);
        ConditionManager.setConditionParameters(spec, condition);
        return condition;
    }

    public static Condition newInstance(String id) {
        Class conditionClass = null;
        ConditionSpec spec = null;
        if (id != null) {
            conditionClass = conditions.get(id);
            spec = specs.get(id);
            if (conditionClass == null) {
                if (spec != null) {
                    conditionClass = ConditionManager.getConditionClass(spec);
                    conditions.put(id, conditionClass);
                } else {
                    throw new RuntimeException("There is no condition with id '" + id + "'");
                }
            }
        }
        Condition condition = ConditionManager.newConditionInstance(conditionClass);
        ConditionManager.setConditionParameters(spec, condition);
        return condition;
    }

    public static void addConditionSpec(String id, ConditionSpec spec) {
        if (id != null) {
            spec.setId(id);
            specs.put(id, spec);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class getConditionClass(ConditionSpec spec) {
        Class conditionClass = null;
        if (spec.getId() != null) {
            conditionClass = conditions.get(spec.getId());
            if (conditionClass != null) return conditionClass;
            ConditionSpec tmpspec = specs.get(spec.getId());
            if (tmpspec == null) throw new RuntimeException("There is no condition with id '" + spec.getId() + "'");
            return ConditionManager.newInstanceFromClassname(tmpspec.getClassname());
        }
        if (spec.getClassname() == null) throw new RuntimeException("Must specify 'id' or 'classname'");
        return ConditionManager.newInstanceFromClassname(spec.getClassname());
    }

    private static void setConditionParameters(ConditionSpec spec, Condition condition) {
        BeanInfo conditionBeanInfo = null;
        try {
            conditionBeanInfo = Introspector.getBeanInfo(condition.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e.getMessage());
        }
        PropertyDescriptor[] propertyDescriptors = conditionBeanInfo.getPropertyDescriptors();
        Map<String, String> parameters = spec.getParameters();
        block5: for (Map.Entry<String, String> param : parameters.entrySet()) {
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor pd = propertyDescriptorArray[n];
                if (pd.getName().compareToIgnoreCase(param.getKey()) == 0) {
                    try {
                        pd.getWriteMethod().invoke((Object)condition, param.getValue());
                        continue block5;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
                ++n;
            }
        }
    }

    private static Condition newConditionInstance(Class conditionClass) {
        Condition condition = null;
        try {
            condition = (Condition)conditionClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        return condition;
    }

    private static Class newInstanceFromClassname(String classname) {
        try {
            Class<?> clazz = Class.forName(classname);
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe.getMessage());
        }
    }
}

