/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import oracle.ide.Condition;
import oracle.ide.Context;
import oracle.ide.controller.ActionCondition;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ideimpl.condition.ConditionManager;
import oracle.ideimpl.condition.ConditionSpec;

class CommandInvokingController
implements Controller {
    private ActionCondition condition;
    private ConditionSpec conditionSpec;
    private String commandClass;
    private Command command;

    public CommandInvokingController(ConditionSpec conditionSpec, String commandClass) {
        this.conditionSpec = conditionSpec;
        this.commandClass = commandClass;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (this.command == null) {
            this.command = CommandProcessor.createCommand((String)this.commandClass, (Context)context);
        }
        this.command.setContext(context);
        try {
            CommandProcessor.getInstance().invoke(this.command);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        if (this.condition == null) {
            Condition tmpCondition = ConditionManager.newInstance(this.conditionSpec);
            this.condition = !(tmpCondition instanceof ActionCondition) ? new ActionConditionWrapper(tmpCondition, null) : (ActionCondition)tmpCondition;
        }
        if (this.condition.evaluate(context)) {
            this.condition.updateState(context, action);
        }
        return true;
    }

    private class ActionConditionWrapper
    implements ActionCondition {
        private Condition condition;

        private ActionConditionWrapper(Condition condition) {
            this.condition = condition;
        }

        public void updateState(Context context, IdeAction action) {
            action.setEnabled(true);
        }

        public boolean evaluate(Context context) {
            return this.condition.evaluate(context);
        }

        ActionConditionWrapper(Condition condition, 1 var3_3) {
            this(condition);
        }

        public final class 1 {
        }
    }
}

