/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextAwareLabelUpdater;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.PropertyResolver;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.javaxide.Util;
import oracle.ideimpl.condition.ConditionSpec;
import oracle.ideimpl.controller.CommandInvokingController;
import oracle.javatools.icons.OracleIcons;

public final class IdeActionHook
extends ExtensionHook {
    private static final Logger LOGGER = Logger.getLogger(IdeActionHook.class.getName());
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "actions");
    private static final ElementName ACTION = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "action");
    private static final ElementName PROPERTIES = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "properties");
    private static final ElementName PROPERTY = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "property");
    private static final ElementName CONTROLLER_CLASS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "controller-class");
    private static final ElementName COMMAND_CLASS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "command-class");
    private static final ElementName COMMANDS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "commands");
    private static final ElementName COMMAND = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "command");
    private static final ElementName CONDITION = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "condition");
    private static final ElementName PARAMETER = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "parameter");
    private static final ElementName LABEL_UPDATER = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "label-updater");
    private static final ElementName LABEL_WHEN_ENABLED = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "when-enabled");
    private static final ElementName LABEL_WHEN_DISABLED = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "when-disabled");
    private static final ElementName LABEL_UPDATER_CLASS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "label-updater-class");
    private static final String KEY_ACTION = "oide_action";
    private static final String KEY_RESOLVER = "oide_action_resolver";
    private static final String KEY_COMMAND = "oide_action_command";
    private static final String KEY_CONDITION_SPEC = "oide_action_condition_spec";
    private static final String KEY_UPDATER_INFO = "oide_action_label_updater";
    private static final String KEY_LABEL_WHEN_ENABLED_FORMAT = "oide_action_label_when_enabled_format";
    private static final String KEY_LABEL_WHEN_DISABLED_FORMAT = "oide_action_label_when_disabled_format";
    private final ElementVisitor _actionVisitor;
    private final ElementVisitor _propertiesVisitor;
    private final ElementVisitor _propertyVisitor;
    private final ElementVisitor _controllerVisitor;
    private final ElementVisitor _commandClassVisitor;
    private final ElementVisitor _commandsVisitor;
    private final ElementVisitor _commandVisitor;
    private final ElementVisitor _conditionVisitor;
    private final ElementVisitor _parameterVisitor;
    private final ElementVisitor _labelUpdaterVisitor;
    private final ElementVisitor _labelWhenEnabledVisitor;
    private final ElementVisitor _labelWhenDisabledVisitor;
    private Map<String, DeclarativeAction> _actions;

    private void $init$() {
        this._actionVisitor = new ActionVisitor(null);
        this._propertiesVisitor = new PropertiesVisitor(null);
        this._propertyVisitor = new PropertyVisitor(null);
        this._controllerVisitor = new ControllerVisitor(null);
        this._commandClassVisitor = new CommandClassVisitor(null);
        this._commandsVisitor = new CommandsVisitor(null);
        this._commandVisitor = new CommandVisitor(null);
        this._conditionVisitor = new ConditionVisitor(null);
        this._parameterVisitor = new ParameterVisitor(null);
        this._labelUpdaterVisitor = new LabelUpdaterVisitor(null);
        this._labelWhenEnabledVisitor = new LabelActionVisitor(KEY_LABEL_WHEN_ENABLED_FORMAT);
        this._labelWhenDisabledVisitor = new LabelActionVisitor(KEY_LABEL_WHEN_DISABLED_FORMAT);
        this._actions = new HashMap<String, DeclarativeAction>();
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ACTION, this._actionVisitor);
    }

    public void end(ElementEndContext context) {
    }

    void installActions() {
        for (DeclarativeAction action : this._actions.values()) {
            action.installAction();
        }
        this._actions.clear();
    }

    public IdeActionHook() {
        this.$init$();
    }

    static Map ra$_actions(IdeActionHook ideActionHook) {
        return ideActionHook._actions;
    }

    static ElementName ra$PROPERTIES() {
        return PROPERTIES;
    }

    static ElementVisitor ra$_propertiesVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._propertiesVisitor;
    }

    static ElementName ra$COMMANDS() {
        return COMMANDS;
    }

    static ElementVisitor ra$_commandsVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._commandsVisitor;
    }

    static ElementName ra$CONTROLLER_CLASS() {
        return CONTROLLER_CLASS;
    }

    static ElementVisitor ra$_controllerVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._controllerVisitor;
    }

    static ElementName ra$COMMAND_CLASS() {
        return COMMAND_CLASS;
    }

    static ElementVisitor ra$_commandClassVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._commandClassVisitor;
    }

    static ElementName ra$LABEL_UPDATER() {
        return LABEL_UPDATER;
    }

    static ElementVisitor ra$_labelUpdaterVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._labelUpdaterVisitor;
    }

    static ElementName ra$PROPERTY() {
        return PROPERTY;
    }

    static ElementVisitor ra$_propertyVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._propertyVisitor;
    }

    static ElementName ra$COMMAND() {
        return COMMAND;
    }

    static ElementVisitor ra$_commandVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._commandVisitor;
    }

    static ElementName ra$CONDITION() {
        return CONDITION;
    }

    static ElementVisitor ra$_conditionVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._conditionVisitor;
    }

    static ElementName ra$PARAMETER() {
        return PARAMETER;
    }

    static ElementVisitor ra$_parameterVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._parameterVisitor;
    }

    static Logger ra$LOGGER() {
        return LOGGER;
    }

    static ElementName ra$LABEL_WHEN_ENABLED() {
        return LABEL_WHEN_ENABLED;
    }

    static ElementVisitor ra$_labelWhenEnabledVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._labelWhenEnabledVisitor;
    }

    static ElementName ra$LABEL_WHEN_DISABLED() {
        return LABEL_WHEN_DISABLED;
    }

    static ElementVisitor ra$_labelWhenDisabledVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._labelWhenDisabledVisitor;
    }

    private final class ActionVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            if (id == null || (id = id.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'id'.");
                return;
            }
            if (IdeActionHook.ra$_actions(IdeActionHook.this).containsKey(id)) {
                this.log((ElementContext)context, Level.SEVERE, "Duplicate action id: " + id);
                return;
            }
            Integer cmdIdInteger = Ide.findCmdID((String)id);
            if (cmdIdInteger != null && cmdIdInteger > 82) {
                this.log((ElementContext)context, Level.SEVERE, "Duplicate action id: " + id);
                return;
            }
            DeclarativeAction action = new DeclarativeAction(id);
            IdeActionHook.ra$_actions(IdeActionHook.this).put(id, action);
            ClassLoader cl = (ClassLoader)context.getScopeData().get("classLoader");
            String bundleClass = (String)context.getScopeData().get("rsbundleclass");
            DeclarativeResolver resolver = new DeclarativeResolver(cl, bundleClass);
            action.setPropertyResolver(resolver);
            context.getScopeData().put(IdeActionHook.KEY_RESOLVER, resolver);
            context.getScopeData().put(IdeActionHook.KEY_ACTION, action);
            context.registerChildVisitor(IdeActionHook.ra$PROPERTIES(), IdeActionHook.ra$_propertiesVisitor(IdeActionHook.this));
            context.registerChildVisitor(IdeActionHook.ra$COMMANDS(), IdeActionHook.ra$_commandsVisitor(IdeActionHook.this));
            context.registerChildVisitor(IdeActionHook.ra$CONTROLLER_CLASS(), IdeActionHook.ra$_controllerVisitor(IdeActionHook.this));
            context.registerChildVisitor(IdeActionHook.ra$COMMAND_CLASS(), IdeActionHook.ra$_commandClassVisitor(IdeActionHook.this));
            context.registerChildVisitor(IdeActionHook.ra$LABEL_UPDATER(), IdeActionHook.ra$_labelUpdaterVisitor(IdeActionHook.this));
        }

        public void end(ElementEndContext context) {
            super.end(context);
        }

        private ActionVisitor() {
        }

        ActionVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class PropertiesVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(IdeActionHook.ra$PROPERTY(), IdeActionHook.ra$_propertyVisitor(IdeActionHook.this));
        }

        private PropertiesVisitor() {
        }

        PropertiesVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CommandsVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(IdeActionHook.ra$COMMAND(), IdeActionHook.ra$_commandVisitor(IdeActionHook.this));
        }

        private CommandsVisitor() {
        }

        CommandsVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CommandVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.getScopeData().put(IdeActionHook.KEY_COMMAND, new ConditionCommandSpec(null));
            context.registerChildVisitor(IdeActionHook.ra$CONDITION(), IdeActionHook.ra$_conditionVisitor(IdeActionHook.this));
            context.registerChildVisitor(IdeActionHook.ra$COMMAND_CLASS(), IdeActionHook.ra$_commandClassVisitor(IdeActionHook.this));
        }

        public void end(ElementEndContext context) {
            ConditionCommandSpec command = (ConditionCommandSpec)context.getScopeData().get(IdeActionHook.KEY_COMMAND);
            CommandInvokingController controller = new CommandInvokingController(command.getConditionSpec(), command.getCommandClass());
            DeclarativeAction action = (DeclarativeAction)context.getScopeData().get(IdeActionHook.KEY_ACTION);
            action.addController(controller);
        }

        private CommandVisitor() {
        }

        CommandVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ConditionVisitor
    extends ElementVisitor {
        private String _id;
        private String _classname;

        private void $init$() {
            this._id = null;
            this._classname = null;
        }

        public void start(ElementStartContext context) {
            this._id = null;
            this._classname = null;
            String id = context.getAttributeValue("id");
            String classname = context.getAttributeValue("classname");
            if (id == null && classname == null) {
                this.log((ElementContext)context, Level.SEVERE, "Either attribute 'id' or 'classname' must be specified.");
                return;
            }
            if (id != null) {
                if ((id = id.trim()).length() != 0) {
                    this._id = id;
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "Attribute 'id' has an invalid value.");
                    return;
                }
            }
            if (classname != null) {
                if ((classname = classname.trim()).length() != 0) {
                    this._classname = classname;
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "Attribute 'classname' has an invalid value.");
                    return;
                }
            }
            ConditionSpec conditionSpec = new ConditionSpec();
            conditionSpec.setId(this._id);
            conditionSpec.setClassname(this._classname);
            context.getScopeData().put(IdeActionHook.KEY_CONDITION_SPEC, conditionSpec);
            context.registerChildVisitor(IdeActionHook.ra$PARAMETER(), IdeActionHook.ra$_parameterVisitor(IdeActionHook.this));
        }

        public void end(ElementEndContext context) {
            ConditionSpec conditionSpec = (ConditionSpec)context.getScopeData().get(IdeActionHook.KEY_CONDITION_SPEC);
            ConditionCommandSpec command = (ConditionCommandSpec)context.getScopeData().get(IdeActionHook.KEY_COMMAND);
            if (command.getConditionSpec() == null) {
                command.setConditionSpec(conditionSpec);
                context.getScopeData().remove(IdeActionHook.KEY_CONDITION_SPEC);
            }
        }

        private ConditionVisitor() {
            this.$init$();
        }

        ConditionVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ParameterVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String _name = null;
            String _value = null;
            String name = context.getAttributeValue("name");
            if (name == null || (name = name.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'name'.");
                return;
            }
            _name = name;
            String value = context.getAttributeValue("value");
            if (name == null) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'value'.");
                return;
            }
            _value = value;
            ConditionSpec conditionSpec = null;
            conditionSpec = context.getScopeData().put(IdeActionHook.KEY_CONDITION_SPEC, conditionSpec);
            conditionSpec.setParameter(_name, _value);
        }

        private ParameterVisitor() {
        }

        ParameterVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class PropertyVisitor
    extends ElementVisitor {
        private String _rskey;
        private String _name;

        private void $init$() {
            this._rskey = null;
            this._name = null;
        }

        public void start(ElementStartContext context) {
            this._rskey = null;
            this._name = null;
            String name = context.getAttributeValue("name");
            if (name == null || (name = name.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'name'.");
                return;
            }
            this._name = name;
            this._rskey = context.getAttributeValue("rskey");
            if (this._rskey != null) {
                this._rskey = this._rskey.trim();
            }
        }

        public void end(ElementEndContext context) {
            if (this._name != null) {
                DeclarativeResolver resolver = (DeclarativeResolver)((Object)context.getScopeData().get(IdeActionHook.KEY_RESOLVER));
                if (this._rskey != null) {
                    DeclarativeResolver.mav$put(resolver, this._name, resolver.createResString(this._rskey));
                } else if (context.getText() == null || context.getText().trim().length() == 0) {
                    this.log((ElementContext)context, Level.WARNING, "Value expected for property '" + this._name + "'.");
                } else {
                    String text = context.getText().trim();
                    if (text.startsWith("uri:") && text.length() > 4) {
                        URI uri = URIFactory.newURI((String)text.substring(4));
                        try {
                            DeclarativeResolver.mav$put(resolver, this._name, VirtualFileSystem.getVirtualFileSystem().toURL(uri));
                        }
                        catch (MalformedURLException e) {
                            FeedbackManager.reportException((String)"Unexpected MalformedURLException", (Throwable)e);
                        }
                    } else {
                        DeclarativeResolver.mav$put(resolver, this._name, context.getText().trim());
                    }
                }
            }
        }

        private PropertyVisitor() {
            this.$init$();
        }

        PropertyVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class MetaClassController
    implements Controller {
        private final MetaClass _metaClass;
        private Controller _delegate;

        private void $init$() {
            this._delegate = null;
        }

        MetaClassController(MetaClass mc) {
            this.$init$();
            this._metaClass = mc;
        }

        private Controller getDelegate() {
            if (this._delegate == null) {
                this._delegate = (Controller)Util.createInstance((MetaClass)this._metaClass, Controller.class);
                if (this._delegate == null) {
                    this._delegate = new 1();
                }
            }
            return this._delegate;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            return this.getDelegate().handleEvent(action, context);
        }

        public boolean update(IdeAction action, Context context) {
            Controller delegate = this.getDelegate();
            boolean result = delegate.update(action, context);
            if (result) {
                action.putValue("controller-handling-update", (Object)delegate.getClass().getName());
            }
            return result;
        }

        final class 1
        implements Controller {
            public boolean handleEvent(IdeAction action, Context context) {
                return false;
            }

            public boolean update(IdeAction action, Context context) {
                return false;
            }
        }
    }

    private static final class DeclarativeResolver
    extends PropertyResolver {
        private ClassLoader _resLoader;
        private String _resBundleClass;
        private final Map _properties;

        private void $init$() {
            this._resLoader = null;
            this._resBundleClass = null;
            this._properties = new HashMap();
        }

        DeclarativeResolver(ClassLoader resLoader, String resClass) {
            this.$init$();
            this._resLoader = resLoader;
            this._resBundleClass = resClass;
        }

        public Object get(String propertyName) {
            Object value = this._properties.get(propertyName);
            if (value instanceof ResString) {
                value = ((ResString)value).get();
            }
            if ("SmallIcon".equals(propertyName) && !(value instanceof Icon)) {
                if (value == null) {
                    return null;
                }
                Icon result = null;
                if (value instanceof URL) {
                    ImageIcon icon = new ImageIcon((URL)value);
                    if (icon.getImageLoadStatus() != 8) {
                        IdeActionHook.ra$LOGGER().severe("Failed to load icon for URL: " + value);
                    } else {
                        result = icon;
                    }
                } else {
                    String sValue = (String)value;
                    if (sValue.startsWith("OracleIcons.")) {
                        String iconName = sValue.substring(12).toUpperCase();
                        try {
                            Field f = OracleIcons.class.getDeclaredField(iconName);
                            String fValue = (String)f.get(null);
                            result = OracleIcons.getIcon((String)fValue);
                        }
                        catch (Exception e) {
                            IdeActionHook.ra$LOGGER().log(Level.SEVERE, "Error loading icon ", e);
                        }
                    } else {
                        ResourceBundle bundle = this.getBundle();
                        URL res = bundle.getClass().getResource((String)value);
                        if (res == null) {
                            IdeActionHook.ra$LOGGER().severe("Failed to load icon " + value + ". Base class was " + bundle.getClass());
                        } else {
                            result = new ImageIcon(res);
                        }
                    }
                }
                return result;
            }
            if (("Check".equals(propertyName) || "State".equals(propertyName) || "Radio".equals(propertyName)) && !(value instanceof Boolean)) {
                Boolean booleanValue = Boolean.valueOf((String)value);
                return booleanValue;
            }
            if ("MnemonicKey".equals(propertyName) && !(value instanceof Integer)) {
                if (value == null) {
                    Object label = this._properties.get("Name");
                    if (label instanceof ResString) {
                        label = ((ResString)label).get();
                    }
                    if (label != null) {
                        int keycode = StringUtils.getMnemonicKeyCode((String)label.toString());
                        if (keycode == 0) {
                            return 0;
                        }
                        return keycode;
                    }
                } else {
                    if (((String)value).length() > 0) {
                        char c = ((String)value).charAt(0);
                        value = (int)c;
                        return value;
                    }
                    return 0;
                }
            }
            if ("Name".equals(propertyName)) {
                return StringUtils.stripMnemonic((String)((String)value));
            }
            return value;
        }

        private void put(Object key, Object value) {
            this._properties.put(key, value);
        }

        private ResourceBundle getBundle() {
            if (this._resLoader == null) {
                this._resLoader = Thread.currentThread().getContextClassLoader();
            }
            return ResourceBundle.getBundle(this._resBundleClass, Locale.getDefault(), this._resLoader);
        }

        ResString createResString(String key) {
            return new ResString(key);
        }

        static void mav$put(DeclarativeResolver declarativeResolver, Object object, Object object2) {
            declarativeResolver.put(object, object2);
        }

        static ResourceBundle mav$getBundle(DeclarativeResolver declarativeResolver) {
            return declarativeResolver.getBundle();
        }

        private class ResString {
            private final String _key;

            ResString(String key) {
                this._key = key;
            }

            public String get() {
                ResourceBundle bundle = DeclarativeResolver.mav$getBundle(DeclarativeResolver.this);
                return bundle.getString(this._key);
            }
        }
    }

    private final class ControllerVisitor
    extends MetaClassVisitor {
        protected void metaClass(ElementContext context, MetaClass mc) {
            DeclarativeAction action = (DeclarativeAction)context.getScopeData().get(IdeActionHook.KEY_ACTION);
            action.addController(new MetaClassController(mc));
        }

        private ControllerVisitor() {
        }

        ControllerVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CommandClassVisitor
    extends MetaClassVisitor {
        protected void metaClass(ElementContext context, MetaClass mc) {
            DeclarativeAction action = (DeclarativeAction)context.getScopeData().get(IdeActionHook.KEY_ACTION);
            ConditionCommandSpec command = (ConditionCommandSpec)context.getScopeData().get(IdeActionHook.KEY_COMMAND);
            if (command != null && command.getCommandClass() == null) {
                command.setCommandClass(mc.getClassName());
            } else {
                action.setCommandClass(mc.getClassName());
            }
        }

        private CommandClassVisitor() {
        }

        CommandClassVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class LabelUpdaterVisitor
    extends ElementVisitor {
        private String _labelUpdaterClass;

        public void start(ElementStartContext context) {
            this._labelUpdaterClass = context.getAttributeValue("class");
            if (this._labelUpdaterClass != null && (this._labelUpdaterClass = this._labelUpdaterClass.trim()).length() == 0) {
                this._labelUpdaterClass = null;
            }
            context.getScopeData().put(IdeActionHook.KEY_UPDATER_INFO, new HashMap());
            context.registerChildVisitor(IdeActionHook.ra$LABEL_WHEN_ENABLED(), IdeActionHook.ra$_labelWhenEnabledVisitor(IdeActionHook.this));
            context.registerChildVisitor(IdeActionHook.ra$LABEL_WHEN_DISABLED(), IdeActionHook.ra$_labelWhenDisabledVisitor(IdeActionHook.this));
        }

        public void end(ElementEndContext context) {
            Map labelUpdateInfo = (Map)context.getScopeData().get(IdeActionHook.KEY_UPDATER_INFO);
            Object labelUpdater = null;
            labelUpdater = this._labelUpdaterClass != null ? new DefaultLabelUpdater(this._labelUpdaterClass) : new ContextAwareLabelUpdater();
            labelUpdater.setEnabledFormat((String)labelUpdateInfo.get(IdeActionHook.KEY_LABEL_WHEN_ENABLED_FORMAT));
            labelUpdater.setDisabledFormat((String)labelUpdateInfo.get(IdeActionHook.KEY_LABEL_WHEN_DISABLED_FORMAT));
            DeclarativeAction action = (DeclarativeAction)context.getScopeData().get(IdeActionHook.KEY_ACTION);
            action.setLabelUpdater((LabelUpdater)labelUpdater);
        }

        private LabelUpdaterVisitor() {
        }

        LabelUpdaterVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class LabelActionVisitor
    extends ElementVisitor {
        private String _formatKey;

        public LabelActionVisitor(String formatKey) {
            this._formatKey = formatKey;
        }

        public void start(ElementStartContext context) {
            String format = context.getAttributeValue("format");
            if (format == null) {
                this.log((ElementContext)context, Level.SEVERE, "Attribute 'format' must be specified.");
                return;
            }
            if ((format = format.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Attribute 'format' has an invalid value.");
                return;
            }
            Map labelUpdateInfo = (Map)context.getScopeData().get(IdeActionHook.KEY_UPDATER_INFO);
            labelUpdateInfo.put(this._formatKey, format);
        }
    }

    private class DeclarativeAction {
        private String _id;
        private PropertyResolver _resolver;
        private Collection<Controller> _controllers;
        private String _commandClass;
        private LabelUpdater _labelUpdater;

        private void $init$() {
            this._controllers = new ArrayList<Controller>();
        }

        DeclarativeAction(String id) {
            this.$init$();
            this._id = id;
        }

        public void setPropertyResolver(PropertyResolver pr) {
            this._resolver = pr;
        }

        public void setLabelUpdater(LabelUpdater labelUpdater) {
            this._labelUpdater = labelUpdater;
        }

        public void addController(Controller c) {
            this._controllers.add(c);
        }

        public void setCommandClass(String commandClass) {
            this._commandClass = commandClass;
        }

        void installAction() {
            int cmdId = Ide.findOrCreateCmdID((String)this._id);
            IdeAction action = IdeAction.get((int)cmdId);
            action.addPropertyResolver(this._resolver);
            for (Controller c : this._controllers) {
                action.addController(c);
            }
            if (this._commandClass != null) {
                action.setCommand(this._commandClass);
            }
            if (action.getLabelUpdater() == null) {
                action.setLabelUpdater(this._labelUpdater);
            } else {
                IdeActionHook.ra$LOGGER().log(Level.WARNING, "Tried to override previous value for labelUpdater");
            }
        }
    }

    private static class ConditionCommandSpec {
        private ConditionSpec conditionSpec;
        private String commandClass;

        public void setCommandClass(String commandClass) {
            this.commandClass = commandClass;
        }

        public String getCommandClass() {
            return this.commandClass;
        }

        public void setConditionSpec(ConditionSpec conditionSpec) {
            this.conditionSpec = conditionSpec;
        }

        public ConditionSpec getConditionSpec() {
            return this.conditionSpec;
        }

        private ConditionCommandSpec() {
        }

        ConditionCommandSpec(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class DefaultLabelUpdater
    implements LabelUpdater {
        private String _labelUpdaterClass;
        private LabelUpdater _labelUpdater;
        private String _enabledFormat;
        private String _disabledFormat;

        public DefaultLabelUpdater(String labelUpdaterClass) {
            this._labelUpdaterClass = labelUpdaterClass;
        }

        public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
            if (this._labelUpdater == null) {
                this.createLabelUpdater();
            }
            this.setFormatsOnLabelUpdaterDelegate();
            return this._labelUpdater.labelWhenEnabled(context, action, originalLabel);
        }

        public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
            if (this._labelUpdater == null) {
                this.createLabelUpdater();
            }
            this.setFormatsOnLabelUpdaterDelegate();
            return this._labelUpdater.labelWhenDisabled(context, action, originalLabel);
        }

        public void setEnabledFormat(String format) {
            this._enabledFormat = format;
        }

        public void setDisabledFormat(String format) {
            this._disabledFormat = format;
        }

        private void createLabelUpdater() {
            try {
                Class<?> klass = Class.forName(this._labelUpdaterClass);
                this._labelUpdater = (LabelUpdater)klass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private void setFormatsOnLabelUpdaterDelegate() {
            this._labelUpdater.setEnabledFormat(this._enabledFormat);
            this._labelUpdater.setDisabledFormat(this._disabledFormat);
        }
    }
}

