/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.TabbedWindow;
import oracle.ide.controls.TabbedWindowEvent;
import oracle.ide.controls.TabbedWindowListener;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.log.LogPage;
import oracle.ideimpl.controls.SwitchablePanel;

public final class FlatTabbedWindow
extends TabbedWindow
implements ListSelectionListener {
    private SwitchablePanel _switchablePanel;

    private void $init$() {
        this._switchablePanel = new SwitchablePanel();
    }

    public FlatTabbedWindow() {
        this(true);
    }

    public FlatTabbedWindow(boolean showCloseButtonOnTabs) {
        this.$init$();
        this._switchablePanel.getCustomTab().addSelectionListener((ListSelectionListener)this);
        this._switchablePanel.getCustomTab().setMinTabWidth(30);
        if (showCloseButtonOnTabs) {
            this._switchablePanel.getCustomTab().setCloseAction((Action)new TabCloseAction());
            this._switchablePanel.getCustomTab().setCtrlClickCloseEnabled(true);
        }
        this.setLayout(new BorderLayout());
        this.add(this._switchablePanel, "Center");
    }

    public final void add(String name, Icon icon, Component gui, String tooltip, Object data) {
        this.add(name, icon, gui, tooltip, data, true);
    }

    public final void add(String name, Icon icon, Component gui, String tooltip, Object data, boolean takeFocus) {
        this._switchablePanel.addPage(name, icon, gui, tooltip, data);
        this.setActive(gui, takeFocus);
    }

    public void removeComponent(Component component) {
        DefaultCustomTabPage tabPage = this._switchablePanel.getTabPageForComponent(component);
        this._switchablePanel.removePage((CustomTabPage)tabPage);
    }

    public void setActive(Component component) {
        this.setActive(component, true);
    }

    public void setActive(Component component, boolean takeFocus) {
        DefaultCustomTabPage tabPage = this._switchablePanel.getTabPageForComponent(component);
        CustomTab customTab = this._switchablePanel.getCustomTab();
        customTab.setSelectedPage(customTab.searchPage((CustomTabPage)tabPage));
        this._switchablePanel.moveToFront((CustomTabPage)tabPage, takeFocus);
    }

    public Object getActiveData() {
        int index;
        CustomTab customTab = this._switchablePanel.getCustomTab();
        if (customTab != null && (index = customTab.getSelectedPage()) > -1) {
            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)customTab.getPage(index);
            return tabPage.getUserObject();
        }
        return null;
    }

    public int getCount() {
        return this._switchablePanel.getPageCount();
    }

    public void navigateLeft() {
        int index;
        CustomTab customTab = this._switchablePanel.getCustomTab();
        if (customTab != null && (index = customTab.getSelectedPage()) - 1 >= 0) {
            customTab.setSelectedPage(index - 1);
        }
    }

    public void navigateRight() {
        int index;
        CustomTab customTab = this._switchablePanel.getCustomTab();
        if (customTab != null && (index = customTab.getSelectedPage()) + 1 <= this.getCount() - 1) {
            customTab.setSelectedPage(index + 1);
        }
    }

    public void displayDropdownMenu() {
        this._switchablePanel.displayDropdownMenu();
    }

    public void highlightPage(LogPage page) {
        CustomTab customTab = this._switchablePanel.getCustomTab();
        int pageCount = customTab.getPageCount();
        int i = 0;
        while (i < pageCount) {
            Object userObject;
            CustomTabPage tabPage = customTab.getPage(i);
            if (tabPage instanceof DefaultCustomTabPage && (userObject = ((DefaultCustomTabPage)tabPage).getUserObject()) instanceof LogPage && userObject == page) {
                customTab.setHighlighted(i, true);
                break;
            }
            ++i;
        }
    }

    public void highlightPage(Component component) {
        CustomTab customTab = this._switchablePanel.getCustomTab();
        DefaultCustomTabPage componentTabPage = this._switchablePanel.getTabPageForComponent(component);
        int pageCount = customTab.getPageCount();
        int i = 0;
        while (i < pageCount) {
            CustomTabPage tabPage = customTab.getPage(i);
            if (tabPage == componentTabPage) {
                customTab.setHighlighted(i, true);
                break;
            }
            ++i;
        }
    }

    public CustomTabPage getTabPageForComponent(Component component) {
        return this._switchablePanel.getTabPageForComponent(component);
    }

    public TabbedWindow.PageInfo[] getPages() {
        int pageCount = this.getCount();
        TabbedWindow.PageInfo[] pages = new TabbedWindow.PageInfo[pageCount];
        int i = 0;
        while (i < pageCount) {
            TabbedWindow.PageInfo pageInfo;
            CustomTab customTab = this._switchablePanel.getCustomTab();
            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)customTab.getPage(i);
            pages[i] = pageInfo = new TabbedWindow.PageInfo(tabPage.getLabel(), tabPage.getIcon(), this._switchablePanel.getComponentForPage((CustomTabPage)tabPage), tabPage.getTooltip(), tabPage.getUserObject());
            ++i;
        }
        return pages;
    }

    public void addTabbedWindowListener(TabbedWindowListener l) {
        this.listenerList.add(TabbedWindowListener.class, l);
    }

    public void removeTabbedWindowListener(TabbedWindowListener l) {
        this.listenerList.remove(TabbedWindowListener.class, l);
    }

    public void addMouseListener(MouseListener listener) {
        this._switchablePanel.addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this._switchablePanel.removeMouseListener(listener);
    }

    public CustomTab getCustomTab() {
        return this._switchablePanel.getCustomTab();
    }

    public void setTabTooltip(Component component, String tooltip) {
        DefaultCustomTabPage tabPage = this._switchablePanel.getTabPageForComponent(component);
        tabPage.setTooltip(tooltip);
    }

    public void setTabName(Component component, String name) {
        DefaultCustomTabPage tabPage = this._switchablePanel.getTabPageForComponent(component);
        tabPage.setLabel(name);
        this._switchablePanel.validate();
        this._switchablePanel.invalidate();
        this._switchablePanel.repaint();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getFirstIndex() == -1) {
            return;
        }
        Object data = this.getActiveData();
        if (data != null) {
            this._fireTabbedWindowListener(data);
        }
    }

    private void _fireTabbedWindowListener(Object data) {
        Object[] listeners = this.listenerList.getListenerList();
        TabbedWindowEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TabbedWindowListener.class) {
                if (e == null) {
                    e = new TabbedWindowEvent((Object)this, data);
                }
                ((TabbedWindowListener)listeners[i + 1]).activeChanged(e);
            }
            i -= 2;
        }
    }

    static SwitchablePanel ra$_switchablePanel(FlatTabbedWindow flatTabbedWindow) {
        return flatTabbedWindow._switchablePanel;
    }

    private final class TabCloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)e.getSource();
            FlatTabbedWindow.ra$_switchablePanel(FlatTabbedWindow.this).removePage((CustomTabPage)tabPage);
        }
    }
}

