/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import oracle.ide.controls.ThinBevel;
import oracle.ideimpl.window.WindowingConstants;

public class RolloverButton
extends JButton {
    public static final Border BORDER_DOWN = ThinBevel.LOWERED_BORDER;
    public static final Border BORDER_NONE = ThinBevel.EMPTY_BORDER;
    public static final Border BORDER_UP = ThinBevel.RAISED_BORDER;
    public static final Border BORDER_LINE = BorderFactory.createLineBorder(WindowingConstants.CONTROL_SHADOW_COLOR);
    public static final Border[] CLASSIC_SCHEME = new Border[]{BORDER_DOWN, BORDER_UP, BORDER_UP};
    public static final Border[] ROLLOVER_SCHEME = new Border[]{BORDER_DOWN, BORDER_NONE, BORDER_UP};
    public static final Border[] ROLLOVER_LINE_SCHEME = new Border[]{BORDER_DOWN, BORDER_NONE, BORDER_LINE};
    private Border[] _borderScheme;

    private void $init$() {
        this._borderScheme = ROLLOVER_SCHEME;
    }

    public RolloverButton() {
        this.$init$();
        this.init();
    }

    public RolloverButton(String sText, Icon icon) {
        super(sText, icon);
        this.$init$();
        this.init();
    }

    private void init() {
        this.setBorder(BORDER_NONE);
        this.setRolloverEnabled(true);
    }

    public void setBorderScheme(Border[] borderScheme) {
        this._borderScheme = borderScheme;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isRequestFocusEnabled() {
        return false;
    }

    protected void paintBorder(Graphics g) {
        RolloverButton.paintBorder(this, g, this._borderScheme);
    }

    static void paintBorder(AbstractButton button, Graphics g, Border[] scheme) {
        ButtonModel model = button.getModel();
        boolean bRollover = model.isRollover();
        boolean bPressed = model.isPressed();
        boolean bSelected = model.isSelected();
        Border border = bSelected || bPressed ? scheme[0] : (bRollover ? scheme[2] : scheme[1]);
        border.paintBorder(button, g, 0, 0, button.getWidth(), button.getHeight());
    }
}

