/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.ArrowIcon;
import oracle.ide.controls.customtab.AutoRepeatButtonModel;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;

public class ScrollableCustomTab
extends JPanel
implements ActionListener,
ListDataListener,
ListSelectionListener {
    private static final int SCROLL_ARROW_SIZE = 4;
    private final JViewport _viewport;
    private final CustomTab _customTab;
    private final JButton _scrollLeftButton;
    private final JButton _scrollRightButton;

    public ScrollableCustomTab(int position) {
        super(new GridBagLayout());
        this._customTab = new CustomTab(position);
        this._customTab.addListDataListener((ListDataListener)this);
        this._customTab.addSelectionListener((ListSelectionListener)this);
        this._viewport = new JViewport();
        this._viewport.setView((Component)this._customTab);
        this._scrollLeftButton = new JButton();
        this.initScrollButton(this._scrollLeftButton, "Left", 7);
        this._scrollRightButton = new JButton();
        this.initScrollButton(this._scrollRightButton, "Right", 3);
        Insets insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._viewport, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)this._scrollLeftButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, insets, 0, 0));
        this.add((Component)this._scrollRightButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 0, insets, 0, 0));
    }

    private void initScrollButton(AbstractButton button, String toolTip, int arrowDir) {
        button.setModel((ButtonModel)new AutoRepeatButtonModel(400, 100));
        button.addActionListener(this);
        ArrowIcon icon = new ArrowIcon(4, arrowDir);
        int dim = Math.max(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        if (dim % 2 != 0) {
            ++dim;
        }
        Dimension size = new Dimension(dim, dim);
        button.setIcon((Icon)icon);
        button.setToolTipText(toolTip);
        button.setMinimumSize(size);
        button.setSize(size);
        button.setMaximumSize(size);
        button.setPreferredSize(size);
        button.setFocusable(false);
        button.setRolloverEnabled(false);
        button.setAlignmentY(0.0f);
        button.setMargin(new Insets(0, 0, 0, 0));
        Insets insets = button.getInsets();
        if (insets.top > 3 || insets.left > 3 || insets.bottom > 3 || insets.right > 3) {
            button.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        }
    }

    private void updateButtons() {
        int pageCount = this._customTab.getPageCount();
        int selectedPage = this._customTab.getSelectedPage();
        boolean isLeftEnabled = false;
        int i = selectedPage - 1;
        while (!isLeftEnabled && i >= 0) {
            CustomTabPage page = this._customTab.getPage(i);
            if (page.isEnabled()) {
                isLeftEnabled = true;
            }
            --i;
        }
        boolean isRightEnabled = false;
        int i2 = selectedPage + 1;
        while (!isRightEnabled && i2 < pageCount) {
            CustomTabPage page = this._customTab.getPage(i2);
            if (page.isEnabled()) {
                isRightEnabled = true;
            }
            ++i2;
        }
        this._scrollLeftButton.setEnabled(isLeftEnabled);
        this._scrollRightButton.setEnabled(isRightEnabled);
    }

    public void contentsChanged(ListDataEvent e) {
        this.updateButtons();
    }

    public void intervalAdded(ListDataEvent e) {
        this.updateButtons();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.updateButtons();
    }

    public void actionPerformed(ActionEvent e) {
        block4: {
            Object source;
            block5: {
                source = e.getSource();
                if (this._scrollLeftButton != source) break block5;
                int selectedPage = this._customTab.getSelectedPage();
                int i = selectedPage - 1;
                while (i >= 0) {
                    CustomTabPage page = this._customTab.getPage(i);
                    if (page.isEnabled()) {
                        this._customTab.setSelectedPage(i);
                        break block4;
                    }
                    --i;
                }
                break block4;
            }
            if (this._scrollRightButton != source) break block4;
            int selectedPage = this._customTab.getSelectedPage();
            int pageCount = this._customTab.getPageCount();
            int i = selectedPage + 1;
            while (i < pageCount) {
                CustomTabPage page = this._customTab.getPage(i);
                if (page.isEnabled()) {
                    this._customTab.setSelectedPage(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int selectedPage = this._customTab.getSelectedPage();
        if (selectedPage != -1) {
            DefaultCustomTabPage page = (DefaultCustomTabPage)this._customTab.getPage(selectedPage);
            Dimension preferredSize = this._customTab.getPreferredSize();
            if (preferredSize != null) {
                Rectangle pageBounds = page.getBounds();
                Rectangle viewRect = this._viewport.getViewRect();
                if (pageBounds.x < viewRect.x) {
                    this._viewport.setViewPosition(new Point(pageBounds.x, 0));
                } else if (pageBounds.x + pageBounds.width > viewRect.x + viewRect.width) {
                    this._viewport.setViewPosition(new Point(pageBounds.x + pageBounds.width - viewRect.width, 0));
                }
            }
            this.updateButtons();
        }
    }

    public void doLayout() {
        Dimension preferredSize = this._customTab.getPreferredSize();
        boolean showButtons = preferredSize.width > this.getWidth();
        this._scrollLeftButton.setVisible(showButtons);
        this._scrollRightButton.setVisible(showButtons);
        super.doLayout();
    }

    public CustomTab getCustomTab() {
        return this._customTab;
    }
}

